/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ast.AstDataDescriptionBlock;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.common.AstFileReference;
import com.veryant.cobol.compiler.ast.common.AstRecord;
import com.veryant.cobol.compiler.ast.common.AstRecordingMode;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.memory.RecordItem;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.scope.FileDeclaration;

public class AstFileDescription
extends AstNode {
    private FileDeclaration file;

    public FileDeclaration getFile() {
        return this.file;
    }

    public AstFileDescription(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void validate() {
        AstRecordingMode astRecordingMode;
        super.validate();
        AstFileReference astFileReference = this.findChild(AstFileReference.class);
        this.file = astFileReference.getFile();
        AstRecord astRecord = this.getUniqueChild(AstRecord.class);
        if (astRecord != null) {
            this.file.setHasRecordVaryingClause(astRecord.isVarying());
            this.file.setHasRecordContainsFixedClause(!astRecord.isVarying() && astRecord.getMaxValue() < 0);
            this.file.setHasRecordContainsRangeClause(!astRecord.isVarying() && astRecord.getMaxValue() >= 0);
            this.file.setMaxRecordLength(astRecord.getMaxValue());
            this.file.setMinRecordLength(astRecord.getMinValue());
        }
        if ((astRecordingMode = this.getUniqueChild(AstRecordingMode.class)) != null) {
            switch (astRecordingMode.getRecordingMode()) {
                case F: 
                case V: {
                    this.file.setRecordingMode(astRecordingMode.getRecordingMode());
                }
            }
        }
        AstDataDescriptionBlock astDataDescriptionBlock = this.findChild(AstDataDescriptionBlock.class);
        for (DataItemDeclaration dataItemDeclaration : astDataDescriptionBlock.getRecords()) {
            ((RecordItem)dataItemDeclaration.getDataItem()).setFile(this.file);
            astFileReference.addTopLevel(dataItemDeclaration);
        }
        if (this.getToken().kind == 329 && this.file.getAssign().getDevice() == FileDeclaration.Device.Sort) {
            this.consoleWrite(85, this.file, new Object[0]);
        }
    }

    @Override
    public void walk() {
        AstRecord astRecord = this.getUniqueChild(AstRecord.class);
        if (astRecord != null) {
            astRecord.walk();
            this.file.setDepending(astRecord.getDepending());
        }
    }
}

