/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Operators;
import com.veryant.cobol.compiler.ast.AstOperand;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.IntermediateResult;
import com.veryant.cobol.exceptions.COBOLCompilerException;

public class AstBinaryExpression
extends AstOperand {
    private Operators operator;

    public AstBinaryExpression(Collector collector, Token token) {
        super(collector, token);
        switch (token.kind) {
            case 843: {
                this.operator = Operators.ADD;
                break;
            }
            case 838: {
                this.operator = Operators.SUB;
                break;
            }
            case 844: {
                this.operator = Operators.MUL;
                break;
            }
            case 845: {
                this.operator = Operators.DIV;
                break;
            }
            case 847: {
                this.operator = Operators.POW;
                break;
            }
            default: {
                throw new COBOLCompilerException("Unsupported feature");
            }
        }
    }

    @Override
    public int getPostfixRank() {
        return 2;
    }

    @Override
    public AbstractOperand getOperand() {
        if (this.getChildrenCount() != this.getPostfixRank()) {
            throw new COBOLCompilerException("Internal error, invalid AST structure");
        }
        AstOperand astOperand = (AstOperand)this.getChild(0);
        AstOperand astOperand2 = (AstOperand)this.getChild(1);
        return new IntermediateResult(this.getToken(), this.operator, astOperand.getOperand(), astOperand2.getOperand());
    }
}

