/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.CompilerMessageConstants;
import com.veryant.cobol.compiler.CompilerMessageSeverity;
import com.veryant.cobol.compiler.ISourceReference;

public class CompilerMessage
extends CompilerMessageConstants {
    private static final String CODE_FORMAT = "C%05d";
    private static final String FORMAT = "%s: %s at line %d col %d, %s (%s)";
    private final int code;
    private final int line;
    private final int col;
    private final String file;
    private final Object[] args;

    public CompilerMessageSeverity getType() {
        return SEVERITY[this.code];
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public int getCode() {
        return this.code;
    }

    public String getFormattedCode() {
        return String.format(CODE_FORMAT, this.getCode());
    }

    public String getFile() {
        return this.file;
    }

    public String getMessage() {
        if (this.args == null || this.args.length == 0) {
            return TEXT[this.code];
        }
        return String.format(TEXT[this.code], this.args);
    }

    public String getFormattedMessage() {
        return this.getFormattedMessage(this.getType());
    }

    public String getFormattedMessage(CompilerMessageSeverity compilerMessageSeverity) {
        return String.format(FORMAT, new Object[]{this.getFormattedCode(), compilerMessageSeverity, this.getLine(), this.getCol(), this.getMessage(), this.getFile()});
    }

    public CompilerMessage(int n, int n2, int n3, String string, Object ... objectArray) {
        this.code = n;
        this.line = n2;
        this.col = n3;
        this.file = string;
        this.args = objectArray;
    }

    public CompilerMessage(int n, ISourceReference iSourceReference, Object ... objectArray) {
        this(n, iSourceReference.getSourceLine(), iSourceReference.getSourceColumn(), iSourceReference.getSourceFile(), objectArray);
    }

    public String toString() {
        return this.getFormattedMessage();
    }
}

