/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.utility;

import com.iscobol.rts.XMLStreamConstants;
import com.iscobol.utility.ElementIterator;
import com.iscobol.utility.QName;
import com.iscobol.utility.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

abstract class AbstractXml2Wrk {
    protected static final String eol = System.getProperty("line.separator", "\n");
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Set<String> allCobolNames = new HashSet<String>();
    protected Map<QName, Type> allTypes = new LinkedHashMap<QName, Type>();
    protected final String uri;
    protected String headerString;
    protected String targetNamespace;

    AbstractXml2Wrk(String uri) {
        this.uri = uri;
    }

    protected abstract String getPrefix();

    protected boolean isGenerateEnum() {
        return false;
    }

    protected boolean isGenerateCount() {
        return false;
    }

    protected boolean isGenerateComments() {
        return true;
    }

    protected int getFixedLength() {
        return -1;
    }

    protected String getDataSuffix() {
        return "-data";
    }

    protected String getAttributeSuffix() {
        return "-attr";
    }

    protected String getEnumSuffix() {
        return "-enum";
    }

    protected String getCapacitySuffix() {
        return "-cap";
    }

    protected String getCountSuffix() {
        return "-count";
    }

    protected boolean isIgnoreUnbound() {
        return false;
    }

    protected boolean isDisambiguate() {
        return false;
    }

    protected abstract boolean mustAddGroupNames();

    protected String buildDataName(String name) {
        return this.getCobolName(name + this.getDataSuffix());
    }

    protected String buildCapacityName(String name) {
        return this.getCobolName(name + this.getCapacitySuffix());
    }

    protected String buildAttrName(String name) {
        return this.getCobolName(name + this.getAttributeSuffix());
    }

    protected String buildEnumName(String name, int index) {
        return this.getCobolName(name + this.getEnumSuffix() + "-" + index);
    }

    protected String getCobolName(String name) {
        String Return2 = this.getPrefix() + name;
        if (this.isDisambiguate()) {
            String tmp = Return2;
            int i = 1;
            while (this.allCobolNames.contains(tmp)) {
                tmp = Return2 + "-" + i++;
            }
            Return2 = tmp;
            this.allCobolNames.add(Return2);
        }
        return Return2;
    }

    protected void scanComplexType(Element element, Type par) throws SAXException {
        if (par == null) {
            par = this.getType(element);
        }
        this.scanAttribute(element.getLocalName(), element, par.attrNames);
        ElementIterator ei = new ElementIterator(element);
        Element e = ei.next();
        while (e != null) {
            Element e2;
            if ("sequence".equals(e.getLocalName())) {
                ElementIterator seqi = new ElementIterator(e);
                e2 = seqi.next();
                while (e2 != null) {
                    if ("element".equals(e2.getLocalName())) {
                        Type t = this.scanElement(e2, true);
                        if (t != null) {
                            par.components.put(t.name, t);
                        }
                    } else if ("choice".equals(e2.getLocalName())) {
                        ElementIterator choicei = new ElementIterator(e2);
                        Element e3 = choicei.next();
                        while (e3 != null) {
                            Type t;
                            if ("element".equals(e3.getLocalName()) && (t = this.scanElement(e3, true)) != null) {
                                par.components.put(t.name, t);
                            }
                            e3 = choicei.next();
                        }
                    }
                    e2 = seqi.next();
                }
            } else if ("complexContent".equals(e.getLocalName())) {
                ElementIterator cci = new ElementIterator(e);
                e2 = cci.next();
                while (e2 != null) {
                    if ("extension".equals(e2.getLocalName())) {
                        this.scanExtension(e2, par);
                    } else if ("restriction".equals(e2.getLocalName())) {
                        this.scanRestriction(e2, par);
                    }
                    e2 = cci.next();
                }
            }
            e = ei.next();
        }
    }

    protected void scanExtension(Element element, Type par) throws SAXException {
        QName base = this.getAttribute(element, "base");
        if (base == null) {
            throw new SAXException("extension base not found: '" + AbstractXml2Wrk.nodeToString(element) + "'");
        }
        Type refType = this.allTypes.get(base);
        if (refType == null) {
            refType = new Type(base, this.isElementFormQualified());
            this.allTypes.put(refType.name, refType);
        }
        par.extension = refType;
        ElementIterator exti = new ElementIterator(element);
        Element e3 = exti.next();
        while (e3 != null) {
            if ("sequence".equals(e3.getLocalName())) {
                ElementIterator seqi = new ElementIterator(e3);
                Element e4 = seqi.next();
                while (e4 != null) {
                    Type t;
                    if ("element".equals(e4.getLocalName()) && (t = this.scanElement(e4, true)) != null) {
                        par.components.put(t.name, t);
                    }
                    e4 = seqi.next();
                }
            }
            e3 = exti.next();
        }
    }

    protected Type scanElement(Element element, boolean subTag) throws SAXException {
        Type type;
        QName ref = this.getAttribute(element, "ref");
        if (ref != null) {
            type = this.allTypes.get(ref);
            if (type == null) {
                type = new Type(ref, this.isElementFormQualified());
                this.allTypes.put(ref, type);
            }
        } else {
            QName name = this.getAttribute(element, "name");
            if (name == null) {
                String msg = "Type name not found: '" + AbstractXml2Wrk.nodeToString(element) + "'";
                if (subTag) {
                    this.warning(msg);
                    return null;
                }
                throw new SAXException(msg);
            }
            QName typeName = this.getAttribute(element, "type");
            if (typeName != null) {
                type = new Type(name, this.isElementFormQualified());
                if (AbstractXml2Wrk.isSimpleType(typeName)) {
                    type.simpleType = typeName;
                } else {
                    Type refType = this.allTypes.get(typeName);
                    if (refType == null) {
                        refType = new Type(typeName, this.isElementFormQualified());
                        this.allTypes.put(refType.name, refType);
                    }
                    type.refType = refType;
                }
            } else {
                type = this.allTypes.get(name);
                if (type == null) {
                    type = new Type(name, this.isElementFormQualified());
                    this.allTypes.put(type.name, type);
                }
                ElementIterator ei = new ElementIterator(element);
                Element e = ei.next();
                while (e != null) {
                    if ("complexType".equals(e.getLocalName())) {
                        this.scanComplexType(e, type);
                    } else if ("simpleType".equals(e.getLocalName())) {
                        this.scanSimpleType(e, type);
                    }
                    e = ei.next();
                }
            }
        }
        if (type.minOccurs == null) {
            type.minOccurs = element.getAttribute("minOccurs");
        }
        if (type.maxOccurs == null) {
            type.maxOccurs = element.getAttribute("maxOccurs");
            if (this.isIgnoreUnbound() && "unbounded".equals(type.maxOccurs)) {
                type.maxOccurs = null;
            }
        }
        return type;
    }

    protected void scanSimpleType(Element element, Type par) throws SAXException {
        if (par == null) {
            par = this.getType(element);
        }
        ElementIterator ei = new ElementIterator(element);
        Element e = ei.next();
        while (e != null) {
            if ("restriction".equals(e.getLocalName())) {
                this.scanRestriction(e, par);
                break;
            }
            e = ei.next();
        }
    }

    private void scanRestriction(Element element, Type par) throws SAXException {
        QName base = this.getAttribute(element, "base");
        if (base == null) {
            throw new SAXException("restriction base not found: '" + AbstractXml2Wrk.nodeToString(element) + "'");
        }
        this.scanRestrictionBase(element, base, par);
    }

    protected void scanRestrictionBase(Element element, QName base, Type par) throws SAXException {
        ElementIterator exti = new ElementIterator(element);
        if (AbstractXml2Wrk.isSimpleType(base)) {
            par.simpleType = base;
            Element e3 = exti.next();
            while (e3 != null) {
                this.scanRestrictionSubElement(e3, par);
                e3 = exti.next();
            }
        } else {
            Type refType = this.allTypes.get(base);
            while (refType != null && !AbstractXml2Wrk.isSimpleType(base = refType.name)) {
                refType = refType.restriction;
            }
            if (refType != null) {
                par.simpleType = refType.name;
                Element e3 = exti.next();
                while (e3 != null) {
                    this.scanRestrictionSubElement(e3, par);
                    e3 = exti.next();
                }
            } else {
                refType = new Type(base, this.isElementFormQualified());
                Element e3 = exti.next();
                while (e3 != null) {
                    if ("sequence".equals(e3.getLocalName()) || "all".equals(e3.getLocalName())) {
                        ElementIterator seqi = new ElementIterator(e3);
                        Element e4 = seqi.next();
                        while (e4 != null) {
                            Type t;
                            if ("element".equals(e4.getLocalName()) && (t = this.scanElement(e4, true)) != null) {
                                par.components.put(t.name, t);
                            }
                            e4 = seqi.next();
                        }
                    } else {
                        this.scanRestrictionSubElement(e3, par);
                    }
                    e3 = exti.next();
                }
                this.allTypes.put(refType.name, refType);
                par.restriction = refType;
            }
        }
    }

    protected void scanRestrictionSubElement(Element e, Type t) {
        QName value;
        if ("maxLength".equals(e.getLocalName())) {
            QName value2 = this.getAttribute(e, "value");
            if (value2 != null) {
                t.length = Integer.parseInt(value2.name);
            }
        } else if ("enumeration".equals(e.getLocalName()) && (value = this.getAttribute(e, "value")) != null) {
            if (t.enumeration == null) {
                t.enumeration = new LinkedHashSet();
            }
            t.enumeration.add(value.name);
        }
    }

    protected static boolean isSimpleType(QName a) {
        return "http://www.w3.org/2001/XMLSchema".equals(a.ns) && XMLStreamConstants.isSimpleType(a.name);
    }

    protected Type getType(Element element) throws SAXException {
        return this.getType(element, "name");
    }

    protected Type getType(Element element, String attrName) throws SAXException {
        QName name = this.getAttribute(element, attrName);
        if (name == null) {
            return null;
        }
        Type type = this.allTypes.get(name);
        if (type == null) {
            type = new Type(name, this.isElementFormQualified());
            this.allTypes.put(type.name, type);
        }
        if (type.minOccurs == null) {
            type.minOccurs = element.getAttribute("minOccurs");
        }
        if (type.maxOccurs == null) {
            type.maxOccurs = element.getAttribute("maxOccurs");
            if (this.isIgnoreUnbound() && "unbounded".equals(type.maxOccurs)) {
                type.maxOccurs = null;
            }
        }
        return type;
    }

    protected QName getAttribute(Element element, String attrName) {
        return this.getAttribute(element, attrName, null);
    }

    protected QName getAttribute(Element element, String attrName, String ns) {
        String attr = ns != null ? element.getAttributeNS(ns, attrName) : element.getAttribute(attrName);
        if (attr.length() > 0) {
            QName a = new QName();
            int idx = attr.indexOf(58);
            if (idx >= 0) {
                a.name = attr.substring(idx + 1);
                String pfx = attr.substring(0, idx);
                a.ns = this.namespaces.get(pfx);
                if (a.ns == null) {
                    NamedNodeMap attrs = element.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Attr at;
                        if (!(attrs.item(i) instanceof Attr) || !(at = (Attr)attrs.item(i)).getName().startsWith("xmlns:") || !at.getName().substring(6).equals(pfx)) continue;
                        a.ns = at.getValue();
                        break;
                    }
                }
            } else {
                a.name = attr;
                a.ns = this.getTargetNamespace();
            }
            return a;
        }
        return null;
    }

    protected final String getTargetNamespace() {
        return this.targetNamespace;
    }

    protected void scanAttribute(String nName, Element elmnt, Map<String, QName> attrs) throws SAXException {
        Element ei;
        ElementIterator ni = new ElementIterator(elmnt);
        while ((ei = ni.next()) != null) {
            if (!"attribute".equals(ei.getLocalName())) continue;
            QName attrName = this.getAttribute(ei, "name");
            QName attrType = this.getAttribute(ei, "type");
            if (attrName == null || attrType == null) continue;
            attrs.put(attrName.name, attrType);
        }
    }

    static String nodeToString(Node n) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        if (n instanceof Element) {
            Element e = (Element)n;
            sb.append(e.getTagName());
            NamedNodeMap attrs = e.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr a = (Attr)attrs.item(i);
                sb.append(" ");
                sb.append(a.getName());
                sb.append("=\"");
                sb.append(a.getValue());
                sb.append("\"");
            }
        } else {
            sb.append(n.getNodeName());
        }
        sb.append(">");
        return sb.toString();
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void setHeaderString(String headerString) {
        this.headerString = headerString;
    }

    protected abstract void getQualifiedName(Type var1, boolean var2, String var3, StringBuilder var4);

    protected final void getCode(Type t, int level, String parentNs, StringBuilder sb, Vector<Type> stack) {
        if (this.isGenerateComments() && "0".equals(t.minOccurs)) {
            AbstractXml2Wrk.getSpaces(level, sb);
            sb.append("*> optional");
            sb.append(eol);
        }
        AbstractXml2Wrk.putLevel(sb, level);
        String cobolName = null;
        String typeName = t.name.name;
        if (this.mustAddGroupNames()) {
            sb.append(" ");
            cobolName = this.getCobolName(typeName);
            sb.append(cobolName);
        }
        sb.append(" identified by ");
        this.getQualifiedName(t, stack.isEmpty(), parentNs, sb);
        if ("unbounded".equals(t.maxOccurs)) {
            sb.append(" occurs dynamic capacity " + this.buildCapacityName(typeName));
        } else {
            int maxOcc = 1;
            try {
                maxOcc = Integer.parseInt(t.maxOccurs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (maxOcc > 1) {
                sb.append(" occurs ");
                sb.append(maxOcc);
            }
        }
        if (t.refType != null) {
            t = t.refType;
        } else if (t.restriction != null) {
            t = t.restriction;
        }
        if (t.simpleType != null && ("base64Binary".equals(t.simpleType.name) || "hexBinary".equals(t.simpleType.name))) {
            sb.append(" ");
            sb.append(t.simpleType.name);
        }
        if (this.mustAddGroupNames() && this.isGenerateCount()) {
            sb.append(" count in ");
            sb.append(cobolName + this.getCountSuffix());
        }
        sb.append(".");
        sb.append(eol);
        if (this.isGenerateEnum() && t.enumeration != null) {
            this.getCodeEnum(t.enumeration, typeName, level + 2, sb);
        }
        this.getCodeAttrs(t, level + 2, sb);
        boolean ok = false;
        if (t.simpleType != null) {
            cobolName = this.buildDataName(typeName);
            this.getCodeSimpleType(level + 2, cobolName, this.getPicture(t.simpleType.name, t.length), sb);
            ok = true;
        } else if (!(stack.contains(t) || t.extension == null && t.components.isEmpty())) {
            Type ext = t.extension;
            if (ext != null) {
                ok = this.getCodeExtension(ext, level + 2, t.name.ns, sb, stack);
            }
            ok = ok || !t.components.isEmpty();
            for (Type c : t.components.values()) {
                this.getCode(c, level + 2, t.name.ns, sb, AbstractXml2Wrk.newStack(stack, t));
            }
        }
        if (!ok) {
            cobolName = this.buildDataName(typeName);
            this.getCodeSimpleType(level + 2, cobolName, this.getPicture("", 0), sb);
        }
    }

    private static Vector<Type> newStack(Vector<Type> stack, Type t) {
        Vector<Type> v = new Vector<Type>(stack);
        v.addElement(t);
        return v;
    }

    protected void getCodeAttrs(Type t, int level, StringBuilder sb) {
        for (String attr : t.attrNames.keySet()) {
            AbstractXml2Wrk.putLevel(sb, level);
            String attrName = this.buildAttrName(attr);
            sb.append(" " + attrName);
            sb.append(" identified by '");
            sb.append(attr);
            sb.append("' is attribute pic ");
            sb.append(this.getPicture(t.attrNames.get((Object)attr).name, 0));
            if (this.isGenerateCount()) {
                sb.append(" count in ");
                sb.append(attrName + this.getCountSuffix());
            }
            sb.append(".");
            sb.append(eol);
        }
    }

    protected void getCodeEnum(Set<String> enumeration, String typeName, int level, StringBuilder sb) {
        int i = 0;
        for (String val : enumeration) {
            AbstractXml2Wrk.getSpaces((level - 1) / 2 * 3, sb);
            sb.append("88 " + this.buildEnumName(typeName, i));
            sb.append(" value '");
            sb.append(val);
            sb.append("'.");
            sb.append(eol);
            ++i;
        }
    }

    private boolean getCodeExtension(Type ext, int level, String parentNs, StringBuilder sb, Vector<Type> stack) {
        boolean ok = false;
        if (ext.extension != null) {
            ok = this.getCodeExtension(ext.extension, level, parentNs, sb, stack);
        }
        if (ext.refType != null) {
            ext = ext.refType;
        }
        this.getCodeAttrs(ext, level, sb);
        ok = ok || !ext.components.isEmpty();
        for (Type c : ext.components.values()) {
            this.getCode(c, level, parentNs, sb, AbstractXml2Wrk.newStack(stack, ext));
        }
        return ok;
    }

    private String getPicture(String type, int length) {
        String xsdType = XMLStreamConstants.xsdSimpleTypes.get(type);
        if (xsdType == "I8") {
            return "x(1)";
        }
        if (xsdType == "I16") {
            return "s9(5)";
        }
        if (xsdType == "I32") {
            return "s9(10)";
        }
        if (xsdType == "I64") {
            return "s9(18)";
        }
        if (xsdType == "F") {
            return "s9(8)v99";
        }
        if (xsdType == "D") {
            return "s9(16)v99";
        }
        int fl = this.getFixedLength();
        if (fl >= 0) {
            if (fl == 0) {
                fl = 80;
            }
            return "x(" + (length > 0 ? length : fl) + ")";
        }
        return "x any length";
    }

    private void getCodeSimpleType(int level, String cobolName, String picture, StringBuilder sb) {
        AbstractXml2Wrk.putLevel(sb, level);
        sb.append(" ");
        sb.append(cobolName);
        if (this.isGenerateCount()) {
            sb.append(" count in ");
            sb.append(cobolName + this.getCountSuffix());
        }
        sb.append(" pic ");
        sb.append(picture);
        sb.append(".");
        sb.append(eol);
    }

    protected void addNamespaces(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr a;
            if (!(attrs.item(i) instanceof Attr) || !(a = (Attr)attrs.item(i)).getName().startsWith("xmlns:")) continue;
            this.namespaces.put(a.getName().substring(6), a.getValue());
        }
    }

    protected abstract boolean isElementFormQualified();

    static void putLevel(StringBuilder code, int level) {
        AbstractXml2Wrk.getSpaces((level - 1) / 2 * 3, code);
        if (level < 10) {
            code.append('0');
        }
        code.append(level);
    }

    static void getSpaces(int n, StringBuilder sb) {
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
    }

    protected void warning(String msg) {
        System.err.println("Warning: " + msg);
    }
}

