/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Factory;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.EncBytes;
import com.iscobol.types_n.PicN;
import com.iscobol.types_n.PicNumEdit;
import com.iscobol.types_n.PicX;

public final class PicNumEditN
extends PicNumEdit
implements EncBytes,
IPicNumEdit {
    public PicNumEditN(Memory m, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma, boolean blWhen0, char currChar) {
        super(m, offs, phisicLen, dimSize, dim, name, pic, pComma, blWhen0, currChar);
    }

    public PicNumEditN(CobolVar parent, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma, boolean blWhen0, char currChar) {
        super(parent, offs, phisicLen, dimSize, dim, name, pic, pComma, blWhen0, currChar);
    }

    public PicNumEditN(Memory m, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        super(m, offs, phisicLen, dimSize, dim, name, pic, pComma);
    }

    public PicNumEditN(CobolVar parent, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        super(parent, offs, phisicLen, dimSize, dim, name, pic, pComma);
    }

    @Override
    void updateMemory(Memory mem, CobolNum value) {
        if (value.signum() == 0) {
            if (this.blankWhenZero) {
                int end = this.curOffset + this.length();
                for (int i = this.curOffset; i < end; ++i) {
                    mem.put(i++, (byte)0);
                    mem.put(i, C_SPACE);
                }
                return;
            }
            if (this.format.isStarWhenZero()) {
                int end = this.curOffset + this.length();
                int i = this.curOffset;
                int j = 0;
                while (i < end) {
                    mem.put(i++, (byte)0);
                    byte c = this.format.getByte(j);
                    if (c == 0) {
                        mem.put(i, C_STAR);
                    } else {
                        mem.put(i, c);
                    }
                    ++i;
                    ++j;
                }
                return;
            }
        }
        super.updateMemory(mem, value);
    }

    @Override
    protected void internalSet(byte[] src, int srcOffs, int srcEnd, boolean isString, Memory mem) {
        super.internalSet(src, srcOffs, srcEnd, isString, mem);
        if (Factory.UTF16LE) {
            int i = this.curOffset + this.getLength() - 1;
            for (int j = this.curOffset + this.getLen() - 1; i >= this.curOffset && j >= this.curOffset; --i, --j) {
                if (mem.get(i) == this.format.currencyByte) {
                    mem.put(j--, (byte)((this.format.currencyChar & 0xFF00) >> 8));
                    mem.put(j, (byte)(this.format.currencyChar & 0xFF));
                    continue;
                }
                mem.put(j--, (byte)0);
                mem.put(j, mem.get(i));
            }
        } else {
            int i = this.curOffset + this.getLength() - 1;
            for (int j = this.curOffset + this.getLen() - 1; i >= this.curOffset && j >= this.curOffset; --i, --j) {
                if (mem.get(i) == this.format.currencyByte) {
                    mem.put(j--, (byte)(this.format.currencyChar & 0xFF));
                    mem.put(j, (byte)((this.format.currencyChar & 0xFF00) >> 8));
                    continue;
                }
                mem.put(j--, mem.get(i));
                mem.put(j, (byte)0);
            }
        }
    }

    @Override
    public String toString() {
        return new String(PicN.byteToChar(this.getMemory(), this.getOffset(), this.getLen()));
    }

    @Override
    void updateCache(Memory mem, CobolNum cn) {
        if (checkNC != 0) {
            this.checkNumericContent();
        }
        String str = new String(PicN.byteToChar(mem, this.getOffset(), this.getLen()));
        cn.set(CobolNum.get(str, this.format.getDecLen()), false, false);
    }

    @Override
    public CobolVar moveTo(PicX dest) {
        dest.set(this.toString());
        return this;
    }

    @Override
    public int getLength() {
        return this.getLen() / 2;
    }

    @Override
    public void valueToTable(CobolVar cv, int[] idxs, int[] nDim, int dim) {
        PicN value = new PicN(this.getMemory(), this.getOffset(), this.getMaxLength(), this.dimensionsSize, this.dimensions, null, this.isDecPointComma, this.isJustified);
        cv.moveToTable(value, idxs, nDim, dim);
    }
}

