/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types.FloatingPointConverter;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.PicNativeBinary;

public class PicNativeDouble
extends PicNativeBinary {
    private static final long serialVersionUID = 123L;

    public PicNativeDouble(Memory mem, int offs, int phisicLen, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(mem, offs, phisicLen, true, -1, -7, dimSize, dim, name, pComma);
    }

    public PicNativeDouble(CobolVar par, int offs, int phisicLen, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(par, offs, phisicLen, true, -1, -7, dimSize, dim, name, pComma);
    }

    @Override
    int getAlphaBuffSize() {
        return 48;
    }

    @Override
    void updateMemory(Memory mem, CobolNum cn) {
        this.internalSet(mem, FloatingPointConverter.doubleToLongBits(cn.doubleValue()));
    }

    @Override
    void updateMemory(Memory mem) {
        this.internalSet(mem, FloatingPointConverter.doubleToLongBits(this.num().doubleValue()));
    }

    @Override
    void updateCache(Memory mem, CobolNum cn) {
        cn.set(FloatingPointConverter.longBitsToDouble(this.getLongFromMem(mem)));
    }

    @Override
    public boolean set(long unscaled, int scale, boolean rounded, boolean checkOverflow) {
        if (this.isFinal) {
            return true;
        }
        this.theValue.set(unscaled, scale);
        this.updateMemory(this.memory.getMemory(), this.theValue);
        return false;
    }

    @Override
    public boolean set(CobolNum d, boolean rounded, boolean checkOverflow) {
        if (this.isFinal) {
            return true;
        }
        if (checkOverflow && d == CobolNum.INFINITY) {
            return true;
        }
        this.theValue.set(d, rounded, this.lenInBytes);
        this.updateMemory(this.memory.getMemory(), this.theValue);
        return false;
    }
}

