/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class MemoryUnsafe
extends Memory {
    private static final long serialVersionUID = 123L;
    private static final Unsafe theUnsafe;
    private long address;
    private boolean isAllocated;
    private boolean optimized;

    @Override
    public void init(long addr, int sz, boolean optmzd) {
        this.address = addr;
        this.length = sz;
        this.isAllocated = false;
        this.optimized = optmzd;
    }

    @Override
    public void init(int sz, boolean optmzd) {
        this.length = sz;
        this.address = theUnsafe.allocateMemory(this.length);
        this.isAllocated = true;
        this.optimized = optmzd;
    }

    @Override
    public void init(byte[] val, boolean optmzd) {
        this.init(val.length, optmzd);
        for (int i = this.length - 1; i >= 0; --i) {
            this.put(i, val[i]);
        }
    }

    @Override
    public long getBaseAddress() {
        return this.address;
    }

    @Override
    public boolean isOptimized() {
        return this.optimized;
    }

    @Override
    public byte get(int offset) {
        return theUnsafe.getByte(this.address + (long)offset);
    }

    @Override
    public void put(int offset, byte val) {
        theUnsafe.putByte(this.address + (long)offset, val);
    }

    @Override
    public void fill(byte value) {
        theUnsafe.setMemory(this.address, this.length, value);
    }

    @Override
    public void fill(int offset, int end, byte value) {
        long start = this.address + (long)offset;
        long len = this.address + (long)end - start;
        theUnsafe.setMemory(this.address + (long)offset, len, value);
    }

    @Override
    public void fill(int offset, int end, byte[] value) {
        long from = this.address + (long)offset;
        long to = this.address + (long)end;
        if ((end - offset & 1) == 1) {
            theUnsafe.putByte(from++, value[1]);
        }
        while (from < to) {
            theUnsafe.putByte(from++, value[0]);
            theUnsafe.putByte(from++, value[1]);
        }
    }

    @Override
    public void set(int dstOffset, byte[] src, int srcOffset, int len) {
        long l = this.address + (long)dstOffset;
        int i = 0;
        while (i < len) {
            theUnsafe.putByte(l, src[srcOffset]);
            ++l;
            ++i;
            ++srcOffset;
        }
    }

    @Override
    public void copy(int srcOffset, Memory dst, int dstOffset, int len) {
        theUnsafe.copyMemory(this.address + (long)srcOffset, dst.getBaseAddress() + (long)dstOffset, len);
    }

    @Override
    public void finalize() {
        if (this.isAllocated) {
            theUnsafe.freeMemory(this.address);
            this.isAllocated = false;
        }
    }

    @Override
    public String toString() {
        return new String(this.toByteArray(0, this.length));
    }

    @Override
    public byte[] toByteArray(int offs, int len) {
        byte[] Return2 = new byte[len];
        long l = this.address + (long)offs;
        int i = 0;
        while (i < len) {
            Return2[i] = theUnsafe.getByte(l);
            ++i;
            ++l;
        }
        return Return2;
    }

    static {
        Unsafe unsf = null;
        try {
            Class<Unsafe> uc = Unsafe.class;
            Field[] fields = uc.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals("theUnsafe")) continue;
                fields[i].setAccessible(true);
                unsf = (Unsafe)fields[i].get(uc);
                break;
            }
        }
        catch (Exception _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        theUnsafe = unsf;
    }
}

