/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import java.util.Vector;

public class FunctionArgs {
    private Vector values = new Vector();
    private boolean alphanumeric;

    public FunctionArgs put(CobolVar a) {
        this.alphanumeric = true;
        this.values.addElement(a);
        return this;
    }

    public FunctionArgs put(CobolNum a) {
        this.values.addElement(a);
        return this;
    }

    public FunctionArgs put(NumericVar a) {
        this.values.addElement(a.num());
        return this;
    }

    public FunctionArgs put(NumericVar a, int[] dim) {
        int[] curDim = new int[dim.length];
        this.put(a, dim, curDim, -1);
        return this;
    }

    public FunctionArgs put(CobolVar a, int[] dim) {
        int[] curDim = new int[dim.length];
        this.put(a, dim, curDim, -1);
        return this;
    }

    private final void put(NumericVar a, int[] dim, int[] curDim, int curIdx) {
        if (dim.length > ++curIdx) {
            if (dim[curIdx] > 0) {
                curDim[curIdx] = dim[curIdx];
                this.put(a, dim, curDim, curIdx);
            } else {
                int maxDim = a.getDimensions()[curIdx];
                int i = 1;
                while (i <= maxDim) {
                    curDim[curIdx] = i++;
                    this.put(a, dim, curDim, curIdx);
                }
            }
        } else {
            NumericVar at = a.isInDynamicTable() ? (NumericVar)a.intIAt(curDim) : (NumericVar)a.intIAtNoClone(curDim);
            this.values.addElement(CobolNum.noo(at.num()));
        }
    }

    private final void put(CobolVar a, int[] dim, int[] curDim, int curIdx) {
        if (dim.length > ++curIdx) {
            if (dim[curIdx] > 0) {
                curDim[curIdx] = dim[curIdx];
                this.put(a, dim, curDim, curIdx);
            } else {
                int maxDim = a.getDimensions()[curIdx];
                int i = 1;
                while (i <= maxDim) {
                    curDim[curIdx] = i++;
                    this.put(a, dim, curDim, curIdx);
                }
            }
        } else {
            this.values.addElement(a.intIAt(curDim));
        }
    }

    public CobolNum[] nums() {
        CobolNum[] Return2 = new CobolNum[this.values.size()];
        for (int i = this.values.size() - 1; i >= 0; --i) {
            Return2[i] = (CobolNum)this.values.elementAt(i);
        }
        return Return2;
    }

    public CobolVar[] vars() {
        CobolVar[] Return2 = new CobolVar[this.values.size()];
        for (int i = this.values.size() - 1; i >= 0; --i) {
            Return2[i] = (CobolVar)this.values.elementAt(i);
        }
        return Return2;
    }

    public String toString() {
        StringBuffer Return2 = new StringBuffer("[");
        RuntimeErrorsNumbers[] val = this.alphanumeric ? this.vars() : this.nums();
        for (int i = 0; i < val.length; ++i) {
            Return2.append(val[i].toString());
            Return2.append(' ');
        }
        Return2.append(']');
        return Return2.toString();
    }
}

