/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Factory;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;

public abstract class PicBinary
extends NumericVar {
    private static final long serialVersionUID = 123L;
    CobolNum value;
    long u_max = Long.MAX_VALUE;

    public PicBinary(byte[] mem, int offs, int pl, boolean s, int il, int dl, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(mem, offs, il, dl, s, pl, dimSize, dim, name, pComma);
        if (this.len < 8) {
            this.u_max = 2L;
            for (int i = 1; i < this.len * 8; ++i) {
                this.u_max *= 2L;
            }
        }
        if (mem != null) {
            this.updateCache(mem, this.theValue);
        }
    }

    public PicBinary(CobolVar par, int offs, int pl, boolean s, int il, int dl, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(par, offs, il, dl, s, pl, dimSize, dim, name, pComma);
        if (this.len < 8) {
            this.u_max = 2L;
            for (int i = 1; i < this.len * 8; ++i) {
                this.u_max *= 2L;
            }
        }
    }

    public PicBinary(long initValue, int pl, boolean s, int il, int dl, boolean pComma) {
        super((byte[])null, 0, il, dl, s, pl, null, null, "$literal", pComma);
        this.set(CobolNum.noo(initValue, dl), false, false);
    }

    @Override
    int getAlphaBuffSize() {
        return XLEN[this.getMaxLength()] + 2;
    }

    @Override
    void updateMemory(byte[] mem, CobolNum cn) {
        if (mem != null) {
            cn.toBinaryByteArray(mem, this.curOffset, this.len);
        }
    }

    @Override
    void updateMemory(byte[] mem) {
        if (mem != null) {
            this.num().toBinaryByteArray(mem, this.curOffset, this.len);
        }
    }

    @Override
    void updateCache(byte[] mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            cn.set(this.getLongFromMem(mem), this.decLen);
        } else {
            cn.set(new BigCobolDec(mem, this.curOffset, this.len, this.signed, this.decLen));
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        byte[] mem = this.getMemory();
        Factory.myFill(mem, this.curOffset, this.end, (byte)0);
    }

    protected long getLongFromMem(byte[] buf) {
        long unscaled;
        if (buf != null) {
            int i;
            int start = this.curOffset;
            unscaled = 0L;
            if (this.signed && buf[start] < 0) {
                for (i = 7; i >= this.len; --i) {
                    unscaled |= 255L << i * 8;
                }
            } else {
                i = this.len - 1;
            }
            while (i > 0) {
                unscaled |= (long)(buf[start++] & 0xFF) << i * 8;
                --i;
            }
            unscaled |= (long)(buf[start] & 0xFF);
        } else {
            unscaled = this.value != null ? this.value.getUnscaledLong() : 0L;
        }
        if (!this.signed && unscaled < 0L) {
            unscaled = -unscaled;
        }
        return unscaled;
    }
}

