/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolVar;
import java.io.Serializable;
import java.util.Vector;

class MemMan
implements Serializable {
    private static final long serialVersionUID = 1L;
    byte[] memory;
    private CobolVar lastUsed;
    private boolean isUnsync;
    private Vector dynAreas;

    MemMan() {
    }

    MemMan(byte[] mem) {
        this.memory = mem;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void setUnsync(CobolVar cv) {
        if (this.lastUsed != cv) {
            if (this.isUnsync) {
                try {
                    this.lastUsed.updateMemory(this.memory);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (this.memory == null) {
                        throw new NullPointerException();
                    }
                    CobolVar cv0 = cv;
                    while (cv.getParent() != null) {
                        cv = cv.getParent();
                    }
                    String msg = "Concurrent access to '" + cv.getName() + "'";
                    msg = cv != cv0 ? msg + " group-item" : msg + " data-item";
                    throw new IscobolRuntimeException(3, msg);
                }
            }
            this.lastUsed = cv;
        }
        this.isUnsync = true;
    }

    boolean isLastUsed(CobolVar cv) {
        return cv == this.lastUsed;
    }

    public byte[] getMemory(CobolVar cv) {
        byte[] Return2 = this.getMemory();
        this.lastUsed = cv;
        return Return2;
    }

    public byte[] getMemory() {
        if (this.isUnsync) {
            try {
                this.lastUsed.updateMemory(this.memory);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (this.memory == null) {
                    throw new NullPointerException();
                }
                throw new IscobolRuntimeException(3, "Concurrent access to memory block");
            }
            this.isUnsync = false;
        }
        this.lastUsed = null;
        return this.memory;
    }

    MemMan(MemMan mem) {
        this.memory = new byte[mem.memory.length];
        this.init(mem);
    }

    MemMan(MemMan mem, int len) {
        this.memory = new byte[len];
        this.init(mem);
    }

    private void init(MemMan mem) {
        if (mem.dynAreas != null) {
            this.dynAreas = new Vector();
            this.dynAreas.setSize(mem.dynAreas.size());
        }
    }

    public final int addDynamic() {
        int Return2;
        if (this.dynAreas == null) {
            this.dynAreas = new Vector();
            Return2 = 0;
        } else {
            Return2 = this.dynAreas.size();
        }
        this.dynAreas.setSize(Return2 + 1);
        return Return2;
    }

    public final void allocMemory(int pos, int dim) {
        if (pos >= 0) {
            byte[] mem = (byte[])this.dynAreas.elementAt(pos);
            if (mem == null || dim != mem.length) {
                this.dynAreas.setElementAt(new byte[dim], pos);
            }
        } else {
            if (dim != this.memory.length) {
                this.memory = new byte[dim];
            }
            this.isUnsync = false;
            this.lastUsed = null;
        }
    }

    public final byte[] getMemory(int pos) {
        if (pos >= 0) {
            return (byte[])this.dynAreas.elementAt(pos);
        }
        return this.getMemory();
    }

    public final void copyFrom(MemMan m, boolean cloneMemory) {
        if (cloneMemory) {
            this.memory = (byte[])m.memory.clone();
        }
        this.isUnsync = false;
        this.lastUsed = null;
        if (m.dynAreas != null) {
            int sz = m.dynAreas.size();
            this.dynAreas = new Vector(sz);
            for (int i = 0; i < sz; ++i) {
                byte[] el = (byte[])m.dynAreas.elementAt(i);
                if (el != null) {
                    this.dynAreas.addElement(el.clone());
                    continue;
                }
                this.dynAreas.addElement(null);
            }
        }
    }

    public final int compareTo(MemMan m) {
        if (m.dynAreas != null) {
            int d = this.dynAreas.size() - m.dynAreas.size();
            if (d != 0) {
                return d;
            }
            int sz = m.dynAreas.size();
            for (int i = 0; i < sz; ++i) {
                byte[] b1 = (byte[])this.dynAreas.elementAt(i);
                byte[] b2 = (byte[])m.dynAreas.elementAt(i);
                if (b1 != null) {
                    if (b2 != null) {
                        d = CobolVar.compareTo(b1, 0, b1.length, b2, 0, b2.length);
                        if (d == 0) continue;
                        return d;
                    }
                    return 1;
                }
                if (b2 == null) continue;
                return -1;
            }
        }
        return 0;
    }

    public final boolean isDynamic() {
        return this.dynAreas != null;
    }

    public final String toString() {
        return new String(this.memory);
    }
}

