/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Config;

public class FloatingPointConverter {
    public static final boolean ibmhfp = "ibm_hfp".equalsIgnoreCase(Config.getProperty(".floating_point_format", "ieee_754"));

    public static int floatToIntBits(float flt) {
        if (ibmhfp) {
            return FloatingPointConverter.floatToIntBitsHFP(flt);
        }
        return Float.floatToIntBits(flt);
    }

    public static float intBitsToFloat(int i) {
        if (ibmhfp) {
            return FloatingPointConverter.intBitsToFloatHFP(i);
        }
        return Float.intBitsToFloat(i);
    }

    public static long doubleToLongBits(double d) {
        if (ibmhfp) {
            return FloatingPointConverter.doubleToLongBitsHFP(d);
        }
        return Double.doubleToLongBits(d);
    }

    public static double longBitsToDouble(long l) {
        if (ibmhfp) {
            return FloatingPointConverter.longBitsToDoubleHFP(l);
        }
        return Double.longBitsToDouble(l);
    }

    private static double longBitsToDoubleHFP(long hfpBits) {
        long sign = hfpBits & Long.MIN_VALUE;
        if ((hfpBits & Long.MAX_VALUE) == 0L) {
            return Double.longBitsToDouble(sign);
        }
        long fraction = hfpBits & 0xFFFFFFFFFFFFFFL;
        long characteristic = (hfpBits & 0x7F00000000000000L) >> 56;
        long exp = (characteristic - 64L << 2) + 1023L - 1L;
        if ((fraction >>= 3) == 0L) {
            return Double.longBitsToDouble(sign);
        }
        while ((fraction & 0x10000000000000L) == 0L) {
            --exp;
            fraction <<= 1;
        }
        if (exp <= 0L) {
            fraction = exp < -56L ? 0L : (fraction >>= (int)(-exp + 1L));
            exp = 0L;
        } else if (exp >= 2047L) {
            fraction = 0L;
            exp = 2047L;
        } else {
            fraction &= 0xFFFFFFFFFFFFFL;
        }
        return Double.longBitsToDouble(sign | exp << 52 | fraction);
    }

    private static long doubleToLongBitsHFP(double dbl) {
        long bfpBits = Double.doubleToLongBits(dbl);
        long sign = bfpBits & Long.MIN_VALUE;
        if ((bfpBits & Long.MAX_VALUE) == 0L) {
            return sign;
        }
        long fraction = bfpBits & 0xFFFFFFFFFFFFFL;
        int bfpExp = (int)((bfpBits & 0x7FF0000000000000L) >> 52);
        if (bfpExp == 2047) {
            return sign | 0x7F00000000000000L | 0xFFFFFFFFFFFFFFL;
        }
        if (bfpExp > 0) {
            fraction |= 0x10000000000000L;
        }
        if (bfpExp == 0 && (fraction & 0xF0000000000000L) == 0L) {
            fraction <<= 4;
            bfpExp -= 3;
        }
        fraction <<= 3;
        long hfpExp = bfpExp - 766;
        fraction >>= (int)(-hfpExp & 3L);
        hfpExp += 3L;
        hfpExp /= 4L;
        while ((fraction & 0xF0000000000000L) == 0L) {
            --hfpExp;
            fraction <<= 4;
        }
        if (hfpExp < 0L) {
            return sign;
        }
        if (hfpExp > 127L) {
            throw new IllegalArgumentException("Number too large");
        }
        return sign | hfpExp << 56 | fraction;
    }

    private static float intBitsToFloatHFP(int hfpBits) {
        int sign = hfpBits & Integer.MIN_VALUE;
        if ((hfpBits & Integer.MAX_VALUE) == 0) {
            return Float.intBitsToFloat(sign);
        }
        int fraction = hfpBits & 0xFFFFFF;
        int characteristic = (hfpBits & 0x7F000000) >> 24;
        int exp = (characteristic - 64 << 2) + 127 - 1;
        if (fraction == 0) {
            return Float.intBitsToFloat(sign);
        }
        while ((fraction & 0x800000) == 0) {
            --exp;
            fraction <<= 1;
        }
        if (exp <= 0) {
            fraction = exp < -24 ? 0 : (fraction >>= -exp + 1);
            exp = 0;
        } else if (exp >= 255) {
            fraction = 0;
            exp = 255;
        } else {
            fraction &= 0x7FFFFF;
        }
        return Float.intBitsToFloat(sign | exp << 23 | fraction);
    }

    private static int floatToIntBitsHFP(float flt) {
        int bfpBits = Float.floatToIntBits(flt);
        int sign = bfpBits & Integer.MIN_VALUE;
        if ((bfpBits & Integer.MAX_VALUE) == 0) {
            return sign;
        }
        int fraction = bfpBits & 0x7FFFFF;
        int bfpExp = (bfpBits & 0x7F800000) >> 23;
        if (bfpExp == 255) {
            return sign | 0x7F000000 | 0xFFFFFF;
        }
        if (bfpExp > 0) {
            fraction |= 0x800000;
        }
        if (bfpExp == 0 && (fraction & 0xF00000) == 0) {
            fraction <<= 4;
            bfpExp -= 3;
        }
        int hfpExp = bfpExp + 130;
        fraction >>= -hfpExp & 3;
        hfpExp += 3;
        hfpExp /= 4;
        while ((fraction & 0xF00000) == 0) {
            --hfpExp;
            fraction <<= 4;
        }
        return sign | hfpExp << 24 | fraction;
    }
}

