/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.so;

import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.Pic9Comp_5;
import java.io.File;
import java.util.StringTokenizer;

public class DynamicCall
implements RuntimeErrorsNumbers,
IscobolCall {
    public static final int STDC_CALL_CONV = 0;
    public static final int PASCAL_CALL_CONV = 1;
    public static final int MAX_ARGS = 256;
    private static boolean loaded;
    private final int callConv;
    private final String name;
    private Pic9Comp_5 ret = new Pic9Comp_5(new byte[8], 0, 8, true, 0, 0, null, null, null, false, true);

    private static native void init();

    private static native boolean peerOpen(String var0);

    private static native long peerCall(String var0, int var1, Object[] var2);

    private static native String peerClose(String var0);

    public DynamicCall(String name, int callConv) {
        this.name = name;
        this.callConv = callConv;
    }

    @Override
    public Object call(Object[] arg) {
        long rc;
        if (!loaded) {
            throw new IscobolRuntimeException(2, this.name);
        }
        try {
            rc = DynamicCall.call(this.name, this.callConv, arg);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if ((arg == null || arg.length == 0) && DynamicCall.open(this.name)) {
                rc = 0L;
            }
            throw new IscobolRuntimeException(2, this.name);
        }
        this.ret.set(rc);
        return this.ret;
    }

    @Override
    public void finalize() {
    }

    public static final boolean open(String name) {
        return loaded && DynamicCall.peerOpen(name);
    }

    public final Object openAndLoad(Object[] argv) {
        String lib = System.mapLibraryName(this.name);
        if (!DynamicCall.open(lib)) {
            throw new IscobolRuntimeException(2, this.name);
        }
        this.ret.set(DynamicCall.call(this.name, this.callConv, argv));
        return this.ret;
    }

    public static final long call(String name, int callConv, Object[] argv) {
        long Return2;
        Object[] argvMax = null;
        if (loaded) {
            if (argv != null && argv.length > 256) {
                argvMax = new Object[256];
                System.arraycopy(argv, 0, argvMax, 0, 256);
                Return2 = DynamicCall.peerCall(name, callConv, argvMax);
            } else {
                Return2 = DynamicCall.peerCall(name, callConv, argv);
            }
        } else {
            throw new RuntimeException("Native call not found");
        }
        if (argvMax != null) {
            throw new IllegalArgumentException("Too many arguments:" + argv.length + " (max allowed: " + 256 + ")");
        }
        return Return2;
    }

    public static final String unload(String name) {
        if (loaded) {
            return DynamicCall.peerClose(name);
        }
        return "";
    }

    @Override
    public void perform(int begin, int end) {
    }

    static {
        String sll;
        block5: {
            try {
                System.loadLibrary("dyncall");
                loaded = true;
                DynamicCall.init();
            }
            catch (UnsatisfiedLinkError e) {
                if (Config.getProperty("iscobol.runtime.native.ignore_errors", "iscobol.runtime.native.dynamic.ignore_errors", true)) break block5;
                throw new IscobolRuntimeException(32, (Throwable)e);
            }
        }
        if (Config.getProperty("iscobol.shared_dlopen_null", true)) {
            DynamicCall.open(null);
        }
        if ((sll = Config.getProperty("iscobol.shared_library_list", null)) != null) {
            StringTokenizer st = new StringTokenizer(sll, "\n" + File.pathSeparatorChar);
            while (st.hasMoreTokens()) {
                DynamicCall.open(st.nextToken());
            }
        }
    }
}

