/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts_n;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.IsInitial;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.Memory;
import com.iscobol.rts.MyDataSource;
import com.iscobol.rts.ThreadDependingData;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts_n.EsqlCursor;
import com.iscobol.rts_n.EsqlCursorHndl;
import com.iscobol.rts_n.EsqlHostVar;
import com.iscobol.rts_n.EsqlOraHostVar;
import com.iscobol.rts_n.EsqlOraPrepStat;
import com.iscobol.rts_n.EsqlPrepare;
import com.iscobol.rts_n.EsqlPrepareHandler_n;
import com.iscobol.rts_n.EsqlSqlcaHandler_n;
import com.iscobol.rts_n.Factory;
import com.iscobol.types.PicX;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericLiteralAll;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.ObjectVar;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class EsqlRuntime {
    public static final int SQL_SUCCESS = 0;
    public static final int SQL_NO_DATA_FOUND = 100;
    public static final int SQL_ERROR = -1;
    public static final int SQL_INVALID_HANDLE = -2;
    public static final int SQL_NULL_DATA = -1;
    public static final int DB2_BLOB = 404;
    public static final int DB2_CLOB = 408;
    public static final int DB2_DECIMAL = 484;
    public static final int DB2_CHAR = 452;
    public static final int DB2_VARCHAR = 448;
    public static final int DB2_LVARCHAR = 456;
    public static final int DB2_SMALLINT = 500;
    public static final int DB2_INTEGER = 496;
    public static final int DB2_BIGINT = 492;
    public static final int DB2_FLOAT = 480;
    private static NumericVar FLOAT;
    private static NumericVar REAL;
    private static NumericVar DECIMAL;
    private static NumericVar SMALLINT;
    private static NumericVar INTEGER;
    private static NumericVar BIGINT;
    private static com.iscobol.types_n.PicX VARCHAR;
    private static NumericVar VARCHAR_LEN;
    private static com.iscobol.types_n.PicX VARCHAR_ARR;
    private static com.iscobol.types_n.PicX RECVAL;
    private static NumericVar MYIND;
    static Hashtable sqlTypes;
    static Hashtable sqlTypesOra;
    static Hashtable sqlTypesOraRev;
    static boolean d64;
    static Method getDBRowDataAsBytes;
    static Method getDBRowDescriptor;
    static Method exec;
    static Class[] nullParamClass;
    static Object[] nullParam;
    Object[] rowObj;
    byte[] rowData;
    int[] rowOffs;
    int[] rowInfo;
    static final NumericLiteralAll ZERO;
    public static final int ESQL_SUCCESS = 0;
    public static final int ESQL_DUPLICATE_PREPARE = 1;
    public static final int ESQL_ALREADY_CONNECTED = 2;
    public static final int ESQL_INVALID_SEQUENCE = 3;
    public static final int ESQL_INVALID_PARAMETER = 4;
    public static final int ESQL_CURSOR_NOT_DECLARED = 5;
    public static final int ESQL_INVALID_HANDLE = 6;
    public static final int ESQL_NOT_SUPPORTED = 7;
    public static final int ESQL_INVALID_DRIVER = 8;
    public static final int ESQL_INVALID_DATASOURCE = 9;
    public static final int ESQL_INTERNAL_ERROR = 10;
    public static final int ESQL_CONN_EXCEPTION = 11;
    public static final int ESQL_CONN_UNABLE = 12;
    public static final int ESQL_CONN_NAME_IN_USE = 13;
    public static final int ESQL_CONN_NOT_FOUND = 14;
    public static final int ESQL_CONN_REJECTED = 15;
    public static final int ESQL_CONN_FAILURE = 16;
    public static final int ESQL_CONN_TRANS_UNKNOWN = 17;
    public static final int ESQL_DATA_TRUNCATION = 18;
    public static final int ESQL_JDBC = 19;
    public static final String[][] allErrors;
    public static final int CURS_INCR = 10;
    public static final int CURS_FORWARD_ONLY = 1;
    public static final int CURS_SCROLL_INSENSITIVE = 2;
    public static final int CURS_SCROLL_SENSITIVE = 3;
    public static final int DEFAULT_HOLD = 0;
    public static final int NO_TRUNC = 1;
    public static final int OPENSQL_TRUNC = 2;
    public static final int PROCOBOL_TRUNC = 3;
    private IscobolCall executeHook;
    private Connection defConn;
    private String defName;
    private Hashtable connectionPool;
    private Hashtable procedureTypes;
    private Hashtable procedureTypeNames;
    private Hashtable sqldaTable;
    private static EsqlSqlca curSqlca;
    private EsqlSqlca actSqlca;
    private EsqlSqlda actSqlda;
    private EsqlSqldaDb2 actSqldaDb2;
    private int numTdd;
    private final int cursorType;
    private Logger log;
    private Logger logDP;
    private static final int concurrency;
    private static final String modeIODef;
    private static final boolean warnings;
    private static final boolean automaticConnection;
    public static final int db2DataRowAsByteThreshold;
    public static final int picXHandling;
    public static final int codeNull;
    public static final int noData;
    public static final int tooManyRows;
    private static final int typeIndTrunk;
    private static final int errorFact;
    private static final String classSqlcaDecoderName;
    private static final Class classSqlcaDecoder;
    private static final Method methodSqlcaDecoder;
    private static final EsqlSqlcaHandler_n handlerSqlcaDecoder;
    private static final String classPrepareDecoderName;
    private static final Class classPrepareDecoder;
    private static final Method methodPrepareDecoder;
    private static final EsqlPrepareHandler_n handlerPrepareDecoder;
    private static final SQLWarning dataTruncation;

    public EsqlRuntime() {
        block8: {
            this.rowObj = null;
            this.rowData = null;
            this.rowOffs = null;
            this.rowInfo = null;
            this.connectionPool = new Hashtable();
            this.procedureTypes = new Hashtable();
            this.procedureTypeNames = new Hashtable();
            this.sqldaTable = new Hashtable();
            this.actSqldaDb2 = null;
            this.numTdd = 0;
            this.log = LoggerFactory.get(256);
            this.logDP = LoggerFactory.get(2048);
            switch (Config.getProperty(".jdbc.cursor.type", 1)) {
                default: {
                    this.cursorType = 1003;
                    break;
                }
                case 2: {
                    this.cursorType = 1004;
                    break;
                }
                case 3: {
                    this.cursorType = 1005;
                }
            }
            String executeHookName = Config.getProperty(".esql.execute.hook", null);
            if (executeHookName != null) {
                try {
                    this.executeHook = (IscobolCall)Class.forName(executeHookName).newInstance();
                    if (this.log != null) {
                        this.log.info("Execute Hook enabled: " + executeHookName);
                    }
                }
                catch (Exception _ex) {
                    if (this.log == null) break block8;
                    this.log.warning("Execute Hook disabled (" + _ex + ")");
                }
            }
        }
    }

    boolean hasExecuteHook() {
        return this.executeHook != null;
    }

    protected void callExecuteHook(String query, Statement stmt, Vector<EsqlHostVar> params) {
        block6: {
            Vector<EsqlHostVar> params2 = new Vector<EsqlHostVar>(params);
            if (params2.size() > 0 && params2.elementAt(0) == null) {
                params2.removeElementAt(0);
            }
            if (params2.size() > 1) {
                Collections.sort(params2, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        EsqlHostVar hv1 = (EsqlHostVar)o1;
                        EsqlHostVar hv2 = (EsqlHostVar)o2;
                        return hv1.getCol() - hv2.getCol();
                    }
                });
            }
            Object[] args = new Object[params2.size() + 2];
            int i = 0;
            args[i++] = query;
            args[i++] = stmt;
            for (EsqlHostVar hv : params2) {
                args[i++] = hv.getVar();
            }
            IscobolCall call = this.executeHook;
            try {
                if (call instanceof IsInitial) {
                    call = (IscobolCall)call.getClass().newInstance();
                }
                call.call(args);
            }
            catch (Exception _ex) {
                if (this.log == null) break block6;
                this.log.warning("Entering hook failed: " + _ex);
            }
        }
    }

    public static EsqlRuntime get() {
        EsqlRuntime Return2 = (EsqlRuntime)IscobolSystem.get(EsqlRuntime.class);
        if (Return2 == null) {
            Return2 = new EsqlRuntime();
            IscobolSystem.set(EsqlRuntime.class, Return2);
        }
        return Return2;
    }

    public static void stopRun(Thread t) {
        EsqlRuntime er = (EsqlRuntime)IscobolSystem.getIfExists(EsqlRuntime.class, t);
        if (er != null && er.connectionPool != null) {
            Logger log = er.log;
            String ds = Config.getProperty(".jdbc.on_stop_run", null);
            Enumeration en = er.connectionPool.elements();
            while (en.hasMoreElements()) {
                Connection conn = (Connection)en.nextElement();
                if (ds != null) {
                    if (ds.equalsIgnoreCase("commit")) {
                        try {
                            conn.commit();
                            if (log != null) {
                                log.info("EsqlRuntime_n: STOP RUN commit  connection [" + conn + ((EsqlSqlca)Factory.getCurrent().getTdd().sqlca_n).strNumTdd + "] driver [" + conn.getMetaData().getDriverName() + " " + conn.getMetaData().getDriverVersion() + "] user name [" + conn.getMetaData().getUserName() + "]");
                            }
                        }
                        catch (SQLException sQLException) {}
                    } else if (ds.equalsIgnoreCase("rollback")) {
                        try {
                            conn.rollback();
                            if (log != null) {
                                log.info("EsqlRuntime_n: STOP RUN rollback  connection [" + conn + ((EsqlSqlca)Factory.getCurrent().getTdd().sqlca_n).strNumTdd + "] driver [" + conn.getMetaData().getDriverName() + " " + conn.getMetaData().getDriverVersion() + "] user name [" + conn.getMetaData().getUserName() + "]");
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    if (log != null) {
                        log.info("EsqlRuntime_n: STOP RUN close  connection [" + conn + ((EsqlSqlca)Factory.getCurrent().getTdd().sqlca_n).strNumTdd + "] driver [" + conn.getMetaData().getDriverName() + " " + conn.getMetaData().getDriverVersion() + "] user name [" + conn.getMetaData().getUserName() + "]");
                    }
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static PreparedStatement getStatement(Connection con, String query, int type, int holdability) throws SQLException {
        return EsqlRuntime.getStatement(con, query, type, holdability, false);
    }

    public static PreparedStatement getStatement(Connection con, String query, int type, int holdability, boolean updt) throws SQLException {
        PreparedStatement Return2;
        if (query.trim().length() > 0 && query.trim().charAt(0) == '{') {
            Return2 = holdability != 0 ? con.prepareCall(query, type, concurrency, holdability) : (type != 1003 ? con.prepareCall(query, type, concurrency) : con.prepareCall(query));
        } else {
            int intConc = concurrency;
            if (updt) {
                intConc = 1008;
            }
            Return2 = holdability != 0 ? con.prepareStatement(query, type, intConc, holdability) : con.prepareStatement(query, type, intConc);
        }
        return Return2;
    }

    public static Object remove() {
        return IscobolSystem.get(EsqlRuntime.class);
    }

    public static boolean isStatNoData(String query) {
        String st = query.trim().toUpperCase();
        return st.startsWith("DELETE") || st.startsWith("UPDATE") || st.startsWith("INSERT");
    }

    public static boolean isCall(String query) {
        return query.trim().toUpperCase().startsWith("{CALL");
    }

    public static boolean hasParameters(String query) {
        char[] ca = query.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] != '?') continue;
            return true;
        }
        return false;
    }

    public EsqlPrepare prepareFactory(String prepName, int type, int holdability) {
        EsqlPrepare Return2;
        if (prepName != null) {
            Return2 = (EsqlPrepare)this.getSqlca().allPrepares.get(prepName);
            if (Return2 == null) {
                Return2 = new EsqlPrepare(prepName, type, holdability);
                this.getSqlca().allPrepares.put(prepName, Return2);
            }
        } else {
            Return2 = new EsqlPrepare(prepName, type, holdability);
        }
        return Return2;
    }

    public synchronized EsqlCursor cursorFactory(String curName, Object own) {
        return this.cursorFactory(curName, own, 0, 0);
    }

    public synchronized EsqlCursor cursorFactory(String curName, Object own, int sensitive, Object withReturn) {
        EsqlCursor Return2 = null;
        int intCursorType = this.cursorType;
        if (sensitive == 2) {
            intCursorType = 1005;
        } else if (sensitive == 3) {
            intCursorType = 1004;
        }
        if (curName != null) {
            for (int i = this.actSqlca.allCursors.size() - 1; i >= 0; --i) {
                Return2 = (EsqlCursor)this.getSqlca().allCursors.get(i);
                if (!Return2.is(curName, own)) continue;
                return Return2;
            }
            Return2 = new EsqlCursor(curName, intCursorType, own, withReturn);
            this.getSqlca().allCursors.addElement(Return2);
        } else {
            Return2 = new EsqlCursor(curName, intCursorType, own, withReturn);
        }
        return Return2;
    }

    static void esqlError(int nativeError, String desc) throws SQLException {
        int i;
        for (i = 0; i < 19 && i != nativeError; ++i) {
        }
        throw new SQLException(allErrors[i][1] + desc, allErrors[i][0], 32000 + nativeError);
    }

    private void clearSqlca(CobolVar sqlca) {
        ThreadDependingData tdd = Factory.getCurrent().getTdd();
        this.log = LoggerFactory.get(256);
        this.logDP = LoggerFactory.get(2048);
        if (tdd.sqlca != null) {
            this.connectionPool = tdd.connectionPool;
        } else {
            tdd.connectionPool = this.connectionPool;
        }
        if (tdd.sqlca_n == null) {
            tdd.sqlca_n = new EsqlSqlca(sqlca);
            if (tdd.sqlca == null) {
                tdd.numEsqlTdd = this.numTdd++;
            } else {
                this.numTdd = tdd.numEsqlTdd + 1;
            }
            ((EsqlSqlca)tdd.sqlca_n).errDecode = Config.getSqlDecode();
            ((EsqlSqlca)tdd.sqlca_n).numTdd = this.numTdd;
            ((EsqlSqlca)tdd.sqlca_n).currName = this.defName;
            ((EsqlSqlca)tdd.sqlca_n).currConn = this.defConn;
            if (this.log != null) {
                this.log.info("EsqlRuntime_n NEW THREAD: [" + tdd + "] strNumTdd [" + this.numTdd + "]");
            }
        }
        this.actSqlca = this.getSqlca();
        this.actSqlca.SQLCA.link(sqlca);
        this.actSqlca.SQLCAID.set("SQLCA   ");
        this.actSqlca.SQLWARN.set("        ");
        this.actSqlca.SQLCABC.set(this.getSqlca().SQLCA.getLength());
        this.actSqlca.SQLCODE.set(this.decodeErr(0));
        this.actSqlca.SQLSTATE.set("00000");
        this.actSqlca.SQLERRML.set(0);
        this.actSqlca.SQLERRMC.set("");
        int i = 1;
        while (i <= 6) {
            this.actSqlca.SQLERRD.at(new int[]{i++}).set(0);
        }
        curSqlca = this.actSqlca;
    }

    void fillSqlca(SQLException sqlex, CobolVar sqlca) {
        block12: {
            this.actSqlca = this.getSqlca();
            this.actSqlca.SQLCA.link(sqlca);
            if (sqlex != null) {
                String state = sqlex.getSQLState();
                if (state == null) {
                    state = "XXXXX";
                }
                this.actSqlca.SQLSTATE.set(state);
                this.actSqlca.SQLERRMC.set(sqlex.getMessage());
                this.actSqlca.SQLERRML.set(sqlex.getMessage().length());
                if (sqlex instanceof SQLWarning) {
                    if (warnings) {
                        this.actSqlca.SQLCODE.set(this.decodeErr(sqlex.getErrorCode()));
                    } else {
                        this.actSqlca.SQLCODE.set(this.decodeErr(0));
                    }
                    this.actSqlca.SQLWARN0.set("W");
                    if (state.charAt(4) == '4') {
                        this.actSqlca.SQLWARN1.set("W");
                    }
                } else {
                    int errCode = sqlex.getErrorCode();
                    errCode = errorFact * (errCode == 0 ? 99999 : errCode);
                    this.actSqlca.SQLCODE.set(this.decodeErr(errCode));
                }
            }
            if (methodSqlcaDecoder != null) {
                try {
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: before invoke method sqlcaDecoder " + methodSqlcaDecoder.toString() + "SQLCODE=" + this.actSqlca.SQLCODE);
                    }
                    handlerSqlcaDecoder.sqlcaDecoder(sqlex, this.actSqlca.SQLCODE, this.actSqlca.SQLSTATE, this.actSqlca.SQLERRMC);
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: after invoke method sqlcaDecoder " + methodSqlcaDecoder.toString() + "SQLCODE=" + this.actSqlca.SQLCODE);
                    }
                }
                catch (Exception ex) {
                    if (this.log == null) break block12;
                    this.log.info("EsqlRuntime: invoking method sqlcaDecoder of " + classSqlcaDecoderName + " there is the following exception " + ex);
                }
            }
        }
    }

    void fillSqlca(int fetchRc, CobolVar sqlca, EsqlCursor ec) {
        block12: {
            SQLWarning warn = warnings && ec != null ? ec.getWarnings() : null;
            this.actSqlca = this.getSqlca();
            switch (fetchRc) {
                case 0: {
                    if (warn == null) break;
                    this.fillSqlca(warn, sqlca);
                    break;
                }
                case 1: {
                    this.actSqlca.SQLCA.link(sqlca);
                    if (warn != null) {
                        this.fillSqlca(warn, sqlca);
                        break;
                    }
                    this.fillSqlca(dataTruncation, sqlca);
                    break;
                }
                case -1: {
                    this.actSqlca.SQLCA.link(sqlca);
                    this.actSqlca.SQLCODE.set(this.decodeErr(100));
                    this.actSqlca.SQLSTATE.set("02000");
                    break;
                }
                default: {
                    if (Config.getProperty(".esql.value_too_many_rows", 0) != fetchRc) {
                        throw new IscobolRuntimeException(3, "fillSqlca I");
                    }
                    this.actSqlca.SQLCA.link(sqlca);
                    this.actSqlca.SQLCODE.set(this.decodeErr(fetchRc));
                }
            }
            if (methodSqlcaDecoder != null) {
                try {
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: before invoke method sqlcaDecoder " + methodSqlcaDecoder.toString() + "SQLCODE=" + this.actSqlca.SQLCODE);
                    }
                    handlerSqlcaDecoder.sqlcaDecoder(warn, this.actSqlca.SQLCODE, this.actSqlca.SQLSTATE, this.actSqlca.SQLERRMC);
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: after invoke method sqlcaDecoder " + methodSqlcaDecoder.toString() + "SQLCODE=" + this.actSqlca.SQLCODE);
                    }
                }
                catch (Exception ex) {
                    if (this.log == null) break block12;
                    this.log.info("EsqlRuntime: invoking method sqlcaDecoder " + methodSqlcaDecoder.toString());
                    this.log.info("EsqlRuntime: invoking method sqlcaDecoder of " + classSqlcaDecoderName + " there is the following exception " + ex);
                }
            }
        }
    }

    public boolean connect(CobolVar sqlca, String dsn, String usr, String pwd) {
        return this.connect(sqlca, dsn, usr, pwd, "DEFAULT");
    }

    public synchronized boolean connect(CobolVar sqlca, String dsn, String us, String pw, String id) {
        this.clearSqlca(sqlca);
        String usr = us;
        String pwd = pw;
        String opts = null;
        String driver = Config.getProperty(".jdbc.driver", "");
        String url = Config.getProperty(".jdbc.url", "");
        if (usr == null || usr.length() == 0) {
            usr = Config.getProperty(".jdbc.user", "");
        }
        if (pwd == null || pwd.length() == 0) {
            pwd = Config.getProperty(".jdbc.password", "");
        }
        try {
            Connection conn;
            int idx;
            this.actSqlca.strNumTdd = this.actSqlca.numTdd > 1 && Config.getProperty(".jdbc.thread_connection", false) ? "_TH" + this.actSqlca.numTdd : "";
            if (this.connectionPool.get(id.toUpperCase() + this.actSqlca.strNumTdd) != null) {
                EsqlRuntime.esqlError(2, "");
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: CONNECT id [" + id + this.actSqlca.strNumTdd + "]");
            }
            String ds = Config.getProperty(".jdbc.datasource", null);
            boolean ac = Config.getProperty(".jdbc.autocommit", false);
            if ((pwd == null || pwd.length() == 0) && usr != null && (idx = usr.indexOf(47)) > 0) {
                pwd = usr.substring(idx + 1, usr.length());
                usr = usr.substring(0, idx);
            }
            if (ds != null) {
                MyDataSource mds;
                try {
                    mds = (MyDataSource)Class.forName(ds).newInstance();
                }
                catch (ClassNotFoundException ex) {
                    throw new IscobolRuntimeException(3, "" + ex);
                }
                catch (InstantiationException ex) {
                    throw new IscobolRuntimeException(3, "" + ex);
                }
                catch (IllegalAccessException ex) {
                    throw new IscobolRuntimeException(3, "" + ex);
                }
                catch (ClassCastException ex) {
                    throw new IscobolRuntimeException(3, "" + ex);
                }
                if (this.log != null) {
                    String iPwd = "";
                    if (pwd != null && pwd.length() != 0) {
                        iPwd = "********Encrypted Value******";
                    }
                    String tmp = "EsqlRuntime: CONNECTING driver [" + driver + "] dsn [" + dsn + "] user [" + usr + "] password [" + iPwd + "] with datasource [" + mds + "]";
                    this.log.info(tmp);
                }
                conn = mds.connect(dsn, usr, pwd);
            } else {
                if (!id.equalsIgnoreCase("DEFAULT")) {
                    driver = Config.getProperty(".jdbc.driver." + id.toLowerCase().trim(), driver);
                    url = Config.getProperty(".jdbc.url." + id.toLowerCase().trim(), url);
                }
                try {
                    Class.forName(driver);
                }
                catch (ClassNotFoundException ex) {
                    throw new IscobolRuntimeException(3, "" + ex);
                }
                String tim = Config.getProperty(".jdbc.connection.login.timeout", null);
                if (tim != null) {
                    DriverManager.setLoginTimeout(Integer.parseInt(tim));
                }
                if (this.log != null) {
                    String iPwd = "";
                    if (pwd != null && pwd.length() != 0) {
                        iPwd = "********Encrypted Value******";
                    }
                    String tmp = "EsqlRuntime: CONNECTING driver [" + driver + "] url [" + url + "] dsn [" + dsn + "] user [" + usr + "] password [" + iPwd + "]";
                    this.log.info(tmp);
                }
                if (!(usr != null && usr.length() != 0 || pwd != null && pwd.length() != 0)) {
                    opts = Config.getProperty(".jdbc.options", null);
                    if (opts == null) {
                        conn = DriverManager.getConnection(url + dsn);
                    } else {
                        StringTokenizer st = new StringTokenizer(opts, ",");
                        Properties prop = new Properties();
                        while (st.hasMoreElements()) {
                            String key = st.nextToken();
                            int offs = key.indexOf(61);
                            if (offs <= 0) continue;
                            String value = key.substring(offs + 1);
                            key = key.substring(0, offs);
                            prop.setProperty(key, value);
                        }
                        conn = DriverManager.getConnection(url + dsn, prop);
                    }
                } else {
                    opts = "ignored";
                    conn = DriverManager.getConnection(url + dsn, usr, pwd);
                }
            }
            if (conn == null) {
                EsqlRuntime.esqlError(12, dsn);
            }
            try {
                conn.setAutoCommit(ac);
                this.actSqlca.currConn = conn;
            }
            catch (SQLException tim) {
                // empty catch block
            }
            this.actSqlca.currName = id;
            if (this.actSqlca.strNumTdd.equals("")) {
                this.defName = id;
                this.defConn = conn;
            }
            this.connectionPool.put(id.toUpperCase() + this.actSqlca.strNumTdd, conn);
            if (this.log != null) {
                String iPwd = "";
                if (pwd != null && pwd.length() != 0) {
                    iPwd = "********Encrypted Value******";
                }
                this.log.info("EsqlRuntime: CONNECT  connection [" + conn + "] connection ID [" + id + "] strNumTdd [" + this.actSqlca.strNumTdd + "] driver [" + conn.getMetaData().getDriverName() + " " + conn.getMetaData().getDriverVersion() + "] url [" + conn.getMetaData().getURL() + "] user name [" + conn.getMetaData().getUserName() + "] password[" + iPwd + "] SQLCA [" + this.actSqlca.sqlcaType + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return true;
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: CONNECT  exception [" + ex + "] connection ID [" + id + "] SQLCA [" + this.actSqlca.sqlcaType + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
    }

    public boolean disconnect(CobolVar sqlca) {
        return this.disconnect(sqlca, true);
    }

    public synchronized boolean disconnect(CobolVar sqlca, boolean all) {
        boolean Return2 = true;
        this.clearSqlca(sqlca);
        try {
            if (all) {
                if (this.connectionPool.isEmpty()) {
                    EsqlRuntime.esqlError(14, "");
                }
                Enumeration en = this.connectionPool.elements();
                while (en.hasMoreElements()) {
                    ((Connection)en.nextElement()).close();
                }
                this.connectionPool.clear();
                this.actSqlca.allSelect.clear();
                this.actSqlca.allSavepoint.clear();
                this.actSqlca.currConn = null;
                this.actSqlca.currName = null;
            } else {
                if (this.getCConn() == null) {
                    EsqlRuntime.esqlError(14, "");
                }
                if (this.log != null && this.getCConn() != null) {
                    this.log.info("EsqlRuntime_n: DISCONNECT  current  connection [" + this.getCName() + this.actSqlca.strNumTdd + "] driver [" + this.getCConn().getMetaData().getDriverName() + " " + this.getCConn().getMetaData().getDriverVersion() + "] user name [" + this.getCConn().getMetaData().getUserName() + "]");
                } else if (this.log != null) {
                    this.log.info("EsqlRuntime_n: DISCONNECT  current  connection null ");
                }
                this.getCConn().close();
                this.connectionPool.remove(this.getCName().toUpperCase() + this.actSqlca.strNumTdd);
                Enumeration en = this.actSqlca.allSelect.keys();
                while (en.hasMoreElements()) {
                    String sel = (String)en.nextElement();
                    if (!sel.startsWith(this.getCName().trim() + "--")) continue;
                    this.actSqlca.allSelect.remove(sel);
                }
                this.actSqlca.currConn = null;
                this.actSqlca.currName = null;
            }
            if (this.log != null && all) {
                this.log.info("EsqlRuntime_n: DISCONNECT ALL, SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null && all) {
                this.log.info("EsqlRuntime_n: DISCONNECT ALL, exception [" + ex + "]");
            } else if (this.log != null && this.getCConn() != null) {
                this.log.info("EsqlRuntime_n: DISCONNECT  current, exception [" + ex + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean disconnect(CobolVar sqlca, String id) {
        this.clearSqlca(sqlca);
        Connection conn = (Connection)this.connectionPool.get(id.toUpperCase() + this.actSqlca.strNumTdd);
        try {
            if (conn == null) {
                EsqlRuntime.esqlError(14, id);
            }
            if (this.log != null && conn != null) {
                this.log.info("EsqlRuntime_n: DISCONNECT  id [" + id + "] connection [" + conn + "] strNumTdd [" + this.actSqlca.strNumTdd + "] driver [" + conn.getMetaData().getDriverName() + " " + conn.getMetaData().getDriverVersion() + "] user name [" + conn.getMetaData().getUserName() + "]");
            } else if (this.log != null) {
                this.log.info("EsqlRuntime_n: DISCONNECT  id [" + id + "] connection NULL");
            }
            conn.close();
            this.connectionPool.remove(id.toUpperCase() + this.actSqlca.strNumTdd);
            Enumeration en = this.actSqlca.allSelect.keys();
            while (en.hasMoreElements()) {
                String sel = (String)en.nextElement();
                if (!sel.startsWith(this.getCName().trim() + "--")) continue;
                this.actSqlca.allSelect.remove(sel);
            }
            if (conn == this.getCConn()) {
                this.actSqlca.currConn = (Connection)this.connectionPool.get("DEFAULT" + this.actSqlca.strNumTdd);
                this.actSqlca.currName = this.actSqlca.currConn == null ? null : "DEFAULT";
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: DISCONNECT  id [" + id + "] exception [" + ex + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean setConnection(CobolVar sqlca, String id) {
        this.clearSqlca(sqlca);
        this.actSqlca.strNumTdd = this.actSqlca.numTdd > 1 && Config.getProperty(".jdbc.thread_connection", false) ? "_TH" + this.actSqlca.numTdd : "";
        Connection conn = (Connection)this.connectionPool.get(id.toUpperCase() + this.actSqlca.strNumTdd);
        try {
            if (conn == null) {
                EsqlRuntime.esqlError(14, id);
                if (this.log != null) {
                    this.log.info("EsqlRuntime_n: SET CONNECT id [" + id + this.actSqlca.strNumTdd + "] not found");
                }
            } else if (conn != this.getCConn()) {
                this.actSqlca.currConn = conn;
                this.actSqlca.currName = id;
                if (this.actSqlca.strNumTdd.equals("")) {
                    this.defConn = conn;
                    this.defName = id;
                }
                if (this.log != null && conn != null) {
                    this.log.info("EsqlRuntime_n: SET CONNECT  id [" + id + this.actSqlca.strNumTdd + "] connection [" + conn + this.actSqlca.strNumTdd + "] driver [" + conn.getMetaData().getDriverName() + " " + conn.getMetaData().getDriverVersion() + "] user name [" + conn.getMetaData().getUserName() + "]");
                }
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: SET CONNECT id [" + id + this.actSqlca.strNumTdd + "] exception [" + ex + "]");
            }
            return false;
        }
        return true;
    }

    private int getHoldability(Object isHold) {
        int Return2 = 0;
        if (isHold != null) {
            if ("1".equals(isHold)) {
                Return2 = 1;
            } else if ("2".equals(isHold)) {
                Return2 = 2;
            }
        }
        return Return2;
    }

    public int declareStmt(CobolVar sqlca, String curName, String query, Object isHold, Object own) {
        return this.declareStmt(sqlca, curName, query, isHold, own, false);
    }

    public int declareStmt(CobolVar sqlca, String curName, String query, Object isHold, Object own, boolean updt) {
        return this.declareStmt(sqlca, curName, query, isHold, own, updt, 0, null);
    }

    public synchronized int declareStmt(CobolVar sqlca, String curName, String query, Object isHold, Object own, boolean updt, int sensitive, Object withReturn) {
        this.clearSqlca(sqlca);
        EsqlCursor ec = this.cursorFactory(curName, own, sensitive, withReturn);
        ec.setQuery(query.trim());
        ec.setHoldability(this.getHoldability(isHold));
        if (updt) {
            ec.setUpdatable();
        }
        if (this.log != null) {
            this.log.info("EsqlRuntime_n: DECLARE STMT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + curName + "] sensitive [" + sensitive + "] statement [" + query + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
        }
        return ec.getHandle();
    }

    public synchronized int declareStmtOracle(CobolVar sqlca, String curName, String query, Object isHold, Object own) {
        return this.declareStmtOracle(sqlca, curName, query, isHold, own, 0);
    }

    public synchronized int declareStmtOracle(CobolVar sqlca, String curName, String query, Object isHold, Object own, int sensitive) {
        this.clearSqlca(sqlca);
        EsqlOraPrepStat ec = new EsqlOraPrepStat("callable", 0, 0);
        try {
            ec.setQuery(this.getCConn(), query.trim());
            if (this.log != null) {
                this.log.info("EsqlRuntime: DECLARE STMTC ORACLE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + curName + "] sensitive [" + sensitive + "] statement [" + query + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime: DECLARE STMC  ORACLE[" + this.actSqlca.strNumTdd + "] exception [" + ex + "]");
            }
            return 0;
        }
        return ec.getHandle();
    }

    public synchronized int declare(CobolVar sqlca, String curName, Object prep, Object isHold, Object own) {
        return this.declare(sqlca, curName, prep, isHold, own, null);
    }

    public synchronized int declare(CobolVar sqlca, String curName, Object prep, Object isHold, Object own, Object withReturn) {
        this.clearSqlca(sqlca);
        EsqlCursor ec = this.cursorFactory(curName, own, 0, withReturn);
        ec.setHoldability(this.getHoldability(isHold));
        if (prep instanceof String) {
            ec.setPrepName((String)prep);
        } else {
            ec.setPrepName("" + prep);
        }
        if (prep instanceof ObjectVar) {
            Object obj = ((ObjectVar)prep).getId();
            if (this.actSqlca.allCursHndl.get(prep) != null) {
                this.actSqlca.allCursHndl.remove(prep);
            }
            if (curName != null) {
                this.actSqlca.allCursHndl.put(prep, ec);
            }
            if (obj instanceof EsqlPrepare) {
                ec.setPrepare((EsqlPrepare)obj);
            } else {
                try {
                    EsqlRuntime.esqlError(6, prep.toString());
                }
                catch (SQLException ex) {
                    this.fillSqlca(ex, sqlca);
                    return 0;
                }
            }
        } else {
            ec.setPrepare(this.prepareFactory(prep.toString(), ec.getType(), ec.getHoldability()));
        }
        if (this.log != null) {
            this.log.info("EsqlRuntime_n: DECLARE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + curName + "] statement [" + (ec == null ? "invalid --> NULL" : ec.getQuery()) + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
        }
        return ec.getHandle();
    }

    public synchronized int getCursorHandle(String curName, Object own) {
        for (int i = this.actSqlca.allCursors.size() - 1; i >= 0; --i) {
            EsqlCursor ec = (EsqlCursor)this.actSqlca.allCursors.get(i);
            if (!ec.is(curName, own)) continue;
            return ec.getHandle();
        }
        return 0;
    }

    private synchronized EsqlCursor getCursor(ObjectVar hndl) throws SQLException {
        return this.getCursor(hndl, (Object)null);
    }

    private synchronized EsqlCursor getCursor(ObjectVar hndl, Object own) throws SQLException {
        EsqlCursor Return2 = null;
        try {
            Return2 = (EsqlCursor)hndl.getId();
            if (Return2 == null && own != null) {
                String curName = hndl.getName().substring(10);
                this.actSqlca = this.getSqlca();
                for (int i = this.actSqlca.allCursors.size() - 1; i >= 0; --i) {
                    EsqlCursor ec = (EsqlCursor)this.actSqlca.allCursors.get(i);
                    if (ec == null || !ec.name.equalsIgnoreCase(curName) || !ec.owner.getClass().toString().equals(own.getClass().toString())) continue;
                    Return2 = ec;
                }
            }
            if (Return2 == null) {
                EsqlRuntime.esqlError(6, "" + hndl.toString());
            }
        }
        catch (ClassCastException ex) {
            EsqlRuntime.esqlError(6, "" + hndl.getId());
        }
        return Return2;
    }

    public synchronized boolean getCursor(CobolVar sqlca, ObjectVar hndl) {
        return this.getCursor(sqlca, hndl, null);
    }

    public synchronized boolean getCursor(CobolVar sqlca, ObjectVar hndl, Object own) {
        this.clearSqlca(sqlca);
        try {
            EsqlCursor esqlCursor = this.getCursor(hndl, own);
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            return false;
        }
        return true;
    }

    public synchronized boolean closeCursor(CobolVar sqlca, ObjectVar hndl) {
        return this.closeCursor(sqlca, hndl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean closeCursor(CobolVar sqlca, ObjectVar hndl, Object own) {
        EsqlCursor ec = null;
        this.clearSqlca(sqlca);
        try {
            ec = this.getCursor(hndl);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: CLOSE CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + ec.name + "]");
            }
            ec.close();
            if (this.actSqlca.allCursHndl.get(hndl) != null) {
                Vector vector = this.actSqlca.allCursors;
                synchronized (vector) {
                    for (int i = this.actSqlca.allCursors.size() - 1; i >= 0; --i) {
                        ec = (EsqlCursor)this.actSqlca.allCursors.get(i);
                        if (ec != (EsqlCursor)this.actSqlca.allCursHndl.get(hndl)) continue;
                        this.actSqlca.allCursors.remove(ec);
                        break;
                    }
                }
                this.actSqlca.allCursHndl.remove(hndl);
            }
            hndl.free();
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: CLOSE CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean closeCursor(CobolVar sqlca, String curName, Object own) {
        EsqlCursor ec = null;
        this.clearSqlca(sqlca);
        try {
            Vector vector = this.actSqlca.allCursors;
            synchronized (vector) {
                for (int i = this.actSqlca.allCursors.size() - 1; i >= 0; --i) {
                    ec = (EsqlCursor)this.actSqlca.allCursors.get(i);
                    if (!ec.is(curName, own)) continue;
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: CLOSE CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + ec.name + "]");
                    }
                    ec.close();
                    this.actSqlca.allCursors.remove(ec);
                    break;
                }
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: CLOSE CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + ex + " name [" + (ec == null ? "invalid --> NULL" : ec.name) + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public boolean bindCol(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len) {
        return this.bindCol(cursHndl, val, type, order, ind, len, null);
    }

    public boolean bindCol(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len, Object own) {
        try {
            EsqlCursor ec = this.getCursor(cursHndl, own);
            ec.bindCol(val, type, order, ind, len);
        }
        catch (SQLException ex) {
            return false;
        }
        return true;
    }

    public boolean bindColOra(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len) {
        try {
            EsqlOraPrepStat ec = (EsqlOraPrepStat)UserHandles.getId(cursHndl.toint());
            ec.bindCol(val, type, order, ind, len);
        }
        catch (SQLException ex) {
            return false;
        }
        return true;
    }

    public boolean getObject(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len) {
        this.actSqlca = this.getSqlca();
        try {
            ResultSet rs = null;
            if (cursHndl.getId() instanceof ResultSet) {
                rs = (ResultSet)cursHndl.getId();
            } else {
                EsqlRuntime.esqlError(6, "" + cursHndl.getId());
            }
            if (this.actSqlca.hv == null) {
                this.actSqlca.hv = new EsqlHostVar(val, type, order, ind, len);
            } else {
                this.actSqlca.hv.setHostVar(val, type, order, ind, len, null);
            }
            return this.actSqlca.hv.toVar(order, rs);
        }
        catch (SQLException ex) {
            this.actSqlca.SQLCODE.set(this.decodeErr(100));
            this.actSqlca.SQLSTATE.set("02000");
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: exception in getObject connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] Exception [" + ex + "] var [" + val.getName() + "] thread [" + Factory.getCurrent().getTdd() + "] hndl [" + cursHndl.getId() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
    }

    public boolean setParam(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len, String mode) {
        return this.setParam(cursHndl, val, type, order, ind, len, mode, null);
    }

    public boolean setParam(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len, String mode, Object own) {
        return this.setParam(cursHndl, val, type, order, ind, len, mode, own, (short)-1);
    }

    public boolean setParam(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len, String mode, Object own, short sqlType) {
        try {
            EsqlCursor ec = this.getCursor(cursHndl, own);
            ec.setParam(val, type, order, ind, len, mode, sqlType);
        }
        catch (SQLException ex) {
            return false;
        }
        return true;
    }

    public boolean setParamOra(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len, String mode) {
        return this.setParamOra(cursHndl, val, type, order, ind, len, mode, (short)-1);
    }

    public boolean setParamOra(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len, String mode, short sqlType) {
        try {
            EsqlOraPrepStat ec = (EsqlOraPrepStat)UserHandles.getId(cursHndl.toint());
            ec.setParam(val, type, order, ind, len, sqlType);
        }
        catch (SQLException ex) {
            return false;
        }
        return true;
    }

    public boolean setParamQ(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len, String mode) {
        return this.setParamQ(cursHndl, val, type, order, ind, len, mode, (short)-1);
    }

    public boolean setParamQ(ObjectVar cursHndl, CobolVar val, int type, int order, NumericVar ind, NumericVar len, String modei, short sqlType) {
        int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
        this.actSqlca = this.getSqlca();
        try {
            PreparedStatement ps = (PreparedStatement)cursHndl.getId();
            if (this.actSqlca.hv == null) {
                this.actSqlca.hv = new EsqlHostVar(val, type, order, ind, len, null, sqlType);
            } else {
                this.actSqlca.hv.setHostVar(val, type, order, ind, len, null, sqlType);
            }
            this.actSqlca.hv.fromVar(order, ps, trimType);
        }
        catch (Exception ex) {
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: setParamq connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception " + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean open(CobolVar sqlca, ObjectVar cursHndl) {
        return this.open(sqlca, cursHndl, false);
    }

    public synchronized boolean open(CobolVar sqlca, ObjectVar cursHndl, boolean rowset) {
        EsqlCursor ec = null;
        this.clearSqlca(sqlca);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            ec = this.getCursor(cursHndl);
            ec.setRowset(rowset);
            ec.open(this.getCConn());
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPENING CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + ec.name + "] statement [" + ec.getQueryLog() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            ec.descr = null;
            if (warnings) {
                this.fillSqlca(ec.getWarnings(), sqlca);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: OPEN CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + ec.name + "] statement [" + ec.getQuery() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: OPEN CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + (ec == null ? "invalid --> NULL" : ec.name) + "] statement [" + (ec == null ? "invalid --> NULL" : ec.getQueryLog()) + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean openDescr(CobolVar sqlca, String curName, ObjectVar cursHndl, CobolVar descr, Object owner, boolean d64) {
        PreparedStatement stmt = null;
        ParameterMetaData parMeta = null;
        ResultSetMetaData resMeta = null;
        int numPar = 0;
        EsqlRuntime.d64 = d64;
        this.clearSqlca(sqlca);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            EsqlCursor ec = (EsqlCursor)cursHndl.getId();
            stmt = ((EsqlPrepare)this.getSqlca().allPrepares.get(ec.getPrepName())).getHstmt();
            parMeta = stmt.getParameterMetaData();
            resMeta = stmt.getMetaData();
            this.linkSqlda(descr);
            if (this.actSqlda.allOpenDescr.containsKey(curName)) {
                this.actSqlda.allOpenDescr.replace(curName, descr);
            } else {
                this.actSqlda.allOpenDescr.put(curName, descr);
            }
            Object hv = null;
            CobolVar newVar = null;
            Vector<EsqlHostVar> params = new Vector<EsqlHostVar>();
            numPar = parMeta.getParameterCount();
            int sqlType = 1;
            int len = 1;
            params.addElement(null);
            for (int i = 1; i <= numPar; ++i) {
                sqlType = sqlTypesOraRev.containsKey(this.actSqlda.DVTYP.atNC(i).toint()) ? (Integer)sqlTypesOraRev.get(this.actSqlda.DVTYP.atNC(i).toint()) : 1;
                len = this.actSqlda.DVLN.atNC(i).toint();
                switch (sqlType) {
                    case 6: 
                    case 7: 
                    case 8: {
                        if (len <= 21) {
                            newVar = Factory.getVarFloat(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "v" + i, false, 18, 0, true, false, false);
                            break;
                        }
                        if (REAL != null) break;
                        newVar = Factory.getVarDouble(Factory.getNotOptmzdMem(8), 0, 8, false, null, null, null, "v" + i, false, 3, 0, true, false, false);
                        break;
                    }
                    case 5: {
                        newVar = Factory.getVarBinary(Factory.getNotOptmzdMem(2), 0, 2, false, null, null, null, "v" + i, false, 4, 0, true, false, false);
                        break;
                    }
                    case 4: {
                        newVar = Factory.getVarBinary(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "v" + i, false, 9, 0, true, false, false);
                        break;
                    }
                    case -5: {
                        newVar = Factory.getVarBinary(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "v1", false, 18, 0, true, false, false);
                        break;
                    }
                    case 3: {
                        newVar = Factory.getVarPackedAcu(Factory.getNotOptmzdMem(len / 2 + 1), 0, len / 2 + 1, false, null, null, null, "v" + i, false, len, resMeta.getScale(i), true, false, false);
                        break;
                    }
                    default: {
                        newVar = Factory.getVarAlphanum(Factory.getNotOptmzdMem(len), 0, len, false, null, null, null, "v" + i, false, false);
                    }
                }
                newVar.setAddress(this.actSqlda.DV.atNC(i).tolong());
                MYIND = Factory.getVarBinary(Factory.getNotOptmzdMem(2), 0, 2, false, null, null, null, "MYIND", false, 4, 0, true, false, false, false);
                params.addElement(new EsqlHostVar(newVar, sqlType, i, MYIND, Factory.getNumLiteral(len, len, 0, false)));
            }
            EsqlRuntime.setParams(stmt, params);
            ec.open(this.getCConn());
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPEN DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] stmt [" + stmt + "] parCount [" + numPar + "] into variable [" + descr.getName() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]] SQLERRMC [" + this.actSqlca.SQLERRMC.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPEN DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] parCount [" + numPar + "] into variable [" + descr.getName() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]] SQLERRMC [" + this.actSqlca.SQLERRMC.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean openRowset(CobolVar sqlca, ObjectVar cursHndl) {
        boolean Return2 = this.open(sqlca, cursHndl, true);
        return Return2;
    }

    public synchronized boolean openDescrDb2(CobolVar sqlca, ObjectVar cursHndl, CobolVar descr, boolean d64) {
        PreparedStatement stmt = null;
        ResultSetMetaData resMeta = null;
        int numCol = 0;
        EsqlRuntime.d64 = d64;
        this.clearSqlca(sqlca);
        try {
            this.linkSqldaDb2(descr);
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            EsqlCursor ec = this.getCursor(cursHndl);
            ec.open(this.getCConn());
            if (warnings) {
                this.fillSqlca(ec.getWarnings(), sqlca);
            }
            stmt = ec.getPrep().getHstmt();
            resMeta = stmt.getMetaData();
            numCol = resMeta.getColumnCount();
            if (ec.db2BindCols.size() == 0) {
                for (int i = 1; i <= numCol; ++i) {
                    ec.db2BindCols.add(null);
                }
            }
            ec.descr = descr;
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPEN DESCRIPTOR DB2 connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] stmt [" + stmt + "] parCount [" + numCol + "] into variable [" + descr.getName() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPEN DESCRIPTOR DB2 connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] parCount [" + numCol + "] into variable [" + descr.getName() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean execute(CobolVar sqlca, ObjectVar cursHndl) {
        this.clearSqlca(sqlca);
        EsqlCursor ec = null;
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if ((ec = this.getCursor(cursHndl)) == null) {
                EsqlRuntime.esqlError(6, ": Execute");
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: EXECUTING  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + ec.getQueryLog() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            if (ec.open(this.getCConn())) {
                this.fillSqlca(ec.fetch(1, true, 0), sqlca, ec);
                if (this.actSqlca.SQLCODE.toint() == this.decodeErr(100) && noData != 0) {
                    this.actSqlca.SQLCODE.set(noData);
                    this.actSqlca.SQLSTATE.set("02000");
                } else if (tooManyRows != 0 && ec.fetch(1, false, 0) == 0) {
                    this.actSqlca.SQLCODE.set(tooManyRows);
                    this.actSqlca.SQLSTATE.set("21000");
                }
            } else {
                if (warnings) {
                    this.fillSqlca(ec.getWarnings(), sqlca);
                }
                this.actSqlca.SQLCA.link(sqlca);
                this.actSqlca.SQLERRD.at(new int[]{3}).set(ec.getRowCount());
                if (ec.isStatNoData() && ec.getRowCount() == 0 && noData != 0) {
                    this.actSqlca.SQLCODE.set(noData);
                    this.actSqlca.SQLSTATE.set("02000");
                }
            }
            if (this.actSqlca.SQLCODE.num().compareTo(ZERO.num()) == 0 && ec.hasNullResult()) {
                this.setCodeNull();
            }
            ec.searchCallExc();
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: EXECUTE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + ec.getQuery() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            ec.close();
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                if (ec != null) {
                    this.log.info("EsqlRuntime_n: EXECUTE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + ec.getQueryLog() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + ex + "]");
                } else {
                    this.log.info("EsqlRuntime_n: EXECUTE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + ex + "]");
                }
            }
            if (ec != null) {
                try {
                    ec.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    public synchronized boolean executeOracle(CobolVar sqlca, ObjectVar cursHndl) {
        this.clearSqlca(sqlca);
        EsqlOraPrepStat ec = null;
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if ((ec = (EsqlOraPrepStat)UserHandles.getId(cursHndl.toint())) == null) {
                EsqlRuntime.esqlError(6, ": Execute");
            }
            ec.exec();
            if (warnings) {
                this.fillSqlca(ec.getWarnings(), sqlca);
            }
            this.actSqlca.SQLCA.link(sqlca);
            this.actSqlca.SQLERRD.at(new int[]{3}).set(ec.getRowCount());
            if (this.actSqlca.SQLCODE.num().compareTo(ZERO.num()) == 0 && ec.hasNullResult()) {
                this.setCodeNull();
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTEC ORACLE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + ec.getQueryLog() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            UserHandles.free(cursHndl.toint());
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                if (ec != null) {
                    this.log.info("EsqlRuntime: EXECUTE ORACLE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + ec.getQueryLog() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + ex + "]");
                } else {
                    this.log.info("EsqlRuntime: EXECUTEC ORACLE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + ex + "]");
                }
            }
            if (ec != null) {
                UserHandles.free(cursHndl.toint());
            }
            return false;
        }
        return true;
    }

    public synchronized boolean executeQuery(CobolVar sqlca, ObjectVar cursHndl) {
        this.clearSqlca(sqlca);
        try {
            PreparedStatement stmt = (PreparedStatement)cursHndl.getId();
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if (stmt == null) {
                EsqlRuntime.esqlError(6, ": Execute Query");
            }
            ResultSet rs = stmt.executeQuery();
            if (warnings) {
                this.fillSqlca(rs.getWarnings(), sqlca);
            }
            this.actSqlca.SQLCA.link(sqlca);
            rs.next();
            cursHndl.setId(rs);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: EXECUTE Query connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] stmt [" + rs + "] resultSet [" + rs + "] rows [" + rs.getRow() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: EXECUTE query connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + ex + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean closePreparedStatement(CobolVar sqlca, ObjectVar cursHndl) {
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            ResultSet res = null;
            if (cursHndl.getId() instanceof ResultSet) {
                res = (ResultSet)cursHndl.getId();
            } else {
                EsqlRuntime.esqlError(6, ": Close Prepared Statement");
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: CLOSE PREPARED STATEMENT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] res [" + res + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            if (this.logDP != null) {
                this.logDP.info("Developers log: EsqlRuntime: before close RS " + res);
            }
            res.close();
            cursHndl.free();
        }
        catch (SQLException ex) {
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: PREPARED CLOSE STATEMENT  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + ex + "]");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean executeImmediate(CobolVar sqlca, String query) {
        this.clearSqlca(sqlca);
        Statement stmt = null;
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            stmt = this.getCConn().createStatement();
            if (this.logDP != null) {
                this.logDP.info("Developers log: EsqlRuntime: after open ST " + stmt);
            }
            if (stmt.execute(query)) {
                ResultSet rs = stmt.getResultSet();
                if (warnings) {
                    this.fillSqlca(stmt.getWarnings(), sqlca);
                }
                if (!rs.next()) {
                    this.fillSqlca(-1, sqlca, null);
                }
            } else if (warnings) {
                this.fillSqlca(stmt.getWarnings(), sqlca);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: EXECUTE_IMMEDIATE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + query + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: EXECUTE_IMMEDIATE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + query + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                try {
                    if (this.logDP != null) {
                        this.logDP.info("Developers log: EsqlRuntime: before close ST " + stmt);
                    }
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return true;
    }

    public synchronized boolean executeDescriptorDb2(CobolVar sqlca, String prepName, CobolVar descrInput, CobolVar descrUsing, Object own, boolean d64) {
        EsqlRuntime.d64 = d64;
        this.clearSqlca(sqlca);
        PreparedStatement hstmt = null;
        int sqlType = 0;
        int len = 0;
        String value = "";
        try {
            int i;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            hstmt = ((EsqlPrepare)this.getSqlca().allPrepares.get(prepName)).getHstmt();
            ParameterMetaData parMeta = hstmt.getParameterMetaData();
            ResultSetMetaData resMeta = hstmt.getMetaData();
            if (descrInput != null) {
                this.linkSqldaDb2(descrInput);
                int numCol = parMeta.getParameterCount();
                int numColSda = this.actSqldaDb2.SQLN.toint();
                if (numColSda < numCol) {
                    numCol = 0;
                }
                boolean sqldaInd = true;
                Object hv = null;
                CobolVar newVar = null;
                Vector<CobolVar> params = new Vector<CobolVar>();
                for (i = 1; i <= numCol; ++i) {
                    if (parMeta.getParameterMode(i) != 1 && parMeta.getParameterMode(i) != 2) continue;
                    sqlType = this.actSqldaDb2.SQLTYPE.at(i).toint();
                    len = this.actSqldaDb2.SQLLEN.at(i).toint();
                    switch (sqlType) {
                        case 6: 
                        case 7: 
                        case 8: {
                            if (len <= 21) {
                                newVar = Factory.getVarFloat(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "v" + i, false, 18, 0, true, false, false);
                                break;
                            }
                            if (REAL != null) break;
                            newVar = Factory.getVarDouble(Factory.getNotOptmzdMem(8), 0, 8, false, null, null, null, "v" + i, false, 3, 0, true, false, false);
                            break;
                        }
                        case 5: {
                            newVar = Factory.getVarBinary(Factory.getNotOptmzdMem(2), 0, 2, false, null, null, null, "v" + i, false, 4, 0, true, false, false);
                            break;
                        }
                        case 4: {
                            newVar = Factory.getVarBinary(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "v" + i, false, 9, 0, true, false, false);
                            break;
                        }
                        case -5: {
                            newVar = Factory.getVarBinary(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "v1", false, 18, 0, true, false, false);
                            break;
                        }
                        case 3: {
                            newVar = Factory.getVarPackedAcu(Factory.getNotOptmzdMem(len / 2 + 1), 0, len / 2 + 1, false, null, null, null, "v" + i, false, len, resMeta.getScale(i), true, false, false);
                            break;
                        }
                        default: {
                            len = this.actSqldaDb2.SQLLEN.at(i).toint();
                            newVar = Factory.getVarAlphanumPrv(Factory.getNotOptmzdMem(len), 0, len, false, null, null, null, "v" + i, false, false);
                        }
                    }
                    newVar.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                    params.addElement(newVar);
                }
                EsqlRuntime.setParams(hstmt, params);
            }
            hstmt.execute();
            ResultSet rs = hstmt.getResultSet();
            if (descrUsing != null) {
                this.linkSqldaDb2(descrUsing);
                int numCol = parMeta.getParameterCount();
                int numColSda = this.actSqldaDb2.SQLN.toint();
                if (numColSda < numCol) {
                    numCol = 0;
                }
                boolean sqldaInd = true;
                Object hv = null;
                Object newVar = null;
                block17: for (i = 1; i <= numCol; ++i) {
                    if (parMeta.getParameterMode(i) != 4 && parMeta.getParameterMode(i) != 2) continue;
                    switch (sqlType) {
                        case 6: 
                        case 7: 
                        case 8: {
                            if (len <= 21) {
                                if (FLOAT == null) {
                                    FLOAT = Factory.getVarFloat(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "FLOAT", false, 18, 0, true, false, false);
                                }
                                FLOAT.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                                FLOAT.set(rs.getFloat(i));
                                continue block17;
                            }
                            if (REAL == null) {
                                REAL = Factory.getVarDouble(Factory.getNotOptmzdMem(8), 0, 8, false, null, null, null, "REAL", false, 3, 0, true, false, false);
                            }
                            REAL.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            REAL.set(rs.getDouble(i));
                            continue block17;
                        }
                        case 5: {
                            if (SMALLINT == null) {
                                SMALLINT = Factory.getVarBinary(Factory.getNotOptmzdMem(2), 0, 2, false, null, null, null, "SMALLINT", false, 4, 0, true, false, false);
                            }
                            SMALLINT.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            SMALLINT.set(rs.getInt(i));
                            continue block17;
                        }
                        case 4: {
                            if (INTEGER == null) {
                                INTEGER = Factory.getVarBinary(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "INTEGER", false, 9, 0, true, false, false);
                            }
                            INTEGER.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            INTEGER.set(rs.getInt(i));
                            continue block17;
                        }
                        case -5: {
                            if (BIGINT == null) {
                                BIGINT = Factory.getVarBinary(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "BIGINT", false, 18, 0, true, false, false);
                            }
                            BIGINT.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            BIGINT.set(rs.getInt(i));
                            continue block17;
                        }
                        case 3: {
                            DECIMAL = Factory.getVarPackedAcu(Factory.getNotOptmzdMem(len / 2 + 1), 0, len / 2 + 1, false, null, null, null, "DECIMAL", false, len, resMeta.getScale(i), true, false, false);
                            DECIMAL.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            if (len <= 6) {
                                DECIMAL.set(rs.getFloat(i));
                                continue block17;
                            }
                            if (len <= 15) {
                                DECIMAL.set(rs.getDouble(i));
                                continue block17;
                            }
                            DECIMAL.set(rs.getBigDecimal(i));
                            continue block17;
                        }
                        default: {
                            RECVAL = Factory.getVarAlphanumPrv(Factory.getNotOptmzdMem(len), 0, len, false, null, null, null, "RECVAL", false, false);
                            if (value != null && value.length() < len) {
                                len = value.length();
                            } else if (value == null) {
                                len = -1;
                            }
                            if (value == null) continue block17;
                            RECVAL.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            RECVAL.set(value);
                        }
                    }
                }
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTE DESCR :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + prepName + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTE DESCR  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + ex + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean fetch(CobolVar sqlca, ObjectVar cursHndl, int type) {
        return this.fetch(sqlca, cursHndl, type, null);
    }

    public synchronized boolean fetch(CobolVar sqlca, ObjectVar cursHndl, int type, Object own) {
        this.clearSqlca(sqlca);
        EsqlCursor ec = null;
        try {
            ec = this.getCursor(cursHndl, own);
            this.fillSqlca(ec.fetch(type, true, 0), sqlca, ec);
            this.actSqlca.SQLERRD.at(new int[]{3}).set(ec.getRowCount());
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: FETCH  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + ec.name + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                if (ec != null) {
                    this.log.info("EsqlRuntime_n: FETCH  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + ec.name + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                } else {
                    this.log.info("EsqlRuntime_n: FETCH  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [null] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
            return false;
        }
        return true;
    }

    public synchronized boolean fetchDb2(CobolVar sqlca, ObjectVar cursHndl, int type, Object own) {
        EsqlCursor ec = null;
        this.clearSqlca(sqlca);
        try {
            ec = this.getCursor(cursHndl, own);
            if (ec.descr == null) {
                return this.fetch(sqlca, cursHndl, type, own);
            }
            return this.fetchDescrDb2(sqlca, cursHndl, ec.descr, type, false);
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                if (ec != null) {
                    this.log.info("EsqlRuntime: FETCH_DB2  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + ec.name + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                } else {
                    this.log.info("EsqlRuntime: FETCH_DB2  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [null] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
            return false;
        }
    }

    public synchronized boolean fetchInto(CobolVar sqlca, ObjectVar cursHndl, int type) {
        return this.fetchInto(sqlca, cursHndl, type, null);
    }

    public synchronized boolean fetchInto(CobolVar sqlca, ObjectVar cursHndl, int type, Object own) {
        this.clearSqlca(sqlca);
        EsqlCursor ec = null;
        try {
            ec = this.getCursor(cursHndl, own);
            this.fillSqlca(ec.fetch(type, true, 0), sqlca, ec);
            this.actSqlca.SQLERRD.at(new int[]{3}).set(ec.getRowCount());
            if (noData != 0 && ec.isCursorOutEnd()) {
                this.actSqlca.SQLCODE.set(noData);
                this.actSqlca.SQLSTATE.set("02000");
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: FETCH INTO connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + ec.name + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                if (ec != null) {
                    this.log.info("EsqlRuntime_n: FETCH INTO connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "," + this.actSqlca.currConn + "] cursor [" + ec.name + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                } else {
                    this.log.info("EsqlRuntime_n: FETCH INTO connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [null] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
            return false;
        }
        return true;
    }

    public synchronized boolean fetchDescr(CobolVar sqlca, ObjectVar cursHndl, CobolVar descrVar, int type, boolean d64) {
        EsqlRuntime.d64 = d64;
        this.clearSqlca(sqlca);
        EsqlCursor ec = null;
        Object prep = null;
        PreparedStatement stmt = null;
        int numCol = 0;
        try {
            ec = this.getCursor(cursHndl);
            this.fillSqlca(ec.fetch(type, true, 0), sqlca, ec);
            this.linkSqlda(descrVar);
            this.actSqlca.SQLERRD.at(new int[]{3}).set(ec.getRowCount());
            if (noData != 0 && ec.isCursorOutEnd()) {
                this.actSqlca.SQLCODE.set(noData);
                this.actSqlca.SQLSTATE.set("02000");
            }
            if (!ec.isCursorOutEnd()) {
                stmt = ec.getPrep().getHstmt();
                ResultSetMetaData resMeta = stmt.getMetaData();
                numCol = resMeta.getColumnCount();
                this.actSqlda.SQLDFND.set(numCol);
                for (int i = 1; i <= numCol; ++i) {
                    String str = ec.getResultSet().getString(i);
                    if (this.actSqlda.DV.atNC(i).tolong() != 0L) {
                        this.actSqlda.pointedVar.setAddress(this.actSqlda.DV.atNC(i).tolong());
                        this.actSqlda.pointedVar.set(str);
                    }
                    ((CobolVar)this.actSqlda.DVLN.atNC(i)).set(str.length());
                    if (this.actSqlda.DI.atNC(i).tolong() == 0L) continue;
                    this.actSqlda.pointedVar.setAddress(this.actSqlda.DI.atNC(i).tolong());
                    if (str == null) {
                        this.actSqlda.pointedVar.set(1);
                        continue;
                    }
                    this.actSqlda.pointedVar.set(0);
                }
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: FETCH USING DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + ec.name + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                if (ec != null) {
                    this.log.info("EsqlRuntime: FETCH USING DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "," + this.actSqlca.currConn + "] cursor [" + ec.name + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                } else {
                    this.log.info("EsqlRuntime: FETCH USING DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [null] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
            return false;
        }
        return true;
    }

    public synchronized boolean fetchDescrDb2(CobolVar sqlca, ObjectVar cursHndl, CobolVar descrVar, int type, boolean d64) {
        EsqlRuntime.d64 = d64;
        this.clearSqlca(sqlca);
        EsqlCursor ec = null;
        Object prep = null;
        PreparedStatement stmt = null;
        int numCol = 0;
        int len = 0;
        int sqlType = -1;
        byte[] bytearr = null;
        int lenI = 0;
        try {
            ec = this.getCursor(cursHndl);
            this.fillSqlca(ec.fetch(type, true, 0), sqlca, ec);
            this.actSqlca.SQLERRD.at(new int[]{3}).set(ec.getRowCount());
            if (noData != 0 && ec.isCursorOutEnd()) {
                this.actSqlca.SQLCODE.set(noData);
                this.actSqlca.SQLSTATE.set("02000");
            }
            if (!ec.isCursorOutEnd()) {
                int i;
                stmt = ec.getPrep().getHstmt();
                ResultSetMetaData resMeta = stmt.getMetaData();
                numCol = resMeta.getColumnCount();
                this.linkSqldaDb2(descrVar);
                if (ec.db2BindCols.size() == 0) {
                    for (i = 1; i <= numCol; ++i) {
                        ec.db2BindCols.add(null);
                    }
                    MYIND = Factory.getVarBinary(Factory.getNotOptmzdMem(2), 0, 2, false, null, null, null, "MYIND", false, 4, 0, true, false, false, false);
                }
                for (i = 1; i <= numCol; ++i) {
                    String value;
                    sqlType = resMeta.getColumnType(i);
                    bytearr = null;
                    len = resMeta.getPrecision(i);
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR setting " + i + " col len=" + len + " " + this.actSqldaDb2.SQLNAMEC.at(i).toString() + " sqlType=" + sqlType + " db2DataRowAsByteThreshold=" + db2DataRowAsByteThreshold);
                    }
                    if (db2DataRowAsByteThreshold > 0 && len >= db2DataRowAsByteThreshold && (sqlType == 1 || sqlType == 12)) {
                        block52: {
                            try {
                                this.rowObj = (Object[])getDBRowDataAsBytes.invoke((Object)ec.getResultSet(), nullParam);
                                this.rowData = (byte[])this.rowObj[0];
                                this.rowOffs = (int[])this.rowObj[1];
                            }
                            catch (Exception _ex) {
                                if (this.log == null) break block52;
                                this.log.info("EsqlRuntime: exception invoke db2 " + _ex);
                            }
                        }
                        byte[] num = new byte[2];
                        int offs = this.rowOffs[i - 1] + 2;
                        if (sqlType == 12) {
                            System.arraycopy(this.rowData, this.rowOffs[i - 1] + 2, num, 0, 2);
                            lenI = num[0] << 8 & 0xFF00 | num[1] << 0 & 0xFF;
                            offs += 2;
                        } else {
                            lenI = len;
                        }
                        bytearr = new byte[lenI];
                        if (this.log != null && this.rowData != null) {
                            this.log.info("EsqlRuntime: doDb2Bytes rowData[" + EsqlHostVar.bytesToHex(this.rowData) + ", " + this.rowData.length + "]" + offs + ", " + lenI);
                        } else if (this.log != null) {
                            this.log.info("EsqlRuntime: doDb2Bytes rowData[null]" + this.rowOffs[i - 1] + ", " + lenI);
                        }
                        if (this.rowData[this.rowOffs[i - 1]] == 0 && this.rowData[this.rowOffs[i - 1] + 1] == 0) {
                            System.arraycopy(this.rowData, offs, bytearr, 0, bytearr.length);
                        }
                        value = new String(bytearr);
                        if (this.rowData[this.rowOffs[i - 1]] == 0 && this.rowData[this.rowOffs[i - 1] + 1] == 0 && this.log != null) {
                            this.log.info("arrayCopy(rowData," + offs + ", bytearr, 0," + bytearr.length + ") value(hex)[" + EsqlHostVar.bytesToHex(value.getBytes()) + "] bytearr(hex)[" + EsqlHostVar.bytesToHex(bytearr) + "]");
                        }
                    } else {
                        value = ec.getResultSet().getString(i);
                    }
                    switch (sqlType) {
                        case 6: 
                        case 7: 
                        case 8: {
                            if (len <= 21) {
                                if (FLOAT == null) {
                                    FLOAT = Factory.getVarFloat(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "FLOAT", false, 18, 0, true, false, false);
                                }
                                FLOAT.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                                FLOAT.set(ec.getResultSet().getFloat(i));
                                break;
                            }
                            if (REAL == null) {
                                REAL = Factory.getVarDouble(Factory.getNotOptmzdMem(8), 0, 8, false, null, null, null, "REAL", false, 3, 0, true, false, false);
                            }
                            REAL.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            REAL.set(ec.getResultSet().getDouble(i));
                            break;
                        }
                        case 5: {
                            if (SMALLINT == null) {
                                SMALLINT = Factory.getVarBinary(Factory.getNotOptmzdMem(2), 0, 2, false, null, null, null, "SMALLINT", false, 4, 0, true, false, false);
                            }
                            SMALLINT.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            SMALLINT.set(ec.getResultSet().getInt(i));
                            break;
                        }
                        case 4: {
                            if (INTEGER == null) {
                                INTEGER = Factory.getVarBinary(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "INTEGER", false, 9, 0, true, false, false);
                            }
                            INTEGER.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            INTEGER.set(ec.getResultSet().getInt(i));
                            break;
                        }
                        case -5: {
                            if (BIGINT == null) {
                                BIGINT = Factory.getVarBinary(Factory.getNotOptmzdMem(4), 0, 4, false, null, null, null, "BIGINT", false, 18, 0, true, false, false);
                            }
                            BIGINT.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            BIGINT.set(ec.getResultSet().getInt(i));
                            break;
                        }
                        case 3: {
                            if (ec.db2BindCols.get(i - 1) == null) {
                                DECIMAL = Factory.getVarPackedAcu(Factory.getNotOptmzdMem(len / 2 + 1), 0, len / 2 + 1, false, null, null, null, "DECIMAL", false, len, resMeta.getScale(i), true, false, false);
                                ec.db2BindCols.set(i - 1, DECIMAL);
                            } else {
                                DECIMAL = (NumericVar)ec.db2BindCols.get(i - 1);
                            }
                            DECIMAL.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            if (len <= 6) {
                                DECIMAL.set(ec.getResultSet().getFloat(i));
                                break;
                            }
                            if (len <= 15) {
                                DECIMAL.set(ec.getResultSet().getDouble(i));
                                break;
                            }
                            DECIMAL.set(ec.getResultSet().getBigDecimal(i));
                            break;
                        }
                        default: {
                            len = this.actSqldaDb2.SQLLEN.at(i).toint();
                            if (ec.db2BindCols.get(i - 1) == null) {
                                RECVAL = Factory.getVarAlphanumPrv(Factory.getNotOptmzdMem(len), 0, len, false, null, null, null, "RECVAL", false, false);
                                ec.db2BindCols.set(i - 1, RECVAL);
                            } else {
                                RECVAL = (com.iscobol.types_n.PicX)ec.db2BindCols.get(i - 1);
                            }
                            if (value != null && value.length() < len) {
                                len = value.length();
                            } else if (value == null) {
                                len = -1;
                            }
                            if (value == null) break;
                            RECVAL.setAddress(this.actSqldaDb2.SQLDATA.at(i).tolong());
                            if (bytearr != null) {
                                RECVAL.set(bytearr);
                            } else {
                                RECVAL.set(value);
                            }
                            if (this.log == null) break;
                            this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR inp buf[" + RECVAL.toString() + "] hex[" + EsqlHostVar.bytesToHex(RECVAL.toString().getBytes()));
                        }
                    }
                    if (resMeta.isNullable(i) == 1) {
                        MYIND.setAddress(this.actSqldaDb2.SQLIND.at(i).tolong());
                        MYIND.set(len);
                        if (db2DataRowAsByteThreshold > 0 && len >= db2DataRowAsByteThreshold && (sqlType == 1 || sqlType == 12)) {
                            if (this.rowData[this.rowOffs[i - 1]] != 0 || this.rowData[this.rowOffs[i - 1] + 1] != 0) {
                                MYIND.set(-1);
                            }
                        } else if (ec.getResultSet().wasNull()) {
                            MYIND.set(-1);
                        }
                    }
                    if (this.log == null) continue;
                    this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR after setting " + this.actSqldaDb2.SQLNAMEC.at(i).toString() + " SQLIND(" + i + ")=" + this.actSqldaDb2.SQLIND.at(i).tolong() + "," + len);
                }
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + ec.name + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                if (ec != null) {
                    this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "," + this.actSqlca.currConn + "] cursor [" + ec.name + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                } else {
                    this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [null] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
            return false;
        }
        return true;
    }

    public synchronized boolean prepare(CobolVar sqlca, Object name, String stat) {
        this.clearSqlca(sqlca);
        try {
            EsqlPrepare p;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if (name instanceof ObjectVar) {
                p = this.prepareFactory(null, this.cursorType, 0);
                ((ObjectVar)name).setId(p);
            } else {
                p = this.prepareFactory(name.toString(), this.cursorType, 0);
            }
            p.setQuery(this.getCConn(), stat);
            EsqlPrepare pre = (EsqlPrepare)this.actSqlca.allPrepares.get(name);
            if (pre == null) {
                this.actSqlca.allPrepares.put(name, p);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: PREPARE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + p.getName() + "] statement [" + stat + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: PREPARE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + name + "] statement [" + stat + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean prepareDb2Into(CobolVar sqlca, Object name, String stat, CobolVar sqldaDb2, boolean d64) {
        int db2CHAR = 452;
        EsqlRuntime.d64 = d64;
        this.clearSqlca(sqlca);
        int typeSql = 0;
        try {
            EsqlPrepare p;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if (name instanceof ObjectVar) {
                p = this.prepareFactory(null, this.cursorType, 0);
                ((ObjectVar)name).setId(p);
            } else {
                p = this.prepareFactory(name.toString(), this.cursorType, 0);
            }
            p.setQuery(this.getCConn(), stat);
            EsqlPrepare pre = (EsqlPrepare)this.actSqlca.allPrepares.get(name);
            if (pre == null) {
                this.actSqlca.allPrepares.put(name, p);
            } else {
                p = pre;
            }
            ResultSetMetaData resMeta = p.getHstmt().getMetaData();
            this.linkSqldaDb2(sqldaDb2);
            int numCol = resMeta.getColumnCount();
            this.actSqldaDb2.SQLD.set(numCol);
            for (int i = 1; i <= numCol; ++i) {
                typeSql = resMeta.getColumnType(i);
                if (sqlTypes.get(typeSql) != null) {
                    typeSql = (Integer)sqlTypes.get(typeSql);
                } else {
                    typeSql = db2CHAR;
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: PREPARE INTO :SQLDA column " + i + " sqltype not found " + typeSql + "default 452 USED");
                    }
                }
                this.actSqldaDb2.SQLTYPE.at(i).set(typeSql);
                if (resMeta.getColumnType(i) == 3) {
                    this.actSqldaDb2.SQLLEN.at(i).set(256 * resMeta.getScale(i) + resMeta.getPrecision(i));
                } else {
                    this.actSqldaDb2.SQLLEN.atNC(i).set(resMeta.getPrecision(i));
                }
                this.actSqldaDb2.SQLNAMEC.at(i).set(resMeta.getColumnName(i));
                this.actSqldaDb2.SQLNAMEL.at(i).set(resMeta.getColumnName(i).trim().length());
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: PREPARE INTO :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + p.getName() + "] statement [" + stat + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime: PREPARE INTO :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + name + "] statement [" + stat + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean prepareQuery(CobolVar sqlca, ObjectVar hndl, CobolVar fromVar, String stat, String name) {
        this.clearSqlca(sqlca);
        try {
            PreparedStatement stmt;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if (fromVar != null) {
                stat = stat.replace("--isFromVar--", fromVar.toString());
                name = name + fromVar;
            }
            if ((stmt = (PreparedStatement)this.actSqlca.allSelect.get(this.getCName().trim() + "--" + name)) == null) {
                stmt = this.getCConn().prepareStatement(stat);
                this.actSqlca.allSelect.put(this.getCName().trim() + "--" + name, stmt);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: PREPARE QUERY connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] prep [" + stmt + "] name [" + name + "] statement [" + stat + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            hndl.setId(stmt);
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: PREPARE QUERY connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] hndl [" + hndl + "] statement [" + stat + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean commit(CobolVar sqlca) {
        this.clearSqlca(sqlca);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            this.getCConn().commit();
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: COMMIT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: COMMIT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean rollback(CobolVar sqlca) {
        return this.rollback(sqlca, "");
    }

    public synchronized boolean rollback(CobolVar sqlca, String sPoint) {
        this.clearSqlca(sqlca);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if (sPoint != null && sPoint.length() > 0) {
                this.getCConn().rollback((Savepoint)this.actSqlca.allSavepoint.get(sPoint));
            } else {
                this.getCConn().rollback();
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: ROLLBACK connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + sPoint + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime_n: ROLLBACK connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + sPoint + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public static void setParams(PreparedStatement st, Vector params) throws SQLException {
        EsqlHostVar hv;
        int i;
        int end = params.size();
        int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
        for (i = 1; i < end && (hv = (EsqlHostVar)params.get(i)) != null; ++i) {
            hv.fromVar(i, st, trimType);
        }
        if (st instanceof CallableStatement) {
            for (i = 1; i < end && (hv = (EsqlHostVar)params.get(i)) != null; ++i) {
                hv.regOutVar(i, (CallableStatement)st);
            }
        }
    }

    public static boolean fillHostVars(CallableStatement hstmt, Vector params) throws SQLException {
        EsqlHostVar hv;
        boolean Return2 = false;
        int end = params.size();
        for (int i = 1; i < end && (hv = (EsqlHostVar)params.get(i)) != null; ++i) {
            Return2 |= hv.toVar(i, hstmt, typeIndTrunk);
        }
        return Return2;
    }

    public static boolean fillHostVars(ResultSet hstmt, Vector params) throws SQLException {
        EsqlHostVar hv;
        boolean Return2 = false;
        int end = params.size();
        for (int i = 1; i < end && (hv = (EsqlHostVar)params.get(i)) != null; ++i) {
            Return2 |= hv.toVar(i, hstmt);
        }
        return Return2;
    }

    static boolean searchNullWithoutInd(Vector params) throws SQLException {
        EsqlHostVar hv;
        boolean Return2 = false;
        int end = params.size();
        for (int i = 1; i < end && !Return2 && (hv = (EsqlHostVar)params.get(i)) != null; ++i) {
            Return2 = hv.isResultNull();
        }
        return Return2;
    }

    public synchronized boolean procedure(CobolVar sqlca, String query, Object[] args) {
        Object vars = null;
        Object curs = null;
        this.clearSqlca(sqlca);
        boolean trunc = false;
        Vector<EsqlHostVar> params = null;
        String mode = modeIODef;
        String parMode = modeIODef;
        CallableStatement cs = null;
        try {
            int col;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            cs = this.getCConn().prepareCall(query);
            if (args != null && args.length > 0) {
                params = new Vector<EsqlHostVar>();
                params.addElement(null);
                int i = 0;
                int j = 0;
                while (i < args.length) {
                    EsqlHostVar hv;
                    parMode = (String)args[i + 3];
                    mode = parMode.equals("I") ? "IN" : (parMode.equals("O") ? "OUT" : (parMode.equals("D") ? modeIODef : "INOUT"));
                    if (args[i + 2] != null && (Integer)args[i + 2] == 2003) {
                        int type = 0;
                        String name = (String)this.procedureTypeNames.get(j + 1);
                        if (name != null) {
                            type = (Integer)this.procedureTypes.get(name);
                        }
                        hv = new EsqlOraHostVar((CobolVar)args[i], 0, j + 1, (NumericVar)args[i + 1], null, mode);
                        params.addElement(hv);
                        hv.setName(name);
                        hv.setSpecType(type);
                    } else {
                        hv = new EsqlHostVar((CobolVar)args[i], 0, j + 1, (NumericVar)args[i + 1], null, mode);
                        params.addElement(hv);
                    }
                    i += 4;
                    ++j;
                }
                EsqlRuntime.setParams(cs, params);
            }
            if (this.log != null) {
                int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
                String quer = "] trimType[" + trimType + "] using[";
                if (params != null && params.size() > 0) {
                    for (col = 1; col < params.size(); ++col) {
                        if (col > 1) {
                            quer = quer + ", ";
                        }
                        if (params.get(col) != null) {
                            if (trimType == -1) {
                                quer = quer + "'" + params.get(col).getVar().toString() + "'";
                                continue;
                            }
                            quer = quer + "'" + EsqlHostVar.rtrim(params.get(col).getVar(), trimType, trimType) + "'";
                            continue;
                        }
                        quer = quer + "null";
                    }
                }
                this.log.info("EsqlRuntime_n: PROCEDURE before execute connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + query + quer + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            if (this.hasExecuteHook()) {
                this.callExecuteHook(query, cs, params);
            }
            cs.executeUpdate();
            if (params != null) {
                trunc = EsqlRuntime.fillHostVars(cs, params);
                if (trunc) {
                    this.fillSqlca(1, sqlca, null);
                } else if (EsqlRuntime.searchNullWithoutInd(params)) {
                    this.setCodeNull();
                }
            }
            this.procedureTypes.clear();
            this.procedureTypeNames.clear();
            cs.close();
            if (this.log != null) {
                int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
                String quer = "] trimType[" + trimType + "] using[";
                if (params != null && params.size() > 0) {
                    for (col = 1; col < params.size(); ++col) {
                        if (col > 1) {
                            quer = quer + ", ";
                        }
                        if (params.get(col) != null) {
                            if (trimType == -1) {
                                quer = quer + "'" + params.get(col).getVar().toString() + "'";
                                continue;
                            }
                            quer = quer + "'" + EsqlHostVar.rtrim(params.get(col).getVar(), trimType, trimType) + "'";
                            continue;
                        }
                        quer = quer + "null";
                    }
                }
                this.log.info("EsqlRuntime_n: PROCEDURE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + query + quer + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
                String quer = "] trimType[" + trimType + "] using[";
                if (params != null && params.size() > 0) {
                    for (int col = 1; col < params.size(); ++col) {
                        if (col > 1) {
                            quer = quer + ", ";
                        }
                        if (params.get(col) != null) {
                            if (trimType == -1) {
                                quer = quer + "'" + params.get(col).getVar().toString() + "'";
                                continue;
                            }
                            quer = quer + "'" + EsqlHostVar.rtrim(params.get(col).getVar(), trimType, trimType) + "'";
                            continue;
                        }
                        quer = quer + "null";
                    }
                }
                this.log.info("EsqlRuntime_n: PROCEDURE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + query + quer + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            this.procedureTypes.clear();
            this.procedureTypeNames.clear();
            try {
                if (cs != null) {
                    cs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public synchronized boolean createType(CobolVar sqlca, int ord, String name, int type, Object newType) {
        this.procedureTypes.put(name, Integer.valueOf((Integer)newType));
        this.procedureTypeNames.put(ord + 1, name);
        return true;
    }

    public int allocate(ObjectVar hostVar, Object own, int sqlType) {
        EsqlCursorHndl ec = new EsqlCursorHndl(this.cursorType, sqlType, own, false);
        hostVar.set(ec.getHandle());
        return ec.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int free(ObjectVar hostVar) {
        this.actSqlca = this.getSqlca();
        EsqlPrepare ret = (EsqlPrepare)this.actSqlca.allPrepares.get(hostVar);
        if (ret != null) {
            try {
                if (this.actSqlca.allCursHndl.get(hostVar) != null) {
                    EsqlCursor ec = null;
                    Vector vector = this.actSqlca.allCursors;
                    synchronized (vector) {
                        for (int i = this.actSqlca.allCursors.size() - 1; i >= 0; --i) {
                            ec = (EsqlCursor)this.actSqlca.allCursors.get(i);
                            if (ec != (EsqlCursor)this.actSqlca.allCursHndl.get(hostVar)) continue;
                            this.actSqlca.allCursors.remove(ec);
                            break;
                        }
                    }
                    this.actSqlca.allCursHndl.remove(hostVar);
                }
                ret.close();
                this.actSqlca.allPrepares.remove(hostVar);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        hostVar.free();
        return 0;
    }

    public static Connection getCurrConnection() {
        return EsqlRuntime.get().getCConn();
    }

    public static ResultSet getResultSet(String rsName) {
        return EsqlRuntime.get().getIResultSet(rsName);
    }

    public boolean rsUpdateCol(CobolVar sqlca, ObjectVar cursHndl, String name, CobolVar val, int type, int order, NumericVar ind, NumericVar len) {
        EsqlCursor ec = null;
        try {
            ec = this.getCursor(cursHndl);
            ec.updateCol(val, name, type, order, ind, len);
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            return false;
        }
        return true;
    }

    public boolean rsUpdColRowset(CobolVar sqlca, ObjectVar cursHndl, String name, CobolVar val, int type, int order, NumericVar ind, NumericVar len) {
        EsqlCursor ec = null;
        try {
            ec = this.getCursor(cursHndl);
            ec.updCol(val, name, type, order, ind, len);
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            return false;
        }
        return true;
    }

    public boolean rsUpdateColDb2Reg(CobolVar sqlca, ObjectVar cursHndl, String name, String sel, int type, int order, NumericVar ind, NumericVar len, boolean d64) {
        EsqlCursor ec = null;
        EsqlRuntime.d64 = d64;
        try {
            if (this.actSqlca.regDb2 == null) {
                this.actSqlca.regDb2 = this.actSqlca.currConn.createStatement();
            }
            ResultSet rs = this.actSqlca.regDb2.executeQuery(sel);
            rs.next();
            String res = rs.getObject(1).toString();
            ec = this.getCursor(cursHndl);
            ec.updateColDb2Reg(res, name, type, order, ind, len);
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            return false;
        }
        return true;
    }

    public boolean rsUpdateRow(CobolVar sqlca, ObjectVar cursHndl) {
        EsqlCursor ec = null;
        this.clearSqlca(sqlca);
        try {
            ec = this.getCursor(cursHndl);
            if (ec.isRowset()) {
                return this.rsUpdateRowset(sqlca, cursHndl, 0);
            }
            ec.updateRow();
            if (this.log != null) {
                this.log.info("EsqlRuntime: UPDATE CURRENT [" + ec.name + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] SQLERRMC[" + this.actSqlca.SQLERRMC.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                String name = "null";
                if (ec != null) {
                    // empty if block
                }
                name = ec.name;
                this.log.info("EsqlRuntime: UPDATE CURRENT " + name + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public boolean rsUpdateRowset(CobolVar sqlca, ObjectVar cursHndl, int row) {
        EsqlCursor ec = null;
        int actRow = 0;
        this.clearSqlca(sqlca);
        try {
            ec = this.getCursor(cursHndl);
            if (ec.getResultSet() == null) {
                throw new SQLException(" Cursor null", " updateRowset");
            }
            if (row == 0) {
                ec.beforeFirst();
                while (ec.next()) {
                    ec.updateHostVars();
                    ec.updateRow();
                    ++actRow;
                }
                this.actSqlca.SQLERRD.at(new int[]{3}).set(actRow);
            } else {
                actRow = ec.getRow();
                if (!ec.absolute(row)) {
                    throw new SQLException(" Invalid row ", " updateRowset");
                }
                ec.updateHostVars();
                ec.updateRow();
                if (actRow >= row) {
                    --actRow;
                }
                ec.absolute(actRow);
                this.actSqlca.SQLERRD.at(new int[]{3}).set(1);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: UPDATE CURRENT ROWSET [" + ec.name + "] row " + row + " connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                String name = "null";
                if (ec != null) {
                    // empty if block
                }
                name = ec.name;
                this.log.info("EsqlRuntime: UPDATE CURRENT ROWSET [" + name + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public boolean rsUpdateNull(CobolVar sqlca, ObjectVar cursHndl, String name) {
        this.clearSqlca(sqlca);
        try {
            EsqlCursor ec = this.getCursor(cursHndl);
            ec.updateNull(name);
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            return false;
        }
        return true;
    }

    public boolean rsDeleteRow(CobolVar sqlca, ObjectVar cursHndl) {
        EsqlCursor ec = null;
        try {
            ec = this.getCursor(cursHndl);
            ec.deleteRow();
            if (this.log != null) {
                this.log.info("EsqlRuntime: DELETE CURRENT [" + ec.name + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                String name = "null";
                if (ec != null) {
                    // empty if block
                }
                name = ec.name;
                this.log.info("EsqlRuntime: DELETE CURRENT [" + name + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public boolean rsDeleteRowset(CobolVar sqlca, ObjectVar cursHndl, int row) {
        EsqlCursor ec = null;
        int actRow = 0;
        this.clearSqlca(sqlca);
        try {
            ec = this.getCursor(cursHndl);
            if (ec.getResultSet() == null) {
                throw new SQLException(" Cursor null", " deleteRowset");
            }
            if (row == 0) {
                ec.beforeFirst();
                while (ec.next()) {
                    ec.deleteRow();
                    ++actRow;
                }
                this.actSqlca.SQLERRD.at(new int[]{3}).set(actRow);
            } else {
                actRow = ec.getRow();
                if (!ec.absolute(row)) {
                    throw new SQLException(" Invalid row ", " deleteRowset");
                }
                ec.deleteRow();
                if (actRow >= row) {
                    --actRow;
                }
                ec.absolute(actRow);
                this.actSqlca.SQLERRD.at(new int[]{3}).set(1);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: DELETE CURRENT ROWSET [" + ec.name + "] row " + row + " connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                String name = "null";
                if (ec != null) {
                    // empty if block
                }
                name = ec.name;
                this.log.info("EsqlRuntime: DELETE CURRENT ROWSET [" + name + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean describe(CobolVar sqlca, boolean selectList, String prepName, CobolVar intoVar, boolean d64) {
        EsqlSqlda sqlda = new EsqlSqlda();
        sqlda.isSelect = selectList;
        EsqlRuntime.d64 = d64;
        this.sqldaTable.put(intoVar.getName(), sqlda);
        this.linkSqlda(intoVar);
        this.actSqlda.isSelect = selectList;
        if (this.log != null) {
            this.log.info("EsqlRuntime: DESCRIBE " + (selectList ? "SELECT LIST " : "BIND VARIABLES") + " FOR " + prepName + " INTO " + intoVar.getName() + " connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
        }
        try {
            EsqlPrepare p = (EsqlPrepare)this.actSqlca.allPrepares.get(prepName);
            if (p == null) {
                EsqlRuntime.esqlError(3, ": Missing prepare " + prepName);
            }
            int fnd = 0;
            String str = "";
            if (!selectList) {
                int i;
                ParameterMetaData parMeta = p.getHstmt().getParameterMetaData();
                Vector nameBind = p.getNameBind();
                if (nameBind != null) {
                    fnd = nameBind.size();
                }
                this.actSqlda.SQLDFND.set(fnd);
                for (i = 1; i <= fnd; ++i) {
                    this.actSqlda.DVTYP.atNC(i).set(0);
                    this.actSqlda.DH_CUR_VNAMEL.atNC(i).set(0);
                    this.actSqlda.DI_CUR_VNAMEL.atNC(i).set(0);
                }
                for (i = 1; i <= fnd; ++i) {
                    str = (String)nameBind.get(i - 1);
                    this.actSqlda.DH_CUR_VNAMEL.atNC(i).set(str.length());
                    if (str.length() > this.actSqlda.DH_MAX_VNAMEL.atNC(i).toint()) {
                        str = str.substring(0, this.actSqlda.DH_MAX_VNAMEL.atNC(i).toint());
                    }
                    if (this.actSqlda.DH_VNAME.atNC(i).tolong() == 0L) continue;
                    this.actSqlda.pointedVar.setAddress(this.actSqlda.DH_VNAME.atNC(i).tolong());
                    this.actSqlda.pointedVar.set(str);
                }
            } else {
                ResultSetMetaData resMeta = p.getHstmt().getMetaData();
                fnd = resMeta.getColumnCount();
                this.actSqlda.SQLDFND.set(fnd);
                for (int i = 1; i <= fnd; ++i) {
                    this.actSqlda.DVLN.atNC(i).set(resMeta.getPrecision(i));
                    this.actSqlda.DVTYP.atNC(i).set(sqlTypesOra.get(resMeta.getColumnType(i)));
                    str = resMeta.getColumnName(i);
                    this.actSqlda.DH_CUR_VNAMEL.atNC(i).set(str.length());
                    if (str.length() > this.actSqlda.DH_MAX_VNAMEL.atNC(i).toint()) {
                        str = str.substring(0, this.actSqlda.DH_MAX_VNAMEL.atNC(i).toint());
                    }
                    if (this.actSqlda.DH_VNAME.atNC(i).tolong() == 0L) continue;
                    this.actSqlda.pointedVar.setAddress(this.actSqlda.DH_VNAME.atNC(i).tolong());
                    this.actSqlda.pointedVar.set(str);
                }
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime: DESCRIBE  name [" + prepName + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean describeDb2(CobolVar sqlca, String descrType, String prepName, CobolVar intoVar, boolean d64) {
        int db2CHAR = 452;
        EsqlRuntime.d64 = d64;
        this.clearSqlca(sqlca);
        int typeSql = 0;
        int numCol = 0;
        int numColSda = 0;
        try {
            EsqlPrepare p;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if ((p = (EsqlPrepare)this.actSqlca.allPrepares.get(prepName)) == null) {
                EsqlRuntime.esqlError(3, ": Missing prepare " + prepName);
            }
            this.linkSqldaDb2(intoVar);
            if (descrType.equalsIgnoreCase("INPUT")) {
                ParameterMetaData parMeta = p.getHstmt().getParameterMetaData();
                numCol = parMeta.getParameterCount();
                numColSda = this.actSqldaDb2.SQLN.toint();
                this.actSqldaDb2.SQLD.set(numCol);
                if (numColSda < numCol) {
                    numCol = 0;
                }
                for (int i = 1; i <= numCol; ++i) {
                    if (parMeta.getParameterMode(i) != 1) continue;
                    typeSql = parMeta.getParameterType(i);
                    if (sqlTypes.get(typeSql) != null) {
                        typeSql = (Integer)sqlTypes.get(typeSql);
                    } else {
                        typeSql = db2CHAR;
                        if (this.log != null) {
                            this.log.info("EsqlRuntime: DESCRIBE INPUT :SQLDA column " + i + " sqltype not found " + typeSql + "default 452 USED");
                        }
                    }
                    if (parMeta.isNullable(i) == 1) {
                        ++typeSql;
                    }
                    this.actSqldaDb2.SQLTYPE.at(i).set(typeSql);
                    if (parMeta.getParameterType(i) == 3) {
                        this.actSqldaDb2.SQLLEN.atNC(i).set(parMeta.getPrecision(i) + parMeta.getScale(i));
                        continue;
                    }
                    this.actSqldaDb2.SQLLEN.atNC(i).set(parMeta.getPrecision(i));
                }
                if (this.log != null) {
                    this.log.info("EsqlRuntime: DESCRIBE INPUT  :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + p.getName() + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            } else {
                ResultSetMetaData resMeta = p.getHstmt().getMetaData();
                numCol = resMeta.getColumnCount();
                numColSda = this.actSqldaDb2.SQLN.toint();
                this.actSqldaDb2.SQLD.set(numCol);
                if (numColSda < numCol) {
                    numCol = 0;
                }
                for (int i = 1; i <= numCol; ++i) {
                    typeSql = resMeta.getColumnType(i);
                    if (sqlTypes.get(typeSql) != null) {
                        typeSql = (Integer)sqlTypes.get(typeSql);
                    } else {
                        typeSql = db2CHAR;
                        if (this.log != null) {
                            this.log.info("EsqlRuntime: DESCRIBE OUTPUT :SQLDA column " + i + " sqltype not found " + typeSql + "default 452 USED");
                        }
                    }
                    if (resMeta.isNullable(i) == 1) {
                        ++typeSql;
                    }
                    this.actSqldaDb2.SQLTYPE.at(i).set(typeSql);
                    if (resMeta.getColumnType(i) == 3) {
                        this.actSqldaDb2.SQLLEN.atNC(i).set(resMeta.getPrecision(i) + resMeta.getScale(i));
                    } else {
                        this.actSqldaDb2.SQLLEN.atNC(i).set(resMeta.getPrecision(i));
                    }
                    this.actSqldaDb2.SQLNAMEC.at(i).set(resMeta.getColumnName(i));
                    this.actSqldaDb2.SQLNAMEL.at(i).set(resMeta.getColumnName(i).trim().length());
                }
                if (this.log != null) {
                    this.log.info("EsqlRuntime: DESCRIBE OUTPUT  :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + p.getName() + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime: DESCRIBE " + descrType + " :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + prepName + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean startRowset(CobolVar sqlca, ObjectVar cursHndl, int start, boolean absolute) {
        EsqlCursor ec = null;
        this.clearSqlca(sqlca);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            ec = this.getCursor(cursHndl);
            ec.startRowset(start, absolute);
        }
        catch (SQLException ex) {
            return false;
        }
        return true;
    }

    public synchronized boolean savepoint(CobolVar sqlca, String sPoint, boolean unique, boolean retLcurs, boolean retLocks) {
        this.clearSqlca(sqlca);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            Savepoint savePoint = this.getCConn().setSavepoint(sPoint);
            this.actSqlca.allSavepoint.put(sPoint, savePoint);
            if (this.log != null) {
                this.log.info("EsqlRuntime: SAVEPOINT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + sPoint + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime: SAVEPOINT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + sPoint + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean release(CobolVar sqlca, String sPoint) {
        this.clearSqlca(sqlca);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            Savepoint spt = (Savepoint)this.actSqlca.allSavepoint.get(sPoint);
            this.getCConn().releaseSavepoint(spt);
            this.actSqlca.allSavepoint.remove(sPoint);
            if (this.log != null) {
                this.log.info("EsqlRuntime: RELEASE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + sPoint + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException ex) {
            this.fillSqlca(ex, sqlca);
            if (this.log != null) {
                this.log.info("EsqlRuntime: RELEASE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + sPoint + "] exception [" + ex + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public void setCodeNull() {
        this.actSqlca = this.getSqlca();
        this.actSqlca.SQLCODE.set(codeNull);
        this.actSqlca.SQLERRMC.set(" ");
    }

    private EsqlSqlca getSqlca() {
        return (EsqlSqlca)Factory.getCurrent().getTdd().sqlca_n;
    }

    private String getCName() {
        return this.getSqlca().currName;
    }

    public synchronized Connection getCConn() {
        EsqlSqlca sqlca = this.getSqlca();
        Connection Return2 = sqlca == null ? this.defConn : sqlca.currConn;
        if (Return2 == null && automaticConnection) {
            if (sqlca != null) {
                this.connect(sqlca.SQLCA, "", "", "", "DEFAULT");
            } else {
                this.connect(null, "", "", "", "DEFAULT");
            }
            Return2 = sqlca == null ? this.defConn : sqlca.currConn;
        }
        return Return2;
    }

    public synchronized ResultSet getIResultSet(String rsName) {
        ResultSet rs = null;
        EsqlCursor ec = null;
        if (rsName != null) {
            String iName = rsName.toUpperCase();
            if (curSqlca != null && EsqlRuntime.curSqlca.allCursors != null) {
                for (int i = EsqlRuntime.curSqlca.allCursors.size() - 1; i >= 0; --i) {
                    ec = (EsqlCursor)EsqlRuntime.curSqlca.allCursors.get(i);
                    if (!ec.name.equalsIgnoreCase(iName)) continue;
                    return ec.getResultSet();
                }
            }
        }
        return rs;
    }

    public int decodeErr(int err) {
        if (this.getSqlca().errDecode.get("" + err) != null) {
            return Integer.parseInt((String)this.getSqlca().errDecode.get("" + err));
        }
        return err;
    }

    private void linkSqlda(CobolVar sqlda) {
        if (this.actSqlda == null) {
            this.actSqlda = new EsqlSqlda();
            Memory DSC$0 = null;
            DSC$0 = Factory.getNotOptmzdMem(44008);
            this.actSqlda.DSC = Factory.getVarAlphanum(DSC$0, 0, 44008, false, null, null, null, "DSC", false, false);
            this.actSqlda.SQLDNUM = Factory.getVarInt(this.actSqlda.DSC, 0, 4, false, null, null, null, "SQLDNUM", false, 9, 0, true, false, false);
            this.actSqlda.SQLDFND = Factory.getVarInt(this.actSqlda.DSC, 4, 4, false, null, null, null, "SQLDFND", false, 9, 0, true, false, false);
            this.actSqlda.DVAR = Factory.getVarAlphanum(this.actSqlda.DSC, 8, 44, false, null, new int[]{44}, new int[]{1000}, "DVAR", false, false);
            this.actSqlda.DV = Factory.getVarInt(this.actSqlda.DVAR, 8, 4, false, null, new int[]{44}, new int[]{1000}, "DV", false, 9, 0, true, false, false);
            this.actSqlda.DFMT = Factory.getVarInt(this.actSqlda.DVAR, 12, 4, false, null, new int[]{44}, new int[]{1000}, "DFMT", false, 9, 0, true, false, false);
            this.actSqlda.DVLN = Factory.getVarInt(this.actSqlda.DVAR, 16, 4, false, null, new int[]{44}, new int[]{1000}, "DVLN", false, 9, 0, true, false, false);
            this.actSqlda.DFMTL = Factory.getVarShort(this.actSqlda.DVAR, 20, 2, false, null, new int[]{44}, new int[]{1000}, "DFMTL", false, 4, 0, true, false, false);
            this.actSqlda.DVTYP = Factory.getVarShort(this.actSqlda.DVAR, 22, 2, false, null, new int[]{44}, new int[]{1000}, "DVTYP", false, 4, 0, true, false, false);
            this.actSqlda.DI = Factory.getVarInt(this.actSqlda.DVAR, 24, 4, false, null, new int[]{44}, new int[]{1000}, "DI", false, 9, 0, true, false, false);
            this.actSqlda.DH_VNAME = Factory.getVarInt(this.actSqlda.DVAR, 28, 4, false, null, new int[]{44}, new int[]{1000}, "DH-VNAME", false, 9, 0, true, false, false);
            this.actSqlda.DH_MAX_VNAMEL = Factory.getVarShort(this.actSqlda.DVAR, 32, 2, false, null, new int[]{44}, new int[]{1000}, "DH-MAX-VNAMEL", false, 4, 0, true, false, false);
            this.actSqlda.DH_CUR_VNAMEL = Factory.getVarShort(this.actSqlda.DVAR, 34, 2, false, null, new int[]{44}, new int[]{1000}, "DH-CUR-VNAMEL", false, 4, 0, true, false, false);
            this.actSqlda.DI_VNAME = Factory.getVarInt(this.actSqlda.DVAR, 36, 4, false, null, new int[]{44}, new int[]{1000}, "DI-VNAME", false, 9, 0, true, false, false);
            this.actSqlda.DI_MAX_VNAMEL = Factory.getVarShort(this.actSqlda.DVAR, 40, 2, false, null, new int[]{44}, new int[]{1000}, "DI-MAX-VNAMEL", false, 4, 0, true, false, false);
            this.actSqlda.DI_CUR_VNAMEL = Factory.getVarShort(this.actSqlda.DVAR, 42, 2, false, null, new int[]{44}, new int[]{1000}, "DI-CUR-VNAMEL", false, 4, 0, true, false, false);
            this.actSqlda.DFCLP = Factory.getVarInt(this.actSqlda.DVAR, 44, 4, false, null, new int[]{44}, new int[]{1000}, "DFCLP", false, 9, 0, true, false, false);
            this.actSqlda.DFCRCP = Factory.getVarInt(this.actSqlda.DVAR, 48, 4, false, null, new int[]{44}, new int[]{1000}, "DFCRCP", false, 9, 0, true, false, false);
        }
        this.actSqlda.DSC.link(sqlda);
    }

    private void linkSqldaDb2(CobolVar sqlda) {
        if (this.actSqldaDb2 == null) {
            this.actSqldaDb2 = new EsqlSqldaDb2();
            Memory SQLDA$0 = null;
            if (!d64) {
                SQLDA$0 = Factory.getNotOptmzdMem(33016);
                this.actSqldaDb2.SQLDA = Factory.getVarAlphanum(SQLDA$0, 0, 33016, false, null, null, null, "SQLDA", false, false);
                this.actSqldaDb2.SQLDAID = Factory.getVarAlphanum(this.actSqldaDb2.SQLDA, 0, 8, false, null, null, null, "SQLDAID", false, false);
                this.actSqldaDb2.SQLDABC = Factory.getVarBinary(this.actSqldaDb2.SQLDA, 8, 4, false, null, null, null, "SQLDABC", false, 8, 0, true, false, false, false);
                this.actSqldaDb2.SQLN = Factory.getVarBinary(this.actSqldaDb2.SQLDA, 12, 2, false, null, null, null, "SQLN", false, 4, 0, true, false, false, false);
                this.actSqldaDb2.SQLD = Factory.getVarBinary(this.actSqldaDb2.SQLDA, 14, 2, false, null, null, null, "SQLD", false, 4, 0, true, false, false, false);
                this.actSqldaDb2.SQLVAR = Factory.getVarAlphanum(this.actSqldaDb2.SQLDA, 16, 44, false, null, new int[]{44}, new int[]{750}, "SQLVAR", false, false);
                this.actSqldaDb2.SQLTYPE = Factory.getVarBinary(this.actSqldaDb2.SQLVAR, 16, 2, false, null, new int[]{44}, new int[]{750}, "SQLTYPE", false, 4, 0, true, false, false, false);
                this.actSqldaDb2.SQLLEN = Factory.getVarBinary(this.actSqldaDb2.SQLVAR, 18, 2, false, null, new int[]{44}, new int[]{750}, "SQLLEN", false, 4, 0, true, false, false, false);
                this.actSqldaDb2.SQLDATA = Factory.getVarCompN(this.actSqldaDb2.SQLVAR, 20, 4, false, null, new int[]{44}, new int[]{750}, "SQLDATA", false, 0, 0, false, false, false);
                this.actSqldaDb2.SQLIND = Factory.getVarCompN(this.actSqldaDb2.SQLVAR, 24, 4, false, null, new int[]{44}, new int[]{750}, "SQLIND", false, 0, 0, false, false, false);
                this.actSqldaDb2.SQLNAME = Factory.getVarAlphanum(this.actSqldaDb2.SQLVAR, 28, 32, false, null, new int[]{44}, new int[]{750}, "SQLNAME", false, false);
                this.actSqldaDb2.SQLNAMEL = Factory.getVarBinary(this.actSqldaDb2.SQLNAME, 28, 2, false, null, new int[]{44}, new int[]{750}, "SQLNAMEL", false, 4, 0, true, false, false, false);
                this.actSqldaDb2.SQLNAMEC = Factory.getVarAlphanum(this.actSqldaDb2.SQLNAME, 30, 30, false, null, new int[]{44}, new int[]{750}, "SQLNAMEC", false, false);
            } else {
                SQLDA$0 = Factory.getNotOptmzdMem(39016);
                this.actSqldaDb2.SQLDA = Factory.getVarAlphanum(SQLDA$0, 0, 39016, false, null, null, null, "SQLDA", false, false);
                this.actSqldaDb2.SQLDAID = Factory.getVarAlphanum(this.actSqldaDb2.SQLDA, 0, 8, false, null, null, null, "SQLDAID", false, false);
                this.actSqldaDb2.SQLDABC = Factory.getVarBinary(this.actSqldaDb2.SQLDA, 8, 4, false, null, null, null, "SQLDABC", false, 8, 0, true, false, false, false);
                this.actSqldaDb2.SQLN = Factory.getVarBinary(this.actSqldaDb2.SQLDA, 12, 2, false, null, null, null, "SQLN", false, 4, 0, true, false, false, false);
                this.actSqldaDb2.SQLD = Factory.getVarBinary(this.actSqldaDb2.SQLDA, 14, 2, false, null, null, null, "SQLD", false, 4, 0, true, false, false, false);
                this.actSqldaDb2.SQLVAR = Factory.getVarAlphanum(this.actSqldaDb2.SQLDA, 16, 52, false, null, new int[]{52}, new int[]{750}, "SQLVAR", false, false);
                this.actSqldaDb2.SQLTYPE = Factory.getVarBinary(this.actSqldaDb2.SQLVAR, 16, 2, false, null, new int[]{52}, new int[]{750}, "SQLTYPE", false, 4, 0, true, false, false, false);
                this.actSqldaDb2.SQLLEN = Factory.getVarBinary(this.actSqldaDb2.SQLVAR, 18, 2, false, null, new int[]{52}, new int[]{750}, "SQLLEN", false, 4, 0, true, false, false, false);
                this.actSqldaDb2.SQLDATA = Factory.getVarNativeBinary(this.actSqldaDb2.SQLVAR, 20, 8, false, null, new int[]{52}, new int[]{750}, "SQLDATA", false, 0, 0, true, false, false, true);
                this.actSqldaDb2.SQLIND = Factory.getVarNativeBinary(this.actSqldaDb2.SQLVAR, 28, 8, false, null, new int[]{52}, new int[]{750}, "SQLIND", false, 0, 0, true, false, false, true);
                this.actSqldaDb2.SQLNAME = Factory.getVarAlphanum(this.actSqldaDb2.SQLVAR, 36, 32, false, null, new int[]{52}, new int[]{750}, "SQLNAME", false, false);
                this.actSqldaDb2.SQLNAMEL = Factory.getVarBinary(this.actSqldaDb2.SQLNAME, 36, 2, false, null, new int[]{52}, new int[]{750}, "SQLNAMEL", false, 4, 0, true, false, false, false);
                this.actSqldaDb2.SQLNAMEC = Factory.getVarAlphanum(this.actSqldaDb2.SQLNAME, 38, 30, false, null, new int[]{52}, new int[]{750}, "SQLNAMEC", false, false);
            }
        }
        this.actSqldaDb2.SQLDA.link(sqlda);
    }

    public Connection getConn(CobolVar sqlca) {
        this.clearSqlca(sqlca);
        return this.getCConn();
    }

    public Connection getConn() {
        return this.getCConn();
    }

    public void logSqlj(String strLog) {
        if (this.log != null) {
            this.log.info(strLog);
        }
    }

    public int getErrorFact() {
        return errorFact;
    }

    public boolean isQueryToChange() {
        return methodPrepareDecoder != null;
    }

    public void changeQuery(CobolVar query) {
        block4: {
            if (this.log != null) {
                this.log.info("EsqlRuntime: before invoke method prepareDecoder " + methodPrepareDecoder.toString() + "query =" + query.toString());
            }
            try {
                handlerPrepareDecoder.queryDecoder(query);
            }
            catch (Exception ex) {
                if (this.log == null) break block4;
                this.log.info("EsqlRuntime: invoking method prepareDecoder of " + classPrepareDecoderName + " there is the following exception " + ex);
            }
        }
        if (this.log != null) {
            this.log.info("EsqlRuntime: after invoke method prepareDecoder " + methodPrepareDecoder.toString() + "query =" + query.toString());
        }
    }

    static {
        sqlTypes = new Hashtable();
        sqlTypes.put(2004, 404);
        sqlTypes.put(2005, 408);
        sqlTypes.put(-2, 912);
        sqlTypes.put(-3, 908);
        sqlTypes.put(-8, 904);
        sqlTypes.put(12, 448);
        sqlTypes.put(1, 452);
        sqlTypes.put(-1, 456);
        sqlTypes.put(-16, 464);
        sqlTypes.put(2011, 468);
        sqlTypes.put(6, 480);
        sqlTypes.put(7, 480);
        sqlTypes.put(8, 480);
        sqlTypes.put(3, 484);
        sqlTypes.put(4, 496);
        sqlTypes.put(-5, 492);
        sqlTypes.put(5, 500);
        sqlTypes.put(91, 384);
        sqlTypes.put(92, 388);
        sqlTypes.put(93, 392);
        sqlTypesOra = new Hashtable();
        sqlTypesOra.put(2004, 94);
        sqlTypesOra.put(2005, 95);
        sqlTypesOra.put(-2, 4);
        sqlTypesOra.put(-3, 4);
        sqlTypesOra.put(-8, 11);
        sqlTypesOra.put(12, 1);
        sqlTypesOra.put(1, 1);
        sqlTypesOra.put(-1, 94);
        sqlTypesOra.put(-16, 95);
        sqlTypesOra.put(2011, 95);
        sqlTypesOra.put(6, 4);
        sqlTypesOra.put(3, 7);
        sqlTypesOra.put(4, 3);
        sqlTypesOra.put(-5, 3);
        sqlTypesOra.put(5, 3);
        sqlTypesOra.put(91, 12);
        sqlTypesOra.put(92, 12);
        sqlTypesOra.put(93, 12);
        sqlTypesOraRev = new Hashtable();
        sqlTypesOraRev.put(11, -8);
        sqlTypesOraRev.put(1, 12);
        sqlTypesOraRev.put(94, -1);
        sqlTypesOraRev.put(95, -16);
        sqlTypesOraRev.put(4, 6);
        sqlTypesOraRev.put(7, 3);
        sqlTypesOraRev.put(3, 4);
        sqlTypesOraRev.put(12, 91);
        d64 = false;
        nullParamClass = new Class[0];
        nullParam = new Object[0];
        ZERO = Factory.getAllNumLiteral(0L, 1, 0, false);
        allErrors = new String[][]{{"00000", ""}, {"IN001", "Duplicate PREPARE name "}, {"IN002", "Already connected "}, {"IN003", "Invalid sequence "}, {"IN004", "Invalid paramater "}, {"IN005", "Cursor not declared "}, {"IN006", "Invalid handle "}, {"IN007", "Not supported call "}, {"IN008", "Invalid JDBC driver "}, {"IN009", "Invalid data source "}, {"IN999", "Internal error "}, {"08000", "Connection exception "}, {"08001", "Unable to establish connection "}, {"08002", "Connection name in use "}, {"08003", "Connection does not exist "}, {"08004", "Server rejected the connection "}, {"08006", "Connection failure "}, {"08007", "Transaction resolution unknown "}, {"01004", "String data, right truncation "}, {"00000", ""}};
        dataTruncation = new SQLWarning(allErrors[18][1], allErrors[18][0], 1004);
        IscobolSystem.setLoaded(EsqlRuntime.class);
        concurrency = Config.getProperty(".jdbc.cursor.concurrency", 1007);
        errorFact = Config.getProperty(".esql.error.negative", false) ? -1 : 1;
        warnings = Config.getProperty(".esql.warnings", false);
        modeIODef = Config.getProperty(".esql.default_param_type", "INOUT");
        typeIndTrunk = Config.getProperty(".esql.indicator_trunc_on_call", true) ? 2 : 3;
        automaticConnection = Config.getProperty(".jdbc.auto_connect", false);
        db2DataRowAsByteThreshold = Config.getProperty(".jdbc.url", "").startsWith("jdbc:db2:") ? Config.getProperty(".esql.db2.row_data_as_bytes_threshold", 0) : 0;
        picXHandling = Config.getProperty(".esql.picx_handling", 0);
        codeNull = Config.getProperty(".esql.value_sqlcode_on_null", 1405);
        noData = Config.getProperty(".esql.value_sqlcode_on_no_data", 0);
        tooManyRows = Config.getProperty(".esql.value_too_many_rows", 0);
        classSqlcaDecoderName = Config.getProperty(".esql.sqlca_handler", "");
        if (classSqlcaDecoderName.length() > 0) {
            try {
                classSqlcaDecoder = Class.forName(classSqlcaDecoderName);
                methodSqlcaDecoder = classSqlcaDecoder.getMethod("sqlcaDecoder", SQLException.class, CobolVar.class, CobolVar.class, CobolVar.class);
                handlerSqlcaDecoder = (EsqlSqlcaHandler_n)Class.forName(classSqlcaDecoderName).newInstance();
            }
            catch (Exception e) {
                throw new IscobolRuntimeException(e);
            }
        } else {
            classSqlcaDecoder = null;
            methodSqlcaDecoder = null;
            handlerSqlcaDecoder = null;
        }
        classPrepareDecoderName = Config.getProperty(".esql.prepare_handler", "");
        if (classPrepareDecoderName.length() > 0) {
            try {
                classPrepareDecoder = Class.forName(classPrepareDecoderName);
                handlerPrepareDecoder = (EsqlPrepareHandler_n)Class.forName(classPrepareDecoderName).newInstance();
                methodPrepareDecoder = classPrepareDecoder.getMethod("queryDecoder", CobolVar.class);
                methodPrepareDecoder.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IscobolRuntimeException(e);
            }
        } else {
            classPrepareDecoder = null;
            methodPrepareDecoder = null;
            handlerPrepareDecoder = null;
        }
        if (db2DataRowAsByteThreshold > 0) {
            try {
                Class<?> Db2Class = Class.forName("com.ibm.db2.jcc.DB2ResultSet");
                getDBRowDataAsBytes = Db2Class.getMethod("getDBRowDataAsBytes", nullParamClass);
                getDBRowDescriptor = Db2Class.getMethod("getDBRowDescriptor", nullParamClass);
            }
            catch (Exception e) {
                throw new IscobolRuntimeException(e);
            }
        }
    }

    class EsqlSqldaDb2 {
        EsqlHostVar hv = null;
        String cursorName = "";
        Vector indicators = new Vector();
        Vector values = new Vector();
        NumericVar ind = Factory.getNumLiteral(750L, 3, 0, false);
        boolean isSelect = false;
        com.iscobol.types_n.PicX SQLDA;
        com.iscobol.types_n.PicX SQLDAID;
        NumericVar SQLDABC;
        NumericVar SQLN;
        NumericVar SQLD;
        com.iscobol.types_n.PicX SQLVAR;
        NumericVar SQLTYPE;
        NumericVar SQLLEN;
        NumericVar SQLDATA;
        NumericVar SQLIND;
        com.iscobol.types_n.PicX SQLNAME;
        NumericVar SQLNAMEL;
        com.iscobol.types_n.PicX SQLNAMEC;

        EsqlSqldaDb2() {
        }
    }

    class EsqlSqlda {
        EsqlHostVar hv = null;
        String cursorName = "";
        Hashtable allOpenDescr = new Hashtable();
        Vector names = new Vector();
        Vector values = new Vector();
        NumericVar ind = Factory.getNumLiteral(1000L, 3, 0, false);
        boolean isSelect = false;
        com.iscobol.types_n.PicX pointedVar = Factory.getVarAlphanum(Factory.getNotOptmzdMem(80), 0, 80, false, null, null, null, "pointedVar", false, false);
        Memory DSC$0;
        com.iscobol.types_n.PicX DSC;
        NumericVar SQLDNUM;
        NumericVar SQLDFND;
        com.iscobol.types_n.PicX DVAR;
        NumericVar DV;
        NumericVar DFMT;
        NumericVar DVLN;
        NumericVar DFMTL;
        NumericVar DVTYP;
        NumericVar DI;
        NumericVar DH_VNAME;
        NumericVar DH_MAX_VNAMEL;
        NumericVar DH_CUR_VNAMEL;
        NumericVar DI_VNAME;
        NumericVar DI_MAX_VNAMEL;
        NumericVar DI_CUR_VNAMEL;
        NumericVar DFCLP;
        NumericVar DFCRCP;

        EsqlSqlda() {
        }
    }

    class EsqlSqlca {
        EsqlHostVar hv = null;
        String strNumTdd = "";
        int numTdd = 0;
        Hashtable allPrepares = new Hashtable();
        Hashtable allCursHndl = new Hashtable();
        Hashtable allSelect = new Hashtable();
        Hashtable allSavepoint = new Hashtable();
        Hashtable errDecode;
        Connection currConn;
        String currName;
        Statement regDb2;
        Vector allCursors = new Vector();
        Vector allDb2HostVar = new Vector();
        String sqlcaType = "noType";
        int sqlcaLen = 320;
        com.iscobol.types_n.PicX SQLCA;
        com.iscobol.types_n.PicX SQLCAID;
        NumericVar SQLCABC;
        NumericVar SQLCODE;
        com.iscobol.types_n.PicX SQLERRM;
        NumericVar SQLERRML;
        com.iscobol.types_n.PicX SQLERRMC;
        com.iscobol.types_n.PicX SQLERRP;
        NumericVar SQLERRD;
        com.iscobol.types_n.PicX SQLWARN;
        com.iscobol.types_n.PicX SQLWARN0;
        com.iscobol.types_n.PicX SQLWARN1;
        com.iscobol.types_n.PicX SQLWARN2;
        com.iscobol.types_n.PicX SQLWARN3;
        com.iscobol.types_n.PicX SQLWARN4;
        com.iscobol.types_n.PicX SQLWARN5;
        com.iscobol.types_n.PicX SQLWARN6;
        com.iscobol.types_n.PicX SQLWARN7;
        com.iscobol.types_n.PicX SQLSTATE;
        NumericVar SQLEXT;
        com.iscobol.types_n.PicX SQLWARN8;
        com.iscobol.types_n.PicX SQLWARN9;
        com.iscobol.types_n.PicX SQLWARNA;
        PicX SQLEXTP;

        public EsqlSqlca(CobolVar sqlca) {
            this.sqlcaLen = sqlca.getMaxLength();
            if (this.sqlcaLen == 136 && Factory.sqlcaDb2) {
                this.sqlcaType = "IBM";
                this.SQLCA = Factory.getVarAlphanum((Memory)null, 0, 136, false, null, null, null, "SQLCA", false, false);
                this.SQLCAID = Factory.getVarAlphanum(this.SQLCA, 0, 8, false, null, null, null, "SQLCAID", false, false);
                this.SQLCABC = Factory.getVarBinary(this.SQLCA, 8, 4, false, null, null, null, "SQLCABC", false, 9, 0, true, false, false, false);
                this.SQLCODE = Factory.getVarBinary(this.SQLCA, 12, 4, false, null, null, null, "SQLCODE", false, 9, 0, true, false, false, false);
                this.SQLERRM = Factory.getVarAlphanum(this.SQLCA, 16, 72, false, null, null, null, "SQLERRM", false, false);
                this.SQLERRML = Factory.getVarBinary(this.SQLERRM, 16, 2, false, null, null, null, "SQLERRML", false, 4, 0, true, false, false, false);
                this.SQLERRMC = Factory.getVarAlphanum(this.SQLERRM, 18, 70, false, null, null, null, "SQLERRMC", false, false);
                this.SQLERRP = Factory.getVarAlphanum(this.SQLCA, 88, 8, false, null, null, null, "SQLERRP", false, false);
                this.SQLERRD = Factory.getVarBinary(this.SQLCA, 96, 4, false, null, new int[]{4}, new int[]{6}, "SQLERRD", false, 9, 0, true, false, false, false);
                this.SQLWARN = Factory.getVarAlphanum(this.SQLCA, 120, 11, false, null, null, null, "SQLWARN", false, false);
                this.SQLWARN0 = Factory.getVarAlphanum(this.SQLWARN, 120, 1, false, null, null, null, "SQLWARN0", false, false);
                this.SQLWARN1 = Factory.getVarAlphanum(this.SQLWARN, 121, 1, false, null, null, null, "SQLWARN1", false, false);
                this.SQLWARN2 = Factory.getVarAlphanum(this.SQLWARN, 122, 1, false, null, null, null, "SQLWARN2", false, false);
                this.SQLWARN3 = Factory.getVarAlphanum(this.SQLWARN, 123, 1, false, null, null, null, "SQLWARN3", false, false);
                this.SQLWARN4 = Factory.getVarAlphanum(this.SQLWARN, 124, 1, false, null, null, null, "SQLWARN4", false, false);
                this.SQLWARN5 = Factory.getVarAlphanum(this.SQLWARN, 125, 1, false, null, null, null, "SQLWARN5", false, false);
                this.SQLWARN6 = Factory.getVarAlphanum(this.SQLWARN, 126, 1, false, null, null, null, "SQLWARN6", false, false);
                this.SQLWARN7 = Factory.getVarAlphanum(this.SQLWARN, 127, 1, false, null, null, null, "SQLWARN7", false, false);
                this.SQLWARN8 = Factory.getVarAlphanum(this.SQLWARN, 128, 1, false, null, null, null, "SQLWARN8", false, false);
                this.SQLWARN9 = Factory.getVarAlphanum(this.SQLWARN, 129, 1, false, null, null, null, "SQLWARN9", false, false);
                this.SQLWARNA = Factory.getVarAlphanum(this.SQLWARN, 130, 1, false, null, null, null, "SQLWARNA", false, false);
                this.SQLSTATE = Factory.getVarAlphanum(this.SQLCA, 131, 5, false, null, null, null, "SQLSTATE", false, false);
            } else if (this.sqlcaLen == 136) {
                this.sqlcaType = "PROCOB";
                this.SQLCA = Factory.getVarAlphanum((Memory)null, 0, 136, false, null, null, null, "SQLCA", false, false);
                this.SQLCAID = Factory.getVarAlphanum(this.SQLCA, 0, 8, false, null, null, null, "SQLCAID", false, false);
                this.SQLCABC = Factory.getVarBinary(this.SQLCA, 8, 4, false, null, null, null, "SQLCABC", false, 9, 0, true, false, false, false);
                this.SQLCODE = Factory.getVarBinary(this.SQLCA, 12, 4, false, null, null, null, "SQLCODE", false, 9, 0, true, false, false, false);
                this.SQLERRM = Factory.getVarAlphanum(this.SQLCA, 16, 72, false, null, null, null, "SQLERRM", false, false);
                this.SQLERRML = Factory.getVarBinary(this.SQLERRM, 16, 2, false, null, null, null, "SQLERRML", false, 4, 0, true, false, false, false);
                this.SQLERRMC = Factory.getVarAlphanum(this.SQLERRM, 18, 70, false, null, null, null, "SQLERRMC", false, false);
                this.SQLERRP = Factory.getVarAlphanum(this.SQLCA, 88, 8, false, null, null, null, "SQLERRP", false, false);
                this.SQLERRD = Factory.getVarBinary(this.SQLCA, 96, 4, false, null, new int[]{4}, new int[]{6}, "SQLERRD", false, 9, 0, true, false, false, false);
                this.SQLWARN = Factory.getVarAlphanum(this.SQLCA, 120, 11, false, null, null, null, "SQLWARN", false, false);
                this.SQLWARN0 = Factory.getVarAlphanum(this.SQLWARN, 120, 1, false, null, null, null, "SQLWARN0", false, false);
                this.SQLWARN1 = Factory.getVarAlphanum(this.SQLWARN, 121, 1, false, null, null, null, "SQLWARN1", false, false);
                this.SQLWARN2 = Factory.getVarAlphanum(this.SQLWARN, 122, 1, false, null, null, null, "SQLWARN2", false, false);
                this.SQLWARN3 = Factory.getVarAlphanum(this.SQLWARN, 123, 1, false, null, null, null, "SQLWARN3", false, false);
                this.SQLWARN4 = Factory.getVarAlphanum(this.SQLWARN, 124, 1, false, null, null, null, "SQLWARN4", false, false);
                this.SQLWARN5 = Factory.getVarAlphanum(this.SQLWARN, 125, 1, false, null, null, null, "SQLWARN5", false, false);
                this.SQLWARN6 = Factory.getVarAlphanum(this.SQLWARN, 126, 1, false, null, null, null, "SQLWARN6", false, false);
                this.SQLWARN7 = Factory.getVarAlphanum(this.SQLWARN, 127, 1, false, null, null, null, "SQLWARN7", false, false);
                this.SQLWARN8 = Factory.getVarAlphanum(this.SQLWARN, 128, 1, false, null, null, null, "SQLWARN8", false, false);
                this.SQLWARN9 = Factory.getVarAlphanum(this.SQLWARN, 129, 1, false, null, null, null, "SQLWARN9", false, false);
                this.SQLWARNA = Factory.getVarAlphanum(this.SQLWARN, 130, 1, false, null, null, null, "SQLWARNA", false, false);
                this.SQLSTATE = Factory.getVarAlphanum(this.SQLCA, 131, 5, false, null, null, null, "SQLSTATE", false, false);
            } else if (this.sqlcaLen == 320) {
                this.sqlcaType = "isCOBOL";
                this.SQLCA = Factory.getVarAlphanum((Memory)null, 0, 320, false, null, null, null, "SQLCA", false, false);
                this.SQLCAID = Factory.getVarAlphanum(this.SQLCA, 0, 8, false, null, null, null, "SQLCAID", false, false);
                this.SQLCABC = Factory.getVarNativeBinary(this.SQLCA, 8, 4, false, null, null, null, "SQLCABC", false, 9, 0, true, false, false, false);
                this.SQLCODE = Factory.getVarNativeBinary(this.SQLCA, 12, 4, false, null, null, null, "SQLCODE", false, 9, 0, true, false, false, false);
                this.SQLERRM = Factory.getVarAlphanum(this.SQLCA, 16, 256, false, null, null, null, "SQLERRM", false, false);
                this.SQLERRML = Factory.getVarNativeBinary(this.SQLERRM, 16, 2, false, null, null, null, "SQLERRML", false, 4, 0, true, false, false, false);
                this.SQLERRMC = Factory.getVarAlphanum(this.SQLERRM, 18, 254, false, null, null, null, "SQLERRMC", false, false);
                this.SQLERRP = Factory.getVarAlphanum(this.SQLCA, 272, 8, false, null, null, null, "SQLERRP", false, false);
                this.SQLERRD = Factory.getVarNativeBinary(this.SQLCA, 280, 4, false, null, new int[]{4}, new int[]{6}, "SQLERRD", false, 9, 0, true, false, false, false);
                this.SQLWARN = Factory.getVarAlphanum(this.SQLCA, 304, 8, false, null, null, null, "SQLWARN", false, false);
                this.SQLWARN0 = Factory.getVarAlphanum(this.SQLWARN, 304, 1, false, null, null, null, "SQLWARN0", false, false);
                this.SQLWARN1 = Factory.getVarAlphanum(this.SQLWARN, 305, 1, false, null, null, null, "SQLWARN1", false, false);
                this.SQLWARN2 = Factory.getVarAlphanum(this.SQLWARN, 306, 1, false, null, null, null, "SQLWARN2", false, false);
                this.SQLWARN3 = Factory.getVarAlphanum(this.SQLWARN, 307, 1, false, null, null, null, "SQLWARN3", false, false);
                this.SQLWARN4 = Factory.getVarAlphanum(this.SQLWARN, 308, 1, false, null, null, null, "SQLWARN4", false, false);
                this.SQLWARN5 = Factory.getVarAlphanum(this.SQLWARN, 309, 1, false, null, null, null, "SQLWARN5", false, false);
                this.SQLWARN6 = Factory.getVarAlphanum(this.SQLWARN, 310, 1, false, null, null, null, "SQLWARN6", false, false);
                this.SQLWARN7 = Factory.getVarAlphanum(this.SQLWARN, 311, 1, false, null, null, null, "SQLWARN7", false, false);
                this.SQLSTATE = Factory.getVarAlphanum(this.SQLCA, 312, 5, false, null, null, null, "SQLSTATE", false, false);
                this.SQLEXT = Factory.getVarPackedAcu(this.SQLCA, 317, 3, false, null, null, null, "SQLEXT", false, 5, 0, true, false, false);
            } else {
                throw new IscobolRuntimeException(3, "Invalid SQLCA length " + this.sqlcaLen);
            }
        }
    }
}

