/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts_n;

import com.iscobol.rts.Config;
import com.iscobol.rts.File;
import com.iscobol.rts_n.EsqlRuntime;
import com.iscobol.rts_n.Factory;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.ObjectVar;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;

public class Esql {
    private static final int GET_BLOB_FROM_FILE = 1;
    private static final int PUT_BLOB_INTO_FILE = 2;
    private static final int FREE_BLOB_HANDLE = 3;

    public static NumericVar ALLOCATE(Object[] argv) {
        long objId = 0L;
        ObjectVar HNDL = null;
        CobolVar TYPE = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    TYPE = (CobolVar)argv[2];
                }
                case 1: {
                    OWNER = argv[1];
                }
                case 0: {
                    HNDL = (ObjectVar)argv[0];
                }
                case -1: 
            }
            objId = EsqlRuntime.get().allocate(HNDL, OWNER, TYPE == null ? Config.getProperty(".jdbc.allocate_type", ".jdbc.allocate.type", -16) : TYPE.toint());
        }
        return Factory.getNumLiteral(objId, 18, 0, false);
    }

    public static NumericVar BIND_COL(Object[] argv) {
        ObjectVar HNDL = null;
        CobolVar VALUE = null;
        NumericVar TYPE = null;
        NumericVar ORDER = null;
        NumericVar LEN = null;
        NumericVar DEC = null;
        NumericVar IND = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    OWNER = argv[7];
                }
                case 6: {
                    IND = (NumericVar)argv[6];
                }
                case 5: {
                    DEC = (NumericVar)argv[5];
                }
                case 4: {
                    LEN = (NumericVar)argv[4];
                }
                case 3: {
                    ORDER = (NumericVar)argv[3];
                }
                case 2: {
                    TYPE = (NumericVar)argv[2];
                }
                case 1: {
                    VALUE = (CobolVar)argv[1];
                }
                case 0: {
                    HNDL = (ObjectVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().bindCol(HNDL, VALUE, TYPE.integer(), ORDER.integer(), IND, LEN, OWNER);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar BIND_COL_ORA(Object[] argv) {
        ObjectVar HNDL = null;
        CobolVar VALUE = null;
        NumericVar TYPE = null;
        NumericVar ORDER = null;
        NumericVar LEN = null;
        NumericVar DEC = null;
        NumericVar IND = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    IND = (NumericVar)argv[6];
                }
                case 5: {
                    DEC = (NumericVar)argv[5];
                }
                case 4: {
                    LEN = (NumericVar)argv[4];
                }
                case 3: {
                    ORDER = (NumericVar)argv[3];
                }
                case 2: {
                    TYPE = (NumericVar)argv[2];
                }
                case 1: {
                    VALUE = (CobolVar)argv[1];
                }
                case 0: {
                    HNDL = (ObjectVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().bindColOra(HNDL, VALUE, TYPE.integer(), ORDER.integer(), IND, LEN);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar GET_OBJECT(Object[] argv) {
        ObjectVar HNDL = null;
        CobolVar VALUE = null;
        NumericVar TYPE = null;
        NumericVar ORDER = null;
        NumericVar LEN = null;
        NumericVar DEC = null;
        NumericVar IND = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    IND = (NumericVar)argv[6];
                }
                case 5: {
                    DEC = (NumericVar)argv[5];
                }
                case 4: {
                    LEN = (NumericVar)argv[4];
                }
                case 3: {
                    ORDER = (NumericVar)argv[3];
                }
                case 2: {
                    TYPE = (NumericVar)argv[2];
                }
                case 1: {
                    VALUE = (CobolVar)argv[1];
                }
                case 0: {
                    HNDL = (ObjectVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().getObject(HNDL, VALUE, TYPE.integer(), ORDER.integer(), IND, LEN);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static CobolVar BLOB(CobolVar[] argv) {
        if (argv != null && argv.length > 1 && argv[1] instanceof ObjectVar) {
            switch (argv[0].toint()) {
                case 1: {
                    if (argv.length <= 2) break;
                    try {
                        FileInputStream blobStream = new FileInputStream(File.get(argv[2].toString().trim()));
                        int flen = blobStream.available();
                        byte[] blob = new byte[flen];
                        blobStream.read(blob, 0, flen);
                        ((ObjectVar)argv[1]).setId(blob);
                        return Factory.getNumLiteral(flen, 10, 0, false);
                    }
                    catch (IOException blobStream) {
                        break;
                    }
                }
                case 2: {
                    Object obj;
                    if (argv.length <= 2 || !((obj = ((ObjectVar)argv[1]).getId()) instanceof byte[])) break;
                    try {
                        java.io.File blobFile = File.get(argv[2].toString().trim());
                        blobFile.delete();
                        if (blobFile.createNewFile()) {
                            FileOutputStream blobStream = new FileOutputStream(blobFile);
                            int flen = ((byte[])obj).length;
                            blobStream.write((byte[])obj, 0, flen);
                            ((ObjectVar)argv[1]).setId(obj);
                            return Factory.getNumLiteral(flen, 10, 0, false);
                        }
                    }
                    catch (IOException blobFile) {}
                    break;
                }
                case 3: {
                    Object obj;
                    if (argv.length <= 1 || !((obj = ((ObjectVar)argv[1]).getId()) instanceof byte[])) break;
                    int flen = ((byte[])obj).length;
                    ((ObjectVar)argv[1]).free();
                    return Factory.getNumLiteral(flen, 10, 0, false);
                }
            }
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar CLOSE_HNDL(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    OWNER = argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().closeCursor(SQLCA2, HNDL, OWNER);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar CLOSE(Object[] argv) {
        CobolVar SQLCA2 = null;
        Object NAME = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    OWNER = argv[3];
                }
                case 1: 
                case 2: {
                    NAME = argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().closeCursor(SQLCA2, NAME.toString().trim(), OWNER);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar COMMIT(Object[] argv) {
        CobolVar SQLCA2 = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().commit(SQLCA2);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar CONNECT(Object[] argv) {
        CobolVar SQLCA2 = null;
        CobolVar DSN = null;
        CobolVar USR = null;
        CobolVar PWD = null;
        CobolVar CID = null;
        CobolVar DSN_LEN = null;
        CobolVar USR_LEN = null;
        CobolVar PWD_LEN = null;
        CobolVar CID_LEN = null;
        CobolVar CONN_STRING = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    CONN_STRING = (CobolVar)argv[9];
                }
                case 8: {
                    CID_LEN = (CobolVar)argv[8];
                }
                case 7: {
                    CID = (CobolVar)argv[7];
                }
                case 6: {
                    PWD_LEN = (CobolVar)argv[6];
                }
                case 5: {
                    PWD = (CobolVar)argv[5];
                }
                case 4: {
                    USR_LEN = (CobolVar)argv[4];
                }
                case 3: {
                    USR = (CobolVar)argv[3];
                }
                case 2: {
                    DSN_LEN = (CobolVar)argv[2];
                }
                case 1: {
                    DSN = (CobolVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            if (CONN_STRING != null) {
                String tmp = CONN_STRING.toString();
                if (tmp.toUpperCase().contains("DRIVER=")) {
                    if ((tmp = tmp.substring(tmp.toUpperCase().indexOf("DRIVER=") + 7)).contains(";")) {
                        tmp = tmp.substring(0, tmp.indexOf(";"));
                    }
                    Factory.setEnv("jdbc.driver", tmp);
                    tmp = CONN_STRING.toString();
                }
                if (tmp.toUpperCase().contains("URL=")) {
                    if ((tmp = tmp.substring(tmp.toUpperCase().indexOf("URL=") + 4)).contains(";")) {
                        tmp = tmp.substring(0, tmp.indexOf(";"));
                    }
                    Factory.setEnv("jdbc.url", tmp);
                    tmp = CONN_STRING.toString();
                }
                if (!tmp.toUpperCase().contains("DRIVER=") && !tmp.toUpperCase().contains("URL=")) {
                    Factory.setEnv("jdbc.url", CONN_STRING.toString());
                }
            }
            String dsn = DSN_LEN.toint() > 0 ? DSN.toString().substring(0, DSN_LEN.toint()).trim() : DSN.toString().trim();
            String usr = USR_LEN.toint() > 0 ? USR.toString().substring(0, USR_LEN.toint()).trim() : USR.toString().trim();
            String pwd = PWD_LEN.toint() > 0 ? PWD.toString().substring(0, PWD_LEN.toint()).trim() : PWD.toString().trim();
            String cid = CID != null ? (CID_LEN.toint() > 0 ? CID.toString().substring(0, CID_LEN.toint()).trim() : CID.toString().trim()) : "DEFAULT";
            EsqlRuntime.get().connect(SQLCA2, dsn, usr, pwd, cid);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar DECLARE(Object[] argv) {
        long objId = 0L;
        CobolVar SQLCA2 = null;
        Object NAME = null;
        Object PREP = null;
        Object HOLD = null;
        Object OWNER = null;
        Object withReturn = 0;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    withReturn = argv[7];
                }
                case 6: {
                    OWNER = argv[6];
                }
                case 5: {
                    HOLD = argv[5];
                }
                case 3: 
                case 4: {
                    PREP = argv[3];
                }
                case 1: 
                case 2: {
                    NAME = argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            objId = EsqlRuntime.get().declare(SQLCA2, NAME == null ? null : NAME.toString().trim(), PREP, HOLD, OWNER, withReturn);
        }
        return Factory.getNumLiteral(objId, 18, 0, false);
    }

    public static NumericVar DECLARE_STMT(Object[] argv) {
        long objId = 0L;
        CobolVar SQLCA2 = null;
        Object NAME = null;
        Object QUERY2 = null;
        Object HOLD = null;
        Object OWNER = null;
        Object SENSITIVE = "-1";
        Object withReturn = 0;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    withReturn = argv[8];
                }
                case 7: {
                    SENSITIVE = argv[7];
                }
                case 6: {
                    OWNER = argv[6];
                }
                case 5: {
                    HOLD = argv[5];
                }
                case 3: 
                case 4: {
                    QUERY2 = argv[3];
                }
                case 1: 
                case 2: {
                    NAME = argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            objId = EsqlRuntime.get().declareStmt(SQLCA2, NAME == null ? null : NAME.toString().trim(), QUERY2.toString().trim(), HOLD, OWNER, false, Integer.parseInt(SENSITIVE.toString()), withReturn);
        }
        return Factory.getNumLiteral(objId, 18, 0, false);
    }

    public static NumericVar DECLARE_STMT_ORA(Object[] argv) {
        long objId = 0L;
        CobolVar SQLCA2 = null;
        Object NAME = null;
        Object QUERY2 = null;
        Object HOLD = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    OWNER = argv[6];
                }
                case 5: {
                    HOLD = argv[5];
                }
                case 3: 
                case 4: {
                    QUERY2 = argv[3];
                }
                case 1: 
                case 2: {
                    NAME = argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            objId = EsqlRuntime.get().declareStmtOracle(SQLCA2, NAME == null ? null : NAME.toString().trim(), QUERY2.toString().trim(), HOLD, OWNER);
        }
        return Factory.getNumLiteral(objId, 18, 0, false);
    }

    public static NumericVar DECLARE_UPDT(Object[] argv) {
        long objId = 0L;
        CobolVar SQLCA2 = null;
        Object NAME = null;
        Object QUERY2 = null;
        Object HOLD = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    OWNER = argv[6];
                }
                case 5: {
                    HOLD = argv[5];
                }
                case 3: 
                case 4: {
                    QUERY2 = argv[3];
                }
                case 1: 
                case 2: {
                    NAME = argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            objId = EsqlRuntime.get().declareStmt(SQLCA2, NAME == null ? null : NAME.toString().trim(), QUERY2.toString().trim(), HOLD, OWNER, true);
        }
        return Factory.getNumLiteral(objId, 18, 0, false);
    }

    public static NumericVar DISCONNECT(Object[] argv) {
        CobolVar SQLCA2 = null;
        CobolVar CID = null;
        NumericVar ALL = null;
        if (argv != null) {
            String connId;
            switch (argv.length - 1) {
                default: {
                    CID = (CobolVar)argv[2];
                }
                case 1: {
                    ALL = (NumericVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            if (CID == null || (connId = CID.toString().trim()).length() == 0) {
                if (ALL == null) {
                    EsqlRuntime.get().disconnect(SQLCA2);
                } else {
                    EsqlRuntime.get().disconnect(SQLCA2, ALL.toint() != 0);
                }
            } else {
                EsqlRuntime.get().disconnect(SQLCA2, connId);
            }
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar EXECUTE(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().execute(SQLCA2, HNDL);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar EXECUTE_ORA(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().executeOracle(SQLCA2, HNDL);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar EXECUTE_IMMEDIATE(Object[] argv) {
        CobolVar SQLCA2 = null;
        CobolVar QUERY2 = null;
        boolean isHostVar = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    isHostVar = argv[2] != null ? (Boolean)argv[2] : false;
                }
                case 1: {
                    QUERY2 = (CobolVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            if (EsqlRuntime.get().isQueryToChange()) {
                EsqlRuntime.get().changeQuery(QUERY2);
            }
            EsqlRuntime.get().executeImmediate(SQLCA2, QUERY2.toString().trim());
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar EXECUTE_QUERY(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().executeQuery(SQLCA2, HNDL);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar EXECUTE_DESCRIPTOR_DB2(Object[] argv) {
        CobolVar SQLCA2 = null;
        CobolVar descrInto = null;
        CobolVar descrUsing = null;
        String prepName = null;
        Object OWNER = null;
        boolean d64 = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    d64 = (Boolean)argv[5];
                }
                case 4: {
                    OWNER = argv[4];
                }
                case 3: {
                    descrUsing = (CobolVar)argv[3];
                }
                case 2: {
                    descrInto = (CobolVar)argv[2];
                }
                case 1: {
                    prepName = (String)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().executeDescriptorDb2(SQLCA2, prepName, descrUsing, descrUsing, OWNER, d64);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar CLOSEPREPARED_STAT(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().closePreparedStatement(SQLCA2, HNDL);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar FETCH_INTO(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        NumericVar TYPE = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    OWNER = argv[3];
                }
                case 2: {
                    TYPE = (NumericVar)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().fetchInto(SQLCA2, HNDL, TYPE.integer(), OWNER);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar ROWSET_STARTING(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        NumericVar start = null;
        boolean absolute = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    absolute = (Boolean)argv[3];
                }
                case 2: {
                    start = (NumericVar)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().startRowset(SQLCA2, HNDL, start.integer(), absolute);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar FETCH_DESCRIPTOR(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        CobolVar descrVar = null;
        NumericVar TYPE = null;
        boolean d64 = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    d64 = (Boolean)argv[4];
                }
                case 3: {
                    TYPE = (NumericVar)argv[3];
                }
                case 2: {
                    descrVar = (CobolVar)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().fetchDescr(SQLCA2, HNDL, descrVar, TYPE.integer(), d64);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar FETCH_DESCRIPTOR_DB2(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        CobolVar descrVar = null;
        NumericVar TYPE = null;
        boolean d64 = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    d64 = (Boolean)argv[4];
                }
                case 3: {
                    TYPE = (NumericVar)argv[3];
                }
                case 2: {
                    descrVar = (CobolVar)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().fetchDescrDb2(SQLCA2, HNDL, descrVar, TYPE.integer(), d64);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar FETCH(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        NumericVar TYPE = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    OWNER = argv[3];
                }
                case 2: {
                    TYPE = (NumericVar)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().fetch(SQLCA2, HNDL, TYPE.integer(), OWNER);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar FETCH_DB2(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        NumericVar TYPE = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    OWNER = argv[3];
                }
                case 2: {
                    TYPE = (NumericVar)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().fetchDb2(SQLCA2, HNDL, TYPE.integer(), OWNER);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar FREE(Object[] argv) {
        ObjectVar HNDL = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    HNDL = (ObjectVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().free(HNDL);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar GETCURSORHANDLE(Object[] argv) {
        NumericVar HNDL = null;
        Object NAME = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    OWNER = argv[3];
                }
                case 2: {
                    HNDL = (NumericVar)argv[2];
                }
                case 0: 
                case 1: {
                    NAME = argv[0];
                }
                case -1: 
            }
            HNDL.set(EsqlRuntime.get().getCursorHandle(NAME.toString().trim(), OWNER));
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar OPEN(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().open(SQLCA2, HNDL);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar OPEN_DESCRIPTOR(Object[] argv) {
        CobolVar descriptorVar = null;
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        String CUR_NAME = null;
        Object OWNER = null;
        boolean d64 = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    d64 = (Boolean)argv[5];
                }
                case 4: {
                    OWNER = argv[4];
                }
                case 3: {
                    descriptorVar = (CobolVar)argv[3];
                }
                case 2: {
                    HNDL = (ObjectVar)argv[2];
                }
                case 1: {
                    CUR_NAME = (String)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().openDescr(SQLCA2, CUR_NAME, HNDL, descriptorVar, OWNER, d64);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar OPEN_ROWSET(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().openRowset(SQLCA2, HNDL);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar OPEN_DESCRIPTOR_DB2(Object[] argv) {
        CobolVar descriptorVar = null;
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        boolean d64 = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    d64 = (Boolean)argv[3];
                }
                case 2: {
                    descriptorVar = (CobolVar)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().openDescrDb2(SQLCA2, HNDL, descriptorVar, d64);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar PREPARE(Object[] argv) {
        CobolVar SQLCA2 = null;
        Object NAME = "";
        CobolVar STAT = null;
        boolean isHostVar = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    STAT = (CobolVar)argv[3];
                }
                case 2: {
                    isHostVar = argv[2] != null ? (Boolean)argv[2] : false;
                }
                case 1: {
                    NAME = argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            if (EsqlRuntime.get().isQueryToChange()) {
                EsqlRuntime.get().changeQuery(STAT);
            }
            EsqlRuntime.get().prepare(SQLCA2, NAME, STAT.toString().trim());
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar PREPARE_DB2_SQLDA(Object[] argv) {
        CobolVar SQLCA2 = null;
        CobolVar SQLDA = null;
        Object NAME = "";
        Object STAT = "";
        boolean d64 = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    d64 = (Boolean)argv[6];
                }
                case 5: {
                    SQLDA = (CobolVar)argv[5];
                }
                case 3: 
                case 4: {
                    STAT = argv[3];
                }
                case 1: 
                case 2: {
                    NAME = argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().prepareDb2Into(SQLCA2, NAME, STAT.toString().trim(), SQLDA, d64);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar DESCRIBE(Object[] argv) {
        CobolVar SQLCA2 = null;
        boolean selectList = true;
        String prepStat = "";
        CobolVar intoVar = null;
        boolean d64 = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    d64 = (Boolean)argv[4];
                }
                case 3: {
                    intoVar = (CobolVar)argv[3];
                }
                case 2: {
                    prepStat = (String)argv[2];
                }
                case 1: {
                    selectList = (Boolean)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().describe(SQLCA2, selectList, prepStat, intoVar, d64);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar DESCRIBE_DB2(Object[] argv) {
        CobolVar SQLCA2 = null;
        String descrType = null;
        String prepStat = "";
        CobolVar intoVar = null;
        boolean d64 = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    d64 = (Boolean)argv[4];
                }
                case 3: {
                    intoVar = (CobolVar)argv[3];
                }
                case 2: {
                    prepStat = (String)argv[2];
                }
                case 1: {
                    descrType = (String)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().describeDb2(SQLCA2, descrType, prepStat, intoVar, d64);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar PREPARE_QUERY(Object[] argv) {
        CobolVar SQLCA2 = null;
        ObjectVar HNDL = null;
        CobolVar FROMVAR = null;
        Object NAME = "";
        Object STAT = "";
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    STAT = argv[4];
                }
                case 3: {
                    NAME = argv[3];
                }
                case 2: {
                    FROMVAR = (CobolVar)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().prepareQuery(SQLCA2, HNDL, FROMVAR, STAT.toString().trim(), NAME.toString().trim());
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar PROCEDURE(Object[] argv) {
        CobolVar SQLCA2 = null;
        Object QUERY2 = null;
        Object[] args = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    QUERY2 = argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            if (argv.length > 3) {
                args = new Object[argv.length - 3];
                for (int i = 3; i < argv.length; ++i) {
                    args[i - 3] = argv[i];
                }
            }
            EsqlRuntime.get().procedure(SQLCA2, QUERY2.toString().trim(), args);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar CREATETYPE(Object[] argv) {
        CobolVar SQLCA2 = null;
        int ORD = -1;
        String NAME = null;
        int TYPE = -1;
        Object NEWTYPE = null;
        Object args = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    NEWTYPE = argv[4];
                }
                case 3: {
                    TYPE = (Integer)argv[3];
                }
                case 2: {
                    NAME = (String)argv[2];
                }
                case 1: {
                    ORD = (Integer)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().createType(SQLCA2, ORD, NAME.trim(), TYPE, NEWTYPE);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar ROLLBACK(Object[] argv) {
        CobolVar SQLCA2 = null;
        String SAVEPOINT = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    SAVEPOINT = (String)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().rollback(SQLCA2, SAVEPOINT);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar SET_CONNECTION(Object[] argv) {
        CobolVar SQLCA2 = null;
        CobolVar CID = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    CID = (CobolVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().setConnection(SQLCA2, CID.toString().trim());
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar SET_PARAM(Object[] argv) {
        short SQLTYPE = -1;
        ObjectVar HNDL = null;
        CobolVar VALUE = null;
        NumericVar TYPE = null;
        NumericVar ORDER = null;
        NumericVar LEN = null;
        NumericVar DEC = null;
        NumericVar IND = null;
        String MODE = null;
        Object OWNER = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    SQLTYPE = argv[9] != null ? (short)((Short)argv[9]) : (short)-1;
                }
                case 8: {
                    OWNER = argv[8];
                }
                case 7: {
                    MODE = argv[7] != null ? argv[7].toString() : null;
                }
                case 6: {
                    IND = (NumericVar)argv[6];
                }
                case 5: {
                    DEC = (NumericVar)argv[5];
                }
                case 4: {
                    LEN = (NumericVar)argv[4];
                }
                case 3: {
                    ORDER = (NumericVar)argv[3];
                }
                case 2: {
                    TYPE = (NumericVar)argv[2];
                }
                case 1: {
                    VALUE = (CobolVar)argv[1];
                }
                case 0: {
                    HNDL = (ObjectVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().setParam(HNDL, VALUE, TYPE.integer(), ORDER.integer(), IND, LEN, MODE, OWNER, SQLTYPE);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar SET_PARAM_ORA(Object[] argv) {
        short SQLTYPE = -1;
        ObjectVar HNDL = null;
        CobolVar VALUE = null;
        NumericVar TYPE = null;
        NumericVar ORDER = null;
        NumericVar LEN = null;
        NumericVar DEC = null;
        NumericVar IND = null;
        String MODE = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    SQLTYPE = argv[8] != null ? (short)((Short)argv[8]) : (short)-1;
                }
                case 7: {
                    MODE = argv[7] != null ? argv[7].toString() : null;
                }
                case 6: {
                    IND = (NumericVar)argv[6];
                }
                case 5: {
                    DEC = (NumericVar)argv[5];
                }
                case 4: {
                    LEN = (NumericVar)argv[4];
                }
                case 3: {
                    ORDER = (NumericVar)argv[3];
                }
                case 2: {
                    TYPE = (NumericVar)argv[2];
                }
                case 1: {
                    VALUE = (CobolVar)argv[1];
                }
                case 0: {
                    HNDL = (ObjectVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().setParamOra(HNDL, VALUE, TYPE.integer(), ORDER.integer(), IND, LEN, MODE, SQLTYPE);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar SET_PARAMQ(Object[] argv) {
        short SQLTYPE = -1;
        ObjectVar HNDL = null;
        CobolVar VALUE = null;
        NumericVar TYPE = null;
        NumericVar ORDER = null;
        NumericVar LEN = null;
        NumericVar DEC = null;
        NumericVar IND = null;
        String MODE = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    SQLTYPE = argv[8] != null ? (short)((Short)argv[8]) : (short)-1;
                }
                case 7: {
                    MODE = argv[7] != null ? argv[7].toString() : null;
                }
                case 6: {
                    IND = (NumericVar)argv[6];
                }
                case 5: {
                    DEC = (NumericVar)argv[5];
                }
                case 4: {
                    LEN = (NumericVar)argv[4];
                }
                case 3: {
                    ORDER = (NumericVar)argv[3];
                }
                case 2: {
                    TYPE = (NumericVar)argv[2];
                }
                case 1: {
                    VALUE = (CobolVar)argv[1];
                }
                case 0: {
                    HNDL = (ObjectVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().setParamQ(HNDL, VALUE, TYPE.integer(), ORDER.integer(), IND, LEN, MODE, SQLTYPE);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar RS_UPDATE_COL(Object[] argv) {
        ObjectVar HNDL = null;
        String NAME = null;
        CobolVar VALUE = null;
        NumericVar TYPE = null;
        NumericVar ORDER = null;
        NumericVar LEN = null;
        NumericVar DEC = null;
        NumericVar IND = null;
        CobolVar SQLCA2 = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    IND = (NumericVar)argv[8];
                }
                case 7: {
                    DEC = (NumericVar)argv[7];
                }
                case 6: {
                    LEN = (NumericVar)argv[6];
                }
                case 5: {
                    ORDER = (NumericVar)argv[5];
                }
                case 4: {
                    TYPE = (NumericVar)argv[4];
                }
                case 3: {
                    VALUE = (CobolVar)argv[3];
                }
                case 2: {
                    NAME = (String)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().rsUpdateCol(SQLCA2, HNDL, NAME, VALUE, TYPE.integer(), ORDER.integer(), IND, LEN);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar RS_UPDATE_COL_ROWSET(Object[] argv) {
        ObjectVar HNDL = null;
        String NAME = null;
        CobolVar VALUE = null;
        NumericVar TYPE = null;
        NumericVar ORDER = null;
        NumericVar LEN = null;
        NumericVar DEC = null;
        NumericVar IND = null;
        CobolVar SQLCA2 = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    IND = (NumericVar)argv[8];
                }
                case 7: {
                    DEC = (NumericVar)argv[7];
                }
                case 6: {
                    LEN = (NumericVar)argv[6];
                }
                case 5: {
                    ORDER = (NumericVar)argv[5];
                }
                case 4: {
                    TYPE = (NumericVar)argv[4];
                }
                case 3: {
                    VALUE = (CobolVar)argv[3];
                }
                case 2: {
                    NAME = (String)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().rsUpdColRowset(SQLCA2, HNDL, NAME, VALUE, TYPE.integer(), ORDER.integer(), IND, LEN);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar RS_UPDATE_COL_DB2REG(Object[] argv) {
        ObjectVar HNDL = null;
        String NAME = null;
        String selReg = null;
        NumericVar TYPE = null;
        NumericVar ORDER = null;
        NumericVar LEN = null;
        NumericVar DEC = null;
        NumericVar IND = null;
        CobolVar SQLCA2 = null;
        boolean d64 = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    d64 = (Boolean)argv[9];
                }
                case 8: {
                    IND = (NumericVar)argv[8];
                }
                case 7: {
                    DEC = (NumericVar)argv[7];
                }
                case 6: {
                    LEN = (NumericVar)argv[6];
                }
                case 5: {
                    ORDER = (NumericVar)argv[5];
                }
                case 4: {
                    TYPE = (NumericVar)argv[4];
                }
                case 3: {
                    selReg = (String)argv[3];
                }
                case 2: {
                    NAME = (String)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().rsUpdateColDb2Reg(SQLCA2, HNDL, NAME, selReg, TYPE.integer(), ORDER.integer(), IND, LEN, d64);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar RS_UPDATE_ROW(Object[] argv) {
        ObjectVar HNDL = null;
        CobolVar SQLCA2 = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().rsUpdateRow(SQLCA2, HNDL);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar RS_UPDATE_ROW_ROWSET(Object[] argv) {
        ObjectVar HNDL = null;
        CobolVar SQLCA2 = null;
        NumericVar row = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    row = (NumericVar)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().rsUpdateRowset(SQLCA2, HNDL, row.integer());
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar RS_UPDATE_NULL(Object[] argv) {
        String NAME = null;
        ObjectVar HNDL = null;
        CobolVar SQLCA2 = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    NAME = (String)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().rsUpdateNull(SQLCA2, HNDL, NAME);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar RS_DELETE_ROW(Object[] argv) {
        ObjectVar HNDL = null;
        CobolVar SQLCA2 = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().rsDeleteRow(SQLCA2, HNDL);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar RS_DELETE_ROWSET(Object[] argv) {
        ObjectVar HNDL = null;
        CobolVar SQLCA2 = null;
        NumericVar rows = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    rows = (NumericVar)argv[2];
                }
                case 1: {
                    HNDL = (ObjectVar)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().rsDeleteRowset(SQLCA2, HNDL, rows.integer());
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static Connection GET_CONNECTION(Object[] argv) {
        CobolVar SQLCA2 = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            return EsqlRuntime.get().getConn(SQLCA2);
        }
        return null;
    }

    public static NumericVar SAVEPOINT(Object[] argv) {
        CobolVar SQLCA2 = null;
        String SAVEPOINT = null;
        boolean unique = false;
        boolean retainCursors = false;
        boolean retainLocks = false;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    retainLocks = (Boolean)argv[4];
                }
                case 3: {
                    retainCursors = (Boolean)argv[3];
                }
                case 2: {
                    unique = (Boolean)argv[2];
                }
                case 1: {
                    SAVEPOINT = (String)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().savepoint(SQLCA2, SAVEPOINT, unique, retainCursors, retainLocks);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static NumericVar RELEASE(Object[] argv) {
        CobolVar SQLCA2 = null;
        String SAVEPOINT = null;
        if (argv != null) {
            switch (argv.length - 1) {
                default: {
                    SAVEPOINT = (String)argv[1];
                }
                case 0: {
                    SQLCA2 = (CobolVar)argv[0];
                }
                case -1: 
            }
            EsqlRuntime.get().release(SQLCA2, SAVEPOINT);
        }
        return Factory.getNumLiteral(0L, 1, 0, false);
    }

    public static void LOG_SQLJ(String strLog) {
        EsqlRuntime.get().logSqlj(strLog);
    }

    public static int getSqlcode100() {
        return Config.getProperty(".esql.sqlcode.100", 100);
    }
}

