/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.GraphPen;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetGraphPen
extends PrintCommand {
    private Color color;
    private int style;
    private double width;
    private GraphPen pen;

    public SetGraphPen(GuiFactory gf, int style, double width, Color color) {
        super(gf, 6);
        this.style = style;
        this.width = width;
        this.color = color == null ? new Color(0, 0, 0) : color;
        this.pen = new GraphPen(style, width, color);
    }

    public SetGraphPen(GuiFactory gf, RandomAccessFile inOut) throws IOException {
        super(gf, 6);
        this.style = inOut.readInt();
        this.width = inOut.readDouble();
        this.color = new Color(inOut.readInt(), true);
        this.pen = new GraphPen(this.style, this.width, this.color);
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        inOut.writeInt(this.style);
        inOut.writeDouble(this.width);
        inOut.writeInt(this.color.getRGB());
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, g2d, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        pc.graphPen = this.pen;
        return true;
    }
}

