/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PageColumn;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import com.iscobol.types.CobolVar;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public abstract class PrintData
extends PrintCommand {
    protected final Data data;
    protected final int len;
    protected final byte yStart;

    public PrintData(GuiFactory gf, Data data, byte ys, int code) {
        super(gf, code);
        this.data = data;
        this.len = data.length();
        this.yStart = ys;
    }

    public PrintData(GuiFactory gf, RandomAccessFile inOut, int code) throws IOException {
        super(gf, code);
        this.data = new Data(inOut);
        this.len = this.data.length();
        this.yStart = inOut.readByte();
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        this.data.write(inOut);
        inOut.writeByte(this.yStart);
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, null, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        if (pc.pgCols == null && pc.dataCols == null) {
            return this.printPlain(pc, g2d, pf);
        }
        return this.printColumns(pc, g2d, pf);
    }

    private float getYOffs(TextLayout layout) {
        return PrintData.getYOffs(this.yStart, layout);
    }

    public boolean printPlain(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        if (this.data.text != null && this.data.text.length() > 0) {
            TextLayout layout = new TextLayout(this.data.text, pc.font, pc.frc);
            if (PrintData.gtAtTolerance(pc.pen.y + layout.getAscent() + layout.getDescent() + layout.getLeading(), pf.getImageableHeight())) {
                return false;
            }
            if (g2d != null) {
                PrintData.drawString(g2d, pc, layout, this.data.text, pc.pen.x, pc.pen.y + this.getYOffs(layout));
            }
            pc.pen.x += layout.getAdvance();
        }
        return true;
    }

    public boolean printColumns(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        TextLayout layout = new TextLayout("0", pc.font, pc.frc);
        if (PrintData.gtAtTolerance(pc.pen.y + layout.getAscent() + layout.getDescent() + layout.getLeading(), pf.getImageableHeight())) {
            return false;
        }
        pc.pen.y += this.getYOffs(layout);
        if (g2d != null) {
            int start = 1;
            int end = 9999;
            if (pc.pgCols == null) {
                end = pc.dataCols[0];
                this.printColumn(pc, g2d, pf, start, end, null, null);
            } else {
                Arrays.sort(pc.pgCols);
                for (int i = 0; i < pc.pgCols.length; ++i) {
                    PageColumn nxtCol;
                    try {
                        end = pc.dataCols[i];
                    }
                    catch (NullPointerException ex) {
                        end = 9999;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        end = 9999;
                    }
                    try {
                        nxtCol = pc.pgCols[i + 1];
                    }
                    catch (NullPointerException ex) {
                        nxtCol = null;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        nxtCol = null;
                    }
                    if (end <= start) continue;
                    this.printColumn(pc, g2d, pf, start, end, pc.pgCols[i], nxtCol);
                    start = end;
                }
            }
        }
        pc.pen.y -= this.getYOffs(layout);
        return true;
    }

    public boolean printColumn(PrintContext pc, Graphics2D g2d, PageFormat pf, int start, int end, PageColumn clm, PageColumn nxtCol) {
        block27: {
            TextLayout layout;
            String strToPrint;
            Font font;
            double y;
            double x;
            block29: {
                block28: {
                    int textLen = this.data.length();
                    if (start > textLen || start >= end) break block27;
                    x = pc.pen.x;
                    y = pc.pen.y;
                    font = pc.font;
                    float indent = 0.0f;
                    float pSeparation = 0.0f;
                    int align = 32;
                    boolean tranparency = true;
                    double factor = 1.0;
                    if (clm != null) {
                        if (clm.getFont() != null) {
                            font = clm.getFont();
                        }
                        factor = PrintData.getFactor(clm.getUnit(), font, pc.frc);
                        x = (double)clm.getStart() * factor + (double)clm.getIndent() * factor;
                    }
                    if (textLen < end) {
                        if (this.data.bytes != null) {
                            try {
                                strToPrint = new String(this.data.bytes, start - 1, this.data.bytes_length - start + 1, Data.encoding);
                            }
                            catch (UnsupportedEncodingException e) {
                                strToPrint = "";
                            }
                        } else {
                            strToPrint = this.data.text.substring(start - 1);
                        }
                    } else if (this.data.bytes != null) {
                        try {
                            strToPrint = new String(this.data.bytes, start - 1, end - start, Data.encoding);
                        }
                        catch (UnsupportedEncodingException e) {
                            strToPrint = "";
                        }
                    } else {
                        strToPrint = this.data.text.substring(start - 1, end - 1);
                    }
                    double devEnd = 0.0;
                    if (clm == null) break block28;
                    switch (clm.getAlign()) {
                        case 'C': 
                        case 'D': 
                        case 'L': 
                        case 'R': 
                        case 'S': {
                            strToPrint = strToPrint.trim();
                            if (strToPrint.length() != 0) break;
                            strToPrint = " ";
                            break;
                        }
                    }
                    layout = new TextLayout(strToPrint, font, pc.frc);
                    switch (clm.getAlign()) {
                        case 'L': {
                            devEnd = PrintData.endColumn(pc, pf, clm, nxtCol, factor);
                            while (x + (double)layout.getAdvance() - devEnd > 1.0 && strToPrint.length() > 1) {
                                strToPrint = strToPrint.substring(0, strToPrint.length() - 1);
                                layout = new TextLayout(strToPrint, font, pc.frc);
                            }
                            break block29;
                        }
                        case 'C': {
                            layout = new TextLayout(strToPrint, font, pc.frc);
                            devEnd = PrintData.endColumn(pc, pf, clm, nxtCol, factor);
                            while (x + (double)layout.getAdvance() - devEnd > 1.0 && strToPrint.length() > 1) {
                                strToPrint = strToPrint.substring(0, strToPrint.length() - 1);
                                layout = new TextLayout(strToPrint, font, pc.frc);
                            }
                            x += (devEnd - x - (double)layout.getAdvance()) / 2.0;
                            break;
                        }
                        case 'D': 
                        case 'S': {
                            int dp = clm.getPComma() ? 44 : 46;
                            int dpIdx = strToPrint.indexOf(dp);
                            if (dpIdx >= 0 && dpIdx + 1 < strToPrint.length()) {
                                String decPart = strToPrint.substring(dpIdx + 1);
                                double sepEdge = (double)clm.getSeparation() * factor;
                                layout = new TextLayout(decPart, font, pc.frc);
                                while ((double)layout.getAdvance() - sepEdge > 1.0 && decPart.length() > 1) {
                                    decPart = decPart.substring(0, decPart.length() - 1);
                                    layout = new TextLayout(decPart, font, pc.frc);
                                }
                                strToPrint = clm.getAlign() == 'S' ? strToPrint.substring(0, dpIdx) + " " : strToPrint.substring(0, dpIdx + 1);
                                if (!((double)layout.getAdvance() - sepEdge > 1.0)) {
                                    devEnd = PrintData.endColumn(pc, pf, clm, nxtCol, factor);
                                    PrintData.drawString(g2d, font, pc, layout, decPart, (float)devEnd, (float)y);
                                }
                            }
                        }
                        case 'R': {
                            layout = new TextLayout(strToPrint, font, pc.frc);
                            devEnd = PrintData.endColumn(pc, pf, clm, nxtCol, factor);
                            while (x + (double)layout.getAdvance() - devEnd > 1.0 && strToPrint.length() > 1) {
                                strToPrint = strToPrint.substring(1, strToPrint.length());
                                layout = new TextLayout(strToPrint, font, pc.frc);
                            }
                            x = devEnd - (double)layout.getAdvance();
                            break;
                        }
                    }
                    break block29;
                }
                layout = new TextLayout(strToPrint, font, pc.frc);
            }
            PrintData.drawString(g2d, font, pc, layout, strToPrint, (float)x, (float)y);
            return true;
        }
        return false;
    }

    private static double endColumn(PrintContext pc, PageFormat pf, PageColumn clm, PageColumn nxtCol, double factor) {
        double Return2;
        if (nxtCol != null) {
            double nxtStart = (double)nxtCol.getStart() * PrintData.getFactor(nxtCol.getUnit(), nxtCol.getFont() == null ? pc.font : nxtCol.getFont(), pc.frc);
            Return2 = nxtStart - (double)clm.getSeparation() * factor;
        } else {
            Return2 = pf.getImageableWidth() - (double)clm.getSeparation() * factor;
        }
        return Return2;
    }

    private static double getFactor(int unit, Font font, FontRenderContext frc) {
        double Return2;
        switch (unit) {
            case 1: {
                TextLayout cell = new TextLayout("0", font, frc);
                Return2 = cell.getAdvance();
                break;
            }
            case 2: {
                Return2 = 72.0;
                break;
            }
            case 3: {
                Return2 = 28.34645652770996;
                break;
            }
            default: {
                Return2 = 1.0;
            }
        }
        return Return2;
    }

    public static class Data
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static final String encoding = CobolVar.encoding;
        private String text;
        private byte[] bytes;
        private int bytes_length;

        public Data(String text) {
            this.text = text;
            this.bytes_length = 0;
        }

        public Data(byte[] b, int offs, int len) {
            if (offs == 0) {
                this.bytes = b;
            } else {
                this.bytes = new byte[len];
                System.arraycopy(b, offs, this.bytes, 0, len);
            }
            this.bytes_length = len;
            try {
                this.text = new String(this.bytes, 0, this.bytes_length, encoding);
            }
            catch (UnsupportedEncodingException e) {
                this.text = "";
            }
        }

        public Data(RandomAccessFile inOut) throws IOException {
            this.read(inOut);
        }

        public String getText() {
            return this.text;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String toString() {
            return this.text;
        }

        public int length() {
            return this.bytes != null ? this.bytes_length : this.text.length();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.write(out);
        }

        private void write(DataOutput out) throws IOException {
            out.writeBoolean(this.bytes != null);
            if (this.bytes != null) {
                out.writeInt(this.bytes_length);
                for (int i = 0; i < this.bytes_length; ++i) {
                    out.writeByte(this.bytes[i]);
                }
            } else {
                out.writeUTF(this.text);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.read(in);
        }

        private void read(DataInput in) throws IOException, ClassNotFoundException {
            boolean isBytes = in.readBoolean();
            if (isBytes) {
                this.bytes_length = in.readInt();
                this.bytes = new byte[this.bytes_length];
                for (int i = 0; i < this.bytes_length; ++i) {
                    this.bytes[i] = in.readByte();
                }
                try {
                    this.text = new String(this.bytes, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    this.text = "";
                }
            } else {
                this.text = in.readUTF();
            }
        }

        public void write(RandomAccessFile inOut) throws IOException {
            this.write((DataOutput)inOut);
        }

        public void read(RandomAccessFile inOut) throws IOException {
            try {
                this.read((DataInput)inOut);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

