/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.HandlesManager;
import java.awt.Font;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class PageColumn
implements Cloneable,
Serializable,
Comparable {
    public static final char ALIGN_NONE = ' ';
    public static final char ALIGN_LEFT = 'L';
    public static final char ALIGN_RIGHT = 'R';
    public static final char ALIGN_CENTER = 'C';
    public static final char ALIGN_DECIMAL = 'D';
    public static final char ALIGN_DECIMAL_SUPPRESS = 'S';
    private boolean pComma;
    private float start;
    private float indent;
    private float separation;
    private Font font;
    private int fontId = -1;
    private int unit;
    private char align;
    private boolean transparency;

    public PageColumn(GuiFactory gf, HandlesManager hndls, boolean pComma, float start, float indent, float separation, Font font, int unit, char align, boolean transparency) {
        this.pComma = pComma;
        this.start = start;
        this.indent = indent;
        this.separation = separation;
        this.font = font;
        if (this.font != null) {
            this.fontId = hndls.newHandle(this.font);
        }
        this.unit = unit;
        this.align = align;
        this.transparency = transparency;
    }

    public PageColumn(GuiFactory gf, HandlesManager hndls, RandomAccessFile inOut) throws IOException {
        this.pComma = inOut.readBoolean();
        this.start = inOut.readFloat();
        this.indent = inOut.readFloat();
        this.separation = inOut.readFloat();
        this.fontId = inOut.readInt();
        this.font = (Font)hndls.getObject(this.fontId);
        this.unit = inOut.readInt();
        this.align = inOut.readChar();
        this.transparency = inOut.readBoolean();
    }

    public int compareTo(Object o) {
        if (o instanceof PageColumn) {
            PageColumn pc = (PageColumn)o;
            if (this.start < pc.start) {
                return -1;
            }
            if (this.start > pc.start) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    void toFile(RandomAccessFile inOut) throws IOException {
        inOut.writeBoolean(this.pComma);
        inOut.writeFloat(this.start);
        inOut.writeFloat(this.indent);
        inOut.writeFloat(this.separation);
        inOut.writeInt(this.fontId);
        inOut.writeInt(this.unit);
        inOut.writeChar(this.align);
        inOut.writeBoolean(this.transparency);
    }

    public boolean getPComma() {
        return this.pComma;
    }

    public float getStart() {
        return this.start;
    }

    public float getIndent() {
        return this.indent;
    }

    public float getSeparation() {
        return this.separation;
    }

    public Font getFont() {
        return this.font;
    }

    public int getUnit() {
        return this.unit;
    }

    public char getAlign() {
        return this.align;
    }

    public boolean getTransparency() {
        return this.transparency;
    }
}

