/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.Events;
import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.RemoteFontComponent;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.AppFactoryImpl;
import com.iscobol.gui.server.FontCmp;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.MixingCharAndBytesException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts.print.RemotePrintCommandFactory;
import com.iscobol.rts.print.RemoteSpoolPrinter;
import com.iscobol.rts.print.ServerSpoolPrinter;
import com.iscobol.rts.print.SpoolPrinterInterface;
import com.iscobol.rts.print.SpoolPrinterList;
import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.print.attribute.Size2DSyntax;

public class LocalSpoolPrinter
extends Writer
implements SpoolPrinterInterface,
RuntimeErrorsNumbers {
    public static final int BUFFER_CHAR_SIZE = Short.MAX_VALUE;
    public static final int CHAR_COPY_WTRMRK = 31743;
    public static final int BUFFER_BYTE_SIZE = 65535;
    public static final int BYTE_COPY_WTRMRK = 64511;
    public static final int BUFFER_BYTE_X_SIZE = 65535;
    public static final int BYTE_X_COPY_WTRMRK = 64511;
    private byte[] byteBuffer;
    private char[] charNBuffer;
    private byte[] charXBuffer;
    private int bIdx;
    private int cIdx;
    private int bxIdx;
    private final int id;
    private SpoolPrinterInterface sp;
    private boolean serverSide;

    public LocalSpoolPrinter(int id, boolean ss, LocalSpoolPrinter current) throws IOException {
        this.id = id;
        this.serverSide = ss;
        if (this.serverSide) {
            this.sp = new ServerSpoolPrinter(new AppFactoryImpl().newGuiFactory(), null);
            if (current != null && current.isServerSide()) {
                ((ServerSpoolPrinter)this.sp).setAttrs((ServerSpoolPrinter)current.sp);
            }
        } else {
            int currId = -1;
            RemotePrintCommandFactory f = null;
            if (current != null && !current.isServerSide()) {
                if (current.sp instanceof RemotePrintCommandFactory) {
                    f = (RemotePrintCommandFactory)current.sp;
                    currId = ((RemoteSpoolPrinter)f.target).getTheObjectId();
                } else {
                    currId = ((RemoteSpoolPrinter)current.sp).getTheObjectId();
                }
            }
            this.sp = ScreenUtility.getGuiFactory().getSpoolPrinter(currId);
            if (IscobolSystem.isAS()) {
                this.sp = new RemotePrintCommandFactory(this.sp, f);
            }
        }
    }

    public LocalSpoolPrinter(int id, boolean preview, boolean direct, boolean pdf, String fileName, boolean binary, Events events, boolean ss, LocalSpoolPrinter current) throws IOException {
        this.id = id;
        this.serverSide = ss;
        if (this.serverSide) {
            this.sp = new ServerSpoolPrinter(new AppFactoryImpl().newGuiFactory(), events);
            if (current != null && current.isServerSide()) {
                ((ServerSpoolPrinter)this.sp).setAttrs((ServerSpoolPrinter)current.sp);
            }
            ((ServerSpoolPrinter)this.sp).setAttrs(preview, direct, pdf, fileName, binary);
        } else {
            int currId = -1;
            RemotePrintCommandFactory f = null;
            if (current != null && !current.isServerSide()) {
                if (current.sp instanceof RemotePrintCommandFactory) {
                    f = (RemotePrintCommandFactory)current.sp;
                    currId = ((RemoteSpoolPrinter)f.target).getTheObjectId();
                } else {
                    currId = ((RemoteSpoolPrinter)current.sp).getTheObjectId();
                }
            }
            this.sp = ScreenUtility.getGuiFactory().getSpoolPrinter(preview, direct, pdf, fileName, binary, events, currId);
            if (IscobolSystem.isAS()) {
                this.sp = new RemotePrintCommandFactory(this.sp, f);
            }
        }
    }

    public int getId() {
        return this.id;
    }

    @Override
    public boolean setup() throws IOException {
        return this.sp.setup();
    }

    @Override
    public double[] setup(double top, double bottom, double left, double right) throws IOException {
        return this.sp.setup(top, bottom, left, right);
    }

    @Override
    public void setFont(Map attrs) throws IOException {
        this.myFlush();
        this.sp.setFont(attrs);
    }

    @Override
    public void setFont(int fontId) throws IOException {
        this.myFlush();
        this.sp.setFont(fontId);
    }

    @Override
    public Point getPageLayout(Hashtable attrs) throws IOException {
        this.myFlush();
        return this.sp.getPageLayout(attrs);
    }

    @Override
    public void setMargins(double top, double bottom, double left, double right, int type) throws IOException {
        this.myFlush();
        this.sp.setMargins(top, bottom, left, right, type);
    }

    @Override
    public double[] getMargins(int type) throws IOException {
        this.myFlush();
        return this.sp.getMargins(type);
    }

    @Override
    public void setColor(int red, int green, int blue, int alpha) throws IOException {
        this.myFlush();
        this.sp.setColor(red, green, blue, alpha);
    }

    @Override
    public void setBackground(int red, int green, int blue, int alpha) throws IOException {
        this.myFlush();
        this.sp.setBackground(red, green, blue, alpha);
    }

    @Override
    public void setLinesPerPage(int lines) throws IOException {
        this.myFlush();
        this.sp.setLinesPerPage(lines);
    }

    @Override
    public void printBitmap(int imageId, double row, double col, int locType, double height, double width, int sizeType) throws IOException {
        this.myFlush();
        this.sp.printBitmap(imageId, row, col, locType, height, width, sizeType);
    }

    @Override
    public void drawGraph(int shape, double startX, double startY, double stopX, double stopY, int type, String shade) throws IOException {
        this.myFlush();
        this.sp.drawGraph(shape, startX, startY, stopX, stopY, type, shade);
    }

    @Override
    public void setBoxShade(int red, int green, int blue, int alpha) throws IOException {
        this.myFlush();
        this.sp.setBoxShade(red, green, blue, alpha);
    }

    @Override
    public void setGraphPen(int style, double width, int red, int green, int blue, int alpha) throws IOException {
        this.myFlush();
        this.sp.setGraphPen(style, width, red, green, blue, alpha);
    }

    @Override
    public void setGraphPenPt(int style, double width, int red, int green, int blue, int alpha) throws IOException {
        this.myFlush();
        this.sp.setGraphPenPt(style, width, red, green, blue, alpha);
    }

    @Override
    public void setGraphBrush(int style, int red, int green, int blue, int alpha) throws IOException {
        this.myFlush();
        this.sp.setGraphBrush(style, red, green, blue, alpha);
    }

    @Override
    public void setDataColumns(int[] cols) throws IOException {
        this.myFlush();
        this.sp.setDataColumns(cols);
    }

    @Override
    public void setPageColumn(boolean pComma, double start, double indent, double separation, int fontId, int unit, char align, boolean transparency) throws IOException {
        this.myFlush();
        this.sp.setPageColumn(pComma, start, indent, separation, fontId, unit, align, transparency);
    }

    @Override
    public void clearPageColumn() throws IOException {
        this.myFlush();
        this.sp.clearPageColumn();
    }

    @Override
    public void setCursor(double startX, double startY, double[] stopX, double[] stopY, int type, int shape, byte ta) throws IOException {
        this.myFlush();
        this.sp.setCursor(startX, startY, stopX, stopY, type, shape, ta);
    }

    @Override
    public int getNoPrinters() throws IOException {
        return this.sp.getNoPrinters();
    }

    @Override
    public int getCurrPrinter() throws IOException {
        return this.sp.getCurrPrinter();
    }

    @Override
    public boolean setPrinter(String pr) throws IOException {
        return this.sp.setPrinter(pr);
    }

    @Override
    public boolean setPrinter(int nr) throws IOException {
        return this.sp.setPrinter(nr);
    }

    @Override
    public void setOrientation(int or) throws IOException {
        this.myFlush();
        this.sp.setOrientation(or);
    }

    @Override
    public int getOrientation() throws IOException {
        this.myFlush();
        return this.sp.getOrientation();
    }

    @Override
    public void setQuality(int qu) throws IOException {
        this.myFlush();
        this.sp.setQuality(qu);
    }

    @Override
    public int getQuality() throws IOException {
        this.myFlush();
        return this.sp.getQuality();
    }

    @Override
    public void setJobName(String jn, String out) throws IOException {
        this.sp.setJobName(jn, out);
    }

    @Override
    public String getPrinterName(int idx) throws IOException {
        return this.sp.getPrinterName(idx);
    }

    @Override
    public int getPrinterNumber(String st) throws IOException {
        return this.sp.getPrinterNumber(st);
    }

    @Override
    public String getPrinterURI(int idx) throws IOException {
        return this.sp.getPrinterURI(idx);
    }

    @Override
    public boolean isPrinterDefault(int idx) throws IOException {
        return this.sp.isPrinterDefault(idx);
    }

    @Override
    public int getColorSupport(int idx) throws IOException {
        return this.sp.getColorSupport(idx);
    }

    @Override
    public int getCurrOrientation() throws IOException {
        return this.sp.getCurrOrientation();
    }

    @Override
    public int getCurrCopies() throws IOException {
        return this.sp.getCurrCopies();
    }

    @Override
    public void setCurrCopies(int c) throws IOException {
        this.sp.setCurrCopies(c);
    }

    @Override
    public boolean hasDuplexPrinting() throws IOException {
        return this.sp.hasDuplexPrinting();
    }

    @Override
    public void setDuplexPrinting(int dp) throws IOException {
        this.sp.setDuplexPrinting(dp);
    }

    @Override
    public int getDuplexPrinting() throws IOException {
        return this.sp.getDuplexPrinting();
    }

    @Override
    public String getJobName() throws IOException {
        return this.sp.getJobName();
    }

    @Override
    public boolean setMediaSize(int n) throws IOException {
        this.myFlush();
        return this.sp.setMediaSize(n);
    }

    @Override
    public boolean setCustomMediaSize(float x, float y, int u) throws IOException {
        this.myFlush();
        return this.sp.setCustomMediaSize(x, y, u);
    }

    @Override
    public int getCurrMediaSize() throws IOException {
        this.myFlush();
        return this.sp.getCurrMediaSize();
    }

    @Override
    public Size2DSyntax getCurrMediaSize2D() throws IOException {
        this.myFlush();
        return this.sp.getCurrMediaSize2D();
    }

    @Override
    public boolean setMediaTray(int n) throws IOException {
        this.myFlush();
        return this.sp.setMediaTray(n);
    }

    @Override
    public int getMediaTray() throws IOException {
        this.myFlush();
        return this.sp.getMediaTray();
    }

    @Override
    public void setChromaticity(int co) throws IOException {
        this.myFlush();
        this.sp.setChromaticity(co);
    }

    @Override
    public int getChromaticity() throws IOException {
        this.myFlush();
        return this.sp.getChromaticity();
    }

    @Override
    public void setCollate(int cl) throws IOException {
        this.myFlush();
        this.sp.setCollate(cl);
    }

    @Override
    public int getCollate() throws IOException {
        this.myFlush();
        return this.sp.getCollate();
    }

    @Override
    public void reset() throws IOException {
        this.myFlush();
        this.sp.reset();
    }

    @Override
    public int[] getCurrPrinterCapabilities() throws IOException {
        this.myFlush();
        return this.sp.getCurrPrinterCapabilities();
    }

    @Override
    public Hashtable getFontMetrics(Hashtable attrs) throws IOException {
        this.myFlush();
        return this.sp.getFontMetrics(attrs);
    }

    @Override
    public void setPitch(char type, float factor) throws IOException {
        this.myFlush();
        this.sp.setPitch(type, factor);
    }

    @Override
    public void setDefaultUnits(int type) throws IOException {
        this.myFlush();
        this.sp.setDefaultUnits(type);
    }

    @Override
    public void newPage() throws IOException {
        this.myFlush();
        this.sp.newPage();
    }

    @Override
    public void textOut(byte[] b, int offset, int length) throws IOException {
        this.myFlush();
        this.sp.textOut(b, offset, length);
    }

    @Override
    public void printAt(String s, float x, float y, float w, boolean rpos, char algn, byte ys, boolean clp) throws IOException {
        this.myFlush();
        this.sp.printAt(s, x, y, w, rpos, algn, ys, clp);
    }

    @Override
    public int[][] getMedia4Printer(String prnName) throws IOException {
        return this.sp.getMedia4Printer(prnName);
    }

    @Override
    public boolean isServerSide() throws IOException {
        return this.serverSide;
    }

    public void setServerFont(int fontId) throws IOException {
        if (this.serverSide) {
            this.myFlush();
            ServerSpoolPrinter ssp = (ServerSpoolPrinter)this.sp;
            ssp.setFont(ssp.getFont(fontId, true));
        }
    }

    @Override
    public void setAttribute(String key, String value) throws IOException {
        this.sp.setAttribute(key, value);
    }

    @Override
    public boolean hasPrinted() throws IOException {
        return this.sp.hasPrinted();
    }

    @Override
    public void cancelJob() throws IOException {
        this.sp.cancelJob();
    }

    private void myFlush() throws IOException {
        if (this.cIdx > 0) {
            if (this.cIdx < 31743) {
                char[] tArray = new char[this.cIdx];
                System.arraycopy(this.charNBuffer, 0, tArray, 0, this.cIdx);
                this.sp.write(tArray);
            } else {
                this.sp.write(this.charNBuffer, 0, this.cIdx);
            }
            this.cIdx = 0;
        } else if (this.bIdx > 0) {
            if (this.bIdx < 64511) {
                byte[] tArray = new byte[this.bIdx];
                System.arraycopy(this.byteBuffer, 0, tArray, 0, this.bIdx);
                this.sp.write(tArray);
            } else {
                this.sp.write(this.byteBuffer, 0, this.bIdx);
            }
            this.bIdx = 0;
        } else if (this.bxIdx > 0) {
            if (this.bxIdx < 64511) {
                byte[] tArray = new byte[this.bxIdx];
                System.arraycopy(this.charXBuffer, 0, tArray, 0, this.bxIdx);
                this.sp.writeBytes(tArray);
            } else {
                this.sp.writeBytes(this.charXBuffer, 0, this.bxIdx);
            }
            this.bxIdx = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.myFlush();
        this.byteBuffer = null;
        this.charNBuffer = null;
        this.charXBuffer = null;
        this.sp.close();
        SpoolPrinterList.get().removeSpoolPrinter(this.id);
    }

    @Override
    public IOException printAndClose() throws IOException {
        this.myFlush();
        this.byteBuffer = null;
        this.charNBuffer = null;
        this.charXBuffer = null;
        return this.sp.printAndClose();
    }

    @Override
    public void flush() throws IOException {
        this.myFlush();
        this.sp.flush();
    }

    @Override
    public void write(char[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(char[] b, int off, int len) throws IOException {
        if (this.byteBuffer != null) {
            throw new MixingCharAndBytesException(3);
        }
        if (this.charXBuffer != null) {
            throw new MixingCharAndBytesException(4);
        }
        if (len > Short.MAX_VALUE) {
            this.myFlush();
            this.sp.write(b, off, len);
        } else if (this.charNBuffer == null) {
            this.charNBuffer = new char[Short.MAX_VALUE];
        } else if (this.cIdx + len > Short.MAX_VALUE) {
            this.myFlush();
        }
        System.arraycopy(b, off, this.charNBuffer, this.cIdx, len);
        this.cIdx += len;
    }

    @Override
    public void write(int c) throws IOException {
        this.write(new char[]{(char)c});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.charNBuffer != null) {
            throw new MixingCharAndBytesException(1);
        }
        if (this.charXBuffer != null) {
            throw new MixingCharAndBytesException(2);
        }
        if (len > 65535) {
            this.myFlush();
            this.sp.write(b, off, len);
        } else if (this.byteBuffer == null) {
            this.byteBuffer = new byte[65535];
        } else if (this.bIdx + len > 65535) {
            this.myFlush();
        }
        System.arraycopy(b, off, this.byteBuffer, this.bIdx, len);
        this.bIdx += len;
    }

    @Override
    public void write(byte c) throws IOException {
        this.write(new byte[]{c});
    }

    @Override
    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.charNBuffer != null) {
            throw new MixingCharAndBytesException(6);
        }
        if (this.byteBuffer != null) {
            throw new MixingCharAndBytesException(5);
        }
        if (len > 65535) {
            this.myFlush();
            this.sp.writeBytes(b, off, len);
        } else if (this.charXBuffer == null) {
            this.charXBuffer = new byte[65535];
        } else if (this.bxIdx + len > 65535) {
            this.myFlush();
        }
        System.arraycopy(b, off, this.charXBuffer, this.bxIdx, len);
        this.bxIdx += len;
    }

    public static QPrinterAttrs handleDashQPrinter(String name) {
        QPrinterAttrs Return2 = new QPrinterAttrs();
        if (name.length() > 0) {
            Hashtable<FontAttribute, String> attrs = null;
            if (name.indexOf(59) < 0) {
                Return2.name = name;
            } else {
                String optKey = null;
                String optVal = null;
                StringTokenizer st = new StringTokenizer(name, ";");
                Return2.name = st.nextToken();
                while (st.hasMoreElements()) {
                    optVal = st.nextToken();
                    int eqIdx = optVal.indexOf(61);
                    if (eqIdx <= 0 || eqIdx >= optVal.length() - 1) continue;
                    optKey = optVal.substring(0, eqIdx).toUpperCase();
                    optVal = optVal.substring(eqIdx + 1, optVal.length());
                    if ("DIRECT".equalsIgnoreCase(optKey)) {
                        if (!"ON".equalsIgnoreCase(optVal)) continue;
                        Return2.direct = true;
                        while (st.hasMoreElements()) {
                            st.nextToken();
                        }
                        continue;
                    }
                    if ("FONT".equals(optKey)) {
                        if (attrs == null) {
                            attrs = new Hashtable<FontAttribute, String>();
                        }
                        attrs.put(FontAttribute.FAMILY, optVal.trim());
                        continue;
                    }
                    if ("PITCH".equals(optKey)) {
                        try {
                            Float size = new Float(optVal);
                            if (attrs == null) {
                                attrs = new Hashtable();
                            }
                            attrs.put(FontAttribute.SIZE, (String)((Object)size));
                        }
                        catch (NumberFormatException size) {}
                        continue;
                    }
                    if ("LINES".equals(optKey)) {
                        try {
                            int val;
                            Return2.linesPerPage = val = Integer.parseInt(optVal);
                        }
                        catch (NumberFormatException val) {}
                        continue;
                    }
                    if ("ORIENTATION".equals(optKey)) {
                        try {
                            int val;
                            Return2.orientation = val = Integer.parseInt(optVal);
                        }
                        catch (NumberFormatException val) {}
                        continue;
                    }
                    if (!"COPY".equals(optKey)) continue;
                    try {
                        int val;
                        Return2.currCopies = val = Integer.parseInt(optVal);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                if (attrs != null && !Return2.direct) {
                    Return2.fontAttrs = attrs;
                }
            }
        }
        return Return2;
    }

    @Override
    public void setPreview(boolean prvw) throws IOException {
        this.sp.setPreview(prvw);
    }

    @Override
    public void setPDF(boolean pdf) throws IOException {
        this.sp.setPDF(pdf);
    }

    @Override
    public void updatePrinters() throws IOException {
        this.sp.updatePrinters();
    }

    @Override
    public void setHeaderFooter(String h, String f, int ft) throws IOException {
        this.sp.setHeaderFooter(h, f, ft);
    }

    @Override
    public void setReportName(String u) throws IOException {
        this.sp.setReportName(u);
    }

    public void sendCommands() throws IOException {
        if (this.sp instanceof RemotePrintCommandFactory) {
            ((RemotePrintCommandFactory)this.sp).sendCommands();
        }
    }

    public static class QPrinterAttrs {
        public boolean direct;
        public String name;
        public int linesPerPage = Integer.MIN_VALUE;
        public int orientation = Integer.MIN_VALUE;
        public int currCopies = Integer.MIN_VALUE;
        public Hashtable fontAttrs;

        public void copyTo(LocalSpoolPrinter lsp) {
            try {
                lsp.setPrinter(this.name);
                if (this.linesPerPage != Integer.MIN_VALUE) {
                    lsp.setLinesPerPage(this.linesPerPage);
                }
                if (this.orientation != Integer.MIN_VALUE) {
                    lsp.setOrientation(this.orientation);
                }
                if (this.currCopies != Integer.MIN_VALUE) {
                    lsp.setCurrCopies(this.currCopies);
                }
                if (this.fontAttrs != null) {
                    RemoteFontComponent font = ScreenUtility.getGuiFactory().getFont(this.fontAttrs, 0, 0, true);
                    if (lsp.isServerSide()) {
                        int hndl = UserHandles.ssetId(new FontCmp(font, this.fontAttrs));
                        lsp.setFont(hndl);
                        UserHandles.free(hndl);
                    } else {
                        lsp.setFont(font.getTheObjectId());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

