/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolClass;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.RuntimeProperties;

public class Version
implements RuntimeErrorsNumbers {
    public static final int major = RuntimeProperties.getVersionNumber();
    public static final int minor = RuntimeProperties.getReleaseNumber();
    public static final int spack = RuntimeProperties.getSpNumber();
    static final int build = RuntimeProperties.getBuildMainNumber();
    public static final String csVersion = "99";

    public static void main(String[] argv) {
        System.out.println(Config.getProperty(".runtime.version", "version unknown"));
        System.out.println("DB " + Config.getProperty(".file.index.version", "version unknown"));
        System.out.println("C/S Version " + Config.getProperty(".runtime.cs.version", "c/s version unknown") + ", F/S Version " + Config.getProperty(".runtime.fs.version", "f/s version unknown") + ", UID Version " + Version.getUIDVersion());
        if (argv.length > 0) {
            for (int i = 0; i < argv.length; ++i) {
                try {
                    Class<?> clazz;
                    Object obj;
                    if (argv[i].endsWith(".class")) {
                        argv[i] = argv[i].substring(0, argv[i].length() - 6);
                    }
                    if ((obj = (clazz = Class.forName(argv[i])).newInstance()) instanceof IscobolClass) {
                        IscobolClass ic = (IscobolClass)obj;
                        System.out.println(argv[i] + " version#" + ic.iscobolVersion() + " require#" + ic.iscobolRequired());
                        continue;
                    }
                    System.out.println(argv[i] + " not Iscobol object");
                    continue;
                }
                catch (ClassNotFoundException _ex) {
                    System.out.println(_ex);
                    continue;
                }
                catch (InstantiationException _ex) {
                    System.out.println(_ex);
                    continue;
                }
                catch (IllegalAccessException _ex) {
                    System.out.println(_ex);
                }
            }
            System.exit(0);
        }
    }

    public static String getVersion() {
        return RuntimeProperties.getFullVersionNumber();
    }

    public static String getCsVersion() {
        return csVersion;
    }

    public static long getUIDVersion() {
        try {
            return Class.forName("com.iscobol.debugger.DebuggerConstants").getField("DEBUGGER_SERIAL_VERSION_UID").getLong(null);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static void checkVersion(IscobolClass i) {
        if (i.iscobolVersion() < 261 || i.iscobolRequired() > build) {
            throw new IscobolRuntimeException(13, "rts=" + RuntimeProperties.getFullVersionNumber() + ",obj=" + i.iscobolVersion());
        }
    }
}

