/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.IPicAnyLength;
import com.iscobol.rts.SortKey;
import com.iscobol.rts.VarType;

public class SortKeyItem
implements VarType {
    private static boolean littleEndian = Config.getProperty(".little_endian", Config.LITTLE_ENDIAN);
    private static final int[] zonedCS = new int[256];
    public final boolean descending;
    public final int type;
    private int offset;
    public final int size;
    public final int digits;
    private int signumOffset;
    private int compStart;
    private int compEnd;
    private int compInc;
    private SortKey parent;
    private IPicAnyLength anyLength;

    public SortKeyItem(boolean descendin, int typ, IPicAnyLength al, SortKey p) {
        this(descendin, typ, 0, 0, 0, p);
        this.anyLength = al;
    }

    public SortKeyItem(boolean descendin, int typ, int offse, int siz, int digit, SortKey p) {
        this.descending = descendin;
        this.size = siz;
        this.digits = digit;
        this.parent = p;
        this.setOffset(offse);
        this.compInc = 1;
        switch (typ) {
            case 0: 
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                this.type = typ;
                break;
            }
            case 15: {
                this.signumOffset = 0;
                this.type = this.size == 8 ? 99 : 15;
                if (!littleEndian) break;
                this.compStart = this.offset + this.size - 1;
                this.compEnd = this.offset - 1;
                this.compInc = -1;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                this.signumOffset = this.offset + this.size - 1;
                this.type = typ;
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                this.signumOffset = this.offset;
                this.type = typ;
                break;
            }
            case 13: 
            case 14: {
                if (littleEndian) {
                    this.compStart = this.offset + this.size - 1;
                    this.compEnd = this.offset - 1;
                    this.compInc = -1;
                    this.signumOffset = this.offset;
                }
                this.signumOffset = this.compStart;
                this.type = typ;
                break;
            }
            default: {
                this.type = typ;
            }
        }
    }

    public int getOffset() {
        return this.offset;
    }

    private void setOffset(int offse) {
        this.compStart = this.offset = offse;
        this.compEnd = this.offset + this.size;
    }

    public void removeOffset(int offse) {
        if (this.anyLength == null) {
            this.offset -= offse;
            this.compStart -= offse;
            this.compEnd -= offse;
            this.signumOffset -= offse;
        }
    }

    private static boolean isPositive(byte c) {
        switch (c) {
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    private int zoncmp(byte[] l1, byte[] l2) {
        for (int i = this.compStart; i != this.compEnd; i += this.compInc) {
            int d = zonedCS[l1[i] & 0xFF] - zonedCS[l2[i] & 0xFF];
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    private int zoncmp(byte[] l1, boolean negative1, byte[] l2, boolean negative2) {
        if (negative1) {
            if (negative2) {
                return -this.zoncmp(l1, l2);
            }
            return -1;
        }
        if (!negative2) {
            return this.zoncmp(l1, l2);
        }
        return 1;
    }

    private int memcmp(byte[] l1, byte[] l2) {
        for (int i = this.compStart; i != this.compEnd; i += this.compInc) {
            int d = this.parent.colSeq[l1[i] & 0xFF] - this.parent.colSeq[l2[i] & 0xFF];
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    private int memcmpal(byte[] l1, byte[] l2) {
        int n = l1.length < l2.length ? l1.length : l2.length;
        for (int i = 0; i < n; ++i) {
            int d = this.parent.colSeq[l1[i] & 0xFF] - this.parent.colSeq[l2[i] & 0xFF];
            if (d == 0) continue;
            return d;
        }
        return l1.length - l2.length;
    }

    private int memcmp(byte[] l1, boolean negative1, byte[] l2, boolean negative2) {
        if (negative1) {
            if (negative2) {
                return -this.memcmp(l1, l2);
            }
            return -1;
        }
        if (!negative2) {
            return this.memcmp(l1, l2);
        }
        return 1;
    }

    private int bincmp(byte[] l1, boolean negative1, byte[] l2, boolean negative2) {
        if (negative1) {
            if (negative2) {
                return this.memcmp(l1, l2);
            }
            return -1;
        }
        if (!negative2) {
            return this.memcmp(l1, l2);
        }
        return 1;
    }

    private float toFloat(byte[] mem) {
        int ret;
        int start = this.offset;
        if (littleEndian) {
            ret = mem[start++] & 0xFF;
            ret |= (mem[start++] & 0xFF) << 8;
            ret |= (mem[start++] & 0xFF) << 16;
            ret |= (mem[start++] & 0xFF) << 24;
        } else {
            ret = (mem[start++] & 0xFF) << 24;
            ret |= (mem[start++] & 0xFF) << 16;
            ret |= (mem[start++] & 0xFF) << 8;
            ret |= mem[start] & 0xFF;
        }
        return Float.intBitsToFloat(ret);
    }

    private double toDouble(byte[] mem) {
        long ret;
        int start = this.offset;
        if (littleEndian) {
            ret = (long)mem[start++] & 0xFFL;
            ret |= ((long)mem[start++] & 0xFFL) << 8;
            ret |= ((long)mem[start++] & 0xFFL) << 16;
            ret |= ((long)mem[start++] & 0xFFL) << 24;
            ret |= ((long)mem[start++] & 0xFFL) << 32;
            ret |= ((long)mem[start++] & 0xFFL) << 40;
            ret |= ((long)mem[start++] & 0xFFL) << 48;
            ret |= ((long)mem[start] & 0xFFL) << 56;
        } else {
            ret = ((long)mem[start++] & 0xFFL) << 56;
            ret |= ((long)mem[start++] & 0xFFL) << 48;
            ret |= ((long)mem[start++] & 0xFFL) << 40;
            ret |= ((long)mem[start++] & 0xFFL) << 32;
            ret |= ((long)mem[start++] & 0xFFL) << 24;
            ret |= ((long)mem[start++] & 0xFFL) << 16;
            ret |= ((long)mem[start++] & 0xFFL) << 8;
            ret |= (long)mem[start] & 0xFFL;
        }
        return Double.longBitsToDouble(ret);
    }

    public int compare(int index1, int index2) {
        return this.compare(this.anyLength.intIAt(index1).getBytes(), this.anyLength.intIAt(index2).getBytes());
    }

    public int compare(byte[] l1, byte[] l2) {
        int Return2;
        switch (this.type) {
            default: {
                Return2 = this.memcmp(l1, l2);
                break;
            }
            case 16: {
                if (this.anyLength != null) {
                    Return2 = this.memcmpal(l1, l2);
                    break;
                }
                Return2 = this.memcmp(l1, l2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Return2 = this.zoncmp(l1, !SortKeyItem.isPositive(l1[this.signumOffset]), l2, !SortKeyItem.isPositive(l2[this.signumOffset]));
                break;
            }
            case 6: 
            case 8: {
                Return2 = this.memcmp(l1, (l1[this.signumOffset] & 0xF) == 13, l2, (l2[this.signumOffset] & 0xF) == 13);
                break;
            }
            case 11: 
            case 13: {
                Return2 = this.bincmp(l1, (l1[this.signumOffset] & 0x80) != 0, l2, (l2[this.signumOffset] & 0x80) != 0);
                break;
            }
            case 99: {
                double dres = this.toDouble(l1) - this.toDouble(l2);
                if (dres > 0.0) {
                    Return2 = 1;
                    break;
                }
                if (dres < 0.0) {
                    Return2 = -1;
                    break;
                }
                Return2 = 0;
                break;
            }
            case 15: {
                float fres = this.toFloat(l1) - this.toFloat(l2);
                Return2 = fres > 0.0f ? 1 : (fres < 0.0f ? -1 : 0);
            }
        }
        if (this.descending) {
            return -Return2;
        }
        return Return2;
    }

    public boolean isAnyLength() {
        return this.anyLength != null;
    }

    static {
        for (int i = 0; i < zonedCS.length; ++i) {
            SortKeyItem.zonedCS[i] = i;
        }
        SortKeyItem.zonedCS[123] = 48;
        SortKeyItem.zonedCS[65] = 49;
        SortKeyItem.zonedCS[66] = 50;
        SortKeyItem.zonedCS[67] = 51;
        SortKeyItem.zonedCS[68] = 52;
        SortKeyItem.zonedCS[69] = 53;
        SortKeyItem.zonedCS[70] = 54;
        SortKeyItem.zonedCS[71] = 55;
        SortKeyItem.zonedCS[72] = 56;
        SortKeyItem.zonedCS[73] = 57;
    }
}

