/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.RtsUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SOAPEnvelopeParser
extends DefaultHandler {
    public static final String NAMESPACE1 = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String NAMESPACE2 = "http://www.w3.org/2003/05/soap-envelope";
    private static final int ST_ERR_INVALID_ENVELOPE = -1;
    private static final int ST_END_OK = 0;
    private static final int ST_START = 1;
    private static final int ST_ENVELOPE = 2;
    private static final int ST_BODY = 3;
    private int status = 1;
    private String methName;
    private String methURI;

    public SOAPEnvelopeParser(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory factory = RtsUtil.newSAXParserFactory();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.status <= 0) {
            return;
        }
        if (this.status == 3) {
            this.methName = localName;
            this.methURI = uri;
            this.status = 0;
        } else if ("Envelope".equalsIgnoreCase(localName) && this.isEnvelopeNS(uri)) {
            this.status = this.status != 1 ? -1 : 2;
        } else if ("Body".equalsIgnoreCase(localName) && this.isEnvelopeNS(uri)) {
            this.status = this.status != 2 ? -1 : 3;
        }
        if ("Body".equalsIgnoreCase(localName) && this.isEnvelopeNS(uri)) {
            this.status = 3;
        }
    }

    private boolean isEnvelopeNS(String uri) {
        return NAMESPACE1.equals(uri) || NAMESPACE2.equals(uri);
    }

    public String getMethodName() {
        return this.methName;
    }

    public String getMethodURI() {
        return this.methURI;
    }
}

