/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.InflaterInputStream;

public class SMAPReader {
    private static final Map<String, Integer> formats;
    private static final int MAX_FORMAT = 7;
    private byte[] orig;
    private int origPos;
    private int smapIdx;
    private String smap;
    private int newFormatLength;
    protected int newFormat;
    private String javaFile;
    private String fileName;
    private Vector<String> files = new Vector();
    private Vector<LineInfo> lines = new Vector();
    private Vector<String[]> copyStmts = new Vector();
    private Map<String, byte[]> copyResources = new HashMap<String, byte[]>();
    protected long timestamp;

    public SMAPReader(InputStream inStream) throws IOException {
        this(inStream, true);
    }

    protected SMAPReader(InputStream inStream, boolean throwExc) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[8192];
        int r = inStream.read(buff);
        while (r >= 0) {
            baos.write(buff, 0, r);
            r = inStream.read(buff);
        }
        baos.close();
        inStream.close();
        this.orig = baos.toByteArray();
        this.skip(8);
        int constantPoolCount = this.read2();
        this.smapIdx = this.scanConstantPool(constantPoolCount);
        this.skip(6);
        int interfaceCount = this.read2();
        this.skip(interfaceCount * 2);
        this.skipMembers();
        this.skipMembers();
        int attrCount = this.read2();
        this.smap = this.skipAttrs(attrCount);
        if (this.smap != null) {
            this.buildOld();
        } else if (this.newFormat == 1) {
            this.buildOld2(this.newFormatLength);
        } else if (this.newFormat >= 2 && this.newFormat <= 7) {
            this.build(this.newFormatLength);
        } else if (throwExc) {
            throw new IOException("unknown SMAP format");
        }
    }

    int scanConstantPool(int size) throws IOException {
        int Return2 = -1;
        block7: for (int i = 1; i < size; ++i) {
            int tag = this.read1();
            switch (tag) {
                case 1: {
                    String utf = this.readUTF8String(this.read2());
                    Integer f = formats.get(utf);
                    if (f == null) continue block7;
                    this.newFormat = f;
                    Return2 = i;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: {
                    this.skip(2);
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this.skip(4);
                    continue block7;
                }
                case 15: {
                    this.skip(3);
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.skip(8);
                    ++i;
                    continue block7;
                }
                default: {
                    throw new IOException("unexpected tag: " + tag);
                }
            }
        }
        return Return2;
    }

    void skipMembers() throws UnsupportedEncodingException {
        int count = this.read2();
        for (int i = 0; i < count; ++i) {
            this.skip(6);
            int attrCount = this.read2();
            this.skipAttrs(attrCount);
        }
    }

    private String skipAttrs(int attrCount) throws UnsupportedEncodingException {
        String Return2 = null;
        for (int i = 0; i < attrCount; ++i) {
            if (this.read2() == this.smapIdx) {
                int len = this.read4();
                if (this.newFormat > 0) {
                    this.newFormatLength = len;
                    break;
                }
                Return2 = this.readUTF8String(len);
                break;
            }
            this.skip(this.read4());
        }
        return Return2;
    }

    private void skip(int c) {
        this.origPos += c;
    }

    int read1() {
        return this.orig[this.origPos++] & 0xFF;
    }

    int read2() {
        return (this.read1() << 8) + this.read1();
    }

    int read4() {
        return (this.read2() << 16) + this.read2();
    }

    String readUTF8String(int count) throws UnsupportedEncodingException {
        String Return2 = new String(this.orig, this.origPos, count, "UTF-8");
        this.origPos += count;
        return Return2;
    }

    private void buildOld2(int count) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.orig, this.origPos, count);
        DataInputStream dIn = new DataInputStream(new InflaterInputStream(bais));
        this.buildOld2(dIn);
        dIn.close();
    }

    private void build(int count) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.orig, this.origPos, count);
        DataInputStream dIn = new DataInputStream(bais);
        int len = dIn.readInt();
        byte[] b = new byte[len];
        dIn.read(b);
        DataInputStream dIn0 = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(b)));
        this.intBuild(dIn0);
        this.buildExt(dIn, dIn0);
        dIn0.close();
        dIn.close();
    }

    protected void buildExt(DataInputStream dIn, DataInputStream dIn0) throws IOException {
    }

    protected void buildOld2(DataInputStream dIn) throws IOException {
        this.intBuild(dIn);
    }

    private void intBuild(DataInputStream dIn) throws IOException {
        int nLines = dIn.readInt();
        for (int i = 0; i < nLines; ++i) {
            this.lines.addElement(new LineInfo(dIn.readInt(), dIn.readShort(), dIn.readShort(), dIn.readInt()));
        }
        this.readCopyStmts(dIn);
        int nSources = dIn.readInt();
        for (int i = 0; i < nSources; ++i) {
            this.files.addElement(dIn.readUTF());
        }
        if (this.newFormat >= 3) {
            int nCopyRes = dIn.readInt();
            for (int i = 0; i < nCopyRes; ++i) {
                String resName = dIn.readUTF();
                byte[] res = new byte[dIn.readInt()];
                dIn.readFully(res);
                this.copyResources.put(resName, res);
            }
            if (this.newFormat >= 5) {
                this.timestamp = dIn.readLong();
            }
        }
        if (this.files.size() > 0) {
            this.fileName = this.files.elementAt(0);
        }
    }

    protected void readCopyStmts(DataInputStream dIn) throws IOException {
        int nCopies = dIn.readInt();
        for (int i = 0; i < nCopies; ++i) {
            this.copyStmts.addElement(new String[]{dIn.readUTF(), Integer.toString(dIn.readInt()), dIn.readUTF(), Short.toString(dIn.readShort()), Short.toString(dIn.readShort())});
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private void buildOld() {
        StringTokenizer st = new StringTokenizer(this.smap, "\r\n");
        try {
            int i;
            if ("SMAP".equals(st.nextToken())) {
                this.javaFile = st.nextToken();
                st.nextToken();
            }
            while (!"*S isCOBOL".equals(st.nextToken())) {
            }
            String s = st.nextToken();
            if ("*F".equals(s)) {
                s = st.nextToken();
                while (!"*L".equals(s)) {
                    int idx;
                    StringTokenizer st1 = new StringTokenizer(s, " ");
                    i = Integer.parseInt(st1.nextToken());
                    if (i >= this.files.size()) {
                        this.files.setSize(i + 1);
                    }
                    String fn = st1.nextToken();
                    if (this.fileName == null && (idx = fn.lastIndexOf(44)) >= 0) {
                        try {
                            int val = Integer.parseInt(fn.substring(idx + 1));
                            if (val == 0) {
                                this.fileName = fn.substring(0, idx);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.files.setElementAt(fn, i);
                    s = st.nextToken();
                }
            }
            if ("*L".equals(s)) {
                i = 0;
                while (st.hasMoreTokens() && (s = st.nextToken()).charAt(0) != '*') {
                    LineInfo lf = new LineInfo(s, i);
                    this.lines.add(lf);
                    i = lf.fileNum;
                }
            }
            if ("*C".equals(s)) {
                while (st.hasMoreTokens() && (s = st.nextToken()).charAt(0) != '*') {
                    this.copyStmts.add(s.split("\\,"));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public boolean isOk() {
        return !this.lines.isEmpty();
    }

    public CobolInfo getLineInfo(int javaLine) {
        return this.getLineInfo(javaLine, false);
    }

    private String getFileName(LineInfo li) {
        return li.fileName != null ? li.fileName : this.files.elementAt(li.fileIndex);
    }

    public CobolInfo getLineInfo(int javaLine, boolean ifExists) {
        CobolInfo Return2 = null;
        LineInfo lastLi = null;
        int size = this.lines.size();
        for (int i = 0; i < size; ++i) {
            LineInfo li = this.lines.elementAt(i);
            if (javaLine >= li.javaLine && javaLine < li.javaLine + li.repeat) {
                Return2 = new CobolInfo(li.cobLine + javaLine - li.javaLine, this.getFileName(li), li.fileNum, li.fileIndex);
                break;
            }
            if (javaLine < li.javaLine) {
                if (ifExists || lastLi == null) break;
                Return2 = new CobolInfo(lastLi.cobLine + (lastLi.repeat - 1), this.getFileName(lastLi), lastLi.fileNum, lastLi.fileIndex);
                break;
            }
            lastLi = li;
        }
        if (Return2 == null && !ifExists) {
            Return2 = lastLi != null ? new CobolInfo(lastLi.cobLine + lastLi.repeat - 1, this.getFileName(lastLi), lastLi.fileNum, lastLi.fileIndex) : new CobolInfo(javaLine, this.javaFile, 0, 0);
        }
        return Return2;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Vector<String[]> getCopyStatements() {
        return this.copyStmts;
    }

    public Vector<String> getFileNames() {
        return this.files;
    }

    public Map<String, byte[]> getCopyResources() {
        return this.copyResources;
    }

    public int getSmapFormat() {
        return this.newFormat;
    }

    static {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        String SDE = "isCOBOLSourceDebugExtension";
        m.put("SourceDebugExtension", 0);
        m.put("isCOBOLSourceDebugExtension", 1);
        for (int i = 2; i <= 7; ++i) {
            m.put("isCOBOLSourceDebugExtension" + i, i);
        }
        formats = Collections.unmodifiableMap(m);
    }

    private class LineInfo {
        public final int cobLine;
        public final int repeat;
        public final int javaLine;
        public final int fileNum;
        public final String fileName;
        public final int fileIndex;

        public LineInfo(int cobLine, int fileIndex, int repeat, int javaLine) {
            this.cobLine = cobLine;
            this.repeat = repeat;
            this.javaLine = javaLine;
            this.fileIndex = fileIndex;
            this.fileNum = fileIndex;
            this.fileName = null;
        }

        public LineInfo(String smapLine, int lastFile) {
            int i;
            char[] ca = smapLine.toCharArray();
            int len = ca.length;
            int j = 0;
            for (i = 0; i < len && ca[i] >= '0' && ca[i] <= '9'; ++i) {
                j = j * 10 + (ca[i] - 48);
            }
            this.cobLine = j;
            if (i < len && ca[i] == '#') {
                j = 0;
                ++i;
                while (i < len && ca[i] >= '0' && ca[i] <= '9') {
                    j = j * 10 + (ca[i] - 48);
                    ++i;
                }
                this.fileNum = j;
            } else {
                this.fileNum = lastFile;
            }
            String fn = (String)SMAPReader.this.files.elementAt(this.fileNum);
            int idx = fn.lastIndexOf(44);
            if (idx >= 0) {
                this.fileIndex = Integer.parseInt(fn.substring(idx + 1));
                fn = fn.substring(0, idx);
            } else {
                this.fileIndex = 0;
            }
            this.fileName = fn;
            if (i < len && ca[i] == ',') {
                j = 0;
                ++i;
                while (i < len && ca[i] >= '0' && ca[i] <= '9') {
                    j = j * 10 + (ca[i] - 48);
                    ++i;
                }
                this.repeat = j;
            } else {
                this.repeat = 1;
            }
            if (i < len && ca[i] == ':') {
                j = 0;
                ++i;
                while (i < len && ca[i] >= '0' && ca[i] <= '9') {
                    j = j * 10 + (ca[i] - 48);
                    ++i;
                }
                this.javaLine = j;
            } else {
                this.javaLine = 0;
            }
        }
    }

    public static class CobolInfo {
        public final int line;
        public final String fileName;
        public final int fileNum;
        public final int fileIndex;

        private CobolInfo(int l, String f, int fn, int fi) {
            this.line = l;
            this.fileName = f;
            this.fileNum = fn;
            this.fileIndex = fi;
        }
    }
}

