/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.as.ServerCallHandler;
import com.iscobol.rts.Config;
import com.iscobol.rts.Finalizable;
import com.iscobol.rts.IsRemote;
import com.iscobol.rts.IsRemoteFactory;
import com.iscobol.rts.IsRemoteMethod;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class RemoteConnections
implements Finalizable {
    private Hashtable<String, Vector<ConnObj>> connectionsTable = new Hashtable();
    private String currentRemoteCodePrefix;
    private IsRemoteFactory factory;

    public RemoteConnections(IsRemoteFactory factory) {
        this.factory = factory;
        this.load();
    }

    public void load() {
        String remoteCodePrefix = Config.getProperty(".remote.code_prefix", null);
        if (remoteCodePrefix != null) {
            if (this.currentRemoteCodePrefix == null || !this.currentRemoteCodePrefix.equals(remoteCodePrefix)) {
                this.currentRemoteCodePrefix = remoteCodePrefix;
                Vector<ConnObj> connections = this.connectionsTable.get(this.currentRemoteCodePrefix);
                if (connections == null) {
                    connections = new Vector();
                    this.connectionsTable.put(this.currentRemoteCodePrefix, connections);
                    StringTokenizer st = new StringTokenizer(this.currentRemoteCodePrefix, "\n");
                    while (st.hasMoreTokens()) {
                        String tk = st.nextToken();
                        if (tk.startsWith("isc:")) {
                            try {
                                connections.add(new ConnObj(tk, false));
                            }
                            catch (MalformedURLException malformedURLException) {}
                            continue;
                        }
                        if (!tk.startsWith("iscp:")) continue;
                        try {
                            connections.add(new ConnObj(tk, true));
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
        } else {
            this.currentRemoteCodePrefix = null;
        }
    }

    public boolean isEmpty() {
        Vector<ConnObj> conns = this.getCurrentConnections();
        if (conns != null) {
            return conns.isEmpty();
        }
        return true;
    }

    public int getConnectionCount() {
        Vector<ConnObj> conns = this.getCurrentConnections();
        if (conns != null) {
            return conns.size();
        }
        return 0;
    }

    public String getRemoteURL(int idx) {
        return this.getConnectionObject((int)idx).url;
    }

    private Vector<ConnObj> getCurrentConnections() {
        if (this.currentRemoteCodePrefix != null) {
            return this.connectionsTable.get(this.currentRemoteCodePrefix);
        }
        return null;
    }

    public IsRemote getIsRemote(int idx, String callName) throws IOException, ArrayIndexOutOfBoundsException {
        ConnObj co = this.getConnectionObject(idx);
        ServerCallHandler scHdl = this.getServerCallHandler(co);
        return this.factory.getIsRemote(scHdl.getServerCall(), callName, co.isCp);
    }

    public IsRemoteMethod getIsRemoteMethod(int idx, String className, String methodName, String signature, Object[] parameters) throws IOException, ArrayIndexOutOfBoundsException {
        ConnObj co = this.getConnectionObject(idx);
        ServerCallHandler scHdl = this.getServerCallHandler(co);
        return this.factory.getIsRemoteMethod(scHdl.getServerCall(), className, methodName, signature, parameters);
    }

    private ConnObj getConnectionObject(int idx) {
        Vector<ConnObj> connections = this.getCurrentConnections();
        if (connections == null || idx < 0 || idx >= connections.size()) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(idx));
        }
        return connections.get(idx);
    }

    private ServerCallHandler getServerCallHandler(ConnObj co) throws IOException, ArrayIndexOutOfBoundsException {
        String iscobolconf = Config.getProperty(".remote.conf", ".remote_conf", "");
        ServerCallHandler scHdl = co.serverCallHandlers.get(iscobolconf);
        if (scHdl == null) {
            scHdl = ServerCallHandler.init(co.host, Integer.toString(co.port), iscobolconf);
            co.serverCallHandlers.put(iscobolconf, scHdl);
        }
        return scHdl;
    }

    protected void finalize() throws Throwable {
        this.myFinalize();
    }

    @Override
    public void myFinalize() {
        this.disconnectAll();
        this.connectionsTable.clear();
    }

    public void disconnectAll() {
        for (Vector<ConnObj> connections : this.connectionsTable.values()) {
            for (ConnObj rc : connections) {
                for (ServerCallHandler sch : rc.serverCallHandlers.values()) {
                    try {
                        sch.shutdown();
                    }
                    catch (IOException iOException) {}
                }
                rc.serverCallHandlers.clear();
            }
        }
    }

    private static class ConnObj {
        final Hashtable<String, ServerCallHandler> serverCallHandlers = new Hashtable();
        final String url;
        final String host;
        final int port;
        final boolean isCp;

        ConnObj(String url, boolean isCp) throws MalformedURLException {
            this.url = url;
            URL u = new URL("file" + url.substring(url.indexOf(58)));
            this.host = u.getHost();
            this.port = u.getPort();
            this.isCp = isCp;
        }
    }
}

