/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.FactoryData;
import com.iscobol.rts.IsInitial;
import com.iscobol.rts.IsResident;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.LocalStorageProvider;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.ThreadLocalStorageProvider;
import com.iscobol.rts.WithEntryPoints;
import com.iscobol.rts.WithName;
import java.util.ArrayList;

public class LeveledRecursiveCall
implements IscobolCall,
WithName,
LocalStorageProvider,
ThreadLocalStorageProvider,
RuntimeErrorsNumbers {
    private final Class callClass;
    private final ArrayList array = new ArrayList();
    private int level;
    private IscobolCall mostRecentCall;
    int mostRecentLevel;

    public static IscobolCall get(Object ic, FactoryData f) {
        if (ic instanceof IsInitial || ic instanceof LeveledRecursiveCall) {
            return (IscobolCall)ic;
        }
        if (ic instanceof WithEntryPoints) {
            if (ic instanceof IsResident) {
                return new WEPointsResident((WithEntryPoints)ic);
            }
            return new WEPoints((WithEntryPoints)ic);
        }
        if (ic instanceof IsResident) {
            return new Resident((IscobolCall)ic);
        }
        IscobolCall Return2 = (IscobolCall)f.recurCallList.get(ic);
        if (Return2 == null) {
            Return2 = new LeveledRecursiveCall((IscobolCall)ic);
            f.recurCallList.put(ic, Return2);
        }
        return Return2;
    }

    private LeveledRecursiveCall(IscobolCall ic) {
        this.mostRecentCall = ic;
        this.callClass = ic.getClass();
        this.array.add(ic);
    }

    private IscobolCall get() {
        IscobolCall Return2;
        if (this.level >= this.array.size()) {
            try {
                Return2 = (IscobolCall)this.callClass.newInstance();
                this.array.add(Return2);
            }
            catch (Exception ex) {
                throw new IscobolRuntimeException(7, this.callClass.getName() + " (" + ex + ")");
            }
        } else {
            Return2 = (IscobolCall)this.array.get(this.level);
        }
        return Return2;
    }

    @Override
    public Object call(Object[] argv) {
        Object Return2;
        if (this.level != this.mostRecentLevel) {
            this.mostRecentCall = this.get();
            this.mostRecentLevel = this.level;
        }
        ++this.level;
        try {
            Return2 = this.mostRecentCall.call(argv);
        }
        finally {
            --this.level;
        }
        return Return2;
    }

    @Override
    public void perform(int a, int b) {
        if (this.level != this.mostRecentLevel) {
            this.mostRecentCall = this.get();
            this.mostRecentLevel = this.level;
        }
        ++this.level;
        try {
            this.mostRecentCall.perform(a, b);
        }
        finally {
            --this.level;
        }
    }

    public void closeFiles() {
        if (this.level != this.mostRecentLevel) {
            this.mostRecentCall = this.get();
            this.mostRecentLevel = this.level;
        }
        ++this.level;
        try {
            this.mostRecentCall.finalize();
        }
        finally {
            --this.level;
        }
    }

    public void forceAllFinalize() {
        this.level = 0;
        this.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void finalize() {
        if (this.level < 0) {
            return;
        }
        for (int i = this.array.size() - 1; i >= this.level; --i) {
            FactoryData f2;
            IscobolCall theCall = (IscobolCall)this.array.get(i);
            this.array.remove(i);
            try {
                theCall.finalize();
            }
            catch (Throwable f2) {
                f2 = (FactoryData)IscobolSystem.get(FactoryData.class);
                if (f2 != null) {
                    f2.recurCallList.remove(theCall);
                }
                if (theCall != this.mostRecentCall) continue;
                if (i > 0) {
                    this.mostRecentCall = (IscobolCall)this.array.get(i - 1);
                    --this.mostRecentLevel;
                    continue;
                }
                this.mostRecentCall = null;
                this.mostRecentLevel = -1;
                continue;
            }
            catch (Throwable throwable) {
                FactoryData f3 = (FactoryData)IscobolSystem.get(FactoryData.class);
                if (f3 != null) {
                    f3.recurCallList.remove(theCall);
                }
                if (theCall == this.mostRecentCall) {
                    if (i > 0) {
                        this.mostRecentCall = (IscobolCall)this.array.get(i - 1);
                        --this.mostRecentLevel;
                    } else {
                        this.mostRecentCall = null;
                        this.mostRecentLevel = -1;
                    }
                }
                throw throwable;
            }
            f2 = (FactoryData)IscobolSystem.get(FactoryData.class);
            if (f2 != null) {
                f2.recurCallList.remove(theCall);
            }
            if (theCall != this.mostRecentCall) continue;
            if (i > 0) {
                this.mostRecentCall = (IscobolCall)this.array.get(i - 1);
                --this.mostRecentLevel;
                continue;
            }
            this.mostRecentCall = null;
            this.mostRecentLevel = -1;
            continue;
        }
    }

    public String[] getEntryPoints() {
        if (this.mostRecentCall instanceof WithEntryPoints) {
            return ((WithEntryPoints)this.mostRecentCall).getEntryPoints();
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(int entrypoint, Object[] arg) {
        Object Return2;
        if (this.level != this.mostRecentLevel) {
            this.mostRecentCall = this.get();
            this.mostRecentLevel = this.level;
        }
        ++this.level;
        try {
            Return2 = ((WithEntryPoints)this.mostRecentCall).call(entrypoint, arg);
        }
        finally {
            --this.level;
        }
        return Return2;
    }

    public IscobolCall getMostRecent() {
        return this.mostRecentCall;
    }

    @Override
    public String getName() {
        return this.callClass.getName();
    }

    public boolean isEmpty() {
        return this.array.size() == 0;
    }

    @Override
    public Object newLocalStorage() {
        if (LocalStorageProvider.class.isAssignableFrom(this.callClass)) {
            return ((LocalStorageProvider)((Object)this.get())).newLocalStorage();
        }
        return null;
    }

    @Override
    public Object newThreadLocalStorage() {
        if (ThreadLocalStorageProvider.class.isAssignableFrom(this.callClass)) {
            return ((ThreadLocalStorageProvider)((Object)this.get())).newThreadLocalStorage();
        }
        return null;
    }

    @Override
    public String threadLocalStorageName() {
        if (ThreadLocalStorageProvider.class.isAssignableFrom(this.callClass)) {
            return ((ThreadLocalStorageProvider)((Object)this.get())).threadLocalStorageName();
        }
        return this.getClass().getName();
    }

    public Class getCallClass() {
        return this.callClass;
    }

    private static class Resident
    extends LeveledRecursiveCall
    implements IsResident {
        private Resident(IscobolCall ic) {
            super(ic);
        }
    }

    private static class WEPointsResident
    extends LeveledRecursiveCall
    implements WithEntryPoints,
    IsResident {
        private WEPointsResident(WithEntryPoints ic) {
            super(ic);
        }
    }

    private static class WEPoints
    extends LeveledRecursiveCall
    implements WithEntryPoints {
        private WEPoints(WithEntryPoints ic) {
            super(ic);
        }
    }
}

