/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.LocalStorageProvider;

public class CallBiStack {
    private static final int INCR_SIZE = 32;
    private CallObj[] calls = new CallObj[32];
    private Object[] callers = new Object[32];
    private int allocated = 32;
    private int size;
    private int allocated2 = 32;
    private int size2;
    private int main;

    public void pushMain(Object c, Object[] a, Object tls, String name) {
        this.main = 1;
        this.push(c, a, tls, name);
    }

    public void popMain() {
        this.main = 0;
        this.pop();
    }

    public void push(Object c, Object[] a, Object tls, String name) {
        int length;
        if (this.size == this.allocated) {
            length = this.calls.length;
            this.allocated = length + 32;
            CallObj[] newCalls = new CallObj[this.allocated];
            System.arraycopy(this.calls, 0, newCalls, 0, length);
            this.calls = newCalls;
        }
        if (this.size2 == this.allocated2) {
            length = this.callers.length;
            this.allocated2 = length + 32;
            Object[] newCallers = new Object[this.allocated2];
            System.arraycopy(this.callers, 0, newCallers, 0, length);
            this.callers = newCallers;
        }
        CallObj newObj = new CallObj();
        newObj.call = c;
        newObj.argv = a;
        newObj.tls = tls;
        newObj.name = name;
        if (c instanceof LocalStorageProvider) {
            newObj.ls = ((LocalStorageProvider)c).newLocalStorage();
        }
        this.calls[this.size] = newObj;
        ++this.size;
        this.callers[this.size2] = c;
        ++this.size2;
    }

    public void pop() {
        --this.size;
        this.calls[this.size] = null;
        --this.size2;
        this.callers[this.size2] = null;
    }

    public void pushCaller(Object c) {
        this.callers[this.size2] = c;
        ++this.size2;
    }

    public void popCaller() {
        --this.size2;
        this.callers[this.size2] = null;
    }

    public int size() {
        return this.size;
    }

    public int callersSize() {
        return this.size2;
    }

    public boolean isCalled() {
        return this.size - this.main > 0;
    }

    public Object peekCall() {
        if (this.size > 0) {
            return this.calls[this.size - 1].call;
        }
        return null;
    }

    public String peekName() {
        if (this.size > 0) {
            return this.calls[this.size - 1].name;
        }
        return null;
    }

    public Object[] peekArgv() {
        if (this.size > 0) {
            return this.calls[this.size - 1].argv;
        }
        return null;
    }

    public Object callerAt(int i) {
        return this.callers[i];
    }

    public Object callAt(int i) {
        return this.calls[i].call;
    }

    public Object[] argvAt(int i) {
        return this.calls[i].argv;
    }

    public Object localStorageAt(int i) {
        return this.calls[i].ls;
    }

    public Object threadLocalStorageAt(int i) {
        return this.calls[i].tls;
    }

    public int searchCall(Object c) {
        for (int i = 0; i < this.size; ++i) {
            if (this.calls[i].call != c) continue;
            return i;
        }
        return -1;
    }

    private static class CallObj {
        Object call;
        String name;
        Object[] argv;
        Object ls;
        Object tls;

        private CallObj() {
        }
    }
}

