/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.server;

import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.ISessionControl;
import com.iscobol.rpc.messageserver.common.InboundMessageHandler;
import com.iscobol.rpc.messageserver.common.JavaSerializer;
import com.iscobol.rpc.messageserver.common.RpcSocketFactory;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.ThreadDiagnostics;
import com.iscobol.rpc.messageserver.server.AbstractServerApplication;
import com.iscobol.rpc.messageserver.server.AbstractServerApplicationFactory;
import com.iscobol.rpc.messageserver.server.CleanupThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class MessageServer
implements ISessionControl {
    public static final int DEFAULT_MAX_CONNECTIONS = 512;
    private String host = null;
    private int port = 0;
    private boolean reuseAddress;
    private AbstractServerApplicationFactory applicationFactory = null;
    private boolean isAcceptNewConnections = true;
    private boolean isSendAndReceiveMessages = true;
    private int maxConnections = 512;
    private boolean keepAlive;
    private Hashtable applications = new Hashtable();
    private int cleanupThreadSleepTimeInSeconds = 60;
    private IMessageSerializer messageSerializer = new JavaSerializer();
    private boolean ignoreMaxConnectionsLimit;

    public MessageServer(String host, int port, boolean reuseAddress, AbstractServerApplicationFactory applicationFactory) {
        this.host = host;
        this.port = port;
        this.reuseAddress = reuseAddress;
        this.applicationFactory = applicationFactory;
        applicationFactory.setMessageServer(this);
    }

    public void listen() throws UnknownHostException, IOException {
        InetAddress inetAddress;
        Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode());
        ServerSocket serverSocket = null;
        InetAddress inetAddress2 = inetAddress = this.host != null ? InetAddress.getByName(this.host) : null;
        if (this.reuseAddress) {
            try {
                serverSocket = RpcSocketFactory.createServerSocket();
                serverSocket.getClass().getMethod("setReuseAddress", Boolean.TYPE).invoke((Object)serverSocket, Boolean.TRUE);
                Object inetSocketAddress = Class.forName("java.net.InetSocketAddress").getConstructor(InetAddress.class, Integer.TYPE).newInstance(inetAddress, new Integer(this.port));
                serverSocket.getClass().getMethod("bind", Class.forName("java.net.SocketAddress"), Integer.TYPE).invoke((Object)serverSocket, inetSocketAddress, new Integer(100));
            }
            catch (Throwable t) {
                serverSocket = RpcSocketFactory.createServerSocket(this.port, 100, inetAddress);
            }
        } else {
            serverSocket = RpcSocketFactory.createServerSocket(this.port, 100, inetAddress);
        }
        serverSocket.setSoTimeout(0);
        CleanupThread ct = new CleanupThread(this.getApplications(), this.cleanupThreadSleepTimeInSeconds);
        ct.setDaemon(true);
        ct.start();
        boolean rejectConnection = false;
        while (true) {
            rejectConnection = false;
            Socket socket = serverSocket.accept();
            if (this.isAcceptNewConnections) {
                int currentConnectionCount = this.currentConnectionCount();
                if (currentConnectionCount < this.maxConnections) {
                    this.createSession(socket, false);
                } else if (this.ignoreMaxConnectionsLimit) {
                    this.createSession(socket, true);
                } else {
                    rejectConnection = true;
                }
            } else {
                rejectConnection = true;
            }
            if (!rejectConnection) continue;
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSession(final Socket socket, final boolean maxConnectionLimitExceeded) throws IOException {
        final Boolean[] ok = new Boolean[1];
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean ok0 = false;
                try {
                    MessageServer.this.createSessionImpl(socket, maxConnectionLimitExceeded);
                    ok0 = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Boolean[] booleanArray = ok;
                synchronized (ok) {
                    ok[0] = new Boolean(ok0);
                    ok.notify();
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
            }
        };
        t.start();
        Boolean[] booleanArray = ok;
        synchronized (ok) {
            if (ok[0] == null) {
                try {
                    ok.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (ok[0] == null || !ok[0].booleanValue()) {
                System.err.println("Connection timeout");
                socket.close();
            }
            return;
        }
    }

    private void createSessionImpl(Socket socket, boolean maxConnectionLimitExceeded) throws Exception {
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            System.err.println("socket.setTcpNoDelay failed: " + ex.getMessage());
        }
        try {
            socket.setSoTimeout(0);
        }
        catch (SocketException ex) {
            System.err.println("socket.setSoTimeout failed: " + ex.getMessage());
        }
        try {
            socket.setKeepAlive(this.keepAlive);
        }
        catch (SocketException ex) {
            System.err.println("socket.setKeepAlive failed: " + ex.getMessage());
        }
        Session session = new Session(this, socket);
        session.setMaxConnectionLimitExceeded(maxConnectionLimitExceeded);
        session.startMessageHandlers();
        int sessionId = session.getSessionId();
        AbstractServerApplication application = this.applicationFactory.getApplication(session);
        application.setDaemon(true);
        application.start();
        this.getApplications().put(application.getClass().getName() + sessionId, application);
    }

    public int currentConnectionCount() {
        ThreadDiagnostics o = new ThreadDiagnostics();
        ArrayList threads = o.getAllThreads();
        Iterator iter = threads.iterator();
        int i = 0;
        while (iter.hasNext()) {
            InboundMessageHandler imh;
            Thread t = (Thread)iter.next();
            if (!(t instanceof InboundMessageHandler) || (imh = (InboundMessageHandler)t).getSession().isMaxConnectionLimitExceeded()) continue;
            ++i;
        }
        return i;
    }

    public synchronized void setAcceptNewConnections(boolean isAcceptNewConnections) {
        this.isAcceptNewConnections = isAcceptNewConnections;
    }

    @Override
    public synchronized void setSendAndReceiveMessages(boolean isSendAndReceiveMessages) {
        this.isSendAndReceiveMessages = isSendAndReceiveMessages;
    }

    @Override
    public synchronized boolean isSendAndReceiveMessages() {
        return this.isSendAndReceiveMessages;
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setMessageSerializer(IMessageSerializer messageSerializer) {
        this.messageSerializer = messageSerializer;
    }

    @Override
    public IMessageSerializer getMessageSerializer() {
        return this.messageSerializer;
    }

    public Hashtable getApplications() {
        return this.applications;
    }

    public boolean isIgnoreMaxConnectionsLimit() {
        return this.ignoreMaxConnectionsLimit;
    }

    public void setIgnoreMaxConnectionsLimit(boolean ignoreMaxConnectionsLimit) {
        this.ignoreMaxConnectionsLimit = ignoreMaxConnectionsLimit;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }
}

