/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.dualrpc.client;

import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClientDispatcher;
import com.iscobol.rpc.dualrpc.client.IClientCallbackHandler;
import com.iscobol.rpc.dualrpc.client.NotConnectedException;
import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rpc.dualrpc.common.IDualRpcCaller;
import com.iscobol.rpc.dualrpc.common.IDualRpcMessageConstants;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.common.RpcCallPayload;
import com.iscobol.rpc.dualrpc.common.RpcFaultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayloadContainer;
import com.iscobol.rpc.dualrpc.common.RpcWorkerFactory;
import com.iscobol.rpc.messageserver.client.MessageClient;
import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rts.ArrayTable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;

public class DualRpcClient
implements IDualRpcCaller,
IDualRpcMessageConstants {
    private String host = null;
    private int port = 0;
    private HashMap clientHandlers = new HashMap();
    private MessageClient messageclient = null;
    private ArrayTable callWaitingRegistry = new ArrayTable();
    private int defaultCallTimeoutInSeconds = 60;
    private DualRpcClientDispatcher dispatcher = null;
    private IClientCallbackHandler callbackHandler = null;
    private IMessageSerializer messageSerializer = null;
    private IRpcWorkerFactory rpcWorkerFactory = new RpcWorkerFactory();

    public DualRpcClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void registerClientSideHandler(AbstractClientRpcHandler clientRpcHandler) {
        this.getClientHandlers().put(clientRpcHandler.getClass().getName(), clientRpcHandler);
    }

    public void connect() throws UnknownHostException, IOException, GeneralSecurityException {
        this.messageclient = new MessageClient(this.host, this.port);
        if (this.messageSerializer != null) {
            this.getMessageclient().setMessageSerializer(this.messageSerializer);
        }
        this.getMessageclient().connect();
        this.dispatcher = new DualRpcClientDispatcher(this);
        this.dispatcher.setDaemon(true);
        this.dispatcher.start();
    }

    public Object call(String handlerClassName, String methodName) throws CallException {
        ArrayList parameters = new ArrayList();
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, Object p1) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, Object p1, Object p2) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, Object p1, Object p2, Object p3) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, Object p1, Object p2, Object p3, Object p4) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, Object p1, Object p2, Object p3, Object p4, Object p5) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName) throws CallException {
        ArrayList parameters = new ArrayList();
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, Object p1) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, Object p1, Object p2) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, Object p1, Object p2, Object p3) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, Object p1, Object p2, Object p3, Object p4) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, Object p1, Object p2, Object p3, Object p4, Object p5) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, ArrayList parameters) throws CallException {
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, ArrayList parameters) throws CallException {
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, int callTimeoutInSeconds, ArrayList parameters) throws CallException {
        return this.call(handlerClassName, methodName, true, callTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, boolean hasResults, int callTimeoutInSeconds, ArrayList parameters) throws CallException {
        return this.call(new RpcCallPayload(handlerClassName, methodName, parameters, hasResults), callTimeoutInSeconds);
    }

    @Override
    public Object call(int objectId, short methodId, ArrayList parameters, boolean hasResults, int timeout) throws CallException {
        return this.call(new RpcCallPayload(objectId, methodId, parameters, hasResults), timeout);
    }

    @Override
    public Object call(int objectId, short methodId, ArrayList parameters, boolean hasResults) throws CallException {
        return this.call(new RpcCallPayload(objectId, methodId, parameters, hasResults), this.defaultCallTimeoutInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call(RpcCallPayload payload, int callTimeoutInSeconds) throws CallException {
        Object result;
        block17: {
            result = null;
            try {
                MessageClient msgclient = this.getMessageclient();
                if (msgclient != null) {
                    int messageId = 0;
                    Message message = new Message(messageId, 1, payload);
                    if (payload.isSendResults()) {
                        RpcResultPayloadContainer container = new RpcResultPayloadContainer();
                        messageId = this.getCallWaitingRegistry().put(container);
                        message.setId(messageId);
                        boolean isFault = false;
                        String faultExceptionMessage = null;
                        try {
                            RpcResultPayloadContainer rpcResultPayloadContainer = container;
                            synchronized (rpcResultPayloadContainer) {
                                this.getMessageclient().sendMessage(message);
                                if (callTimeoutInSeconds <= 0) {
                                    container.wait();
                                } else {
                                    container.wait(callTimeoutInSeconds * 1000);
                                }
                            }
                            int rpcResultPayloadType = container.getRpcResultPayloadType();
                            switch (rpcResultPayloadType) {
                                case 2: {
                                    RpcResultPayload rpcResultMessage = (RpcResultPayload)container.getRpcMessagePayload();
                                    result = rpcResultMessage.getResultObject();
                                    break;
                                }
                                case 3: {
                                    RpcFaultPayload rpcFaultMessage = (RpcFaultPayload)container.getRpcMessagePayload();
                                    isFault = true;
                                    faultExceptionMessage = rpcFaultMessage.getFaultMessage();
                                    break;
                                }
                                default: {
                                    isFault = true;
                                    faultExceptionMessage = "Call timed out. Current timeout=" + callTimeoutInSeconds;
                                    break;
                                }
                            }
                        }
                        catch (InterruptedException inex) {
                            isFault = true;
                            faultExceptionMessage = "Thread was interrupted. " + inex.toString();
                        }
                        this.getCallWaitingRegistry().remove(messageId);
                        if (isFault) {
                            throw new CallException(faultExceptionMessage);
                        }
                        break block17;
                    }
                    this.getMessageclient().sendMessage(message);
                    break block17;
                }
                throw new CallException("This method cannot be called unless there is an active connection to the server.");
            }
            catch (CallException ce) {
                throw ce;
            }
            catch (Throwable t) {
                throw new CallException(t);
            }
        }
        return result;
    }

    public void disconnect() throws NotConnectedException {
        MessageClient msgclient = this.getMessageclient();
        if (msgclient == null) {
            throw new NotConnectedException("This method cannot be called unless there is an active connection to the server.");
        }
        this.getMessageclient().getSession().closeSession();
    }

    protected MessageClient getMessageclient() {
        return this.messageclient;
    }

    protected ArrayTable getCallWaitingRegistry() {
        return this.callWaitingRegistry;
    }

    public void setDefaultCallTimeoutInSeconds(int defaultCallTimeoutInSeconds) {
        this.defaultCallTimeoutInSeconds = defaultCallTimeoutInSeconds;
    }

    protected HashMap getClientHandlers() {
        return this.clientHandlers;
    }

    protected IClientCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(IClientCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public long getSessionId() throws NotConnectedException {
        return this.getSession().getSessionId();
    }

    public Session getSession() throws NotConnectedException {
        MessageClient msgclient = this.getMessageclient();
        if (msgclient != null) {
            return this.getMessageclient().getSession();
        }
        throw new NotConnectedException("This method cannot be called unless there is an active connection to the server.");
    }

    public void setMessageSerializer(IMessageSerializer messageSerializer) {
        this.messageSerializer = messageSerializer;
    }

    public void setRpcWorkerFactory(IRpcWorkerFactory rpcWorkerFactory) {
        this.rpcWorkerFactory = rpcWorkerFactory;
    }

    protected IRpcWorkerFactory getRpcWorkerFactory() {
        return this.rpcWorkerFactory;
    }
}

