/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi.util;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.TreeSet;

public class MethodTable
implements Comparator {
    private Method[] methods;
    private short unexportId = (short)-1;

    public MethodTable(Class[] interfaces) {
        TreeSet<Method> set = new TreeSet<Method>(this);
        for (int i = 0; i < interfaces.length; ++i) {
            Method[] ms = interfaces[i].getMethods();
            for (int j = 0; j < ms.length; ++j) {
                set.add(ms[j]);
            }
        }
        this.methods = new Method[set.size()];
        set.toArray(this.methods);
        this.unexportId = this.getMethodIndex("unexport", new Class[0]);
    }

    public synchronized short getMethodIndex(Method m) {
        return this.getMethodIndex(m.getName(), m.getParameterTypes());
    }

    private short getMethodIndex(String methodName, Class[] params) {
        int leftIndex = 0;
        int rightIndex = this.methods.length - 1;
        int index = leftIndex + (rightIndex - leftIndex) / 2;
        while (leftIndex <= rightIndex) {
            int c = this.compare(this.methods[index].getName(), this.methods[index].getParameterTypes(), methodName, params);
            if (c == 0) {
                return (short)index;
            }
            if (c > 0) {
                rightIndex = index - 1;
            } else {
                leftIndex = index + 1;
            }
            index = leftIndex + (rightIndex - leftIndex) / 2;
        }
        return -1;
    }

    public short getUnexportMethodIndex() {
        return this.unexportId;
    }

    public Method getMethod(int index) {
        return this.methods[index];
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    public int compare(Object o1, Object o2) {
        Method m1 = (Method)o1;
        Method m2 = (Method)o2;
        return this.compare(m1.getName(), m1.getParameterTypes(), m2.getName(), m2.getParameterTypes());
    }

    private int compare(String methodName1, Class[] params1, String methodName2, Class[] params2) {
        int Return2 = methodName1.compareTo(methodName2);
        if (Return2 != 0) {
            return Return2;
        }
        Return2 = params1.length - params2.length;
        if (Return2 != 0) {
            return Return2;
        }
        for (int i = 0; i < params1.length; ++i) {
            if (params1[i] == params2[i]) continue;
            return params1[i].getName().compareTo(params2[i].getName());
        }
        return 0;
    }
}

