/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi.server;

import com.iscobol.as.AsThreadGroup;
import com.iscobol.as.MultitaskingServerHandler;
import com.iscobol.rmi.Remote;
import com.iscobol.rmi.RemoteCaller;
import com.iscobol.rmi.RemoteInvocationHandler;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rmi.util.MethodTable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;

public class ServerRemoteObject
implements Remote,
Externalizable {
    private static final long serialVersionUID = 533265363546734L;
    protected int rpcCallTimeout;
    protected Integer ref;
    protected transient RemoteRegistry registry;
    private static Hashtable remoteInterfaces = new Hashtable();

    public ServerRemoteObject() {
        this.setCallTimeout(0);
        this.init();
    }

    protected void setCallTimeout(int timeout) {
        this.rpcCallTimeout = timeout;
    }

    protected int getCallTimeout() {
        return this.rpcCallTimeout;
    }

    protected void init() {
        int sessionId = -1;
        if (MultitaskingServerHandler.sessionId >= 0) {
            sessionId = MultitaskingServerHandler.sessionId;
        } else {
            ThreadGroup ctg = Thread.currentThread().getThreadGroup();
            if (ctg instanceof AsThreadGroup) {
                sessionId = ((AsThreadGroup)ctg).getSessionId();
            }
        }
        if (sessionId >= 0) {
            ServerCaller caller = (ServerCaller)RemoteRegistry.getCaller(sessionId);
            this.registry = caller.getRegistry();
            this.ref = new Integer(this.registry.put(this));
        }
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void unexport() {
        if (this.registry != null) {
            this.registry.remove(this.ref);
        }
    }

    protected Remote toStub(RemoteCaller caller) {
        Remote Return2 = caller.getRemote(this.ref);
        if (Return2 == null) {
            try {
                RemoteClassInfo info = ServerRemoteObject.findRemoteInfo(this.getClass());
                RemoteInvocationHandler handler = this.createInvocationHandler(caller, this.ref, info.methods, this.rpcCallTimeout);
                handler.setProblemLog(caller.getProblemLog());
                handler.setRpcCallLog(caller.getRpcCallLog());
                Return2 = (Remote)Proxy.newProxyInstance(this.getClass().getClassLoader(), info.interfaces, (InvocationHandler)handler);
                caller.putRemote(this.ref, Return2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return Return2;
    }

    protected RemoteInvocationHandler createInvocationHandler(RemoteCaller caller, Integer ref, MethodTable mt, int timeout) {
        return new RemoteInvocationHandler(caller, ref, mt, timeout);
    }

    public static Method getMethod(Class c, int idx) throws Exception {
        return ServerRemoteObject.findRemoteInfo((Class)c).methods.getMethod(idx);
    }

    private static RemoteClassInfo findRemoteInfo(Class c) throws Exception {
        RemoteClassInfo Return2 = (RemoteClassInfo)remoteInterfaces.get(c);
        if (Return2 == null) {
            Hashtable ct = new Hashtable();
            ServerRemoteObject.findRemoteInterfaces(c, ct);
            int size = ct.size();
            Return2 = new RemoteClassInfo();
            Return2.interfaces = new Class[size];
            ct.values().toArray(Return2.interfaces);
            Return2.methods = new MethodTable(Return2.interfaces);
            remoteInterfaces.put(c, Return2);
        }
        return Return2;
    }

    private static void findRemoteInterfaces(Class c, Hashtable ct) throws Exception {
        Class<?>[] cls = c.getInterfaces();
        if (cls == null) {
            return;
        }
        for (int i = 0; i < cls.length; ++i) {
            if (!ct.containsKey(cls[i]) && Remote.class.isAssignableFrom(cls[i])) {
                ct.put(cls[i], cls[i]);
            }
            ServerRemoteObject.findRemoteInterfaces(cls[i], ct);
        }
    }

    public Object readResolve() throws ObjectStreamException {
        ClientCaller c = RemoteRegistry.getClientCaller();
        if (c != null) {
            return this.toStub(c);
        }
        return this;
    }

    public Integer getRef() {
        return this.ref;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ref = new Integer(in.readInt());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.ref);
    }

    private static class RemoteClassInfo {
        Class[] interfaces;
        MethodTable methods;

        private RemoteClassInfo() {
        }
    }
}

