/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi;

import com.iscobol.gui.ParamVElement;
import com.iscobol.gui.ParamVector;
import com.iscobol.logger.Logger;
import com.iscobol.rmi.Remote;
import com.iscobol.rmi.RemoteCaller;
import com.iscobol.rmi.util.MethodTable;
import com.iscobol.rpc.dualrpc.common.CallException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RemoteInvocationHandler
implements InvocationHandler {
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final Character char_0 = new Character('\u0000');
    private static final Byte byte_0 = new Byte(0);
    private Integer ref;
    private int objectId;
    private int rpcCallTimeout;
    private RemoteCaller caller;
    private Logger problemLog;
    private Logger rpcCallLog;
    private static final String FINALIZE_METHOD = "finalize";
    private MethodTable methodTable;

    public RemoteInvocationHandler(RemoteCaller caller, Integer ref, MethodTable mt, int timeout) {
        this.ref = ref;
        this.objectId = ref;
        this.caller = caller;
        this.methodTable = mt;
        this.rpcCallTimeout = timeout;
    }

    public Logger getProblemLog() {
        return this.problemLog;
    }

    public void setProblemLog(Logger problemLog) {
        this.problemLog = problemLog;
    }

    public Logger getRpcCallLog() {
        return this.rpcCallLog;
    }

    public void setRpcCallLog(Logger rpcCallLog) {
        this.rpcCallLog = rpcCallLog;
    }

    private Object invokeObject(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        if (this.rpcCallLog != null) {
            this.rpcCallLog.info("RPC CALL: " + RemoteInvocationHandler.getRemoteInterfaceName(proxy) + "." + method.getName());
        }
        if ((methodName = method.getName()).equals("hashCode")) {
            return this.proxyHashCode(proxy);
        }
        if (methodName.equals("equals")) {
            return this.proxyEquals(proxy, args[0]);
        }
        if (methodName.equals("toString")) {
            return this.proxyToString(proxy);
        }
        return RemoteInvocationHandler.nullValueOf(method.getReturnType());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (FINALIZE_METHOD.equals(method.getName())) {
            if (this.rpcCallLog != null) {
                this.rpcCallLog.info("RPC CALL: " + RemoteInvocationHandler.getRemoteInterfaceName(proxy) + ".finalize");
            }
            this.caller.removeRemote(this.ref);
            this.caller.call(this.objectId, this.methodTable.getUnexportMethodIndex(), null, false);
            return this.invokeObject(proxy, method, args);
        }
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObject(proxy, method, args);
        }
        Object Return2 = null;
        try {
            ArrayList<Object> params;
            int nArgs;
            int n = nArgs = args != null ? args.length : 0;
            if (nArgs > 0) {
                params = new ArrayList<Object>(nArgs);
                for (int i = 0; i < nArgs; ++i) {
                    params.add(args[i]);
                }
            } else {
                params = null;
            }
            if (this.rpcCallLog != null) {
                RemoteInvocationHandler.logMethod(this.rpcCallLog, method.getName(), args);
            }
            Return2 = this.caller.call(this.objectId, this.methodTable.getMethodIndex(method), params, true, this.rpcCallTimeout);
            if (this.rpcCallLog != null) {
                RemoteInvocationHandler.logRetVal(this.rpcCallLog, method.getName(), Return2);
            }
            return Return2;
        }
        catch (CallException cex) {
            if (this.problemLog != null) {
                this.problemLog.severe(RemoteInvocationHandler.stackTraceToString(cex));
            }
            IOException ioex = new IOException(cex.getMessage()){
                private static final long serialVersionUID = 1L;

                @Override
                public Throwable getCause() {
                    return cex.getCause();
                }
            };
            throw ioex;
        }
    }

    static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    static String getRemoteInterfaceName(Object proxy) {
        Class<?>[] intfs = proxy.getClass().getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            if (intfs[i] == Remote.class || !Remote.class.isAssignableFrom(intfs[i])) continue;
            return intfs[i].getName();
        }
        return Remote.class.getName();
    }

    protected Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    protected Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
    }

    private static final Object nullValueOf(Class rt) {
        if (!rt.isPrimitive()) {
            return null;
        }
        if (rt == Void.TYPE) {
            return null;
        }
        if (rt == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (rt == Character.TYPE) {
            return char_0;
        }
        return byte_0;
    }

    static void logMethod(Logger rpcCallLog, String methodName, Object[] args) {
        StringBuffer logMsg = new StringBuffer();
        logMsg.append("RPC CALL: methodName = ");
        logMsg.append(methodName);
        if (args != null && args.length > 0) {
            logMsg.append(",   parameters:");
            for (int i = 0; i < args.length; ++i) {
                logMsg.append(eol);
                logMsg.append(RemoteInvocationHandler.getTypeName(args[i], "      ", ""));
                if (args[i] == null) continue;
                logMsg.append(" (" + args[i] + ")");
            }
        } else {
            logMsg.append(",   no-parameters");
        }
        rpcCallLog.info(logMsg.toString());
    }

    static void logRetVal(Logger rpcCallLog, String methodName, Object retVal) {
        StringBuffer logMsg = new StringBuffer();
        logMsg.append("RPC RESULT: methodName = ");
        logMsg.append(methodName);
        logMsg.append(",   returnValue:");
        logMsg.append(eol);
        logMsg.append(RemoteInvocationHandler.getTypeName(retVal, "      ", ""));
        if (retVal != null) {
            logMsg.append(" (" + retVal + ")");
        }
        rpcCallLog.info(logMsg.toString());
    }

    static String getTypeName(Object obj, String indent, String prefix) {
        StringBuffer logMsg;
        block7: {
            Class<?> cls;
            block6: {
                logMsg = new StringBuffer();
                if (obj == null) {
                    logMsg.append(indent);
                    logMsg.append(prefix);
                    logMsg.append("null");
                    return logMsg.toString();
                }
                cls = obj.getClass();
                if (cls != ParamVector.class) break block6;
                ParamVector pv = (ParamVector)obj;
                ParamVElement[] pmElems = pv.toArray();
                logMsg.append(indent + prefix + cls.getName());
                logMsg.append(eol);
                if (pmElems.length <= 0) break block7;
                logMsg.append(RemoteInvocationHandler.getTypeName(pmElems[0], indent + "   ", "elem[0] = "));
                for (int i = 1; i < pmElems.length; ++i) {
                    logMsg.append(eol);
                    logMsg.append(RemoteInvocationHandler.getTypeName(pmElems[i], indent + "   ", "elem[" + i + "] = "));
                }
                break block7;
            }
            if (!cls.isArray()) {
                logMsg.append(indent);
                logMsg.append(prefix);
                logMsg.append(cls.getName().replace('$', '.'));
            } else {
                int n = 0;
                while (cls.isArray()) {
                    cls = cls.getComponentType();
                    ++n;
                }
                logMsg.append(indent + prefix + cls.getName().replace('$', '.'));
                for (int i = 0; i < n; ++i) {
                    logMsg.append("[]");
                }
            }
        }
        return logMsg.toString();
    }

    public int getRpcCallTimeout() {
        return this.rpcCallTimeout;
    }

    public void setRpcCallTimeout(int rpcCallTimeout) {
        this.rpcCallTimeout = rpcCallTimeout;
    }
}

