/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.profiler;

import com.iscobol.profiler.Paragraph;
import com.iscobol.profiler.Profiler;
import com.iscobol.profiler.Program;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

public class Transformer
implements ClassFileTransformer {
    private static final String EP_PREFIX = "_entry_Point$";
    private static final Set<String> invalidPackageNames;
    private static final String prClass;
    private static final String prMtd;
    private static final String prInst = "$profiler$";
    private static final String pgmInst = "$program$";
    private static final int lenPgmArg;
    private static final String iArg = "$paragraph$";
    private static final int lenIArg;
    private static final String iCnr = "$profiler$.getParagraph(\"";
    private static final int lenICnr;
    private static final String iMtd = "$profiler$.enterPar(";
    private static final int lenIMtd;
    private static final String oMtd = "$profiler$.exitPar();";
    private final String ciMtd;
    private final int lenCIMtd;
    private final ClassPool classPool;
    private ClassLoader extClassLoader;
    private LoaderClassPath extClassPath;
    private final CtClass profClass;
    private final CtClass paragClass;
    private final CtClass pgmClass;
    private final Pattern[] inclRegExp;
    private final Pattern[] exclRegExp;
    private Map<String, Boolean> transformedClassNames = new HashMap<String, Boolean>();

    private static final boolean isUpperCase(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Transformer(String incl, String excl) throws Exception {
        String[] s;
        CtClass p;
        this.ciMtd = prMtd + ").getProgram(\"";
        this.lenCIMtd = this.ciMtd.length();
        ClassPool cp = ClassPool.getDefault();
        try {
            p = cp.get(Profiler.class.getName());
        }
        catch (Exception ex) {
            ClassLoader cl = cp.getClassLoader();
            cp = new ClassPool(cp);
            cp.appendClassPath((ClassPath)new LoaderClassPath(cl));
            p = cp.get(Profiler.class.getName());
        }
        this.classPool = cp;
        this.profClass = p;
        this.paragClass = this.classPool.get(Paragraph.class.getName());
        this.pgmClass = this.classPool.get(Program.class.getName());
        if (incl != null && incl.length() > 0) {
            s = incl.split(",");
            this.inclRegExp = new Pattern[s.length];
            for (int i = 0; i < this.inclRegExp.length; ++i) {
                this.inclRegExp[i] = Pattern.compile(s[i]);
            }
        } else {
            this.inclRegExp = null;
        }
        if (excl != null && excl.length() > 0) {
            s = excl.split(",");
            this.exclRegExp = new Pattern[s.length];
            for (int i = 0; i < this.exclRegExp.length; ++i) {
                this.exclRegExp[i] = Pattern.compile(s[i]);
            }
        } else {
            this.exclRegExp = null;
        }
    }

    public boolean matches(String s) {
        int i;
        boolean Return2 = true;
        if (this.inclRegExp != null && this.inclRegExp.length > 0) {
            Return2 = false;
            for (i = 0; i < this.inclRegExp.length; ++i) {
                if (!this.inclRegExp[i].matcher(s).matches()) continue;
                Return2 = true;
                break;
            }
        }
        if (Return2 && this.exclRegExp != null && this.exclRegExp.length > 0) {
            for (i = 0; i < this.exclRegExp.length; ++i) {
                if (!this.exclRegExp[i].matcher(s).matches()) continue;
                Return2 = false;
                break;
            }
        }
        return Return2;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        this.setExtClassLoader(loader);
        byte[] byteCode = classfileBuffer;
        if (this.matches(className)) {
            try {
                CtClass[] ctClass = new CtClass[1];
                byteCode = this.transform(classfileBuffer, null, ctClass);
                ctClass[0].detach();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return byteCode;
    }

    public byte[] transformBytes(byte[] classfileBuffer, ClassLoader cl, boolean debug) throws Throwable {
        this.setExtClassLoader(cl);
        CtClass[] ctClass = new CtClass[1];
        classfileBuffer = this.transform(classfileBuffer, debug, ctClass);
        ctClass[0].detach();
        return classfileBuffer;
    }

    private void setExtClassLoader(ClassLoader extClassLoader) {
        if (this.extClassLoader != extClassLoader) {
            if (this.extClassPath != null) {
                this.classPool.removeClassPath((ClassPath)this.extClassPath);
            }
            this.extClassLoader = extClassLoader;
            if (this.extClassLoader != null) {
                this.extClassPath = new LoaderClassPath(extClassLoader);
                this.classPool.appendClassPath((ClassPath)this.extClassPath);
            } else {
                this.extClassPath = null;
            }
        }
    }

    private static boolean check(CtClass ctClass) {
        if (ctClass.isInterface()) {
            return false;
        }
        try {
            if (Transformer.Implements(ctClass, "com.iscobol.rts.IscobolClass")) {
                String pkg = ctClass.getPackageName();
                return pkg == null || pkg.length() == 0 || !invalidPackageNames.contains(pkg);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private static boolean Implements(CtClass ctClass, String intfName) throws NotFoundException {
        return Transformer.Implements(ctClass, intfName, new HashSet<String>());
    }

    private static boolean Implements(CtClass ctClass, String intfName, Set<String> intfs) throws NotFoundException {
        for (CtClass intf : ctClass.getInterfaces()) {
            String name = intf.getName();
            if (intfs.contains(name)) continue;
            if (intfName.equals(name)) {
                return true;
            }
            intfs.add(name);
            if (!Transformer.Implements(intf, intfName, intfs)) continue;
            return true;
        }
        return false;
    }

    private final byte[] transform(byte[] classfileBuffer, Boolean debug, CtClass[] ctClass) throws Throwable {
        byte[] Return2 = classfileBuffer;
        ctClass[0] = this.classPool.makeClass((InputStream)new ByteArrayInputStream(classfileBuffer));
        if (debug == null) {
            CtClass dc;
            debug = Transformer.Implements(ctClass[0], "com.iscobol.debugger.IscobolDebugger");
            if (Transformer.check(ctClass[0]) || (dc = ctClass[0].getDeclaringClass()) != null && (debug = this.transformedClassNames.get(dc.getName())) != null) {
                this.transform(ctClass[0], debug);
                Return2 = ctClass[0].toBytecode();
            }
        } else {
            this.transform(ctClass[0], debug);
            Return2 = ctClass[0].toBytecode();
        }
        return Return2;
    }

    private final void transform(CtClass ctClass, Boolean debug) throws Throwable {
        CtClass declCl;
        boolean iscobolCall = Transformer.Implements(ctClass, "com.iscobol.rts.IscobolCall");
        CtMethod[] methods = ctClass.getDeclaredMethods();
        StringBuilder sbMtd = new StringBuilder(iMtd);
        StringBuilder sbArg = new StringBuilder(iArg);
        StringBuilder sbCnr = new StringBuilder(iCnr);
        StringBuilder sbCallArg = new StringBuilder(pgmInst);
        StringBuilder sbCMtd = new StringBuilder(this.ciMtd);
        String className = ctClass.getName();
        int idx = className.indexOf("$class$");
        int idx2 = -1;
        boolean iscobolModule = iscobolCall;
        if (idx >= 0) {
            idx2 = className.indexOf(36, idx + 7);
            if (idx2 >= 0) {
                className = className.substring(0, idx) + "::" + className.substring(idx + 7, idx2);
                iscobolModule = true;
                for (CtConstructor ctr : ctClass.getConstructors()) {
                    sbCMtd.setLength(this.lenCIMtd);
                    sbCMtd.append(className);
                    sbCMtd.append("\"," + debug + ").count++;");
                    ctr.insertBefore(sbCMtd.toString());
                }
            }
        } else if (className.matches(".+\\$\\d*inner_\\d+") && (declCl = ctClass.getDeclaringClass()) != null) {
            className = declCl.getName();
            iscobolModule = true;
        }
        int cnt = 0;
        int cntcall = 0;
        ctClass.addField(new CtField(this.profClass, prInst, ctClass), prMtd + ")");
        for (CtMethod method : methods) {
            String mtdName = method.getName();
            if (iscobolCall && "call".equals(mtdName)) {
                sbCallArg.setLength(lenPgmArg);
                sbCallArg.append(cntcall++);
                sbCMtd.setLength(this.lenCIMtd);
                sbCMtd.append(className);
                sbCMtd.append("\"," + debug + ")");
                ctClass.addField(new CtField(this.pgmClass, sbCallArg.toString(), ctClass), sbCMtd.toString());
                sbCallArg.append(".count++;");
                method.insertBefore(sbCallArg.toString());
                continue;
            }
            boolean ep = mtdName.startsWith(EP_PREFIX);
            if (!ep && (!iscobolModule || !Transformer.isUpperCase(mtdName) || mtdName.startsWith("EXEC_SQL_DECLARE_CURSOR$$"))) continue;
            if (ep) {
                mtdName = "(ENTRY) " + mtdName.substring(EP_PREFIX.length()).toUpperCase();
            }
            if ((idx = mtdName.indexOf("$$")) >= 0) {
                String secName = mtdName.substring(idx + 2);
                mtdName = mtdName.substring(0, idx);
                idx = secName.indexOf(36);
                if (idx >= 0) {
                    secName = secName.substring(0, idx);
                }
                mtdName = mtdName.equals(secName) ? mtdName + " section" : mtdName + " of " + secName;
            }
            sbCnr.setLength(lenICnr);
            sbCnr.append(className);
            sbCnr.append("\",\"");
            sbCnr.append(mtdName);
            sbCnr.append("\")");
            sbArg.setLength(lenIArg);
            sbArg.append(cnt++);
            ctClass.addField(new CtField(this.paragClass, sbArg.toString(), ctClass), sbCnr.toString());
            sbMtd.setLength(lenIMtd);
            sbMtd.append(sbArg.toString());
            sbMtd.append(");");
            method.insertBefore(sbMtd.toString());
            method.insertAfter(oMtd, true);
        }
        this.transformedClassNames.put(ctClass.getName(), debug);
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("com.iscobol.lib");
        s.add("com.iscobol.lib_n");
        s.add("com.iscobol.so");
        s.add("com.iscobol.son");
        invalidPackageNames = Collections.unmodifiableSet(s);
        prClass = Profiler.class.getName();
        prMtd = prClass + ".getProfiler(";
        lenPgmArg = pgmInst.length();
        lenIArg = iArg.length();
        lenICnr = iCnr.length();
        lenIMtd = iMtd.length();
    }
}

