/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.preview;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;

public class PictureButton
extends Canvas
implements ItemSelectable {
    private Image image;
    private boolean flat;
    private boolean bistate;
    private Rectangle imagePortion;
    private ActionListener actionListener;
    private ItemListener itemListener;
    private FocusListener focusListener;
    private String actionCommand;
    private boolean pressed;
    private boolean isOn;
    private boolean mouseEntered;
    private MediaTracker mt;
    private Dimension preferredSize;

    public PictureButton(Image image) {
        this(image, null, false, false);
    }

    public PictureButton(Image image, Rectangle imagePortion) {
        this(image, imagePortion, false, false);
    }

    public PictureButton(Image image, Rectangle imagePortion, boolean flat) {
        this(image, imagePortion, flat, false);
    }

    public PictureButton(Image image, boolean flat) {
        this(image, null, flat, false);
    }

    public PictureButton(Image image, boolean flat, boolean bistate) {
        this(image, null, flat, bistate);
    }

    public PictureButton(Image img, Rectangle imagePortion, boolean flat, boolean bistate) {
        this.flat = flat;
        this.bistate = bistate;
        this.imagePortion = imagePortion;
        this.mt = new MediaTracker(this);
        if (img != null) {
            this.updateImage(img);
        }
        this.enableEvents(28L);
    }

    public void updateImage(Image img) {
        if (this.image != null) {
            this.mt.removeImage(this.image, 0);
        }
        this.mt.addImage(img, 0);
        this.image = img;
        try {
            this.mt.waitForAll();
        }
        catch (InterruptedException e) {
            System.err.println("Error " + e);
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        int ins = 2;
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension();
        }
        if (this.imagePortion == null) {
            this.preferredSize.setSize(this.image.getWidth(null) + ins, this.image.getHeight(null) + ins);
        } else {
            this.preferredSize.setSize(this.imagePortion.width + ins, this.imagePortion.height + ins);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getSize().width;
        int height = this.getSize().height;
        int inset = this.pressed ? 1 : 0;
        g.setClip(0, 0, width, height);
        if (!this.flat || this.flat && this.mouseEntered || this.pressed) {
            g2d.draw3DRect(0, 0, width - 1, height - 1, !this.pressed);
        }
        if (!this.isEnabled()) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
        }
        if (this.imagePortion != null) {
            g2d.translate(-this.imagePortion.x, -this.imagePortion.y);
        }
        if (this.image != null) {
            int x = (this.getSize().width - this.image.getWidth(null)) / 2 + inset;
            int y = (this.getSize().height - this.image.getHeight(null)) / 2 + inset;
            g2d.drawImage(this.image, x, y, this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        return this.getSize();
    }

    public boolean getState() {
        if (this.bistate) {
            return this.isOn;
        }
        return false;
    }

    public void setState(boolean s) {
        if (this.bistate) {
            this.isOn = s;
            this.pressed = s;
            this.repaint();
        }
    }

    @Override
    public void setEnabled(boolean value) {
        boolean preStatus = this.isEnabled();
        super.setEnabled(value);
        if (!value) {
            this.mouseEntered = false;
        }
        if (value != preStatus) {
            this.repaint();
        }
    }

    @Override
    public void processEvent(AWTEvent e) {
        int ID = e.getID();
        switch (ID) {
            case 501: {
                if (this.bistate) {
                    if (!this.isOn) {
                        this.pressed = true;
                    }
                } else {
                    this.pressed = true;
                }
                this.repaint();
                break;
            }
            case 402: {
                int keyID = ((KeyEvent)e).getKeyCode();
                if (keyID != 10 && keyID != 32) break;
            }
            case 502: {
                if (this.bistate) {
                    boolean bl = this.isOn = !this.isOn;
                    this.pressed = this.isOn;
                } else {
                    this.pressed = false;
                }
                this.repaint();
                this.fireEvent();
                break;
            }
            case 1004: {
                if (this.mouseEntered) break;
            }
            case 504: {
                if (!this.flat) break;
                this.mouseEntered = true;
                this.repaint();
                break;
            }
            case 1005: {
                if (!this.mouseEntered) break;
            }
            case 505: {
                if (!this.flat) break;
                this.mouseEntered = false;
                this.repaint();
            }
        }
        super.processEvent(e);
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    @Override
    public Object[] getSelectedObjects() {
        return new Object[]{this};
    }

    private void fireEvent() {
        if (this.bistate) {
            if (this.itemListener != null) {
                ItemEvent event = new ItemEvent(this, 701, this, this.isOn ? 1 : 2);
                this.itemListener.itemStateChanged(event);
            }
        } else if (this.actionListener != null) {
            ActionEvent event = new ActionEvent(this, 1001, this.actionCommand);
            this.actionListener.actionPerformed(event);
        }
    }
}

