/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.xlsx;

import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.misc.export.ss.SSGridExporter;
import com.iscobol.misc.export.xlsx.XLSXExportHelper;
import java.awt.Color;
import java.awt.Font;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class XLSXGridExporter
extends SSGridExporter {
    @Override
    protected SSExportHelper createExportHelper() {
        return new XLSXExportHelper();
    }

    @Override
    public void setCellStyleAttrs(CellStyle cs, int rowIdx, int colIdx, String numericFormat) {
        VerticalAlignment verticalAlign = VerticalAlignment.CENTER;
        HorizontalAlignment horizontalAlign = HorizontalAlignment.LEFT;
        XSSFCellStyle cellStyle = (XSSFCellStyle)cs;
        Font f = this.provider.getCellFont(rowIdx, colIdx);
        Color[] c = this.provider.getCellColor(rowIdx, colIdx);
        int halign = this.provider.getCellAlignment(rowIdx, colIdx);
        org.apache.poi.ss.usermodel.Font font = this.getFont(f, c[1]);
        cellStyle.setFont(font);
        XLSXExportHelper ee = (XLSXExportHelper)this.helper;
        cellStyle.setFillForegroundColor(ee.getColor(c[0].getRGB()));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        switch (halign) {
            case 0: {
                horizontalAlign = HorizontalAlignment.CENTER;
                break;
            }
            case 4: {
                horizontalAlign = HorizontalAlignment.RIGHT;
            }
        }
        cellStyle.setAlignment(horizontalAlign);
        cellStyle.setVerticalAlignment(verticalAlign);
        Color dividerColor = this.provider.getDividerColor(rowIdx, colIdx);
        XSSFColor col = ee.getColor(dividerColor.getRGB());
        int rowsDividers = this.provider.getRowsDivider();
        cellStyle.setBorderBottom(ee.getBorder(rowsDividers));
        cellStyle.setBottomBorderColor(col);
        cellStyle.setBorderLeft(ee.getBorder(this.provider.getColumnDivider(colIdx)));
        cellStyle.setLeftBorderColor(col);
        cellStyle.setWrapText(true);
        if (numericFormat != null) {
            cellStyle.setDataFormat(this.helper.getFormat(numericFormat));
        }
    }
}

