/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export;

public class UnitConverter {
    private static final float INCH_CM = 2.54f;
    private static final int DPI = 96;
    public static final int EXCEL_COLUMN_WIDTH_FACTOR = 256;
    public static final int EXCEL_MAX_COLUMN_WIDTH = 65280;
    private static final int UNIT_OFFSET_LENGTH = 6;
    private static final int[] UNIT_OFFSET_MAP = new int[]{0, 43, 85, 128, 171, 213};
    public static final int TOTAL_COLUMN_COORDINATE_POSITIONS = 1023;
    public static final int TOTAL_ROW_COORDINATE_POSITIONS = 255;

    private UnitConverter() {
    }

    public static int pixel2ExcelWidthUnits(int pxs) {
        int widthUnits = 256 * (pxs / 6);
        return Math.min(widthUnits += UNIT_OFFSET_MAP[pxs % 6], 65280);
    }

    public static int inch2ExcelWidthUnits(float inch) {
        return UnitConverter.pixel2ExcelWidthUnits(UnitConverter.inchToPixel(inch));
    }

    public static int pixel2ExcelHeightPoints(int pxs) {
        return pxs;
    }

    public static int inch2ExcelHeightPoints(float inch) {
        return UnitConverter.pixel2ExcelHeightPoints(UnitConverter.inchToPixel(inch));
    }

    public static int inchToPixel(float inch) {
        return Math.round(inch * 96.0f);
    }

    public static float pixelToCentimeter(int pixel) {
        return UnitConverter.inchToCentimeter(UnitConverter.pixelToInch(pixel));
    }

    public static float pixelToInch(int pixel) {
        return (float)pixel / 96.0f;
    }

    public static float inchToCentimeter(float inch) {
        return inch * 2.54f;
    }
}

