/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.logger;

import com.iscobol.logger.Logger;
import com.iscobol.rts.Config;
import com.iscobol.rts.Finalizable;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.Version;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LoggerFactory
implements Finalizable {
    public static final int TR_NONE = 0;
    public static final int TR_ENV = 1;
    public static final int TR_C_STACK = 2;
    public static final int TR_P_STACK = 4;
    public static final int TR_IO = 8;
    public static final int TR_IO_KEY = 16;
    public static final int TR_IO_RECORD = 32;
    public static final int TR_TC_PROBLEMS = 64;
    public static final int TR_TC_RPC_CALL = 128;
    public static final int TR_ESQL = 256;
    public static final int TR_GUI = 512;
    public static final int TR_LIB_STACK = 1024;
    public static final int TR_DEVELOPERS = 2048;
    private int logLen;
    private int count = 1;
    private boolean append;
    private PropertyChangeSupport changeListeners;
    private Set logFiles = new HashSet();
    private Logger logger;
    private boolean firstTime = true;
    private int traceLevel = 0;

    @Override
    public void myFinalize() {
        this.intCloseLog();
    }

    public void finalize() {
        this.intCloseLog();
    }

    private void intCloseLog() {
        if (this.logger != null) {
            this.logger.close();
            this.logger = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyChangeListener(PropertyChangeListener l) {
        LoggerFactory lf;
        if (l == null) {
            return;
        }
        LoggerFactory loggerFactory = lf = LoggerFactory.get();
        synchronized (loggerFactory) {
            if (lf.changeListeners == null) {
                lf.changeListeners = new PropertyChangeSupport(lf);
            }
            lf.changeListeners.addPropertyChangeListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            return;
        }
        LoggerFactory lf = LoggerFactory.get();
        if (lf.changeListeners != null) {
            LoggerFactory loggerFactory = lf;
            synchronized (loggerFactory) {
                lf.changeListeners.removePropertyChangeListener(l);
            }
        }
    }

    private static LoggerFactory get() {
        LoggerFactory Return2 = (LoggerFactory)IscobolSystem.get(LoggerFactory.class);
        if (Return2 == null) {
            Return2 = new LoggerFactory();
            IscobolSystem.set(LoggerFactory.class, Return2);
        }
        return Return2;
    }

    private static void createLogger(Config cf, LoggerFactory lf) {
        lf.traceLevel = cf == null ? Config.getProperty(".tracelevel", 0) : Config.getProperty(cf, ".tracelevel", 0);
        if (lf.traceLevel != 0) {
            boolean showThreadInfo;
            String logFile;
            String logClass;
            String name = Config.getPrefix();
            int l = 0;
            if (name != null && (l = name.length()) > 0) {
                if (name.charAt(l - 1) == '.') {
                    name = name.substring(0, l - 1);
                }
            } else {
                name = "";
            }
            if (cf == null) {
                logClass = Config.getProperty(".logclass", "com.iscobol.logger.Java14Logger");
                logFile = Config.getProperty(".logfile", "%t/" + name + "%g.log");
                lf.logLen = Config.getProperty(".logfile.maxlen", -1);
                lf.count = Config.getProperty(".logfile.number", 1);
                lf.append = Config.getProperty(".logfile.append", false);
                showThreadInfo = Config.getProperty(".logfile.thread", false);
            } else {
                logClass = Config.getProperty(cf, ".logclass", "com.iscobol.logger.Java14Logger");
                logFile = Config.getProperty(cf, ".logfile", "%t/" + name + "%g.log");
                lf.logLen = Config.getProperty(cf, ".logfile.maxlen", -1);
                lf.count = Config.getProperty(cf, ".logfile.number", 1);
                lf.append = Config.getProperty(cf, ".logfile.append", false);
                showThreadInfo = Config.getProperty(cf, ".logfile.thread", false);
            }
            logFile = LoggerFactory.decodeName(logFile);
            try {
                Class<?> Return2 = Class.forName(logClass);
                if (Return2 == null) {
                    throw new InstantiationException(logClass + " is not found!!!");
                }
                if (!Logger.class.isAssignableFrom(Return2)) {
                    throw new InstantiationException(logClass + "!=" + Logger.class);
                }
                if (lf.logger != null) {
                    lf.logger.setFileName(null);
                }
                lf.logger = (Logger)Class.forName(logClass).newInstance();
                boolean logFileAlreadyExists = lf.logFiles.contains(logFile);
                lf.logger.setFileName(logFile, lf.logLen, lf.count, lf.append || logFileAlreadyExists);
                LoggerFactory.setShowThreadInfo(lf, showThreadInfo);
                if (!logFileAlreadyExists) {
                    lf.logFiles.add(logFile);
                    if (Config.getPrefix() == "iscobol.") {
                        lf.logger.info("ISCOBOL " + Version.getVersion());
                    } else {
                        lf.logger.info(name.toUpperCase());
                    }
                    if ((lf.traceLevel & 1) != 0) {
                        String eol = System.getProperty("line.separator", "\n");
                        String jvmOpt = " JVM Options=";
                        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
                        Iterator<String> it = args.iterator();
                        while (it.hasNext()) {
                            jvmOpt = jvmOpt + eol + "      " + it.next();
                        }
                        lf.logger.info(jvmOpt);
                    }
                }
            }
            catch (Exception _e) {
                throw new IscobolRuntimeException(_e);
            }
        }
    }

    public static Logger get(int type) {
        return LoggerFactory.get(null, type);
    }

    public static Logger get(Config cf, int type) {
        return LoggerFactory.get(cf, type, false);
    }

    public static Logger get(Config cf, int type, boolean createNew) {
        LoggerFactory lf = LoggerFactory.get();
        if (createNew || lf.firstTime) {
            LoggerFactory.createLogger(cf, lf);
        }
        lf.firstTime = false;
        if ((lf.traceLevel & type) != 0 || type == -99) {
            return lf.logger;
        }
        return null;
    }

    public static void setTraceLevel(int value) {
        LoggerFactory lf = LoggerFactory.get();
        int oldValue = lf.traceLevel;
        lf.traceLevel = value;
        if (value == 0) {
            if (lf.logger != null) {
                LoggerFactory.setLogFile(lf, null);
                lf.logger = null;
            }
        } else if (lf.logger == null) {
            LoggerFactory.createLogger(null, lf);
        }
        if (lf.changeListeners != null) {
            lf.changeListeners.firePropertyChange(Config.getPrefix() + "tracelevel", oldValue, value);
        }
    }

    public static int getTraceLevel() {
        return LoggerFactory.get().traceLevel;
    }

    public static void setLogFile(String logFileName) {
        LoggerFactory.setLogFile(LoggerFactory.get(), logFileName);
    }

    private static void setLogFile(LoggerFactory lf, String logFileName) {
        Logger l = lf.logger;
        lf.logLen = Config.getProperty(".logfile.maxlen", -1);
        lf.count = Config.getProperty(".logfile.number", 1);
        lf.append = Config.getProperty(".logfile.append", false);
        try {
            if (l != null) {
                if (logFileName != null) {
                    l.setFileName(logFileName, lf.logLen, lf.count, lf.append || lf.logFiles.contains(logFileName));
                    lf.logFiles.add(logFileName);
                } else {
                    l.setFileName(null);
                }
            }
        }
        catch (IOException _e) {
            throw new IscobolRuntimeException(_e);
        }
    }

    public static void setShowThreadInfo(boolean b) {
        LoggerFactory.setShowThreadInfo(LoggerFactory.get(), b);
    }

    private static void setShowThreadInfo(LoggerFactory lf, boolean b) {
        try {
            lf.logger.getClass().getMethod("setShowThreadInfo", Boolean.TYPE).invoke((Object)lf.logger, b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getLogFile() {
        Logger l = LoggerFactory.get().logger;
        if (l != null) {
            return l.getFileName();
        }
        return null;
    }

    public static void closeLog() {
        LoggerFactory lf = (LoggerFactory)IscobolSystem.get(LoggerFactory.class);
        if (lf != null) {
            lf.intCloseLog();
        }
    }

    public static String decodeName(String name) {
        File dirs;
        String Return2 = name;
        GregorianCalendar gc = new GregorianCalendar();
        String tempDir = System.getProperty("java.io.tmpdir");
        String userDir = System.getProperty("user.home");
        String yyyy = "" + gc.get(1);
        String mm = gc.get(2) + 1 > 9 ? "" + (gc.get(2) + 1) : "0" + (gc.get(2) + 1);
        String dd = gc.get(5) > 9 ? "" + gc.get(5) : "0" + gc.get(5);
        String hh = gc.get(11) > 9 ? "" + gc.get(11) : "0" + gc.get(11);
        String nn = gc.get(12) > 9 ? "" + gc.get(12) : "0" + gc.get(12);
        String ss = gc.get(13) > 9 ? "" + gc.get(13) : "0" + gc.get(13);
        String cc = "" + gc.get(14);
        switch (cc.length()) {
            case 4: {
                cc = cc.substring(0, 2);
                break;
            }
            case 3: {
                cc = "0" + cc.charAt(0);
                break;
            }
            case 1: 
            case 2: {
                cc = "00";
            }
        }
        Return2 = Return2.replace("%yyyy", yyyy);
        Return2 = Return2.replace("%mm", mm);
        Return2 = Return2.replace("%dd", dd);
        Return2 = Return2.replace("%hh", hh);
        Return2 = Return2.replace("%nn", nn);
        Return2 = Return2.replace("%ss", ss);
        Return2 = Return2.replace("%cc", cc);
        Return2 = Return2.replace("%t", tempDir);
        Return2 = Return2.replace("%h", userDir);
        String dir = "";
        if (Return2.replace('\\', '/').contains("/")) {
            dir = Return2.replace('\\', '/').substring(0, Return2.replace('\\', '/').lastIndexOf(47));
        }
        if (!(dirs = new File(dir)).exists()) {
            dirs.mkdirs();
        }
        return Return2;
    }

    public static Logger getCurrLog() {
        return LoggerFactory.get((Config)IscobolSystem.get(Config.class), -99, false);
    }
}

