/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.logger;

import com.iscobol.as.ClientInfo;
import com.iscobol.logger.IscobolFormatter;
import com.iscobol.logger.Logger;
import com.iscobol.rts.Factory;
import com.iscobol.rts.HTTPSessionInfo;
import com.iscobol.rts.IscobolSystem;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

public class Java14Logger
implements Logger {
    private java.util.logging.Logger log = java.util.logging.Logger.getAnonymousLogger();
    private String filename;
    private Handler handler;
    private boolean thread;

    @Override
    public void setFileName(String name) throws IOException {
        this.setFileName(name, false);
    }

    @Override
    public void setFileName(String logFile, boolean append) throws IOException {
        this.setFileName(logFile, -1, 1, append);
    }

    @Override
    public void setFileName(String logFile, int logLen, int count, boolean append) throws IOException {
        this.filename = logFile;
        if (this.handler != null) {
            this.log.removeHandler(this.handler);
            this.handler.close();
        }
        if (logFile != null) {
            this.log.setLevel(Level.FINEST);
            this.log.setUseParentHandlers(false);
            ClientInfo info = (ClientInfo)IscobolSystem.get(ClientInfo.class);
            if (info != null) {
                logFile = logFile + "." + info.getThreadId();
            } else {
                HTTPSessionInfo sInfo = (HTTPSessionInfo)IscobolSystem.get(HTTPSessionInfo.class);
                if (sInfo != null) {
                    logFile = logFile + "." + sInfo.getSessionId();
                }
            }
            if (logLen > 0) {
                this.handler = new FileHandler(logFile, logLen, count, append);
                this.log.addHandler(this.handler);
            } else {
                this.handler = new FileHandler(logFile, append);
                this.log.addHandler(this.handler);
            }
            this.handler.setFormatter(new IscobolFormatter());
        }
    }

    private String buildMessage(String msg) {
        if (this.thread && Factory.getd(false) != null) {
            Object call = Factory.peekCall(1);
            if (call != null) {
                Class<?> c = Factory.getCallClass(call);
                if (c == null) {
                    c = call.getClass();
                }
                return msg + " [" + c.getName() + " Thread=" + Factory.getCurrentThreadId() + "]";
            }
            return msg + " [Thread=" + Factory.getCurrentThreadId() + "]";
        }
        return msg;
    }

    @Override
    public void severe(String msg) {
        this.log.severe(this.buildMessage(msg));
    }

    @Override
    public void info(String msg) {
        this.log.info(this.buildMessage(msg));
    }

    @Override
    public void warning(String msg) {
        this.log.warning(this.buildMessage(msg));
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public void close() {
        if (this.handler != null) {
            this.log.removeHandler(this.handler);
            this.handler.close();
        }
    }

    public boolean isShowThreadInfo() {
        return this.thread;
    }

    public void setShowThreadInfo(boolean showThreadInfo) {
        this.thread = showThreadInfo;
    }
}

