/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib_n;

import com.iscobol.lib_n.CBLScanDir;
import com.iscobol.rts.Memory;
import com.iscobol.rts_n.Factory;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.PicX;
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;

public class CBL_DIR_SCAN_READ
extends CBLScanDir {
    private PicX ENTRY = Factory.getVarAlphanum((Memory)null, 0, 32768, false, null, null, null, "DIR-ENTRY", false, false);
    private NumericVar ATTRIBUTE = Factory.getVarCompN(this.ENTRY, 0, 4, false, null, null, null, "DIR-ATTRIBUTE", false, 10, 0, false, false, false);
    private PicX DATE_STAMP = Factory.getVarAlphanum(this.ENTRY, 4, 59, false, null, null, null, "DIR-DATE-STAMP", false, false);
    private NumericVar YEAR = Factory.getVarCompN(this.DATE_STAMP, 4, 4, false, null, null, null, "DIR-YEAR", false, 10, 0, false, false, false);
    private NumericVar MONTH = Factory.getVarCompN(this.DATE_STAMP, 8, 2, false, null, null, null, "DIR-MONTH", false, 5, 0, false, false, false);
    private NumericVar DAY = Factory.getVarCompN(this.DATE_STAMP, 10, 2, false, null, null, null, "DIR-DAY", false, 5, 0, false, false, false);
    private NumericVar HOUR = Factory.getVarCompN(this.DATE_STAMP, 12, 2, false, null, null, null, "DIR-HOUR", false, 5, 0, false, false, false);
    private NumericVar MINUTE = Factory.getVarCompN(this.DATE_STAMP, 14, 2, false, null, null, null, "DIR-MINUTE", false, 5, 0, false, false, false);
    private NumericVar SECOND = Factory.getVarCompN(this.DATE_STAMP, 16, 2, false, null, null, null, "DIR-SECOND", false, 5, 0, false, false, false);
    private NumericVar MILLISEC = Factory.getVarCompN(this.DATE_STAMP, 18, 2, false, null, null, null, "DIR-MILLISEC", false, 5, 0, false, false, false);
    private NumericVar DST = Factory.getVarCompN(this.DATE_STAMP, 20, 1, false, null, null, null, "DIR-DST", false, 3, 0, false, false, false);
    private NumericVar SIZE = Factory.getVarCompN(this.DATE_STAMP, 21, 8, false, null, null, null, "DIR-SIZE", false, 20, 0, false, false, false);
    private NumericVar NAME_MAX_LEN = Factory.getVarCompN(this.DATE_STAMP, 29, 2, false, null, null, null, "DIR-NAME-MAX-LEN", false, 5, 0, false, false, false);
    private PicX ENTRY_NAME = Factory.getVarAlphanum(this.DATE_STAMP, 31, 32737, false, null, null, null, "DIR-ENTRY-NAME", false, false);

    private long doWork(CobolVar arg1, CobolVar arg2) {
        int handle = arg1.toint();
        this.ENTRY.link(arg2);
        int maxNameLen = this.NAME_MAX_LEN.toint();
        CBLScanDir.Entries entry = CBL_DIR_SCAN_READ.getObject(handle);
        if (entry == null) {
            return 2L;
        }
        File currFile = entry.next();
        if (currFile == null) {
            return 3L;
        }
        int attribute = 0;
        attribute = currFile.isFile() ? (attribute |= 1) : (currFile.isDirectory() ? (attribute |= 2) : (attribute |= 4));
        if (currFile.canRead()) {
            attribute |= 8;
        }
        if (currFile.canWrite()) {
            attribute |= 0x10;
        }
        if (currFile.isHidden()) {
            attribute |= 0x20;
        }
        this.ATTRIBUTE.set(attribute);
        GregorianCalendar lm = new GregorianCalendar();
        lm.setTime(new Date(currFile.lastModified()));
        this.YEAR.set(lm.get(1));
        this.MONTH.set(lm.get(2) + 1);
        this.DAY.set(lm.get(5));
        this.HOUR.set(lm.get(11));
        this.MINUTE.set(lm.get(12));
        this.SECOND.set(lm.get(13));
        this.MILLISEC.set(lm.get(14));
        this.DST.set(0);
        this.SIZE.set(currFile.length());
        String name = entry.getName(currFile);
        if (maxNameLen >= name.length()) {
            this.ENTRY_NAME.sub(1, Math.min(maxNameLen, name.length())).set(name);
        }
        return 0L;
    }

    @Override
    public Object call(Object[] argv) {
        if (argv != null && argv.length > 1) {
            this.RETURN_CODE.set(this.doWork((CobolVar)argv[0], (CobolVar)argv[1]));
        } else {
            this.RETURN_CODE.set(127L);
        }
        return this.RETURN_CODE;
    }

    @Override
    public final String getName() {
        return "CBL_DIR_SCAN_READ";
    }
}

