/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib;

import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.io.FileLock;
import com.iscobol.lib.CBLByteStream;
import com.iscobol.rts.File;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.UserHandles;

public class CBL_OPEN_FILE
extends CBLByteStream {
    public CBL_OPEN_FILE() {
        super(0);
    }

    protected CBL_OPEN_FILE(int compopt) {
        super(compopt);
    }

    protected int getCreateFlags() {
        return 0;
    }

    @Override
    public Object call(Object[] argv) {
        boolean readLock;
        boolean exclusiveLock;
        int osmode;
        if (argv == null || argv.length != 5) {
            this.returnCode.set(14592);
            return this.returnCode;
        }
        String fName = File.get(argv[0].toString().trim()).getAbsolutePath();
        int accessMode = ((INumericVar)argv[1]).toint();
        int denyMode = ((INumericVar)argv[2]).toint();
        INumericVar handle = (INumericVar)argv[4];
        switch (accessMode & 0x3F) {
            case 1: {
                osmode = 0 | this.getCreateFlags();
                break;
            }
            case 2: {
                osmode = 1 | this.getCreateFlags();
                if (denyMode == 0) break;
                this.returnCode.set(14592);
                return this.returnCode;
            }
            case 3: {
                osmode = 2 | this.getCreateFlags();
                break;
            }
            default: {
                this.returnCode.set(14592);
                return this.returnCode;
            }
        }
        switch (denyMode) {
            case 0: {
                exclusiveLock = true;
                readLock = true;
                break;
            }
            case 1: {
                exclusiveLock = true;
                readLock = false;
                break;
            }
            case 2: {
                exclusiveLock = true;
                readLock = true;
                break;
            }
            case 3: {
                exclusiveLock = false;
                readLock = false;
                break;
            }
            default: {
                this.returnCode.set(14592);
                return this.returnCode;
            }
        }
        OSFile file = new OSFile();
        try {
            file.open(fName, osmode);
            FileLock lock = new FileLock(fName, file, exclusiveLock, readLock);
            handle.set(UserHandles.ssetId(new CBLByteStream.MyFile(file, lock)));
        }
        catch (IsamException ex) {
            this.returnCode.set(CBL_OPEN_FILE.getFS(ex, false));
            return this.returnCode;
        }
        this.returnCode.set(0);
        return this.returnCode;
    }
}

