/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib;

import com.iscobol.java.CobolVarHelper;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolCall;
import java.io.File;

public class CBL_JOIN_FILENAME
implements IscobolCall {
    private static final int COMPOPT = 0;
    private static final ICobolVar ZERO = Factory.getNumLiteral(0L, 1, 0, false);
    private static final ICobolVar ONE = Factory.getNumLiteral(1L, 1, 0, false);
    private static final ICobolVar FOUR = Factory.getNumLiteral(4L, 1, 0, false);
    private final ICobolVar SUCCESS;
    private final ICobolVar ILLNAME;
    private final ICobolVar TOOBIG;
    private final CobolVarHelper splitjoin_buf;

    protected CBL_JOIN_FILENAME(ICobolVar zero, ICobolVar one, ICobolVar four, int compOpt) {
        this.SUCCESS = zero;
        this.TOOBIG = one;
        this.ILLNAME = four;
        this.splitjoin_buf = new CobolVarHelper("cblt-splitjoin-buf", compOpt).pic9CompX("param-length", 2).pic9CompX("split-join-flag1", 1).pic9CompX("split-join-flag2", 1).pic9CompX("device-offset", 2).pic9CompX("device-length", 2).pic9CompX("basename-offset", 2).pic9CompX("basename-length", 2).pic9CompX("extension-offset", 2).pic9CompX("extension-length", 2).pic9CompX("total-length", 2).pic9CompX("split-buf-len", 2).pic9CompX("join-buf-len", 2).pic9CompX("first-component-length", 2);
    }

    public CBL_JOIN_FILENAME() {
        this(ZERO, ONE, FOUR, 0);
    }

    @Override
    public Object call(Object[] argv) {
        String ext;
        String basename;
        String path;
        boolean upperCase;
        if (argv == null) {
            return this.ILLNAME;
        }
        this.splitjoin_buf.get("cblt-splitjoin-buf").link((ICobolVar)argv[0]);
        int splitJoinFlag1 = this.splitjoin_buf.get("split-join-flag1").toint();
        int splitJoinFlag2 = this.splitjoin_buf.get("split-join-flag2").toint();
        int joinBufLen = this.splitjoin_buf.get("join-buf-len").toint();
        ICobolVar totalLength = this.splitjoin_buf.get("total-length");
        int path_off = this.splitjoin_buf.get("device-offset").toint() - 1;
        int basename_off = this.splitjoin_buf.get("basename-offset").toint() - 1;
        int ext_off = this.splitjoin_buf.get("extension-offset").toint() - 1;
        int path_len = this.splitjoin_buf.get("device-length").toint();
        int basename_len = this.splitjoin_buf.get("basename-length").toint();
        int ext_len = this.splitjoin_buf.get("extension-length").toint();
        boolean bl = upperCase = (splitJoinFlag1 & 1) != 0;
        if ((splitJoinFlag1 & 2) != 0) {
            path = CBL_JOIN_FILENAME.nullTerminated((ICobolVar)argv[2], path_off);
            basename = CBL_JOIN_FILENAME.nullTerminated((ICobolVar)argv[3], basename_off);
            ext = CBL_JOIN_FILENAME.nullTerminated((ICobolVar)argv[4], ext_off);
        } else if ((splitJoinFlag2 & 4) != 0) {
            path = CBL_JOIN_FILENAME.lenTerminated((ICobolVar)argv[2], path_off, this.splitjoin_buf.get("device-length").toint() - 1);
            basename = CBL_JOIN_FILENAME.lenTerminated((ICobolVar)argv[3], basename_off, this.splitjoin_buf.get("basename-length").toint() - 1);
            ext = CBL_JOIN_FILENAME.lenTerminated((ICobolVar)argv[4], ext_off, this.splitjoin_buf.get("extension-length").toint() - 1);
        } else {
            path = CBL_JOIN_FILENAME.spaceTerminated((ICobolVar)argv[2], path_off);
            basename = CBL_JOIN_FILENAME.spaceTerminated((ICobolVar)argv[3], basename_off);
            ext = CBL_JOIN_FILENAME.spaceTerminated((ICobolVar)argv[4], ext_off);
        }
        if (path.length() > path_len) {
            path = path.substring(0, path_len);
        }
        if (basename.length() > basename_len) {
            basename = basename.substring(0, basename_len);
        }
        if (ext.length() > ext_len) {
            ext = ext.substring(0, ext_len);
        }
        StringBuffer result = new StringBuffer();
        String sep = File.separator;
        if (path.length() > 0) {
            result.append(path);
            if (!CBL_JOIN_FILENAME.endsWithSep(path)) {
                result.append(sep);
            }
        }
        result.append(basename);
        if (!ext.startsWith(".")) {
            result.append(".");
        }
        result.append(ext);
        if (upperCase) {
            ((ICobolVar)argv[1]).set(result.toString().toUpperCase());
        } else {
            ((ICobolVar)argv[1]).set(result.toString());
        }
        int totLen = result.length();
        totalLength.set(totLen);
        if (totLen < 1) {
            return this.ILLNAME;
        }
        if (totLen > joinBufLen) {
            return this.TOOBIG;
        }
        return this.SUCCESS;
    }

    @Override
    public void finalize() {
    }

    @Override
    public void perform(int begin, int end) {
    }

    private static String nullTerminated(ICobolVar z, int offs) {
        byte[] str = z.getBytes();
        int len = str.length;
        for (int i = offs; i < len; ++i) {
            if (str[i] != 0) continue;
            len = i;
            break;
        }
        return new String(str, offs, len - offs);
    }

    private static String spaceTerminated(ICobolVar z, int offs) {
        if (offs > 0) {
            return z.toString().substring(offs).trim();
        }
        return z.toString().trim();
    }

    private static String lenTerminated(ICobolVar z, int offs, int len) {
        return z.toString().substring(offs, offs + len);
    }

    private static boolean endsWithSep(String s) {
        int len = s.length();
        if (len > 0) {
            switch (s.charAt(len - 1)) {
                case '/': 
                case ':': 
                case '\\': {
                    return true;
                }
            }
        }
        return false;
    }

    public static void main(String[] argv) {
        CobolVarHelper cvh = new CobolVarHelper("test", 0).picX("str", 20);
        ICobolVar str = cvh.get("str");
        str.set("ABC");
        System.out.println("[" + CBL_JOIN_FILENAME.spaceTerminated(str, 0) + "]");
        System.out.println("[" + CBL_JOIN_FILENAME.spaceTerminated(str, 1) + "]");
        System.out.println("[" + CBL_JOIN_FILENAME.spaceTerminated(str, 2) + "]");
        System.out.println("[" + CBL_JOIN_FILENAME.spaceTerminated(str, 3) + "]");
    }
}

