/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.FileNotOpenException;
import com.iscobol.io.ItemToSort;
import com.iscobol.rts.Config;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.SortKeyItem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SortFile
implements RuntimeErrorsNumbers {
    public static final String tmpDir = Config.getProperty(".sort.dir", null);
    private static final int BUFSIZE = 0x100000;
    private File file;
    private InputStream inp;
    private OutputStream out;
    private boolean eof;
    ItemToSort buffer;

    public SortFile(int len, SortKeyItem[] key) {
        this.buffer = new ItemToSort(key, new byte[len]);
    }

    protected void finalize() {
        this.close();
        if (this.file != null) {
            this.file.delete();
        }
    }

    void create() throws IOException {
        this.file = tmpDir != null ? File.createTempFile("srt", ".srt", new File(tmpDir)) : File.createTempFile("srt", ".srt");
        this.file.deleteOnExit();
        this.out = new BufferedOutputStream(new FileOutputStream(this.file), 0x100000);
    }

    void openRead() throws IOException {
        this.inp = new BufferedInputStream(new FileInputStream(this.file), 0x100000);
        this.eof = false;
    }

    void close() {
        try {
            if (this.inp != null) {
                this.inp.close();
                this.inp = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void write(ItemToSort buff) throws IOException {
        if (this.out == null) {
            throw new FileNotOpenException();
        }
        this.out.write(buff.memory);
    }

    void read() throws IOException {
        if (this.inp != null) {
            if (!this.eof && this.inp.read(this.buffer.memory) <= 0) {
                this.eof = true;
            }
        } else {
            throw new FileNotOpenException();
        }
    }

    boolean isAtEnd() {
        return this.eof;
    }
}

