/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.io.VisionFile;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ScanVision
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    private VisionFile theFile;
    private KeyDescription[] keys;
    private String path = "";
    private int errno;
    private Exception errio = null;

    @Override
    public String getSysErrno() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public String getErrMsg() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public int getCobErrno() {
        return this.errno;
    }

    private int mapError(int e) {
        this.errno = e;
        return 0;
    }

    @Override
    public synchronized long getNumRecords() {
        if (this.theFile != null) {
            return this.theFile.getValidRecordsNum();
        }
        return -1L;
    }

    @Override
    public synchronized int getNumKeys() {
        int Return2;
        if (this.keys != null) {
            Return2 = this.keys.length;
        } else if (this.theFile != null) {
            Return2 = this.theFile.nKeys;
            this.keys = new KeyDescription[Return2];
        } else {
            Return2 = -1;
        }
        return Return2;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.theFile != null) {
            return this.theFile.maxRec;
        }
        return -1;
    }

    @Override
    public int getMinRecordSize() {
        if (this.theFile != null) {
            return this.theFile.minRec;
        }
        return -1;
    }

    @Override
    public synchronized KeyDescription getKey(int num) {
        KeyDescription Return2;
        if (this.theFile != null && num >= 0 && num < this.getNumKeys()) {
            if (this.keys[num] == null) {
                this.keys[num] = new KeyDescription(this.theFile.keys[num].nparts, this.theFile.keys[num].duplicates);
                for (int i = 0; i < this.theFile.keys[num].nparts; ++i) {
                    this.keys[num].setSegment(i, this.theFile.keys[num].parts[i].length, this.theFile.keys[num].parts[i].offset);
                }
            }
            Return2 = this.keys[num];
        } else {
            Return2 = null;
            this.mapError(102);
        }
        return Return2;
    }

    @Override
    public byte[] getSequence() {
        return this.theFile.collatingSequence;
    }

    @Override
    public int build(String ath, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        return this.mapError(126);
    }

    @Override
    public synchronized int open(String pth, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        this.path = pth;
        if (assignExt) {
            this.path = BaseFile.expandFileName(this.path);
        }
        try {
            this.theFile = new VisionFile(this.path);
        }
        catch (FileNotFoundException ex) {
            if (new File(this.path).exists()) {
                return this.mapError(131);
            }
            return this.mapError(130);
        }
        catch (IOException ex) {
            this.errio = ex;
            return this.mapError(133);
        }
        return 1;
    }

    @Override
    public synchronized void setCurrentRecord(long nRec) {
    }

    @Override
    public synchronized long getCurrentRecord() {
        return this.mapError(126);
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public synchronized int close() {
        if (this.theFile != null) {
            this.theFile.close();
            this.theFile = null;
            this.keys = null;
            this.path = "";
        }
        return 1;
    }

    @Override
    public boolean isOpen() {
        return this.theFile != null;
    }

    @Override
    public synchronized long write(byte[] record, int offs, int size, boolean lock) {
        return this.mapError(126);
    }

    @Override
    public synchronized long rewrite(byte[] record, int offs, int size, boolean lock) {
        return this.mapError(126);
    }

    @Override
    public synchronized long delete(byte[] record, int offs) {
        return this.mapError(126);
    }

    @Override
    public synchronized long next(byte[] record, int offs, int lock) {
        int Return2;
        if (this.theFile != null) {
            Return2 = this.theFile.readNext(record, offs, record.length - offs);
            if (Return2 < 0) {
                Return2 = this.mapError(110);
            }
        } else {
            Return2 = this.mapError(101);
        }
        return Return2;
    }

    @Override
    public synchronized long previous(byte[] record, int offs, int lock) {
        return this.mapError(126);
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription k, int lock) {
        return this.mapError(126);
    }

    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        return this.mapError(126);
    }

    @Override
    public long start(byte[] record, int offs, int kNum, int kSize, int mode) {
        return this.mapError(126);
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription k, int kSize, int mode) {
        return this.mapError(126);
    }

    @Override
    public synchronized int unlock() {
        return this.mapError(126);
    }

    @Override
    public synchronized int recover() {
        return this.mapError(126);
    }

    @Override
    public void sync(int allFiles) {
    }

    @Override
    public int remove(String name) {
        return this.mapError(126);
    }

    @Override
    public int rename(String src, String dst) {
        return this.mapError(126);
    }

    @Override
    public int begin() {
        return 1;
    }

    @Override
    public int commit(int ctx) {
        return 1;
    }

    @Override
    public int rollback() {
        return 1;
    }

    @Override
    public String getVersion() {
        return "VisionScan v" + this.theFile.vVersion;
    }

    @Override
    public boolean isKeySelectedByNum() {
        return true;
    }

    public void finalize() {
        this.close();
    }

    public static void main(String[] argv) throws Exception {
        VisionFile vf = new VisionFile(argv[0]);
        vf.printInfo();
    }
}

