/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DeviceFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicN;
import com.iscobol.rts.MixingCharAndBytesException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.IOException;

public class PrinterFile
extends DeviceFile
implements CobolFile,
RuntimeErrorsNumbers {
    private final IPicN nationalBuffer;
    private boolean cp;

    public PrinterFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, boolean binary, Class clazz) {
        super(nam, maxLen, memBuf, minLen, opt, binary, clazz);
        this.nationalBuffer = memBuf instanceof IPicN ? (IPicN)memBuf : null;
    }

    public PrinterFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, boolean binary, String clazz) {
        super(nam, maxLen, memBuf, minLen, opt, binary, clazz);
        this.nationalBuffer = memBuf instanceof IPicN ? (IPicN)memBuf : null;
    }

    public PrinterFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, boolean binary) {
        super(nam, maxLen, memBuf, minLen, opt, binary);
        this.nationalBuffer = memBuf instanceof IPicN ? (IPicN)memBuf : null;
    }

    public PrinterFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt) {
        super(nam, maxLen, memBuf, minLen, opt, false);
        this.nationalBuffer = memBuf instanceof IPicN ? (IPicN)memBuf : null;
    }

    public void setCp(boolean cp) {
        this.cp = cp;
    }

    public boolean isCp() {
        return this.cp;
    }

    @Override
    public void peerOpen(String path, int openType, int lockType) {
        super.peerOpen(path, openType, lockType);
        if (this.outFile != null) {
            int minRecSize = Config.getProperty(".file.min_rec_size", ".min_rec_size", 1);
            if (minRecSize < 0) {
                minRecSize = 0;
            }
            this.outFile.setMinRecSize(minRecSize);
        }
    }

    @Override
    public final boolean write(boolean lock, int len) {
        return this.write(lock, len, 0);
    }

    @Override
    public boolean write(boolean lock, int len, int opts) {
        int rc;
        boolean strip;
        super.write(lock, len);
        boolean bl = strip = (opts & 2) == 0;
        if ((opts & 1) != 0 || this.isGraphicPrinter()) {
            rc = this.outFile.write(this.getBufferAsVar(), len, strip);
        } else {
            rc = this.outFile.write(this.getBufferAsVar(), len, strip);
            if (rc != 0) {
                rc = this.outFile.write(13);
            }
        }
        if (rc != 1) {
            CobolIOException.get(this.outFile.getCobErrno(), "", this, 3);
        }
        return false;
    }

    @Override
    public boolean writeAdvancing(int kind, int lines, boolean lock, int len, int opts) {
        if (this.isGraphicPrinter()) {
            opts |= 1;
        }
        return super.writeAdvancing(kind, lines, lock, len, opts);
    }

    @Override
    public int readNext(boolean lock, ICobolVar into) {
        return this.readNext(lock ? 1 : 0, into);
    }

    @Override
    public int readNext(int lock, ICobolVar into) {
        int Return2 = 0;
        if (lock != -1) {
            super.readNext(lock &= this.lockMask, into);
        } else {
            super.readNext(lock &= 0xFFFFFFFF, into);
        }
        if (this.inpFile == null) {
            AtEndException.get(this, 6);
            return Return2;
        }
        try {
            byte[] in;
            if (this.isBinary()) {
                in = new byte[this.getBufferLength()];
                Return2 = this.inpFile.read(in, 0, this.getBufferLength());
                if (Return2 <= 0) {
                    AtEndException.get(this, 6);
                    return Return2;
                }
            } else {
                char[] inc = new char[this.getBufferLength()];
                Return2 = this.inpFile.read(inc, 0, this.getBufferLength());
                if (Return2 <= 0) {
                    AtEndException.get(this, 6);
                    return Return2;
                }
                in = new String(inc).substring(0, Return2).getBytes();
            }
            this.updateBuffer(in);
            if (into != null) {
                into.setUsingMaxLen(in);
            }
        }
        catch (IOException ex) {
            CobolIOException.get(ex, this, 6);
        }
        return Return2;
    }

    @Override
    protected void peerClose(int opts) {
        this.checkFilePageEject(opts);
        super.peerClose(opts);
    }

    protected void checkFilePageEject(int opts) {
        if (this.outFile != null && Config.getProperty(".file.page_eject_on_close", false) && (opts & 1) == 0) {
            DeviceFile.Output o;
            if (this.outFile instanceof DeviceFile.Output && (o = (DeviceFile.Output)this.outFile).isDirect()) {
                if (!o.printInBackground) {
                    try {
                        o.write(12);
                    }
                    catch (MixingCharAndBytesException e) {
                        if (e.getErrorCode() == 3) {
                            o.writeByte((byte)12);
                        } else if (e.getErrorCode() == 4) {
                            o.writeCharX((byte)12);
                        }
                    }
                }
            } else {
                try {
                    this.outFile.write(12);
                }
                catch (MixingCharAndBytesException mixingCharAndBytesException) {
                    // empty catch block
                }
            }
        }
    }

    protected final void dfPeerClose(int opts) {
        super.peerClose(opts);
    }

    @Override
    public char[] getBufferAsChars() {
        if (this.nationalBuffer != null) {
            return this.nationalBuffer.basicToString().toCharArray();
        }
        return super.getBufferAsChars();
    }

    @Override
    protected ICobolVar getBufferAsVar() {
        if (this.nationalBuffer != null) {
            return this.nationalBuffer;
        }
        return super.getBufferAsVar();
    }
}

