/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataStream;
import com.iscobol.io.FileStatus;
import com.iscobol.io.JavaToIscobolError;

public class FileStatusDefault
implements FileStatus {
    @Override
    public int map(int type, String extFs, DataStream cf, int op) {
        if (extFs != null && extFs.length() > 0) {
            cf.setExtendedStatus(extFs);
        }
        if ((type & 0x7FFF0000) == 0x7FFF0000) {
            char fs1 = (char)((type & 0xFF00) >>> 8);
            char fs2 = (char)(type & 0xFF);
            cf.setFileStatus("" + fs1 + fs2);
            cf.setStatusMessage("");
            if (fs1 == '0') {
                return 0;
            }
            return type;
        }
        block0 : switch (type) {
            case 200: {
                cf.setFileStatus("02");
                cf.setStatusMessage("duplicate key detected");
                type = 0;
                break;
            }
            case 201: {
                cf.setFileStatus("04");
                cf.setStatusMessage("wrong record length in read");
                type = 0;
                break;
            }
            case 203: {
                cf.setFileStatus("05");
                cf.setStatusMessage("optional file missing");
                type = 0;
                break;
            }
            case 202: {
                cf.setFileStatus("05");
                cf.setStatusMessage("optional file created");
                type = 0;
                break;
            }
            case 206: {
                cf.setFileStatus("07");
                cf.setStatusMessage("non-reel/unit device");
                type = 0;
                break;
            }
            case 205: {
                cf.setFileStatus("0D");
                cf.setStatusMessage("command execution failed");
                type = 0;
                break;
            }
            case 110: {
                cf.setFileStatus("10");
                cf.setStatusMessage("end/begin of file");
                break;
            }
            case 100: {
                cf.setFileStatus("22");
                cf.setStatusMessage("duplicate record");
                break;
            }
            case 111: {
                cf.setFileStatus("23");
                cf.setStatusMessage("no record found");
                break;
            }
            case 139: {
                cf.setFileStatus("24");
                cf.setStatusMessage("invalid write");
                break;
            }
            case 133: {
                cf.setFileStatus("30");
                cf.setStatusMessage("permanent I/O error");
                break;
            }
            case 130: {
                cf.setFileStatus("35");
                cf.setStatusMessage("missing file");
                break;
            }
            case 131: {
                cf.setFileStatus("37");
                cf.setStatusMessage("invalid permission");
                if (extFs != null && extFs.length() != 0) break;
                cf.setExtendedStatus("07");
                break;
            }
            case 142: {
                cf.setFileStatus("37");
                cf.setStatusMessage("invalid open mode");
                if (extFs != null && extFs.length() != 0) break;
                cf.setExtendedStatus("09");
                break;
            }
            case 141: {
                cf.setFileStatus("38");
                cf.setStatusMessage("file closed with lock");
                break;
            }
            case 102: {
                cf.setFileStatus("39");
                cf.setStatusMessage("file mismatch");
                break;
            }
            case 135: {
                cf.setFileStatus("41");
                cf.setStatusMessage("already open");
                break;
            }
            case 145: {
                cf.setFileStatus("44");
                cf.setStatusMessage("boundary violation");
                break;
            }
            case 101: {
                switch (op) {
                    default: {
                        cf.setFileStatus("42");
                        cf.setStatusMessage("file not open");
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 262: 
                    case 263: 
                    case 264: {
                        cf.setFileStatus("47");
                        cf.setStatusMessage("wrong open mode or access mode for start/read");
                        if (extFs != null && extFs.length() != 0) break block0;
                        cf.setExtendedStatus("02");
                        break;
                    }
                    case 3: {
                        cf.setFileStatus("48");
                        cf.setStatusMessage("wrong open mode or access mode for write");
                        if (extFs != null && extFs.length() != 0) break block0;
                        cf.setExtendedStatus("02");
                        break;
                    }
                    case 4: 
                    case 5: {
                        cf.setFileStatus("49");
                        cf.setStatusMessage("wrong open mode or access mode for rewrite/delete");
                        if (extFs != null && extFs.length() != 0) break block0;
                        cf.setExtendedStatus("02");
                        break;
                    }
                }
                break;
            }
            case 143: {
                cf.setFileStatus("43");
                cf.setStatusMessage("invalid delete/rewrite in sequential mode");
                break;
            }
            case 112: {
                cf.setFileStatus("46");
                cf.setStatusMessage("no current record defined");
                break;
            }
            case 136: {
                cf.setFileStatus("47");
                cf.setStatusMessage("file not open for INPUT or I-O");
                if (extFs != null && extFs.length() != 0) break;
                cf.setExtendedStatus("01");
                break;
            }
            case 137: {
                cf.setFileStatus("48");
                cf.setStatusMessage("file not open for OUTPUT or I-O");
                if (extFs != null && extFs.length() != 0) break;
                cf.setExtendedStatus("01");
                break;
            }
            case 138: {
                cf.setFileStatus("49");
                cf.setStatusMessage("file not open for I-O");
                if (extFs != null && extFs.length() != 0) break;
                cf.setExtendedStatus("01");
                break;
            }
            case 107: {
                cf.setFileStatus("51");
                cf.setStatusMessage("record locked");
                break;
            }
            case 129: {
                cf.setFileStatus("53");
                cf.setStatusMessage("no more locks available");
                break;
            }
            case 113: {
                cf.setFileStatus("61");
                cf.setStatusMessage("file locked");
                break;
            }
            case 104: {
                cf.setFileStatus("94");
                cf.setStatusMessage("too many files open");
                cf.setExtendedStatus("10");
                break;
            }
            case 105: {
                cf.setFileStatus("98");
                cf.setStatusMessage("file corrupt");
                break;
            }
            case 126: {
                cf.setFileStatus("9B");
                cf.setStatusMessage("operation not permitted");
                break;
            }
            case 140: {
                cf.setFileStatus("9D");
                cf.setStatusMessage("no remappable error");
                break;
            }
            case 122: {
                cf.setFileStatus("9E");
                cf.setStatusMessage("transaction error");
                break;
            }
            case 103: {
                cf.setFileStatus("9g");
                cf.setStatusMessage("Bad key description");
                break;
            }
            case 147: {
                cf.setFileStatus("9N");
                cf.setStatusMessage("Network error");
                break;
            }
            case 149: {
                cf.setFileStatus("9X");
                cf.setStatusMessage("Encryption's key missing");
                break;
            }
            default: {
                cf.setFileStatus("9" + (char)type);
                cf.setStatusMessage("unknown error");
                cf.setExtendedStatus("" + type);
                type = 134;
            }
        }
        return type;
    }

    @Override
    public int map(Exception ex, DataStream cf, int op) {
        if (ex instanceof CobolIOException) {
            return this.map(((CobolIOException)ex).getErrNum(), "", cf, op);
        }
        int type = JavaToIscobolError.map(ex);
        if (type != 134) {
            return this.map(type, "", cf, op);
        }
        cf.setFileStatus("9" + (char)type);
        String exMsg = ex.getMessage();
        if (exMsg != null) {
            cf.setStatusMessage(ex.getMessage());
            cf.setExtendedStatus(ex.getMessage());
        } else {
            cf.setStatusMessage("Unknown");
            cf.setExtendedStatus("Unknown");
        }
        return 134;
    }
}

