/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.iiop.Corba;
import IT.picosoft.iiop.CorbaException;
import IT.picosoft.iiop.IORHelper;
import IT.picosoft.iiop.IiopObj;
import IT.picosoft.iiop.IiopServer;
import IT.picosoft.iiop.Principal;
import com.iscobol.as.fileserver.Methods;
import com.iscobol.io.BaseFile;
import com.iscobol.io.LineSequentialDFile;
import com.iscobol.io.RelativeDFile;
import com.iscobol.io.SequentialDFile;
import com.iscobol.rts.Auth;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicMultiType;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.MonitorFinalize;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicN;
import com.iscobol.types.PicXAnyLength;
import java.util.Hashtable;

public class DynamicRemote
implements DynamicMultiType,
RuntimeErrorsNumbers,
Cloneable {
    public static final int T_INDEX = 1;
    public static final int T_RELATIVE = 2;
    public static final int T_SEQUENTIAL = 3;
    public static final int T_LINE_SEQUENTIAL = 4;
    public static final int T_OUTPUT = 5;
    public static final int T_INPUT = 6;
    public static final int E_SYS_ERR = 1;
    public static final int E_PARAM_ERR = 2;
    public static final int E_TOO_MANY_FILES = 3;
    public static final int E_MODE_CLASH = 4;
    public static final int E_REC_LOCKED = 5;
    public static final int E_BROKEN = 6;
    public static final int E_DUPLICATE = 7;
    public static final int E_NOT_FOUND = 8;
    public static final int E_UNDEF_RECORD = 9;
    public static final int E_DISK_FULL = 10;
    public static final int E_FILE_LOCKED = 11;
    public static final int E_REC_CHANGED = 12;
    public static final int E_MISMATCH = 13;
    public static final int E_NO_MEMORY = 14;
    public static final int E_MISSING_FILE = 15;
    public static final int E_PERMISSION = 16;
    public static final int E_NO_SUPPORT = 17;
    public static final int E_NO_LOCKS = 18;
    public static final int E_INTERFACE = 19;
    public static final int E_LICENSE_ERR = 20;
    public static final int E_UNKNOWN_ERR = 21;
    public static final int E_TRANSACTION = 22;
    public static final int W_NO_SUPPORT = 100;
    public static final int W_DUP_OK = 101;
    FileServer theConn;
    public static final int requiredVersion = 19;
    private int theFile = -1;
    protected MyConn theConns;
    private int openMode = 0;
    private KeyDescription[] keys;
    private int maxRecordSize;
    private int minRecordSize;
    private String path = "";
    private int errno;
    private String sysError;
    private String errMsg;
    private String fsUrl;
    private static final Object exit = "";

    public void setFSUrl(String url) {
        this.fsUrl = url;
    }

    private void init() throws CorbaException {
        String host;
        int port;
        block16: {
            BaseFile lastUsedFile = BaseFile.getLastUsedFile();
            if (this.fsUrl != null) {
                String s = this.fsUrl;
                int idx = s.indexOf(58);
                port = Config.getProperty(".file.remote.port", 10997);
                if (idx >= 0) {
                    host = s.substring(0, idx);
                    int idx2 = s.indexOf(58, idx + 1);
                    try {
                        if (idx2 >= 0) {
                            port = Integer.parseInt(s.substring(idx + 1, idx2));
                            break block16;
                        }
                        port = Integer.parseInt(s.substring(idx + 1));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    host = s;
                }
            } else if (lastUsedFile != null) {
                host = DynamicRemote.searchHost(lastUsedFile);
                port = DynamicRemote.searchPort(lastUsedFile);
            } else {
                host = Config.getProperty(".file.remote.host", "localhost");
                port = Config.getProperty(".file.remote.port", 10997);
            }
        }
        this.theConns = (MyConn)IscobolSystem.get(MyConn.class);
        if (this.theConns == null) {
            this.theConn = FileServer.get(host, port);
            MyConn conn = new MyConn(this.theConn, IscobolSystem.getContext());
            this.theConn.init();
            this.theConns = conn;
            if (this.theConn != null) {
                IscobolSystem.set(MyConn.class, conn);
                Factory.getCurrentMonitor().addObjToFinalize(new MonitorFinalize(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void monitorFinalize() {
                        Object object = exit;
                        synchronized (object) {
                            if (IscobolSystem.getContext() == DynamicRemote.this.getContext()) {
                                DynamicRemote.this.theConn.exit();
                                DynamicRemote.this.theConn = null;
                            }
                        }
                    }
                });
            }
            if (this.theConn != null) {
                MyConnTable.get().connections.put(host + port, this.theConn);
            }
        } else if (MyConnTable.get().connections.get(host + port) != null) {
            this.theConn = (FileServer)MyConnTable.get().connections.get(host + port);
        } else {
            this.theConn = FileServer.get(host, port);
            if (this.theConn != null) {
                MyConnTable.get().connections.put(host + port, this.theConn);
                this.theConn.init();
                Factory.getCurrentMonitor().addObjToFinalize(new MonitorFinalize(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void monitorFinalize() {
                        Object object = exit;
                        synchronized (object) {
                            if (IscobolSystem.getContext() == DynamicRemote.this.getContext()) {
                                DynamicRemote.this.theConn.exit();
                                DynamicRemote.this.theConn = null;
                            }
                        }
                    }
                });
            }
        }
    }

    @Override
    public String getSysErrno() {
        return this.sysError;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg != null ? this.errMsg : "";
    }

    @Override
    public int getCobErrno() {
        return this.errno;
    }

    private FileServer getConn() {
        return this.theConn;
    }

    private IscobolSystem.Context getContext() {
        return this.theConns.cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumRecords() {
        Object object = exit;
        synchronized (object) {
            byte[] result = new byte[11];
            int rc = this.getConn().info(this.theFile, -4, result);
            return Long.parseLong(new String(result, 0, 10));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumKeys() {
        Object object = exit;
        synchronized (object) {
            if (this.keys == null) {
                byte[] result = new byte[256];
                int rc = this.getConn().info(this.theFile, -1, result);
                if (rc == 0) {
                    return this.mapError();
                }
                int[] values = IOUtil.csv2Int(result);
                this.maxRecordSize = values[0];
                this.minRecordSize = values[1];
                this.keys = new KeyDescription[values[2]];
            }
            return this.keys.length;
        }
    }

    @Override
    public int getMaxRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.minRecordSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyDescription getKey(int num) {
        Object object = exit;
        synchronized (object) {
            KeyDescription Return2;
            if (num >= 0 && num < this.getNumKeys()) {
                if (this.keys[num] == null) {
                    byte[] result = new byte[256];
                    int rc = this.getConn().info(this.theFile, num, result);
                    if (rc == 0) {
                        this.mapError();
                        return null;
                    }
                    this.keys[num] = new KeyDescription(result);
                }
                Return2 = this.keys[num];
            } else {
                Return2 = null;
                this.mapError(2);
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSequence() {
        Object object = exit;
        synchronized (object) {
            byte[] result = new byte[256];
            int rc = this.getConn().info(this.theFile, -5, result);
            if (rc == 0) {
                this.mapError();
                return null;
            }
            return result;
        }
    }

    private int findKey(KeyDescription key) {
        int Return2;
        int nKeys = this.getNumKeys();
        try {
            for (Return2 = 0; Return2 < nKeys && !key.equals(this.getKey(Return2)); ++Return2) {
            }
        }
        catch (NullPointerException e) {
            Return2 = -1;
        }
        return Return2;
    }

    private int mapError(int err, int sys, String msg) {
        this.errno = err;
        this.sysError = "" + sys;
        this.errMsg = msg;
        return 0;
    }

    private int mapError(int err, int sys) {
        this.errno = err;
        this.sysError = "" + sys;
        this.errMsg = "";
        return 0;
    }

    private int mapError(int err) {
        this.errno = err;
        this.sysError = "";
        this.errMsg = "";
        return 0;
    }

    private int mapError() {
        this.errno = this.getConn().f_errno;
        this.sysError = "" + this.getConn().f_int_errno;
        this.errMsg = this.getConn().f_errmsg;
        return 0;
    }

    int mapOpen(int mode, int lockType) {
        return mode | lockType;
    }

    private boolean isIndexed(KeyDescription[] keys) {
        return keys != SequentialDFile.KEYS && keys != LineSequentialDFile.KEYS && keys != RelativeDFile.KEYS;
    }

    private String getLParamsEnd(KeyDescription[] keys) {
        String Return2 = keys == SequentialDFile.KEYS ? "0,3" : (keys == LineSequentialDFile.KEYS ? "0,4" : (keys == RelativeDFile.KEYS ? "0,2" : "" + keys.length));
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] k, byte[] collating, boolean assignExt) {
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (IscobolRuntimeException _ex) {
                return this.mapError(150, _ex.getErrNum(), IscobolRuntimeException.getErrorDesc(_ex.getErrNum()));
            }
            catch (CorbaException _ex) {
                return this.mapError(147, _ex.getError(), _ex.getMessage());
            }
            if (assignExt) {
                path = BaseFile.expandFileName(path);
            }
            String p_params = new String(IOUtil.int2Csv(new int[]{blockingFactor, preAllocate, extensionFactor, compressionFactor, ecryptionFlag}, new int[]{1, 1, 1, 3, 1}));
            String l_params = "" + maxRecordSize + "," + minRecordSize + "," + this.getLParamsEnd(k);
            StringBuffer ks = new StringBuffer();
            if (k.length > 0) {
                int i = 0;
                while (true) {
                    ks.append(k[i].toString());
                    if (++i >= k.length) break;
                    ks.append(',');
                }
            }
            if (this.getConn().make(path, comment, p_params, l_params, ks.toString(), collating) == 0) {
                return this.mapError();
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accesMode, boolean optional, boolean assignExt) {
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (IscobolRuntimeException _ex) {
                return this.mapError(150, _ex.getErrNum(), IscobolRuntimeException.getErrorDesc(_ex.getErrNum()));
            }
            catch (CorbaException _ex) {
                return this.mapError(147, _ex.getError(), _ex.getMessage());
            }
            if (assignExt) {
                path = BaseFile.expandFileName(path);
            }
            String l_params = "" + maxRec + "," + minRec + ",";
            l_params = k != null ? l_params + this.getLParamsEnd(k) : l_params + nKeys;
            switch (openType) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    this.theFile = this.getConn().open(path, openType, lockType, l_params);
                    if (this.theFile != 0) break;
                    return this.mapError();
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.openMode = openType;
            this.path = path;
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentRecord(long nRec) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn().setrec(this.theFile, nRec) == 0) {
                this.mapError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentRecord() {
        Object object = exit;
        synchronized (object) {
            long[] Return2 = new long[]{0L};
            if (this.getConn().getrec(this.theFile, Return2) == 0) {
                this.mapError();
            }
            return Return2[0];
        }
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() {
        Object object = exit;
        synchronized (object) {
            if (this.isOpen()) {
                this.openMode = 0;
                if (this.getConn().close(this.theFile) == 0) {
                    this.theFile = 0;
                    this.keys = null;
                    this.path = "";
                    return this.mapError();
                }
                this.theFile = 0;
                this.keys = null;
                this.path = "";
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(byte[] record, int offs, int size, boolean lock) {
        Object object = exit;
        synchronized (object) {
            FileServer conn = this.getConn();
            int Return2 = conn.write(this.theFile, record, offs, size, lock);
            this.errno = conn.f_errno;
            if (Return2 == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rewrite(byte[] record, int offs, int size, boolean lock) {
        Object object = exit;
        synchronized (object) {
            FileServer conn = this.getConn();
            int Return2 = conn.rewrite(this.theFile, record, offs, size, lock);
            this.errno = conn.f_errno;
            if (Return2 == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(byte[] record, int offs) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn().delete(this.theFile, record, offs) == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] record, int offs, int lock) {
        Object object = exit;
        synchronized (object) {
            FileServer conn = this.getConn();
            int Return2 = conn.next(this.theFile, record, offs, (short)lock);
            this.errno = conn.f_errno;
            if (Return2 == 0) {
                return this.mapError();
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] record, int offs, int lock) {
        Object object = exit;
        synchronized (object) {
            FileServer conn = this.getConn();
            int Return2 = conn.previous(this.theFile, record, offs, (short)lock);
            this.errno = conn.f_errno;
            if (Return2 == 0) {
                return this.mapError();
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        Object object = exit;
        synchronized (object) {
            FileServer conn = this.getConn();
            int Return2 = conn.read(this.theFile, record, offs, keyNum, (short)lock);
            this.errno = conn.f_errno;
            if (Return2 == 0) {
                return this.mapError();
            }
            return Return2;
        }
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        return this.read(record, offs, this.findKey(key), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start(byte[] record, int offs, int kNum, int kSize, int mode) {
        Object object = exit;
        synchronized (object) {
            int rc;
            switch (mode) {
                case 0: {
                    byte[] tmpBuf = new byte[record.length];
                    rc = this.getConn().start(this.theFile, tmpBuf, 0, kNum, kSize, mode);
                    break;
                }
                case 1: {
                    byte[] tmpBuf = new byte[record.length];
                    for (int i = record.length - 1; i >= 0; --i) {
                        tmpBuf[i] = -1;
                    }
                    rc = this.getConn().start(this.theFile, tmpBuf, 0, kNum, kSize, mode);
                    break;
                }
                case 5: {
                    rc = this.getConn().start(this.theFile, record, offs, kNum, kSize, mode);
                    break;
                }
                case 6: {
                    rc = this.getConn().start(this.theFile, record, offs, kNum, kSize, mode);
                    break;
                }
                case 7: {
                    rc = this.getConn().start(this.theFile, record, offs, kNum, kSize, mode);
                    break;
                }
                case 8: {
                    rc = this.getConn().start(this.theFile, record, offs, kNum, kSize, mode);
                    break;
                }
                case 9: {
                    rc = this.getConn().start(this.theFile, record, offs, kNum, kSize, mode);
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
                }
            }
            if (rc == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription k, int kSize, int mode) {
        return this.start(record, offs, this.findKey(k), kSize, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unlock() {
        int Return2;
        Object object = exit;
        synchronized (object) {
            Return2 = this.getConn().unlock(this.theFile);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(int allFiles) {
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (IscobolRuntimeException iscobolRuntimeException) {
            }
            catch (CorbaException corbaException) {
                // empty catch block
            }
            this.getConn().sync(allFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(String name) {
        int Return2;
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (IscobolRuntimeException _ex) {
                return this.mapError(150, _ex.getErrNum(), IscobolRuntimeException.getErrorDesc(_ex.getErrNum()));
            }
            catch (CorbaException _ex) {
                return this.mapError(147, _ex.getError(), _ex.getMessage());
            }
            Return2 = this.getConn().remove(name);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeEx(KeyDescription[] k, String name) {
        int Return2;
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (CorbaException _ex) {
                return this.mapError(147, _ex.getError(), _ex.getMessage());
            }
            if (this.isIndexed(k)) {
                Return2 = this.getConn().remove(name);
            } else {
                String l_params = "0,0," + this.getLParamsEnd(k);
                Return2 = this.getConn().removeEx(l_params, name);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rename(String src, String dst) {
        int Return2;
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (IscobolRuntimeException _ex) {
                return this.mapError(150, _ex.getErrNum(), IscobolRuntimeException.getErrorDesc(_ex.getErrNum()));
            }
            catch (CorbaException _ex) {
                return this.mapError(147, _ex.getError(), _ex.getMessage());
            }
            Return2 = this.getConn().rename(src, dst);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int renameEx(KeyDescription[] k, String src, String dst) {
        int Return2;
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (CorbaException _ex) {
                return this.mapError(147, _ex.getError(), _ex.getMessage());
            }
            if (this.isIndexed(k)) {
                Return2 = this.getConn().rename(src, dst);
            } else {
                String l_params = "0,0," + this.getLParamsEnd(k);
                Return2 = this.getConn().renameEx(l_params, src, dst);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int begin() {
        int Return2 = 0;
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (CorbaException _ex) {
                return this.mapError(147, _ex.getError(), _ex.getMessage());
            }
            Return2 = this.getConn().begin();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commit(int ctx) {
        int Return2 = 0;
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (CorbaException _ex) {
                return this.mapError(147, _ex.getError(), _ex.getMessage());
            }
            Return2 = this.getConn().commit(ctx);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rollback() {
        int Return2 = 0;
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (CorbaException _ex) {
                return this.mapError(147, _ex.getError(), _ex.getMessage());
            }
            Return2 = this.getConn().rollback();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int recover() {
        int Return2;
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (CorbaException _ex) {
                return this.mapError(147, _ex.getError(), _ex.getMessage());
            }
            Return2 = this.getConn().recover();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() {
        Object object = exit;
        synchronized (object) {
            try {
                this.init();
            }
            catch (CorbaException _ex) {
                return _ex.getMessage();
            }
            return this.getClass().getName() + "$Revision$||remote:" + this.getConn().version();
        }
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    public void finalize() {
        this.close();
    }

    public static String searchHost(BaseFile file) {
        String name = BaseFile.getBasename(file.getOsPath()).toLowerCase().replace('-', '_');
        String ft = "index.";
        String suff = "";
        if (file.getNumPath() > 0) {
            suff = suff + file.getNumPath();
        }
        if (file instanceof RelativeDFile) {
            ft = "relative.";
        } else if (file instanceof SequentialDFile) {
            ft = "sequential.";
        } else if (file instanceof LineSequentialDFile) {
            ft = "linesequential.";
        }
        String Return2 = Config.getProperty(".file.remote.host." + name + suff, "");
        if (Return2.length() == 0) {
            Return2 = Config.getProperty(".file." + ft + "remote.host", "");
        }
        if (Return2.length() == 0) {
            Return2 = Config.getProperty(".file.remote.host", "localhost");
        }
        return Return2;
    }

    public static int searchPort(BaseFile file) {
        String name = BaseFile.getBasename(file.getOsPath()).toLowerCase().replace('-', '_');
        String ft = "index.";
        String suff = "";
        if (file.getNumPath() > 0) {
            suff = suff + file.getNumPath();
        }
        if (file instanceof RelativeDFile) {
            ft = "relative.";
        } else if (file instanceof SequentialDFile) {
            ft = "sequential.";
        } else if (file instanceof LineSequentialDFile) {
            ft = "linesequential.";
        }
        int Return2 = Config.getProperty(".file.remote.port." + name + suff, -1);
        if (Return2 == -1) {
            Return2 = Config.getProperty(".file." + ft + "remote.port", -1);
        }
        if (Return2 == -1) {
            Return2 = Config.getProperty(".file.remote.port", 10997);
        }
        return Return2;
    }

    public static class MyConn {
        IscobolSystem.Context cont;
        FileServer mainConn;

        MyConn(FileServer c, IscobolSystem.Context t) {
            this.mainConn = c;
            this.cont = t;
        }

        public int call(String name, int n, ICobolVar[] args, int[] io) {
            if (this.mainConn != null) {
                return this.mainConn.call(name, n, args, io);
            }
            return -1000;
        }
    }

    public static class MyConnTable {
        Hashtable connections = new Hashtable();

        static MyConnTable get() {
            MyConnTable Return2 = (MyConnTable)IscobolSystem.get(MyConnTable.class);
            if (Return2 == null) {
                Return2 = new MyConnTable();
                IscobolSystem.set(MyConnTable.class, Return2);
            }
            return Return2;
        }
    }

    static class FileServer {
        private static final String id = "IDL:com/iscobol/io/DynamicRemote:1.0";
        private static final String key = "key";
        public short f_errno;
        public int f_int_errno;
        public String f_errmsg;
        private Server server;

        public static FileServer get(String host, int port) throws CorbaException {
            return new FileServer(host, port);
        }

        private FileServer(String host, int port) throws CorbaException {
            this.server = Server.get(host, port, id, key);
        }

        public int init() throws CorbaException {
            byte[] d2 = new byte[]{49, 57, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
            Object[] argv = new Object[5];
            argv[0] = new Principal(d2);
            this.server.call("D_init", argv);
            if (argv[0] != null) {
                String login = Config.getProperty(".user.name", "");
                String passwd = Config.getProperty(".user.password", ".user.passwd", "");
                int pwdSize = passwd.length() << 1;
                PicN cPwd = new PicN(new byte[pwdSize], 0, pwdSize, null, null, "", false, false);
                cPwd.set(passwd, false);
                PicXAnyLength rand = Factory.getVarXAnyLength(new byte[0], 0, 0, false, null, null, null, "rand", false, false);
                byte[] rndb = ((Principal)argv[0]).data;
                rand.set(rndb);
                String ALG = Auth.getAlgorithmFromChallenge(rand);
                PicXAnyLength hPwd = new PicXAnyLength(new byte[0], 0, 0, null, null, "", false, false);
                PicXAnyLength hhPw = new PicXAnyLength(new byte[0], 0, 0, null, null, "", false, false);
                Auth.getDigest(new CobolVar[]{hPwd, cPwd}, ALG);
                Auth.getDigest(new CobolVar[]{hhPw, rand, hPwd}, ALG);
                argv[3] = login;
                argv[4] = new Principal(((CobolVar)hhPw).getMemory());
                this.server.call("W_login", argv);
                int Return2 = (Integer)argv[0];
                try {
                    this.server.call("Z_checkver", argv);
                    int rc = (Integer)argv[0];
                    if (rc != 19) {
                        throw new IscobolRuntimeException(21, "(" + rc + "!=" + 19 + ")");
                    }
                }
                catch (IscobolRuntimeException _ex) {
                    throw new IscobolRuntimeException(21, _ex.getMessage());
                }
                return Return2;
            }
            throw new IscobolRuntimeException(21, " required Client 19");
        }

        public int exit() throws IscobolRuntimeException {
            Object[] argv = new Object[1];
            try {
                this.server.call("E_exit", argv);
            }
            catch (CorbaException _ex) {
                argv[0] = new Integer(147);
            }
            this.server.finalize();
            return (Integer)argv[0];
        }

        private void myCall(String fun, Object[] argv) {
            try {
                this.server.call(fun, argv);
            }
            catch (CorbaException _ex) {
                argv[0] = new Integer(0);
                argv[1] = new Short(147);
                argv[2] = new Integer(_ex.getError());
                this.f_errmsg = _ex.getMessage();
            }
        }

        public int make(String filename, String comment, String p_params, String l_params, String keys, byte[] coll) throws IscobolRuntimeException {
            Object[] argv = new Object[9];
            argv[3] = filename;
            argv[4] = comment;
            argv[5] = p_params;
            argv[6] = l_params;
            argv[7] = keys;
            argv[8] = coll != null ? new Principal(coll) : null;
            this.myCall("A_make", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int open(String filename, int iomode, int lckmode, String l_params) throws IscobolRuntimeException {
            int maxRec = Integer.parseInt(l_params.substring(0, l_params.indexOf(44)));
            Object[] argv = new Object[7];
            argv[3] = filename;
            argv[4] = new Short((short)iomode);
            argv[5] = new Short((short)lckmode);
            argv[6] = l_params;
            this.myCall("B_open", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int close(int fd) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[3] = new Integer(fd);
            this.myCall("C_close", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int write(int fd, byte[] rec, int offs, int size, boolean lock) throws IscobolRuntimeException {
            Object[] argv = new Object[7];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            argv[5] = new Integer(size);
            argv[6] = new Boolean(lock);
            this.myCall("F_write", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int rewrite(int fd, byte[] rec, int offs, int size, boolean lock) throws IscobolRuntimeException {
            Object[] argv = new Object[7];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            argv[5] = new Integer(size);
            argv[6] = new Boolean(lock);
            this.myCall("G_rewrite", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int delete(int fd, byte[] rec, int offs) throws IscobolRuntimeException {
            Object[] argv = new Object[5];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            this.myCall("H_delete", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int next(int fd, byte[] rec, int offs, short lock) throws IscobolRuntimeException {
            Object[] argv = new Object[7];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            argv[5] = new Integer(rec.length - offs);
            argv[6] = new Short(lock);
            this.myCall("I_next", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int previous(int fd, byte[] rec, int offs, short lock) throws IscobolRuntimeException {
            Object[] argv = new Object[7];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            argv[5] = new Integer(rec.length - offs);
            argv[6] = new Short(lock);
            this.myCall("J_previous", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int read(int fd, byte[] rec, int offs, int keyNum, short lock) throws IscobolRuntimeException {
            Object[] argv = new Object[7];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            argv[5] = new Integer(keyNum);
            argv[6] = new Short(lock);
            this.myCall("K_read", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int start(int fd, byte[] rec, int offs, int keyNum, int kSize, int mode) throws IscobolRuntimeException {
            Object[] argv = new Object[8];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            argv[5] = new Integer(keyNum);
            argv[6] = new Integer(kSize);
            argv[7] = new Short((short)mode);
            this.myCall("L_start", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int unlock(int fd) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[3] = new Integer(fd);
            this.myCall("M_unlock", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int sync(int allFiles) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[3] = new Integer(allFiles);
            this.myCall("N_sync", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int remove(String fName) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[3] = fName;
            this.myCall("O_remove", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int removeEx(String l_params, String fName) throws IscobolRuntimeException {
            Object[] argv = new Object[5];
            argv[3] = l_params;
            argv[4] = fName;
            this.myCall("O_removeEx", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int rename(String src, String dst) throws IscobolRuntimeException {
            Object[] argv = new Object[5];
            argv[3] = src;
            argv[4] = dst;
            this.myCall("P_rename", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int renameEx(String l_params, String src, String dst) throws IscobolRuntimeException {
            Object[] argv = new Object[6];
            argv[3] = l_params;
            argv[4] = src;
            argv[5] = dst;
            this.myCall("P_renameEx", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int info(int fd, int mode, byte[] rec) throws IscobolRuntimeException {
            Object[] argv = new Object[7];
            argv[3] = new Integer(fd);
            argv[4] = new Integer(mode);
            argv[5] = new Principal(rec);
            argv[6] = new Integer(rec.length);
            this.myCall("Q_info", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int begin() throws IscobolRuntimeException {
            Object[] argv = new Object[3];
            this.myCall("R_begin", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int commit(int ctx) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[3] = new Integer(ctx);
            this.myCall("S_commit", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int rollback() throws IscobolRuntimeException {
            Object[] argv = new Object[3];
            this.myCall("T_rollback", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int recover() throws IscobolRuntimeException {
            Object[] argv = new Object[3];
            this.myCall("U_recover", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public String version() throws IscobolRuntimeException {
            Object[] argv = new Object[1];
            try {
                this.server.call("V_version", argv);
            }
            catch (CorbaException _ex) {
                argv[0] = _ex.getMessage();
            }
            return argv[0].toString();
        }

        public int setrec(int fd, long nRec) throws IscobolRuntimeException {
            Object[] argv = new Object[5];
            argv[3] = new Integer(fd);
            argv[4] = new Long(nRec);
            this.myCall("X_setrec", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int getrec(int fd, long[] nRec) throws IscobolRuntimeException {
            Object[] argv = new Object[5];
            argv[3] = new Integer(fd);
            this.myCall("Y_getrec", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            nRec[0] = ((Long)argv[4]).intValue();
            return (Integer)argv[0];
        }

        public int call(String name, int nArgs, ICobolVar[] args, int[] io) throws IscobolRuntimeException {
            Object[] argv = new Object[3];
            argv[1] = name;
            argv[2] = new Object[nArgs];
            Object[] pi = new Object[nArgs];
            for (int i = 0; i < nArgs; ++i) {
                pi = new Object[2];
                if (io[i] > 0) {
                    pi[0] = new Integer(args[i].length());
                    pi[1] = new Principal(null, 0, 0);
                } else {
                    pi[0] = new Integer(io[i]);
                    pi[1] = new Principal(args[i].getBytes(), 0, args[i].length());
                }
                ((Object[])argv[2])[i] = pi;
            }
            try {
                this.server.call("a_call", argv);
            }
            catch (CorbaException _ex) {
                Server.throwException(_ex);
            }
            for (int i = 0; i < nArgs; ++i) {
                if (io[i] < 0) continue;
                pi = (Object[])((Object[])argv[2])[i];
                args[i].set(((Principal)pi[1]).data);
            }
            return (Integer)argv[0];
        }
    }

    static class Server
    extends IiopServer
    implements Corba,
    RuntimeErrorsNumbers {
        public static Server get(String host, int port, String id, String key) throws CorbaException {
            return new Server(new IORHelper(id, host, port, key));
        }

        private Server(IORHelper ior) throws CorbaException {
            super(new IiopObj(ior.toString()));
            this.methods = new Methods();
        }

        public synchronized void call(String name, Object[] argv) throws CorbaException {
            this.invoke(name, argv);
        }

        @Override
        public synchronized void finalize() {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        static void throwException(CorbaException _ex) throws IscobolRuntimeException {
            throw new IscobolRuntimeException(3, "IIOP: " + _ex.getMessage());
        }
    }
}

