/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.intf.Ctree;
import com.iscobol.io.BaseFile;
import com.iscobol.io.TransactionException;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.MonitorFinalize;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class DynamicCtree
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    private int theFile = -1;
    protected MyConn theConn;
    private int openMode = 0;
    private KeyDescription[] keys;
    private int maxRecordSize;
    private int minRecordSize;
    private String path = "";
    private int errno;
    private String sysError;
    private String errMsg;
    private static HashSet threads = new HashSet();
    private static final Object exit;
    private static HashMap issMap;
    private String fileName = "";
    private String issName = "";
    private static byte sign;
    private static Logger log;
    private static int ctreeVersion;
    private static boolean newConfig;
    private static int conf;
    private static int numConnection;

    private static int SetInstance(int[] item, int instance) {
        item[instance] = Ctree.ct_config(5, conf, -1, Config.getProperty(".file.index.server", "FAIRCOMS").trim(), Config.getProperty(".file.index.user", "").trim(), Config.getProperty(".file.index.password", "").trim(), Config.getProperty(".file.index.connect", true) ? "yes" : "no", Config.getProperty(".file.index.versioncheck", false) ? "yes" : "no");
        if (item[instance] < 0) {
            return -1;
        }
        String s = null;
        s = Config.getProperty(".file.index.log.file", null);
        if (s != null) {
            Ctree.ct_config(1, conf, item[instance], "log", "yes", "", "", "");
            Ctree.ct_config(1, conf, item[instance], "log.file", s.trim(), "", "", "");
            if (Config.getProperty(".file.index.log.error", false)) {
                Ctree.ct_config(1, conf, item[instance], "log.error", Config.getProperty(".file.index.log.error", false) ? "yes" : "no", "", "", "");
            }
            if (Config.getProperty(".file.index.log.info", false)) {
                Ctree.ct_config(1, conf, item[instance], "log.info", Config.getProperty(".file.index.log.info", false) ? "yes" : "no", "", "", "");
            }
            if (Config.getProperty(".file.index.log.profile", false)) {
                Ctree.ct_config(1, conf, item[instance], "log.profile", Config.getProperty(".file.index.log.profile", false) ? "yes" : "no", "", "", "");
            }
            if (Config.getProperty(".file.index.log.debug", false)) {
                Ctree.ct_config(1, conf, item[instance], "log.debug", Config.getProperty(".file.index.log.debug", false) ? "yes" : "no", "", "", "");
                if (Config.getProperty(".file.index.log.debug.config", false)) {
                    Ctree.ct_config(1, conf, item[instance], "log.debug.config", Config.getProperty(".file.index.log.debug.config", false) ? "yes" : "no", "", "", "");
                }
                if (Config.getProperty(".file.index.log.debug.config.full", false)) {
                    Ctree.ct_config(1, conf, item[instance], "log.debug.config.full", Config.getProperty(".file.index.log.debug.config.full", false) ? "yes" : "no", "", "", "");
                }
            }
        }
        if (Config.getProperty(".file.index.datacompress", false)) {
            Ctree.ct_config(1, conf, item[instance], "datacompress", Config.getProperty(".file.index.datacompress", false) ? "yes" : "no", "", "", "");
            s = Config.getProperty(".file.index.datacompress.type", null);
            if (s != null) {
                Ctree.ct_config(1, conf, item[instance], "datacompress.type", s.trim(), "", "", "");
            }
            if ((s = Config.getProperty(".file.index.datacompress.level", null)) != null) {
                Ctree.ct_config(1, conf, item[instance], "datacompress.level", s.trim(), "", "", "");
            }
            if ((s = Config.getProperty(".file.index.datacompress.strategy", null)) != null) {
                Ctree.ct_config(1, conf, item[instance], "datacompress.strategy", s.trim(), "", "", "");
            }
        }
        if (Config.getProperty(".file.index.keycompress", false)) {
            Ctree.ct_config(1, conf, item[instance], "keycompress", Config.getProperty(".file.index.keycompress", false) ? "yes" : "no", "", "", "");
            if (Config.getProperty(".file.index.keycompress.leading", false)) {
                Ctree.ct_config(1, conf, item[instance], "keycompress.leading", Config.getProperty(".file.index.keycompress.leading", false) ? "yes" : "no", "", "", "");
            }
            if (Config.getProperty(".file.index.keycompress.padding", false)) {
                Ctree.ct_config(1, conf, item[instance], "keycompress.padding", Config.getProperty(".file.index.keycompress.padding", false) ? "yes" : "no", "", "", "");
            }
        }
        if (Config.getProperty(".file.index.encrypt", false)) {
            Ctree.ct_config(1, conf, item[instance], "encrypt", Config.getProperty(".file.index.encrypt", false) ? "yes" : "no", "", "", "");
        }
        if (Config.getProperty(".file.index.memoryfile", false)) {
            Ctree.ct_config(1, conf, item[instance], "memoryfile", Config.getProperty(".file.index.memoryfile", false) ? "yes" : "no", "", "", "");
        }
        if ((s = Config.getProperty(".ctree.data_suffix", null)) != null) {
            Ctree.ct_config(1, conf, item[instance], "datafilesuffix", s.trim(), "", "", "");
        } else {
            s = Config.getProperty(".file.index.index.data_suffix", null);
            if (s != null) {
                Ctree.ct_config(1, conf, item[instance], "datafilesuffix", s.trim(), "", "", "");
            }
        }
        s = Config.getProperty(".ctree.index_suffix", null);
        if (s != null) {
            Ctree.ct_config(1, conf, item[instance], "indexfilesuffix", s.trim(), "", "", "");
        } else {
            s = Config.getProperty(".file.index.index.index_suffix", null);
            if (s != null) {
                Ctree.ct_config(1, conf, item[instance], "indexfilesuffix", s.trim(), "", "", "");
            }
        }
        if (Config.getProperty(".file.index.fixed_length", false)) {
            Ctree.ct_config(1, conf, item[instance], "ctfixed", Config.getProperty(".file.index.fixed_length", false) ? "yes" : "no", "", "", "");
        }
        if (Config.getProperty(".file.index.transaction", false)) {
            Ctree.ct_config(1, conf, item[instance], "transaction", Config.getProperty(".file.index.transaction", false) ? "yes" : "no", "", "", "");
            if (Config.getProperty(".file.index.transaction.logging", false)) {
                Ctree.ct_config(1, conf, item[instance], "transaction.logging", Config.getProperty(".file.index.transaction.logging", false) ? "yes" : "no", "", "", "");
            }
        }
        if (Config.getProperty(".file.index.rpc", false)) {
            Ctree.ct_config(1, conf, item[instance], "rpc", Config.getProperty(".file.index.rpc", false) ? "yes" : "no", "", "", "");
            if (Config.getProperty(".file.index.rcp.crc", false)) {
                Ctree.ct_config(1, conf, item[instance], "rcp.crc", Config.getProperty(".file.index.rcp.crc", false) ? "yes" : "no", "", "", "");
            }
        }
        if (Config.getProperty(".file.index.lock_wait", false)) {
            Ctree.ct_config(1, conf, item[instance], "retrylock", Config.getProperty(".file.index.lock_wait", false) ? "yes" : "no", "", "", "");
        }
        if (Config.getProperty(".file.index.lock_read_anyhow", false)) {
            Ctree.ct_config(1, conf, item[instance], "ignorelock", Config.getProperty(".file.index.lock_read_anyhow", false) ? "yes" : "no", "", "", "");
        }
        if (Config.getProperty(".file.index.skiplock", false)) {
            Ctree.ct_config(1, conf, item[instance], "skiplock", Config.getProperty(".file.index.skiplock", false) ? "yes" : "no", "", "", "");
        }
        if (Config.getProperty(".file.index.autolock_allowed", false)) {
            Ctree.ct_config(1, conf, item[instance], "runitlockdetect", Config.getProperty(".file.index.autolock_allowed", false) ? "yes" : "no", "", "", "");
        }
        if (Config.getProperty(".file.index.read_lock_test", false)) {
            Ctree.ct_config(1, conf, item[instance], "locktype", Config.getProperty(".file.index.read_lock_test", false) ? "yes" : "no", "", "", "");
        }
        if (Config.getProperty(".file.index.bulkaddition", false)) {
            Ctree.ct_config(1, conf, item[instance], "bulkaddition", Config.getProperty(".file.index.bulkaddition", false) ? "yes" : "no", "", "", "");
        }
        if (Config.getProperty(".file.index.batchaddition", false)) {
            Ctree.ct_config(1, conf, item[instance], "batchaddition", Config.getProperty(".file.index.batchaddition", false) ? "yes" : "no", "", "", "");
            s = Config.getProperty(".file.index.batchaddition.records", null);
            if (s != null) {
                Ctree.ct_config(1, conf, item[instance], "batchaddition.records", s.trim(), "", "", "");
            }
        }
        if (Config.getProperty(".file.index.prefetch", false)) {
            Ctree.ct_config(1, conf, item[instance], "prefetch", Config.getProperty(".file.index.prefetch", false) ? "yes" : "no", "", "", "");
            s = Config.getProperty(".file.index.prefetch.records", null);
            if (s != null) {
                Ctree.ct_config(1, conf, item[instance], "prefetch.records", s.trim(), "", "", "");
            }
        }
        int file = Ctree.ct_config(7, conf, item[instance], Config.getProperty(".file.index.name", "*").trim(), Config.getProperty(".file.index.dir", "*").trim(), "", "", "");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicCtree() {
        Object object = exit;
        synchronized (object) {
            this.theConn = (MyConn)IscobolSystem.get(MyConn.class);
            if (this.theConn == null) {
                MyConn conn;
                if (newConfig) {
                    Ctree.ct_init2(conf);
                } else {
                    Ctree.ct_init();
                }
                ++numConnection;
                this.theConn = conn = new MyConn(Ctree.ct_threadid(), Thread.currentThread());
                if (conn.conn >= 0) {
                    IscobolSystem.set(MyConn.class, conn);
                    Factory.getCurrentMonitor().addObjToFinalize(new MonitorFinalize(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void monitorFinalize() {
                            Object object = exit;
                            synchronized (object) {
                                if (Thread.currentThread() == DynamicCtree.this.getThread()) {
                                    numConnection--;
                                    if (log != null) {
                                        log.info("ct_exit cth: " + DynamicCtree.this.getConn() + " ith: " + Thread.currentThread() + " connection n: " + numConnection);
                                    }
                                    if (newConfig) {
                                        Ctree.ct_exit2();
                                    } else {
                                        Ctree.ct_exit();
                                    }
                                    conn.conn = -1;
                                    DynamicCtree.this.theConn.conn = -1;
                                }
                            }
                        }
                    });
                }
                if (log != null) {
                    log.info("ct_init cth: " + this.getConn() + " ith: " + Thread.currentThread() + " connection n: " + numConnection);
                }
            } else {
                this.attachTh("init");
            }
        }
    }

    @Override
    public String getSysErrno() {
        return this.sysError;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 1: {
                return 133;
            }
            case 2: {
                return 102;
            }
            case 3: {
                return 104;
            }
            case 4: {
                return 125;
            }
            case 5: {
                return 107;
            }
            case 6: {
                return 105;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 111;
            }
            case 9: {
                return 112;
            }
            case 10: {
                return 127;
            }
            case 11: {
                return 113;
            }
            case 12: {
                return 128;
            }
            case 13: {
                return 102;
            }
            case 14: {
                return 116;
            }
            case 15: {
                return 130;
            }
            case 16: {
                return 131;
            }
            case 17: {
                return 126;
            }
            case 18: {
                return 129;
            }
            case 19: {
                return 140;
            }
            case 20: {
                return 133;
            }
            case 22: {
                return 122;
            }
            case 100: {
                return 204;
            }
            case 101: {
                return 200;
            }
        }
        return 134;
    }

    private void setLock(int lock) {
        switch (lock) {
            case -1: {
                Ctree.set_f_no_lock((short)2);
                break;
            }
            case 0: {
                Ctree.set_f_no_lock((short)1);
                break;
            }
            case 1: {
                Ctree.set_f_no_lock((short)0);
                break;
            }
            case 2: {
                Ctree.set_f_no_lock((short)-1);
            }
        }
    }

    private int attachTh(String text) {
        if (Thread.currentThread() != this.getThread() && threads.add(Thread.currentThread())) {
            if (log != null) {
                log.info("new Thread:  " + this.getConn() + " ith: " + Thread.currentThread() + " connection n: " + numConnection);
            }
            Factory.getCurrentMonitor().addObjToFinalize(new MonitorFinalize(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void monitorFinalize() {
                    MyConn myConn = DynamicCtree.this.theConn;
                    synchronized (myConn) {
                        if (log != null) {
                            log.info("monitorFinalize:  " + DynamicCtree.this.getConn() + " ith: " + Thread.currentThread() + " connection n: " + numConnection);
                        }
                        if (DynamicCtree.this.getConn() >= 0) {
                            Ctree.ct_detach();
                        }
                        threads.remove(Thread.currentThread());
                    }
                }
            });
            Ctree.ct_attach(this.getConn());
        }
        return this.getConn();
    }

    private int getConn() {
        return this.theConn.conn;
    }

    private Thread getThread() {
        return this.theConn.cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumRecords() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            byte[] result = new byte[11];
            if (this.attachTh("info") < 0) {
                return this.mapError(1, 5510);
            }
            int rc = Ctree.ct_info(this.theFile, -4, result);
            return Long.parseLong(new String(result, 0, 10));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumKeys() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.keys == null) {
                if (this.attachTh("info") < 0) {
                    return this.mapError(1, 5510);
                }
                byte[] result = new byte[256];
                int rc = Ctree.ct_info(this.theFile, -1, result);
                if (rc == 0) {
                    return this.mapError();
                }
                int[] values = IOUtil.csv2Int(result);
                this.maxRecordSize = values[0];
                this.minRecordSize = values[1];
                this.keys = new KeyDescription[values[2]];
            }
            return this.keys.length;
        }
    }

    @Override
    public int getMaxRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.minRecordSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyDescription getKey(int num) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            KeyDescription Return2;
            if (num >= 0 && num < this.getNumKeys()) {
                if (this.keys[num] == null) {
                    byte[] result = new byte[256];
                    if (this.attachTh("info") < 0) {
                        this.mapError(1, 5510);
                        return null;
                    }
                    int rc = Ctree.ct_info(this.theFile, num, result);
                    if (rc == 0) {
                        this.mapError();
                        return null;
                    }
                    this.keys[num] = new KeyDescription(result);
                }
                Return2 = this.keys[num];
            } else {
                Return2 = null;
                this.mapError(2);
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSequence() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            byte[] result = new byte[256];
            if (this.attachTh("info") < 0) {
                this.mapError(1, 5510);
                return null;
            }
            int rc = Ctree.ct_info(this.theFile, -5, result);
            if (rc == 0) {
                this.mapError();
                return null;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findKey(KeyDescription key) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int Return2;
            int nKeys = this.getNumKeys();
            try {
                for (Return2 = 0; Return2 < nKeys && !key.equals(this.getKey(Return2)); ++Return2) {
                }
            }
            catch (NullPointerException e) {
                Return2 = -1;
            }
            return Return2;
        }
    }

    private int mapError(int err, int sys) {
        this.errno = err;
        this.sysError = "" + sys;
        this.errMsg = "";
        return 0;
    }

    private int mapError(int err) {
        this.errno = err;
        this.sysError = "";
        this.errMsg = "";
        return 0;
    }

    private int mapError() {
        this.errno = Ctree.get_f_errno();
        this.sysError = "" + Ctree.get_f_int_errno();
        this.errMsg = "" + Ctree.get_f_errmsg();
        return 0;
    }

    int mapOpen(int mode, int lockType) {
        int Return2;
        switch (mode) {
            default: {
                Return2 = 0;
                break;
            }
            case 2: {
                Return2 = 1;
                break;
            }
            case 3: {
                Return2 = 2;
                break;
            }
            case 6: {
                Return2 = 3;
            }
        }
        switch (lockType & 0xF) {
            default: {
                break;
            }
            case 1: 
            case 6: {
                Return2 |= 0x300;
                break;
            }
            case 4: {
                Return2 |= 0x200;
                break;
            }
            case 3: 
            case 5: {
                Return2 |= 0x100;
            }
        }
        if ((lockType & 0x100) != 0) {
            Return2 |= 0x10;
        }
        if ((lockType & 0x200) != 0) {
            Return2 |= 0x600;
        }
        if ((lockType & 0x400) != 0) {
            Return2 |= 0x8000;
        }
        if ((lockType & 0x800) != 0) {
            Return2 |= 0x4000;
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            String issPath;
            if (assignExt) {
                path = BaseFile.expandFileName(path);
            }
            if (this.attachTh("make") < 0) {
                return this.mapError(1, 5510);
            }
            String p_params = new String(IOUtil.int2Csv(new int[]{blockingFactor, preAllocate, extensionFactor, compressionFactor, ecryptionFlag}, new int[]{1, 1, 1, 3, 1}));
            String l_params = "" + maxRecordSize + "," + minRecordSize + "," + keys.length;
            StringBuffer ks = new StringBuffer();
            int i = 0;
            while (true) {
                ks.append(keys[i].toString());
                if (++i >= keys.length) break;
                ks.append(',');
            }
            this.attachTh("make");
            if (Ctree.ct_make(path, comment, p_params, l_params, ks.toString(), collating) == 0) {
                return this.mapError();
            }
            if (Config.getProperty(".sqlserver.iss", false) && !(issPath = Config.getProperty(".sqlserver.isspath", "").trim()).equals("")) {
                if (this.setFileName(path, issPath)) {
                    File tFile = new File(issPath + File.separator + this.issName + ".iss");
                    if (tFile.exists()) {
                        if (log != null) {
                            log.info("OPENING: " + issPath + File.separator + this.issName + ".iss successful");
                        }
                        this.theFile = Ctree.ct_open(path, 1, l_params);
                        if (this.theFile >= 0) {
                            try {
                                int len;
                                InputStreamReader r = new InputStreamReader(new FileInputStream(issPath + File.separator + this.issName + ".iss"));
                                StringWriter w = new StringWriter();
                                char[] buffer = new char[1024];
                                while ((len = r.read(buffer)) != -1) {
                                    w.write(buffer, 0, len);
                                }
                                int Return2 = Ctree.ct_sqlinfo(this.theFile, w.toString(), sign);
                                Ctree.ct_close(this.theFile);
                                Return2 = Ctree.ct_sqllink(path, Config.getProperty(".sqlserver.database", "ctreeSQL").trim(), this.fileName, Config.getProperty(".sqlserver.password", "ADMIN").trim());
                                if (log != null) {
                                    if (Return2 == 0) {
                                        log.info("SQLLINK failed");
                                    } else {
                                        log.info("SQLLINK successful: " + path + " " + this.fileName);
                                    }
                                }
                                ((Reader)r).close();
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                            }
                            catch (IOException iOException) {}
                        }
                    } else if (log != null) {
                        log.info("OPENING: " + issPath + File.separator + this.fileName.toLowerCase() + ".iss failed");
                    }
                } else if (log != null) {
                    log.info("OPENING: " + issPath + File.separator + this.fileName.toLowerCase() + ".iss failed");
                }
            }
            return 1;
        }
    }

    private boolean setFileName(String path, String issPath) {
        String dirlevel = Config.getProperty(".sqlserver.dirlevel", "").trim();
        path = path.replace('\\', '/').replace('.', '_').replace('-', '_');
        this.fileName = path.substring(path.lastIndexOf("/") + 1);
        if (dirlevel.length() != 0 && !dirlevel.equals("0")) {
            int j = path.lastIndexOf("/") - 1;
            int level = Integer.parseInt(dirlevel);
            for (int i = j; i >= 0; --i) {
                if (path.charAt(i) != '/') continue;
                this.fileName = path.substring(i + 1, j + 1) + this.fileName;
                j = i - 1;
                if (--level == 0) break;
            }
            if (log != null) {
                log.info("DIRLEVEL: " + path + " to " + this.fileName);
            }
        }
        for (Map.Entry entry : issMap.entrySet()) {
            if (!this.fileName.toLowerCase().matches((String)entry.getKey())) continue;
            this.issName = (String)entry.getValue();
            return true;
        }
        File tFile = new File(issPath + File.separator + this.fileName.toLowerCase() + ".iss");
        if (tFile.exists()) {
            this.issName = this.fileName.toLowerCase();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accesMode, boolean optional, boolean assignExt) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (assignExt) {
                path = BaseFile.expandFileName(path);
            }
            if (this.attachTh("open") < 0) {
                return this.mapError(1, 5510);
            }
            String l_params = "" + maxRec + "," + minRec + "," + nKeys;
            switch (openType) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    this.theFile = Ctree.ct_open(path, this.mapOpen(openType, lockType), l_params);
                    if (this.theFile >= 0) break;
                    return this.mapError();
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.openMode = openType;
            this.path = path;
            return 1;
        }
    }

    @Override
    public void setCurrentRecord(long nRec) {
    }

    @Override
    public long getCurrentRecord() {
        return 0L;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.isOpen()) {
                this.openMode = 0;
                if (this.getConn() >= 0 && this.attachTh("close") >= 0 && Ctree.ct_close(this.theFile) == 0) {
                    return this.mapError();
                }
                this.theFile = -1;
                this.keys = null;
                this.path = "";
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(byte[] record, int offs, int size, boolean lock) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("write") < 0) {
                return this.mapError(1, 5510);
            }
            if (this.minRecordSize == this.maxRecordSize) {
                size = this.maxRecordSize;
            }
            if (lock) {
                this.setLock(1);
            } else {
                this.setLock(0);
            }
            int rc = Ctree.ct_write(this.theFile, record, offs, size);
            this.errno = Ctree.get_f_errno();
            if (rc == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rewrite(byte[] record, int offs, int size, boolean lock) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("rewrite") < 0) {
                return this.mapError(1, 5510);
            }
            if (this.minRecordSize == this.maxRecordSize) {
                size = this.maxRecordSize;
            }
            if (lock) {
                this.setLock(1);
            } else {
                this.setLock(0);
            }
            int rc = Ctree.ct_rewrite(this.theFile, record, offs, size);
            this.errno = Ctree.get_f_errno();
            if (rc == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(byte[] record, int offs) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("delete") < 0) {
                return this.mapError(1, 5510);
            }
            if (Ctree.ct_delete(this.theFile, record, offs) == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] record, int offs, int lock) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("next") < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(lock);
            int Return2 = Ctree.ct_next(this.theFile, record, offs);
            this.errno = Ctree.get_f_errno();
            if (Return2 == 0) {
                return this.mapError();
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] record, int offs, int lock) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("previous") < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(lock);
            int Return2 = Ctree.ct_previous(this.theFile, record, offs);
            this.errno = Ctree.get_f_errno();
            if (Return2 == 0) {
                return this.mapError();
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("read") < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(lock);
            int Return2 = Ctree.ct_read(this.theFile, record, offs, keyNum);
            this.errno = Ctree.get_f_errno();
            if (Return2 == 0) {
                return this.mapError();
            }
            return Return2;
        }
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        return this.read(record, offs, this.findKey(key), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start(byte[] record, int offs, int kNum, int kSize, int mode) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int rc;
            if (this.attachTh("start") < 0) {
                return this.mapError(1, 5510);
            }
            switch (mode) {
                case 0: {
                    byte[] tmpBuf = new byte[record.length];
                    rc = Ctree.ct_start(this.theFile, tmpBuf, 0, kNum, kSize, 1);
                    break;
                }
                case 1: {
                    byte[] tmpBuf = new byte[record.length];
                    for (int i = record.length - 1; i >= 0; --i) {
                        tmpBuf[i] = -1;
                    }
                    rc = Ctree.ct_start(this.theFile, tmpBuf, 0, kNum, kSize, 4);
                    break;
                }
                case 5: {
                    rc = Ctree.ct_start(this.theFile, record, offs, kNum, kSize, 0);
                    break;
                }
                case 6: {
                    rc = Ctree.ct_start(this.theFile, record, offs, kNum, kSize, 2);
                    break;
                }
                case 7: {
                    rc = Ctree.ct_start(this.theFile, record, offs, kNum, kSize, 1);
                    break;
                }
                case 8: {
                    rc = Ctree.ct_start(this.theFile, record, offs, kNum, kSize, 3);
                    break;
                }
                case 9: {
                    rc = Ctree.ct_start(this.theFile, record, offs, kNum, kSize, 4);
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
                }
            }
            if (rc == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription k, int kSize, int mode) {
        return this.start(record, offs, this.findKey(k), kSize, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unlock() {
        int Return2;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("unlock") < 0) {
                return this.mapError(1, 5510);
            }
            Return2 = Ctree.ct_unlock(this.theFile);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(int allFiles) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("sync") >= 0) {
                Ctree.ct_sync(allFiles);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(String name) {
        int Return2;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("remove") < 0) {
                return this.mapError(1, 5510);
            }
            Return2 = Ctree.ct_remove(name);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rename(String src, String dst) {
        int Return2;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("rename") < 0) {
                return this.mapError(1, 5510);
            }
            Return2 = Ctree.ct_rename(src, dst);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int begin() {
        int Return2 = 0;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("begin") < 0) {
                return this.mapError(1, 5510);
            }
            Return2 = Ctree.ct_begin();
            if (Return2 == 0) {
                this.errno = 22;
                TransactionException.get(this.getCobErrno(), "98", 13);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commit(int ctx) {
        int Return2 = 0;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("commit") < 0) {
                return this.mapError(1, 5510);
            }
            Return2 = Ctree.ct_commit(ctx);
            if (Return2 == 0) {
                this.errno = 22;
                TransactionException.get(this.getCobErrno(), "98", 13);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rollback() {
        int Return2 = 0;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("rollback") < 0) {
                return this.mapError(1, 5510);
            }
            Return2 = Ctree.ct_rollback();
            if (Return2 == 0) {
                this.errno = 22;
                TransactionException.get(this.getCobErrno(), "98", 14);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int recover() {
        int Return2;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.attachTh("recover") < 0) {
                return this.mapError(1, 5510);
            }
            Return2 = Ctree.ct_recover();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int intVersionLen;
            int fileVersionLen;
            int nameLen;
            byte[] name = new byte[255];
            byte[] fileVersion = new byte[255];
            byte[] intVersion = new byte[255];
            int rc = Ctree.ct_version(name, fileVersion, intVersion, 0, null);
            for (nameLen = 0; nameLen < name.length && name[nameLen] != 0; ++nameLen) {
            }
            for (fileVersionLen = 0; fileVersionLen < fileVersion.length && fileVersion[fileVersionLen] != 0; ++fileVersionLen) {
            }
            for (intVersionLen = 0; intVersionLen < intVersion.length && intVersion[intVersionLen] != 0; ++intVersionLen) {
            }
            return new String(name, 0, nameLen) + ";" + new String(fileVersion, 0, fileVersionLen) + ";" + new String(intVersion, 0, intVersionLen);
        }
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = exit;
        synchronized (object) {
            if (log != null) {
                log.info("FINALIZE:  " + this.getConn() + " ith: " + Thread.currentThread() + " connection n: " + numConnection);
            }
            this.close();
        }
    }

    static {
        issMap = new HashMap();
        sign = (byte)65;
        ctreeVersion = 0;
        newConfig = false;
        conf = 0;
        numConnection = 0;
        exit = new Object(){

            protected void finalize() {
            }
        };
        newConfig = Config.getProperty(".ctree.new_config", true);
        log = LoggerFactory.get(1);
        if (Config.getProperty(".sqlserver.iss", false)) {
            String s = Config.getProperty(".sqlserver.convention", "A").trim();
            sign = s.equals("") ? (byte)65 : (byte)s.charAt(0);
            Properties props = Config.getIscobolProperties();
            Enumeration<?> num = props.propertyNames();
            while (num.hasMoreElements()) {
                String propName = num.nextElement().toString();
                if (!propName.startsWith("sqlserver.iss.mapping")) continue;
                String propValue = (String)props.get(propName);
                String[] temp = propName.split("\\.");
                if (temp.length != 4) continue;
                issMap.put(temp[3].replaceAll("\\*", ".*"), propValue);
            }
        }
        if (newConfig) {
            int maxInstance = Config.getProperty(".file.index.maxinstance", 2);
            if (maxInstance < 1 || maxInstance > 99) {
                maxInstance = 2;
            }
            int[] item = new int[maxInstance];
            conf = Ctree.ct_config(4, -1, -1, "", "", "", "", "");
            Runtime.getRuntime().addShutdownHook(new Thread("IscobolThread-ShutdownHook"){

                @Override
                public void run() {
                    if (numConnection <= 0) {
                        if (log != null) {
                            log.info("ct_config remove: " + Thread.currentThread() + " connection n: " + numConnection);
                        }
                        Ctree.ct_config(8, conf, -1, "", "", "", "", "");
                    }
                }
            });
            if (log != null) {
                log.info("ct_config adding");
            }
            DynamicCtree.SetInstance(item, 0);
            for (int instance = 1; instance <= maxInstance; ++instance) {
                String s = null;
                s = Config.getProperty(".file.index." + instance + ".server", null);
                if (s == null || DynamicCtree.SetInstance(item, instance) != -1 || log == null) continue;
                log.info("Instance [" + instance + "] failed : " + Config.getProperty(".file.index.server", "FAIRCOMS").trim() + "," + Config.getProperty(".file.index.user", "").trim() + "," + Config.getProperty(".file.index.password", "").trim() + "," + Config.getProperty(".file.index.connect", true) + "," + Config.getProperty(".file.index.versioncheck", false));
            }
        }
    }

    private static class MyConn {
        int conn;
        Thread cont;

        MyConn(int c, Thread t) {
            this.conn = c;
            this.cont = t;
        }
    }
}

