/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.iiop.Corba;
import IT.picosoft.iiop.CorbaArg;
import IT.picosoft.iiop.CorbaException;
import IT.picosoft.iiop.CorbaMethod;
import IT.picosoft.iiop.IiopServer;
import IT.picosoft.iiop.Principal;
import com.iscobol.io.BaseFile;
import com.iscobol.io.TransactionException;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.MonitorFinalize;
import com.iscobol.rts.RuntimeErrorsNumbers;

public class DynamicConnector
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    public static final int Finput = 0;
    public static final int Foutput = 1;
    public static final int Fio = 2;
    public static final int Fextend = 3;
    public static final int Fopen_mask = 3;
    public static final int Ftext = 4;
    public static final int Fbinary = 0;
    public static final int Flocal_only = 8;
    public static final int Fmulti_lock = 16;
    public static final int Fmulti_records = 32;
    public static final int Ftruncate = 64;
    public static final int Fread_lock = 256;
    public static final int Fwrite_lock = 512;
    public static final int Fbuffered = 1024;
    public static final int Fmass_update = 1536;
    public static final int Flock_mask = 1792;
    public static final int Fis_device = 2048;
    public static final int Fopt_lock = 4096;
    public static final int Fappend = 8192;
    public static final int Ftrans = 16384;
    public static final int F_EQUALS = 0;
    public static final int F_NOT_LESS = 1;
    public static final int F_GREATER = 2;
    public static final int F_LESS = 3;
    public static final int F_NOT_GREATER = 4;
    public static final int E_SYS_ERR = 1;
    public static final int E_PARAM_ERR = 2;
    public static final int E_TOO_MANY_FILES = 3;
    public static final int E_MODE_CLASH = 4;
    public static final int E_REC_LOCKED = 5;
    public static final int E_BROKEN = 6;
    public static final int E_DUPLICATE = 7;
    public static final int E_NOT_FOUND = 8;
    public static final int E_UNDEF_RECORD = 9;
    public static final int E_DISK_FULL = 10;
    public static final int E_FILE_LOCKED = 11;
    public static final int E_REC_CHANGED = 12;
    public static final int E_MISMATCH = 13;
    public static final int E_NO_MEMORY = 14;
    public static final int E_MISSING_FILE = 15;
    public static final int E_PERMISSION = 16;
    public static final int E_NO_SUPPORT = 17;
    public static final int E_NO_LOCKS = 18;
    public static final int E_INTERFACE = 19;
    public static final int E_LICENSE_ERR = 20;
    public static final int E_UNKNOWN_ERR = 21;
    public static final int E_TRANSACTION = 22;
    public static final int W_NO_SUPPORT = 100;
    public static final int W_DUP_OK = 101;
    public static final int W_WRONG_LEN_OK = 151;
    public static final int W_MISSING_OK = 152;
    private int theFile = -1;
    protected MyConn theConn;
    private int openMode = 0;
    private KeyDescription[] keys;
    private int maxRecordSize;
    private int minRecordSize;
    private String path = "";
    private int errno;
    private String sysError;
    private String errMsg;
    protected static final Object exit = "";

    protected DynamicConnector(int dummy) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicConnector() {
        Object object = exit;
        synchronized (object) {
            Class<?> self = this.getClass();
            this.theConn = (MyConn)IscobolSystem.get(self);
            if (this.theConn == null) {
                String servPgm = this.getServerPgm();
                final MyConn conn = new MyConn(FileServer.get(servPgm), IscobolSystem.getContext());
                conn.conn.init();
                this.theConn = conn;
                if (conn.conn != null) {
                    IscobolSystem.set(self, conn);
                    Factory.getCurrentMonitor().addObjToFinalize(new MonitorFinalize(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void monitorFinalize() {
                            Object object = exit;
                            synchronized (object) {
                                if (IscobolSystem.getContext() == DynamicConnector.this.getContext()) {
                                    conn.conn.exit();
                                    conn.conn = null;
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    protected String getServerPgm() {
        return Config.getProperty(".file.connector.program", "fscsc") + " 1:" + Thread.currentThread().getName().replace(' ', '-');
    }

    @Override
    public String getSysErrno() {
        return this.sysError;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 1: {
                return 133;
            }
            case 2: {
                return 102;
            }
            case 3: {
                return 104;
            }
            case 4: {
                return 125;
            }
            case 5: {
                return 107;
            }
            case 6: {
                return 105;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 111;
            }
            case 9: {
                return 112;
            }
            case 10: {
                return 127;
            }
            case 11: {
                return 113;
            }
            case 12: {
                return 128;
            }
            case 13: {
                return 128;
            }
            case 14: {
                return 116;
            }
            case 15: {
                return 130;
            }
            case 16: {
                return 131;
            }
            case 17: {
                return 126;
            }
            case 18: {
                return 129;
            }
            case 19: {
                return 140;
            }
            case 20: {
                return 133;
            }
            case 22: {
                return 122;
            }
            case 100: {
                return 204;
            }
            case 101: {
                return 200;
            }
            case 151: {
                return 201;
            }
            case 152: {
                return 203;
            }
            case 21: {
                return 134;
            }
        }
        if ((this.errno & 0x7FFF0000) != 0) {
            return this.errno;
        }
        return 134;
    }

    protected FileServer getConn() {
        return this.theConn.conn;
    }

    protected IscobolSystem.Context getContext() {
        return this.theConn.cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumRecords() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            byte[] result = new byte[11];
            int rc = this.getConn().info(this.theFile, -4, result);
            return Long.parseLong(new String(result, 0, 10));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumKeys() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.keys == null) {
                byte[] result = new byte[256];
                int rc = this.getConn().info(this.theFile, -1, result);
                if (rc == 0) {
                    return this.mapError();
                }
                int[] values = IOUtil.csv2Int(result);
                this.maxRecordSize = values[0];
                this.minRecordSize = values[1];
                this.keys = new KeyDescription[values[2]];
            }
            return this.keys.length;
        }
    }

    @Override
    public int getMaxRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.minRecordSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyDescription getKey(int num) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            KeyDescription Return2;
            if (num >= 0 && num < this.getNumKeys()) {
                if (this.keys[num] == null) {
                    byte[] result = new byte[256];
                    int rc = this.getConn().info(this.theFile, num, result);
                    if (rc == 0) {
                        this.mapError();
                        return null;
                    }
                    this.keys[num] = new KeyDescription(result);
                }
                Return2 = this.keys[num];
            } else {
                Return2 = null;
                this.mapError(2);
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSequence() {
        byte[] Return2 = new byte[256];
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int rc = this.getConn().info(this.theFile, -5, Return2);
            if (rc == 0) {
                this.mapError();
                return null;
            }
            return Return2;
        }
    }

    private int findKey(KeyDescription key) {
        int Return2;
        int nKeys = this.getNumKeys();
        try {
            for (Return2 = 0; Return2 < nKeys && !key.equals(this.getKey(Return2)); ++Return2) {
            }
        }
        catch (NullPointerException e) {
            Return2 = -1;
        }
        return Return2;
    }

    private int mapError(int err, int sys) {
        this.errno = err;
        this.sysError = "" + sys;
        this.errMsg = "";
        return 0;
    }

    private int mapError(int err) {
        this.errno = err;
        this.sysError = "";
        this.errMsg = "";
        return 0;
    }

    private int mapError() {
        return this.mapError(this.getConn());
    }

    private int mapError(FileServer conn) {
        this.errno = conn.f_errno;
        int int_errno = conn.f_int_errno;
        if (this.errno == 21 && (int_errno & 0x7FFF0000) != 0) {
            this.errno = int_errno;
            this.sysError = "HEX FS=" + Integer.toHexString(int_errno & 0xFFFF);
        } else {
            short f_int_errno = (short)(int_errno & 0xFFFF);
            short f_int2_errno = (short)(int_errno >>> 16);
            this.sysError = "" + f_int_errno + "," + f_int2_errno;
        }
        this.errMsg = "";
        return 0;
    }

    int mapOpen(int mode, int lockType) {
        int Return2;
        switch (mode) {
            default: {
                Return2 = 0;
                break;
            }
            case 2: {
                Return2 = 1;
                break;
            }
            case 3: {
                Return2 = 2;
                break;
            }
            case 6: {
                Return2 = 3;
            }
        }
        switch (lockType & 0xF) {
            default: {
                break;
            }
            case 1: 
            case 6: {
                Return2 |= 0x300;
                break;
            }
            case 4: {
                Return2 |= 0x200;
                break;
            }
            case 3: 
            case 5: {
                Return2 |= 0x100;
            }
        }
        if ((lockType & 0x100) != 0) {
            Return2 |= 0x10;
        }
        if ((lockType & 0x200) != 0) {
            Return2 |= 0x600;
        }
        if ((lockType & 0x800) != 0) {
            Return2 |= 0x4000;
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (assignExt) {
                path = BaseFile.expandFileName(path);
            }
            String p_params = new String(IOUtil.int2Csv(new int[]{blockingFactor, preAllocate, extensionFactor, compressionFactor, ecryptionFlag}, new int[]{1, 1, 1, 3, 1}));
            String l_params = "" + maxRecordSize + "," + minRecordSize + "," + keys.length;
            StringBuffer ks = new StringBuffer();
            int i = 0;
            while (true) {
                ks.append(keys[i].toString());
                if (++i >= keys.length) break;
                ks.append(',');
            }
            if (this.getConn().make(path, comment, p_params, l_params, ks.toString(), collating) == 0) {
                return this.mapError();
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accesMode, boolean optional, boolean assignExt) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (assignExt) {
                path = BaseFile.expandFileName(path);
            }
            String l_params = "" + maxRec + "," + minRec + "," + nKeys;
            switch (openType) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    this.theFile = this.getConn().open(path, this.mapOpen(openType, lockType), l_params);
                    if (this.theFile != 0) break;
                    return this.mapError();
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.openMode = openType;
            this.path = path;
            return 1;
        }
    }

    @Override
    public void setCurrentRecord(long nRec) {
    }

    @Override
    public long getCurrentRecord() {
        return 0L;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.isOpen()) {
                FileServer fs = this.getConn();
                this.openMode = 0;
                if (fs != null && fs.close(this.theFile) == 0) {
                    this.theFile = 0;
                    this.keys = null;
                    this.path = "";
                    return this.mapError();
                }
                this.theFile = 0;
                this.keys = null;
                this.path = "";
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(byte[] record, int offs, int size, boolean lock) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            FileServer conn = this.getConn();
            int Return2 = conn.write(this.theFile, record, offs, size, lock);
            this.errno = conn.f_errno;
            if (Return2 == 0) {
                return this.mapError(conn);
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rewrite(byte[] record, int offs, int size, boolean lock) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            FileServer conn = this.getConn();
            int Return2 = conn.rewrite(this.theFile, record, offs, size, lock);
            this.errno = conn.f_errno;
            if (Return2 == 0) {
                return this.mapError(conn);
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(byte[] record, int offs) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.getConn().delete(this.theFile, record, offs) == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] record, int offs, int lock) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            FileServer conn = this.getConn();
            int Return2 = conn.next(this.theFile, record, offs, lock);
            this.errno = conn.f_errno;
            if (Return2 == 0) {
                return this.mapError(conn);
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] record, int offs, int lock) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            FileServer conn = this.getConn();
            int Return2 = conn.previous(this.theFile, record, offs, lock);
            this.errno = conn.f_errno;
            if (Return2 == 0) {
                return this.mapError(conn);
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            FileServer conn = this.getConn();
            int Return2 = conn.read(this.theFile, record, offs, keyNum, lock);
            this.errno = conn.f_errno;
            if (Return2 == 0) {
                return this.mapError(conn);
            }
            return Return2;
        }
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        return this.read(record, offs, this.findKey(key), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start(byte[] record, int offs, int kNum, int kSize, int mode) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int rc;
            switch (mode) {
                case 0: {
                    byte[] tmpBuf = new byte[record.length];
                    rc = this.getConn().start(this.theFile, tmpBuf, 0, kNum, kSize, 1);
                    break;
                }
                case 1: {
                    byte[] tmpBuf = new byte[record.length];
                    for (int i = record.length - 1; i >= 0; --i) {
                        tmpBuf[i] = -1;
                    }
                    rc = this.getConn().start(this.theFile, tmpBuf, 0, kNum, kSize, 4);
                    break;
                }
                case 5: {
                    rc = this.getConn().start(this.theFile, record, offs, kNum, kSize, 0);
                    break;
                }
                case 6: {
                    rc = this.getConn().start(this.theFile, record, offs, kNum, kSize, 2);
                    break;
                }
                case 7: {
                    rc = this.getConn().start(this.theFile, record, offs, kNum, kSize, 1);
                    break;
                }
                case 8: {
                    rc = this.getConn().start(this.theFile, record, offs, kNum, kSize, 3);
                    break;
                }
                case 9: {
                    rc = this.getConn().start(this.theFile, record, offs, kNum, kSize, 4);
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
                }
            }
            if (rc == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription k, int kSize, int mode) {
        return this.start(record, offs, this.findKey(k), kSize, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unlock() {
        int Return2;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            Return2 = this.getConn().unlock(this.theFile);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(int allFiles) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            this.getConn().sync(allFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(String name) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int Return2 = this.getConn().remove(name);
            if (Return2 == 0) {
                return this.mapError();
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rename(String src, String dst) {
        int Return2;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            Return2 = this.getConn().rename(src, dst);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int begin() {
        int Return2 = 0;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            Return2 = this.getConn().begin();
            if (Return2 == 0) {
                this.errno = 22;
                int int_errno = this.getConn().f_int_errno;
                short f_int_errno = (short)(int_errno & 0xFFFF);
                short f_int2_errno = (short)(int_errno >>> 16);
                TransactionException.get(this.getCobErrno(), "" + f_int_errno + "," + f_int2_errno, 12);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commit(int ctx) {
        int Return2 = 0;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            Return2 = this.getConn().commit(ctx);
            if (Return2 == 0) {
                this.errno = 22;
                int int_errno = this.getConn().f_int_errno;
                short f_int_errno = (short)(int_errno & 0xFFFF);
                short f_int2_errno = (short)(int_errno >>> 16);
                TransactionException.get(this.getCobErrno(), "" + f_int_errno + "," + f_int2_errno, 13);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rollback() {
        int Return2 = 0;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            Return2 = this.getConn().rollback();
            if (Return2 == 0) {
                this.errno = 22;
                int int_errno = this.getConn().f_int_errno;
                short f_int_errno = (short)(int_errno & 0xFFFF);
                short f_int2_errno = (short)(int_errno >>> 16);
                TransactionException.get(this.getCobErrno(), "" + f_int_errno + "," + f_int2_errno, 14);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int recover() {
        int Return2;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            Return2 = this.getConn().recover();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int intVersionLen;
            int fileVersionLen;
            int nameLen;
            byte[] name = new byte[255];
            byte[] fileVersion = new byte[255];
            byte[] intVersion = new byte[255];
            int rc = this.getConn().version(name, fileVersion, intVersion, 0, null);
            for (nameLen = 0; nameLen < name.length && name[nameLen] != 0; ++nameLen) {
            }
            for (fileVersionLen = 0; fileVersionLen < fileVersion.length && fileVersion[fileVersionLen] != 0; ++fileVersionLen) {
            }
            for (intVersionLen = 0; intVersionLen < intVersion.length && intVersion[intVersionLen] != 0; ++intVersionLen) {
            }
            return this.getClass().getName() + "$Revision$||" + new String(name, 0, nameLen) + ";" + new String(fileVersion, 0, fileVersionLen) + ";" + new String(intVersion, 0, intVersionLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int config(int opCode, String key, String value) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int Return2 = this.getConn().config(opCode, key, value);
            return Return2;
        }
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    public void finalize() {
        this.close();
    }

    protected static class MyConn {
        FileServer conn;
        IscobolSystem.Context cont;

        MyConn(FileServer c, IscobolSystem.Context t) {
            this.conn = c;
            this.cont = t;
        }
    }

    static class FileServer {
        private static final String id = "IDL:IT/picosoft/picojdbc/JDBCPicoDb:1.0";
        public static final short Finput = 0;
        public static final short Foutput = 1;
        public static final short Fio = 2;
        public static final short Fextend = 3;
        public static final short Fopen_mask = 3;
        public static final short Ftext = 4;
        public static final short Fbinary = 0;
        public static final short Flocal_only = 8;
        public static final short Fmulti_lock = 16;
        public static final short Fmulti_records = 32;
        public static final short Ftruncate = 64;
        public static final short Fread_lock = 256;
        public static final short Fwrite_lock = 512;
        public static final short Fbuffered = 1024;
        public static final short Fmass_update = 1536;
        public static final short Flock_mask = 1792;
        public static final short Fis_device = 2048;
        public static final short Fopt_lock = 4096;
        public static final short Fappend = 8192;
        public static final short Ftrans = 16384;
        private static final String key = "key";
        public short f_errno;
        public int f_int_errno;
        protected Server server;

        public static FileServer get(String pgm) throws IscobolRuntimeException {
            return new FileServer(pgm);
        }

        protected FileServer(Server srv) throws IscobolRuntimeException {
            this.server = srv;
        }

        private FileServer(String pgm) throws IscobolRuntimeException {
            this.server = Server.get(pgm);
        }

        public int init() throws IscobolRuntimeException {
            Object[] argv = new Object[1];
            this.server.call("D_init", argv);
            return (Integer)argv[0];
        }

        public int exit() throws IscobolRuntimeException {
            Object[] argv = new Object[1];
            this.server.call("E_exit", argv);
            this.server.finalize();
            return (Integer)argv[0];
        }

        public int make(String filename, String comment, String p_params, String l_params, String keys, byte[] coll) throws IscobolRuntimeException {
            Object[] argv = new Object[9];
            argv[3] = filename;
            argv[4] = comment;
            argv[5] = p_params;
            argv[6] = l_params;
            argv[7] = keys;
            argv[8] = coll != null ? new Principal(coll) : null;
            this.server.call("A_make", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int open(String filename, int mode, String l_params) throws IscobolRuntimeException {
            Object[] argv = new Object[6];
            argv[3] = filename;
            argv[4] = new Short((short)mode);
            argv[5] = l_params;
            this.server.call("B_open", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int close(int fd) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[3] = new Integer(fd);
            this.server.call("C_close", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int write(int fd, byte[] rec, int offs, int size, boolean lock) throws IscobolRuntimeException {
            Object[] argv = new Object[6];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, size == 0 ? rec.length - offs : size);
            argv[5] = new Boolean(lock);
            this.server.call("F_write", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int rewrite(int fd, byte[] rec, int offs, int size, boolean lock) throws IscobolRuntimeException {
            Object[] argv = new Object[6];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, size == 0 ? rec.length - offs : size);
            argv[5] = new Boolean(lock);
            this.server.call("G_rewrite", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int delete(int fd, byte[] rec, int offs) throws IscobolRuntimeException {
            Object[] argv = new Object[5];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            this.server.call("H_delete", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int next(int fd, byte[] rec, int offs, int lock) throws IscobolRuntimeException {
            Object[] argv = new Object[7];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            argv[5] = new Integer(rec.length - offs);
            argv[6] = new Boolean(lock > 0);
            this.server.call("I_next", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            if (this.f_errno == 5) {
                BaseFile.setLockId(((Integer)argv[0]).intValue());
                return 0;
            }
            return (Integer)argv[0];
        }

        public int previous(int fd, byte[] rec, int offs, int lock) throws IscobolRuntimeException {
            Object[] argv = new Object[7];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            argv[5] = new Integer(rec.length - offs);
            argv[6] = new Boolean(lock > 0);
            this.server.call("J_previous", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            if (this.f_errno == 5) {
                BaseFile.setLockId(((Integer)argv[0]).intValue());
                return 0;
            }
            return (Integer)argv[0];
        }

        public int read(int fd, byte[] rec, int offs, int keyNum, int lock) throws IscobolRuntimeException {
            Object[] argv = new Object[7];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            argv[5] = new Integer(keyNum);
            argv[6] = new Boolean(lock > 0);
            this.server.call("K_read", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            if (this.f_errno == 5) {
                BaseFile.setLockId(((Integer)argv[0]).intValue());
                return 0;
            }
            return (Integer)argv[0];
        }

        public int start(int fd, byte[] rec, int offs, int keyNum, int kSize, int mode) throws IscobolRuntimeException {
            Object[] argv = new Object[8];
            argv[3] = new Integer(fd);
            argv[4] = new Principal(rec, offs, rec.length - offs);
            argv[5] = new Integer(keyNum);
            argv[6] = new Integer(kSize);
            argv[7] = new Short((short)mode);
            this.server.call("L_start", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int unlock(int fd) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[3] = new Integer(fd);
            this.server.call("M_unlock", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int sync(int allFiles) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[3] = new Integer(allFiles);
            this.server.call("N_sync", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int remove(String fName) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[3] = fName;
            this.server.call("O_remove", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int rename(String src, String dst) throws IscobolRuntimeException {
            Object[] argv = new Object[5];
            argv[3] = src;
            argv[4] = dst;
            this.server.call("P_rename", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int info(int fd, int mode, byte[] rec) throws IscobolRuntimeException {
            Object[] argv = new Object[7];
            argv[3] = new Integer(fd);
            argv[4] = new Integer(mode);
            argv[5] = new Principal(rec);
            argv[6] = new Integer(rec.length);
            this.server.call("Q_info", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int begin() throws IscobolRuntimeException {
            Object[] argv = new Object[3];
            this.server.call("R_begin", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int commit(int ctx) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[3] = new Integer(ctx);
            this.server.call("S_commit", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int rollback() throws IscobolRuntimeException {
            Object[] argv = new Object[3];
            this.server.call("T_rollback", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int recover() throws IscobolRuntimeException {
            Object[] argv = new Object[3];
            this.server.call("U_recover", argv);
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int version(byte[] name, byte[] fver, byte[] iver, int i, int[] o) throws IscobolRuntimeException {
            Object[] argv = new Object[8];
            argv[3] = new Principal(name);
            argv[4] = new Principal(fver);
            argv[5] = new Principal(iver);
            argv[6] = new Integer(i);
            this.server.call("V_version", argv);
            if (o != null && o.length > 0) {
                o[0] = (Integer)argv[7];
            }
            this.f_errno = (Short)argv[1];
            this.f_int_errno = (Integer)argv[2];
            return (Integer)argv[0];
        }

        public int config(int opcode, String key, String value) throws IscobolRuntimeException {
            Object[] argv = new Object[4];
            argv[1] = new Integer(opcode);
            argv[2] = key;
            argv[3] = value;
            this.server.call("Y_config", argv);
            return (Integer)argv[0];
        }

        public int initsrv() throws IscobolRuntimeException {
            Object[] argv = new Object[1];
            this.server.call("W_initsrv", argv);
            return (Integer)argv[0];
        }

        public int exitsrv() throws IscobolRuntimeException {
            Object[] argv = new Object[1];
            this.server.call("X_exitsrv", argv);
            return (Integer)argv[0];
        }
    }

    static class Server
    extends IiopServer
    implements Corba,
    RuntimeErrorsNumbers {
        public static final CorbaArg[] make_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_Principal, 0L, 1)};
        public static final CorbaArg[] open_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_short, 0L, 1), new CorbaArg(TCD_string, 0L, 1)};
        public static final CorbaArg[] close_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1)};
        public static final CorbaArg[] write_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 1), new CorbaArg(TCD_boolean, 0L, 1)};
        public static final CorbaArg[] rewrite_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 1), new CorbaArg(TCD_boolean, 0L, 1)};
        public static final CorbaArg[] delete_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 1)};
        public static final CorbaArg[] read_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 3), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_boolean, 0L, 1)};
        public static final CorbaArg[] next_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_boolean, 0L, 1)};
        public static final CorbaArg[] previous_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_boolean, 0L, 1)};
        public static final CorbaArg[] start_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 1), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_short, 0L, 1)};
        public static final CorbaArg[] unlock_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1)};
        public static final CorbaArg[] sync_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1)};
        public static final CorbaArg[] remove_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_string, 0L, 1)};
        public static final CorbaArg[] rename_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1)};
        public static final CorbaArg[] info_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_long, 0L, 1)};
        public static final CorbaArg[] begin_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] commit_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1)};
        public static final CorbaArg[] rollback_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] recover_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] version_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] init_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] exit_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] config_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1)};

        public static Server get(String pgm) throws IscobolRuntimeException {
            Server Return2;
            try {
                Return2 = new Server(pgm);
            }
            catch (CorbaException _ex) {
                Server.throwException(_ex);
                Return2 = null;
            }
            return Return2;
        }

        protected Server(String pgm) throws CorbaException {
            super(pgm);
            this.methods.put(new CorbaMethod("A_make", make_params));
            this.methods.put(new CorbaMethod("B_open", open_params));
            this.methods.put(new CorbaMethod("C_close", close_params));
            this.methods.put(new CorbaMethod("D_init", init_params));
            this.methods.put(new CorbaMethod("E_exit", exit_params));
            this.methods.put(new CorbaMethod("F_write", write_params));
            this.methods.put(new CorbaMethod("G_rewrite", rewrite_params));
            this.methods.put(new CorbaMethod("H_delete", delete_params));
            this.methods.put(new CorbaMethod("I_next", next_params));
            this.methods.put(new CorbaMethod("J_previous", previous_params));
            this.methods.put(new CorbaMethod("K_read", read_params));
            this.methods.put(new CorbaMethod("L_start", start_params));
            this.methods.put(new CorbaMethod("M_unlock", unlock_params));
            this.methods.put(new CorbaMethod("N_sync", sync_params));
            this.methods.put(new CorbaMethod("O_remove", remove_params));
            this.methods.put(new CorbaMethod("P_rename", rename_params));
            this.methods.put(new CorbaMethod("Q_info", info_params));
            this.methods.put(new CorbaMethod("R_begin", begin_params));
            this.methods.put(new CorbaMethod("S_commit", commit_params));
            this.methods.put(new CorbaMethod("T_rollback", rollback_params));
            this.methods.put(new CorbaMethod("U_recover", recover_params));
            this.methods.put(new CorbaMethod("V_version", version_params));
            this.methods.put(new CorbaMethod("Y_config", config_params));
        }

        public synchronized void call(String name, Object[] argv) throws IscobolRuntimeException {
            try {
                this.invoke(name, argv);
            }
            catch (CorbaException _ex) {
                Server.throwException(_ex);
            }
        }

        @Override
        public synchronized void finalize() {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        static void throwException(CorbaException _ex) throws IscobolRuntimeException {
            throw new IscobolRuntimeException(3, "IIOP: " + _ex.getMessage());
        }
    }
}

