/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.java.CobolVarHelper;
import com.iscobol.java.IsCobol;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.so.DynamicCall;
import com.iscobol.types.PicX;
import java.io.File;

public class DynamicBtrieve
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    public static final String LIBNAME = "wbtrv32.dll";
    public static final String FUNNAME = "BTRCALL";
    public static final int COMP_OPT = 66;
    public static final DynamicCall dCall;
    public static final short VAR_RECS = 1;
    public static final short DATA_COMP = 8;
    public static final short DUP = 1;
    public static final short MOD = 2;
    public static final short SEG = 16;
    public static final short B_OPEN = 0;
    public static final short B_CLOSE = 1;
    public static final short B_INSERT = 2;
    public static final short B_UPDATE = 3;
    public static final short B_DELETE = 4;
    public static final short B_GET_EQUAL = 5;
    public static final short B_GET_NEXT = 6;
    public static final short B_GET_PREVIOUS = 7;
    public static final short B_GET_GT = 8;
    public static final short B_GET_GE = 9;
    public static final short B_GET_LT = 10;
    public static final short B_GET_LE = 11;
    public static final short B_GET_FIRST = 12;
    public static final short B_GET_LAST = 13;
    public static final short B_CREATE = 14;
    public static final short B_STAT = 15;
    public static final short B_EXTEND = 16;
    public static final short B_SET_DIR = 17;
    public static final short B_GET_DIR = 18;
    public static final short B_BEGIN_TRAN = 19;
    public static final short B_END_TRAN = 20;
    public static final short B_ABORT_TRAN = 21;
    public static final short B_GET_POSITION = 22;
    public static final short B_GET_DIRECT = 23;
    public static final short B_STEP_NEXT = 24;
    public static final short B_STOP = 25;
    public static final short B_VERSION = 26;
    public static final short B_UNLOCK = 27;
    public static final short B_RESET = 28;
    public static final short B_SET_OWNER = 29;
    public static final short B_CLEAR_OWNER = 30;
    public static final short B_BUILD_INDEX = 31;
    public static final short B_DROP_INDEX = 32;
    public static final short B_STEP_FIRST = 33;
    public static final short B_STEP_LAST = 34;
    public static final short B_STEP_PREVIOUS = 35;
    public static final short B_GET_NEXT_EXTENDED = 36;
    public static final short B_GET_PREV_EXTENDED = 37;
    public static final short B_STEP_NEXT_EXT = 38;
    public static final short B_STEP_PREVIOUS_EXT = 39;
    public static final short B_EXT_INSERT = 40;
    public static final short B_MISC_DATA = 41;
    public static final short B_CONTINUOUS = 42;
    public static final short B_SEEK_PERCENT = 44;
    public static final short B_GET_PERCENT = 45;
    public static final short B_CHUNK_UPDATE = 53;
    public static final short B_KEY_EQUAL = 55;
    public static final short B_KEY_NEXT = 56;
    public static final short B_KEY_PREV = 57;
    public static final short B_KEY_GT = 58;
    public static final short B_KEY_GE = 59;
    public static final short B_KEY_LT = 60;
    public static final short B_KEY_LE = 61;
    public static final short B_KEY_FIRST = 62;
    public static final short B_KEY_LAST = 63;
    public static final short B_EXTENDED_STAT = 65;
    public static final short B_LOGIN = 78;
    public static final short B_NORMAL = 0;
    public static final short ACCELERATED = -1;
    public static final short READONLY = -2;
    public static final short EXCLUSIVE = -4;
    public static final short S_WAIT_LOCK = 100;
    public static final short S_NOWAIT_LOCK = 200;
    public static final short M_WAIT_LOCK = 300;
    public static final short M_NOWAIT_LOCK = 400;
    public static final short KEY_BIAS = 50;
    public static final short B_NO_ERROR = 0;
    public static final short B_INVALID_FUNCTION = 1;
    public static final short B_IO_ERROR = 2;
    public static final short B_FILE_NOT_OPEN = 3;
    public static final short B_KEY_VALUE_NOT_FOUND = 4;
    public static final short B_DUPLICATE_KEY_VALUE = 5;
    public static final short B_INVALID_KEYNUMBER = 6;
    public static final short B_DIFFERENT_KEYNUMBER = 7;
    public static final short B_POSITION_NOT_SET = 8;
    public static final short B_END_OF_FILE = 9;
    public static final short B_MODIFIABLE_KEYVALUE_ERROR = 10;
    public static final short B_FILENAME_BAD = 11;
    public static final short B_FILE_NOT_FOUND = 12;
    public static final short B_EXTENDED_FILE_ERROR = 13;
    public static final short B_PREIMAGE_OPEN_ERROR = 14;
    public static final short B_PREIMAGE_IO_ERROR = 15;
    public static final short B_EXPANSION_ERROR = 16;
    public static final short B_CLOSE_ERROR = 17;
    public static final short B_DISKFULL = 18;
    public static final short B_UNRECOVERABLE_ERROR = 19;
    public static final short B_RECORD_MANAGER_INACTIVE = 20;
    public static final short B_KEYBUFFER_TOO_SHORT = 21;
    public static final short B_DATALENGTH_ERROR = 22;
    public static final short B_POSITIONBLOCK_LENGTH = 23;
    public static final short B_PAGE_SIZE_ERROR = 24;
    public static final short B_CREATE_IO_ERROR = 25;
    public static final short B_NUMBER_OF_KEYS = 26;
    public static final short B_INVALID_KEY_POSITION = 27;
    public static final short B_INVALID_RECORD_LENGTH = 28;
    public static final short B_INVALID_KEYLENGTH = 29;
    public static final short B_NOT_A_BTRIEVE_FILE = 30;
    public static final short B_FILE_ALREADY_EXTENDED = 31;
    public static final short B_EXTEND_IO_ERROR = 32;
    public static final short B_BTR_CANNOT_UNLOAD = 33;
    public static final short B_INVALID_EXTENSION_NAME = 34;
    public static final short B_DIRECTORY_ERROR = 35;
    public static final short B_TRANSACTION_ERROR = 36;
    public static final short B_TRANSACTION_IS_ACTIVE = 37;
    public static final short B_TRANSACTION_FILE_IO_ERROR = 38;
    public static final short B_END_TRANSACTION_ERROR = 39;
    public static final short B_TRANSACTION_MAX_FILES = 40;
    public static final short B_OPERATION_NOT_ALLOWED = 41;
    public static final short B_INCOMPLETE_ACCEL_ACCESS = 42;
    public static final short B_INVALID_RECORD_ADDRESS = 43;
    public static final short B_NULL_KEYPATH = 44;
    public static final short B_INCONSISTENT_KEY_FLAGS = 45;
    public static final short B_ACCESS_TO_FILE_DENIED = 46;
    public static final short B_MAXIMUM_OPEN_FILES = 47;
    public static final short B_INVALID_ALT_SEQUENCE_DEF = 48;
    public static final short B_KEY_TYPE_ERROR = 49;
    public static final short B_OWNER_ALREADY_SET = 50;
    public static final short B_INVALID_OWNER = 51;
    public static final short B_ERROR_WRITING_CACHE = 52;
    public static final short B_INVALID_INTERFACE = 53;
    public static final short B_VARIABLE_PAGE_ERROR = 54;
    public static final short B_AUTOINCREMENT_ERROR = 55;
    public static final short B_INCOMPLETE_INDEX = 56;
    public static final short B_EXPANED_MEM_ERROR = 57;
    public static final short B_COMPRESS_BUFFER_TOO_SHORT = 58;
    public static final short B_FILE_ALREADY_EXISTS = 59;
    public static final short B_REJECT_COUNT_REACHED = 60;
    public static final short B_SMALL_EX_GET_BUFFER_ERROR = 61;
    public static final short B_INVALID_GET_EXPRESSION = 62;
    public static final short B_INVALID_EXT_INSERT_BUFF = 63;
    public static final short B_OPTIMIZE_LIMIT_REACHED = 64;
    public static final short B_INVALID_EXTRACTOR = 65;
    public static final short B_RI_TOO_MANY_DATABASES = 66;
    public static final short B_RIDDF_CANNOT_OPEN = 67;
    public static final short B_RI_CASCADE_TOO_DEEP = 68;
    public static final short B_RI_CASCADE_ERROR = 69;
    public static final short B_RI_VIOLATION = 71;
    public static final short B_RI_REFERENCED_FILE_CANNOT_OPEN = 72;
    public static final short B_RI_OUT_OF_SYNC = 73;
    public static final short B_END_CHANGED_TO_ABORT = 74;
    public static final short B_RI_CONFLICT = 76;
    public static final short B_CANT_LOOP_IN_SERVER = 77;
    public static final short B_DEAD_LOCK = 78;
    public static final short B_PROGRAMMING_ERROR = 79;
    public static final short B_CONFLICT = 80;
    public static final short B_LOCKERROR = 81;
    public static final short B_LOST_POSITION = 82;
    public static final short B_READ_OUTSIDE_TRANSACTION = 83;
    public static final short B_RECORD_INUSE = 84;
    public static final short B_FILE_INUSE = 85;
    public static final short B_FILE_TABLE_FULL = 86;
    public static final short B_NOHANDLES_AVAILABLE = 87;
    public static final short B_INCOMPATIBLE_MODE_ERROR = 88;
    public static final short B_DEVICE_TABLE_FULL = 90;
    public static final short B_SERVER_ERROR = 91;
    public static final short B_TRANSACTION_TABLE_FULL = 92;
    public static final short B_INCOMPATIBLE_LOCK_TYPE = 93;
    public static final short B_PERMISSION_ERROR = 94;
    public static final short B_SESSION_NO_LONGER_VALID = 95;
    public static final short B_COMMUNICATIONS_ERROR = 96;
    public static final short B_DATA_MESSAGE_TOO_SMALL = 97;
    public static final short B_INTERNAL_TRANSACTION_ERROR = 98;
    public static final short B_REQUESTER_CANT_ACCESS_RUNTIME = 99;
    public static final short B_NO_CACHE_BUFFERS_AVAIL = 100;
    public static final short B_NO_OS_MEMORY_AVAIL = 101;
    public static final short B_NO_STACK_AVAIL = 102;
    public static final short B_CHUNK_OFFSET_TOO_LONG = 103;
    public static final short B_LOCALE_ERROR = 104;
    public static final short B_CANNOT_CREATE_WITH_BAT = 105;
    public static final short B_CHUNK_CANNOT_GET_NEXT = 106;
    public static final short B_CHUNK_INCOMPATIBLE_FILE = 107;
    public static final short B_TRANSACTION_TOO_COMPLEX = 109;
    public static final short B_ARCH_BLOG_OPEN_ERROR = 110;
    public static final short B_ARCH_FILE_NOT_LOGGED = 111;
    public static final short B_ARCH_FILE_IN_USE = 112;
    public static final short B_ARCH_LOGFILE_NOT_FOUND = 113;
    public static final short B_ARCH_LOGFILE_INVALID = 114;
    public static final short B_ARCH_DUMPFILE_ACCESS_ERROR = 115;
    public static final short B_LOCATOR_FILE_INDICATOR = 116;
    public static final short B_NO_SYSTEM_LOCKS_AVAILABLE = 130;
    public static final short B_FILE_FULL = 132;
    public static final short B_MORE_THAN_5_CONCURRENT_USERS = 133;
    public static final short B_ISR_NOT_FOUND = 134;
    public static final short B_ISR_INVALID = 135;
    public static final short B_ACS_NOT_FOUND = 136;
    public static final short B_CANNOT_CONVERT_RP = 137;
    public static final short B_INVALID_NULL_INDICATOR = 138;
    public static final short B_INVALID_KEY_OPTION = 139;
    public static final short B_INCOMPATIBLE_CLOSE = 140;
    public static final short B_INVALID_USERNAME = 141;
    public static final short B_INVALID_DATABASE = 142;
    public static final short B_NO_SSQL_RIGHTS = 143;
    public static final short B_ALREADY_LOGGED_IN = 144;
    public static final short B_NO_DATABASE_SERVICES = 145;
    public static final short B_DUPLICATE_SYSTEM_KEY = 146;
    public static final short B_LOG_SEGMENT_MISSING = 147;
    public static final short B_ROLL_FORWARD_ERROR = 148;
    public static final short B_SYSTEM_KEY_INTERNAL = 149;
    public static final short B_DBS_INTERNAL_ERROR = 150;
    public static final short B_NESTING_DEPTH_ERROR = 151;
    public static final short B_INVALID_PARAMETER_TO_MKDE = 160;
    public static final short B_EXTENDED_SYSTEM = 999;
    public static final short B_EXTENDED_MISSING_FILE = 998;
    private KeyDescription[] keys;
    private int openMode = 0;
    private int lockType;
    private boolean lockWait;
    private boolean lockMulti;
    private boolean exclLock;
    private String path = "";
    private int errno;
    private int lastOp;
    private String sysError;
    private String errMsg;
    private int maxRecordSize;
    private int minRecordSize;
    private long numOfRecords;
    private ICobolVar currentPosition;
    private int currentKey;
    private CobolVarHelper operation_h = new CobolVarHelper("all", 66).pic9Comp5("operation", 4, 0);
    private ICobolVar operation = this.operation_h.get("operation");
    CobolVarHelper dataLen_h = new CobolVarHelper("all", 66).pic9Comp5("dataLen", 4, 0);
    private ICobolVar dataLen = this.dataLen_h.get("dataLen");
    CobolVarHelper keyNum_h = new CobolVarHelper("all", 66).picS9Comp5("keyNum", 4, 0);
    private ICobolVar keyNum = this.keyNum_h.get("keyNum");
    private CobolVarHelper posBlock1_h = new CobolVarHelper("all", 66).picX("posBlock", 128);
    private ICobolVar posBlock = this.posBlock1_h.get("all");
    CobolVarHelper versionBuffer_h = new CobolVarHelper("all", 66).group("").occurs(3).pic9Comp5("Version", 4, 0).pic9Comp5("Revision", 4, 0).picX("MKDEId", 1).endGroup();
    private PicX keyBuffer = new PicX(new byte[256], 0, 256, null, null, "", false, false);
    private PicX asKeyBuffer = new PicX(new byte[256], 0, 256, null, null, "", false, false);
    CobolVarHelper keyLen_h = new CobolVarHelper("all", 66).pic9Comp5("keyLen", 4, 0);
    private ICobolVar keyLen = this.keyLen_h.get("keyLen");
    private CobolVarHelper startRecPos_h = new CobolVarHelper("all", 66).pic9Comp5("startRecPos", 9, 0);
    private ICobolVar startRecPos = this.startRecPos_h.get("startRecPos");
    private CobolVarHelper rewRecPos_h = new CobolVarHelper("all", 66).pic9Comp5("rewRecPos", 9, 0);
    private ICobolVar rewRecPos = this.rewRecPos_h.get("rewRecPos");
    private ICobolVar localBuffer;
    private byte[] localBytes;

    private int callBtrv(int op, ICobolVar block, ICobolVar data, ICobolVar dataLen, ICobolVar keyBuff, ICobolVar keyBuffLen, ICobolVar keyNumber) {
        this.operation.set(op);
        Object[] args = new ICobolVar[]{this.operation.setByVal(true), block, data, dataLen, keyBuff, keyBuffLen.setByVal(true), keyNumber.setByVal(true)};
        Object ro = dCall.call(args);
        int rc = ((ICobolVar)ro).toint();
        return this.mapError(rc, op);
    }

    private int mapError(int err, int op) {
        this.errno = err;
        this.lastOp = op;
        this.errMsg = "Btrieve#" + err;
        this.sysError = "B" + err;
        if (this.errno == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getVersion() {
        StringBuffer Return2 = new StringBuffer("Btrieve");
        ICobolVar versionBuffer = this.versionBuffer_h.get("all");
        versionBuffer.set(new byte[versionBuffer.length()]);
        this.dataLen.set(versionBuffer.length());
        this.keyNum.set(0);
        ICobolVar version = this.versionBuffer_h.get("Version");
        ICobolVar revision = this.versionBuffer_h.get("Revision");
        ICobolVar mkdeid = this.versionBuffer_h.get("MKDEId");
        this.keyLen.set(0);
        int rc = this.callBtrv(26, this.posBlock, versionBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
        for (int i = 1; i <= 3; ++i) {
            if (version.intIAt(i).toint() <= 0) continue;
            Return2.append(':');
            Return2.append(version.intIAt(i).toint());
            Return2.append('.');
            Return2.append(revision.intIAt(i).toint());
            Return2.append(' ');
            Return2.append(mkdeid.intIAt(i).toString());
        }
        return Return2.toString();
    }

    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecSize, int minRecSize, KeyDescription[] kdes, byte[] collating, boolean assignExt) {
        if (assignExt) {
            path = BaseFile.expandFileName(path);
        }
        this.keys = kdes;
        int nKeys = this.keys.length;
        int nSegs = 0;
        for (int i = 0; i < nKeys; ++i) {
            nSegs += this.keys[i].getNumSegments();
        }
        int fileFlags = 0;
        if (maxRecSize > minRecSize) {
            fileFlags |= 1;
        }
        if (compressionFactor > 0) {
            fileFlags |= 8;
        }
        CobolVarHelper dataBuffer_h = new CobolVarHelper("all", 66).picS9Comp5("minRecordLen", 4, 0).picS9Comp5("pageSize", 4, 0).picS9Comp5("numOfKeys", 2, 0).picS9Comp5("fileVersion", 2, 0).picX("reserved", 4).picS9Comp5("fileFlags", 4, 0).picS9Comp5("extraPointers", 2, 0).picX("reserved", 1).picS9Comp5("preallocPages", 4, 0).group("keys").occurs(nSegs).picS9Comp5("keyPosition", 4, 0).picS9Comp5("keyLength", 4, 0).picS9Comp5("keyFlags", 4, 0).picX("reserved", 4).picX("extKeyType", 1).picS9Comp5("nullValue", 2, 0).picX("reserved", 2).picS9Comp5("keyNumber", 2, 0).picS9Comp5("acsNumber", 2, 0).endGroup();
        ICobolVar dataBuffer = dataBuffer_h.get("all");
        dataBuffer = dataBuffer_h.get("all");
        dataBuffer.set(new byte[dataBuffer.length()]);
        this.dataLen.set(dataBuffer.length());
        dataBuffer_h.get("minRecordLen").set(minRecSize);
        dataBuffer_h.get("pageSize").set(4096);
        dataBuffer_h.get("numOfKeys").set(nKeys);
        dataBuffer_h.get("fileVersion").set(0);
        dataBuffer_h.get("fileFlags").set(fileFlags);
        ICobolVar keyPosition = dataBuffer_h.get("keyPosition");
        ICobolVar keyLength = dataBuffer_h.get("keyLength");
        ICobolVar keyFlags = dataBuffer_h.get("keyFlags");
        ICobolVar extKeyType = dataBuffer_h.get("extKeyType");
        ICobolVar nullValue = dataBuffer_h.get("nullValue");
        ICobolVar keyNumber = dataBuffer_h.get("keyNumber");
        ICobolVar acsNumber = dataBuffer_h.get("acsNumber");
        int segCnt = 0;
        for (int i = 0; i < nKeys; ++i) {
            int keyFlag;
            int lnseg = this.keys[i].getNumSegments();
            int n = keyFlag = i == 0 ? 0 : 2;
            if (this.keys[i].isDup()) {
                keyFlag |= 1;
            }
            int j = 0;
            while (true) {
                KeyDescription.Segs seg = this.keys[i].getSegment(j);
                keyPosition.intIAt(++segCnt).set(seg.offset + 1);
                keyLength.intIAt(segCnt).set(seg.size);
                if (++j >= lnseg) break;
                keyFlags.intIAt(segCnt).set(keyFlag | 0x10);
            }
            keyFlags.intIAt(segCnt).set(keyFlag);
        }
        this.asKeyBuffer.set(path + '\u0000');
        this.keyLen.set(path.length());
        this.keyNum.set(0);
        return this.callBtrv(14, this.posBlock, dataBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
    }

    @Override
    public int open(String path, int openType, int lock, KeyDescription[] ks, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        this.minRecordSize = minRec;
        this.maxRecordSize = maxRec;
        this.localBytes = new byte[this.maxRecordSize];
        this.localBuffer = new PicX(this.localBytes, 0, this.maxRecordSize, null, null, "localBuffer", false, false);
        this.lockType = lock;
        this.lockMulti = (this.lockType & 0x100) != 0;
        this.currentKey = -1;
        this.lockWait = Config.getProperty(".file.index.lock_wait", false);
        if (assignExt) {
            path = BaseFile.expandFileName(path);
        }
        if (this.keys == null) {
            this.keys = ks;
        }
        CobolVarHelper dataBuffer_h = new CobolVarHelper("all", 66).picX("owner", 16);
        ICobolVar dataBuffer = dataBuffer_h.get("all");
        dataBuffer.set(new byte[dataBuffer.length()]);
        this.dataLen.set(0);
        this.asKeyBuffer.set(path + '\u0000');
        this.keyLen.set(path.length());
        block0 : switch (openType) {
            case 2: 
            case 6: {
                this.keyNum.set((short)-4);
                this.exclLock = true;
                break;
            }
            case 3: {
                switch (this.lockType & 0xF) {
                    default: {
                        this.keyNum.set((short)0);
                        this.exclLock = false;
                        break block0;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                }
                this.keyNum.set((short)-4);
                this.exclLock = true;
                break;
            }
            case 1: {
                this.keyNum.set((short)-2);
                this.exclLock = false;
            }
        }
        int rc = this.callBtrv(0, this.posBlock, dataBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
        if (rc == 1) {
            this.openMode = openType;
        }
        return rc;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 5: {
                return 100;
            }
            case 3: {
                return 101;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                return 102;
            }
            case 6: 
            case 21: 
            case 26: 
            case 27: 
            case 29: 
            case 45: 
            case 49: {
                return 103;
            }
            case 47: {
                return 104;
            }
            case 30: {
                return 105;
            }
            case 81: {
                if (this.lastOp == 0) {
                    return 113;
                }
                return 107;
            }
            case 84: {
                return 107;
            }
            case 85: 
            case 88: {
                return 113;
            }
            case 9: {
                return 110;
            }
            case 4: {
                return 111;
            }
            case 8: {
                return 112;
            }
            case 12: {
                return 130;
            }
            case 998: {
                return 130;
            }
            case 94: {
                return 131;
            }
            case 41: {
                return 35;
            }
        }
        return 133;
    }

    @Override
    public String getSysErrno() {
        return this.sysError;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    @Override
    public int close() {
        int Return2 = 1;
        if (this.isOpen()) {
            CobolVarHelper dataBuffer_h = new CobolVarHelper("all", 66).picX("data", 1);
            ICobolVar dataBuffer = dataBuffer_h.get("all");
            this.dataLen.set(0);
            Return2 = this.callBtrv(1, this.posBlock, dataBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
            this.openMode = 0;
            this.keys = null;
            this.path = "";
        }
        return Return2;
    }

    private int getStat() {
        CobolVarHelper dataBuffer_h = new CobolVarHelper("all", 66).picS9Comp5("minRecordLen", 4, 0).picS9Comp5("pageSize", 4, 0).picS9Comp5("numOfIndexes", 4, 0).picS9Comp5("numOfRecords", 9, 0).picS9Comp5("fileFlags", 4, 0).picX("reserved", 2).picS9Comp5("unusedPages", 4, 0).group("keys").occurs(119).picS9Comp5("keyPosition", 4, 0).picS9Comp5("keyLength", 4, 0).picS9Comp5("keyFlags", 4, 0).picS9Comp5("numOfUniqueVal", 9, 0).picX("extKeyType", 1).picS9Comp5("nullValue", 2, 0).picX("reserved", 2).picS9Comp5("keyNumber", 2, 0).picS9Comp5("acsNumber", 2, 0).endGroup();
        ICobolVar dataBuffer = dataBuffer_h.get("all");
        this.dataLen.set(dataBuffer.length());
        this.keyLen.set(this.asKeyBuffer.length());
        this.keyNum.set(0);
        int Return2 = this.callBtrv(15, this.posBlock, dataBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
        if (Return2 == 1) {
            this.minRecordSize = dataBuffer_h.get("minRecordLen").toint();
            if (this.maxRecordSize < this.minRecordSize) {
                this.maxRecordSize = this.minRecordSize;
            }
            int nKeys = dataBuffer_h.get("numOfIndexes").toint();
            this.numOfRecords = dataBuffer_h.get("numOfRecords").tolong();
            if (nKeys > 0) {
                ICobolVar keyPosition = dataBuffer_h.get("keyPosition");
                ICobolVar keyLength = dataBuffer_h.get("keyLength");
                ICobolVar keyNumber = dataBuffer_h.get("keyNumber");
                ICobolVar keyFlags = dataBuffer_h.get("keyFlags");
                int nSegs = 0;
                int k = 0;
                int seg1 = 0;
                this.keys = new KeyDescription[nKeys];
                nSegs = 1;
                while (true) {
                    if ((keyFlags.intIAt(nSegs).toint() & 0x10) == 0) {
                        this.keys[k] = new KeyDescription(nSegs - seg1, (keyFlags.intIAt(nSegs).toint() & 1) != 0);
                        int j = seg1 + 1;
                        int ix = 0;
                        while (j <= nSegs) {
                            this.keys[k].setSegment(ix, keyLength.intIAt(j).toint(), keyPosition.intIAt(j).toint() - 1);
                            ++j;
                            ++ix;
                        }
                        seg1 = nSegs;
                        if (++k == nKeys) break;
                    }
                    ++nSegs;
                }
            }
        }
        return Return2;
    }

    @Override
    public int getNumKeys() {
        if (this.keys == null) {
            this.getStat();
            if (this.keys == null) {
                return 0;
            }
        }
        return this.keys.length;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.maxRecordSize == 0) {
            this.getStat();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.minRecordSize == 0) {
            this.getStat();
        }
        return this.minRecordSize;
    }

    @Override
    public KeyDescription getKey(int num) {
        KeyDescription Return2;
        if (num >= 0 && num < this.getNumKeys()) {
            Return2 = this.keys[num];
        } else {
            Return2 = null;
            this.mapError(1, 15);
        }
        return Return2;
    }

    @Override
    public long getNumRecords() {
        this.getStat();
        return this.numOfRecords;
    }

    @Override
    public byte[] getSequence() {
        return null;
    }

    @Override
    public void setCurrentRecord(long nRec) {
    }

    @Override
    public long getCurrentRecord() {
        return 0L;
    }

    private int buildKey(PicX res, KeyDescription k, byte[] rec, int offs) {
        int len = k.length();
        byte[] value = res.getMemory();
        int i = 0;
        int j = 0;
        while (i < len) {
            KeyDescription.Segs seg = k.getSegment(j);
            System.arraycopy(rec, seg.offset + offs, value, i, seg.size);
            i += seg.size;
            ++j;
        }
        return len;
    }

    private int lockBias(int lock) {
        int Return2 = lock > 0 && !this.exclLock ? (this.lockMulti ? (this.lockWait || lock == 3 ? 300 : 400) : (this.lockWait || lock == 3 ? 100 : 200)) : 0;
        return Return2;
    }

    @Override
    public long read(byte[] record, int offs, int kNum, int lock) {
        PicX dataBuffer = new PicX(record, offs, this.maxRecordSize, null, null, "", false, false);
        this.currentPosition = null;
        this.dataLen.set(this.maxRecordSize);
        this.keyNum.set(kNum);
        this.keyLen.set(this.buildKey(this.keyBuffer, this.getKey(kNum), record, offs));
        int Return2 = this.callBtrv(5 + this.lockBias(lock), this.posBlock, dataBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
        if (Return2 == 1) {
            this.currentKey = kNum;
            Return2 = this.dataLen.toint();
        }
        return Return2;
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        return this.read(record, offs, this.findKey(key), lock);
    }

    @Override
    public long next(byte[] record, int offs, int lock) {
        int Return2;
        this.dataLen.set(this.maxRecordSize);
        if (this.currentKey < 0) {
            PicX dataBuffer = new PicX(record, offs, this.maxRecordSize, null, null, "", false, false);
            this.currentKey = 0;
            this.keyNum.set(this.currentKey);
            this.keyLen.set(0);
            this.currentPosition = null;
            Return2 = this.callBtrv(12 + this.lockBias(lock), this.posBlock, dataBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
            if (Return2 == 1) {
                Return2 = this.dataLen.toint();
            }
        } else {
            this.keyNum.set(this.currentKey);
            this.keyLen.set(0);
            if (this.currentPosition != null) {
                byte[] pos = this.currentPosition.getBytes();
                System.arraycopy(pos, 0, this.localBytes, 0, pos.length);
                Return2 = this.callBtrv(23 + this.lockBias(lock), this.posBlock, this.localBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
                if (Return2 == 1) {
                    System.arraycopy(this.localBytes, 0, record, offs, this.maxRecordSize);
                    this.currentPosition = null;
                    Return2 = this.dataLen.toint();
                }
            } else {
                PicX dataBuffer = new PicX(record, offs, this.maxRecordSize, null, null, "", false, false);
                Return2 = this.callBtrv(6 + this.lockBias(lock), this.posBlock, dataBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
                if (Return2 == 1) {
                    Return2 = this.dataLen.toint();
                }
            }
        }
        return Return2;
    }

    @Override
    public long previous(byte[] record, int offs, int lock) {
        PicX dataBuffer = new PicX(record, offs, this.maxRecordSize, null, null, "", false, false);
        this.currentPosition = null;
        this.dataLen.set(this.maxRecordSize);
        this.keyNum.set(this.currentKey);
        this.keyLen.set(0);
        int Return2 = this.callBtrv(7 + this.lockBias(lock), this.posBlock, dataBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
        if (Return2 == 1) {
            Return2 = this.dataLen.toint();
        }
        return Return2;
    }

    @Override
    public long start(byte[] record, int offs, int kNum, int keySize, int mode) {
        int op;
        switch (mode) {
            case 0: {
                op = 12;
                break;
            }
            case 1: {
                op = 13;
                break;
            }
            case 5: {
                op = 5;
                break;
            }
            case 6: {
                op = 8;
                break;
            }
            case 7: {
                op = 9;
                break;
            }
            case 8: {
                op = 10;
                break;
            }
            case 9: {
                op = 11;
                break;
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
            }
        }
        PicX dataBuffer = new PicX(record, offs, this.maxRecordSize, null, null, "", false, false);
        this.dataLen.set(this.maxRecordSize);
        this.keyNum.set(kNum);
        this.keyLen.set(this.buildKey(this.keyBuffer, this.getKey(kNum), record, offs));
        long Return2 = this.callBtrv(op + 50, this.posBlock, dataBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
        if (Return2 == 1L) {
            this.currentKey = kNum;
            this.dataLen.set(this.startRecPos_h.get("all").length());
            Return2 = this.callBtrv(22, this.posBlock, this.startRecPos, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
            if (Return2 == 1L) {
                this.currentPosition = this.startRecPos;
            }
        } else if (this.errno == 9) {
            this.errno = 4;
        }
        return Return2;
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription key, int keySize, int mode) {
        return this.start(record, offs, this.findKey(key), keySize, mode);
    }

    @Override
    public long write(byte[] record, int offs, int size, boolean lock) {
        if (this.minRecordSize == this.maxRecordSize) {
            size = this.maxRecordSize;
        }
        PicX dataBuffer = new PicX(record, offs, size, null, null, "", false, false);
        dataBuffer.set(record, offs, size, false);
        this.dataLen.set(size);
        this.keyLen.set(this.asKeyBuffer.length());
        this.keyNum.set(-1);
        return this.callBtrv(2, this.posBlock, dataBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
    }

    @Override
    public long rewrite(byte[] record, int offs, int size, boolean lock) {
        if (size == 0 || this.minRecordSize == this.maxRecordSize) {
            size = this.maxRecordSize;
        }
        PicX dataBuffer = new PicX(record, offs, size, null, null, "", false, false);
        this.keyNum.set(0);
        this.dataLen.set(this.rewRecPos.length());
        int Return2 = this.currentKey >= 0 ? this.callBtrv(22, this.posBlock, this.rewRecPos, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum) : 1;
        if (Return2 == 1) {
            this.dataLen.set(size);
            this.keyNum.set(0);
            this.keyLen.set(this.buildKey(this.asKeyBuffer, this.getKey(0), record, offs));
            Return2 = this.callBtrv(5, this.posBlock, this.localBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
            if (Return2 == 1) {
                this.keyLen.set(this.asKeyBuffer.length());
                this.keyNum.set(-1);
                Return2 = this.callBtrv(3, this.posBlock, dataBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
                if (Return2 == 1 && this.currentKey >= 0) {
                    byte[] pos = this.rewRecPos.getBytes();
                    System.arraycopy(pos, 0, this.localBytes, 0, pos.length);
                    Return2 = this.callBtrv(23, this.posBlock, this.localBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
                }
            }
        }
        return Return2;
    }

    @Override
    public long delete(byte[] record, int offs) {
        int size = this.maxRecordSize;
        PicX dataBuffer = new PicX(record, offs, size, null, null, "", false, false);
        this.keyNum.set(0);
        this.dataLen.set(this.rewRecPos.length());
        int Return2 = this.currentKey >= 0 ? this.callBtrv(22, this.posBlock, this.rewRecPos, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum) : 1;
        if (Return2 == 1) {
            this.dataLen.set(size);
            this.keyNum.set(0);
            this.keyLen.set(this.buildKey(this.asKeyBuffer, this.getKey(0), record, offs));
            Return2 = this.callBtrv(5, this.posBlock, this.localBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
            if (Return2 == 1) {
                this.keyLen.set(this.asKeyBuffer.length());
                this.keyNum.set(-1);
                Return2 = this.callBtrv(4, this.posBlock, dataBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
                if (Return2 == 1 && this.currentKey >= 0) {
                    byte[] pos = this.rewRecPos.getBytes();
                    System.arraycopy(pos, 0, this.localBytes, 0, pos.length);
                    this.callBtrv(23, this.posBlock, this.localBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
                }
            }
        }
        return Return2;
    }

    @Override
    public int unlock() {
        this.dataLen.set(this.maxRecordSize);
        this.keyNum.set(-2);
        int Return2 = this.callBtrv(27, this.posBlock, this.localBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
        return Return2;
    }

    @Override
    public int remove(String name) {
        File f = new File(name);
        if (!f.exists()) {
            return this.mapError(998, 0);
        }
        if (!f.delete()) {
            return this.mapError(999, 0);
        }
        return 1;
    }

    @Override
    public int rename(String src, String dst) {
        File fs = new File(src);
        File fd = new File(dst);
        if (!fs.exists()) {
            return this.mapError(998, 0);
        }
        if (!fs.renameTo(fd)) {
            return this.mapError(999, 0);
        }
        return 1;
    }

    @Override
    public void sync(int mode) {
    }

    @Override
    public int begin() {
        return this.mapError(41, 0);
    }

    @Override
    public int commit(int ctx) {
        return this.mapError(41, 0);
    }

    @Override
    public int rollback() {
        return this.mapError(41, 0);
    }

    @Override
    public int recover() {
        return this.mapError(41, 0);
    }

    @Override
    public boolean isKeySelectedByNum() {
        return true;
    }

    private int findKey(KeyDescription key) {
        int Return2;
        int nKeys = this.getNumKeys();
        try {
            for (Return2 = 0; Return2 < nKeys && !key.equals(this.getKey(Return2)); ++Return2) {
            }
        }
        catch (NullPointerException e) {
            Return2 = -1;
        }
        return Return2;
    }

    public static void main(String[] argv) {
        DynamicBtrieve bt = new DynamicBtrieve();
        System.out.println(bt.getVersion());
        System.out.println(bt.build("testFile", "remarks", 0, 0, 0, 0, 0, 10, 0, null, null, false));
    }

    static {
        IsCobol.call(LIBNAME, null);
        dCall = new DynamicCall(FUNNAME, 1);
    }
}

