/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.io.BaseFile;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.FileLock;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;

public abstract class BaseRelative
extends BaseFile
implements CobolFile,
RuntimeErrorsNumbers {
    private static final long OPEN_LOCK_POS = System.getProperty("java.version").compareTo("1.5") >= 0 ? 0x7FFFFFFFFFFFFFFEL : 0x7FFFFFFEL;
    protected OSFile theFile;
    protected boolean readLock;
    protected boolean exclusiveLock;
    protected boolean multipleLock;
    private FileLock lock;

    public static int cobolErrno(IsamException ex) {
        switch (ex.getIserrno()) {
            case 0: {
                return 0;
            }
            case 100: {
                return 100;
            }
            case 133: {
                return 133;
            }
            case 102: {
                return 102;
            }
            case 104: {
                return 104;
            }
            case 125: {
                return 125;
            }
            case 107: {
                return 107;
            }
            case 105: {
                return 105;
            }
            case 108: {
                return 108;
            }
            case 111: {
                return 111;
            }
            case 110: {
                return 110;
            }
            case 112: {
                return 112;
            }
            case 127: {
                return 127;
            }
            case 113: {
                return 113;
            }
            case 128: {
                return 128;
            }
            case 116: {
                return 116;
            }
            case 130: {
                return 130;
            }
            case 131: {
                return 131;
            }
            case 126: {
                return 126;
            }
            case 129: {
                return 129;
            }
            case 122: {
                return 122;
            }
        }
        return 134;
    }

    public BaseRelative(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am) {
        super(nam, maxLen, memBuf, minLen, opt, am);
    }

    private void setLockType(int lockType) {
        this.exclusiveLock = false;
        this.multipleLock = false;
        this.readLock = false;
        switch (lockType & 0xF) {
            default: {
                break;
            }
            case 1: 
            case 6: {
                this.exclusiveLock = true;
                break;
            }
            case 4: {
                this.readLock = false;
                break;
            }
            case 3: 
            case 5: {
                this.readLock = true;
            }
        }
        if ((lockType & 0x100) != 0) {
            this.multipleLock = true;
        }
    }

    @Override
    public void peerOpen(String path, int openType, int lockType) {
        try {
            if (this.getOpenMode() != 0) {
                CobolIOException.get(135, "", this, 1);
            }
            this.setLockType(lockType);
            this.theFile = new OSFile();
            switch (openType) {
                case 2: {
                    this.theFile.open(path, 577);
                    break;
                }
                case 3: 
                case 6: {
                    if (this.isOptional(openType)) {
                        this.theFile.open(path, 66);
                        break;
                    }
                    this.theFile.open(path, 2);
                    break;
                }
                case 1: {
                    try {
                        this.theFile.open(path, 0);
                        if (!this.exclusiveLock) break;
                        this.readLock = true;
                        break;
                    }
                    catch (IsamException _ex) {
                        if (this.isOptional(openType)) {
                            this.theFile = null;
                            this.setOpenMode(1);
                            CobolIOException.get(203, "", this, 1);
                            break;
                        }
                        throw _ex;
                    }
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.setOpenMode(openType);
            try {
                this.lock = new FileLock(path, this.theFile, this.exclusiveLock, this.readLock);
            }
            catch (IsamException _ex) {
                this.theFile.close();
                throw _ex;
            }
        }
        catch (CobolIOException _ex) {
            throw _ex;
        }
        catch (IsamException _ex) {
            switch (_ex.getIserrno()) {
                case 130: {
                    CobolIOException.get(130, "", this, 1);
                    break;
                }
                default: {
                    CobolIOException.get(BaseRelative.cobolErrno(_ex), "", this, 1);
                }
            }
        }
    }

    @Override
    protected void peerClose(int opts) {
        if (this.theFile != null && this.getOpenMode() != 0) {
            try {
                this.lock.finalize();
                this.theFile.close();
                this.theFile = null;
                this.setOpenMode(0);
            }
            catch (IsamException _ex) {
                CobolIOException.get(BaseRelative.cobolErrno(_ex), "", this, 2);
            }
        }
    }

    @Override
    public void deleteFile(ICobolVar path) {
        super.deleteFile(path);
        try {
            OSFile.unlink(this.getOsPath());
        }
        catch (IsamException _ex) {
            CobolIOException.get(203, "", this, 2);
        }
    }
}

