/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter;

import com.iscobol.htmlexporter.RptBorder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RptStyle {
    private static final Pattern RPT_STYLE_PTN = Pattern.compile("(([a-z]+)\\d+)\\-([a-z]+)\\-(.+)");
    private String name;
    private String baseName;
    private String sectionId;
    private String sectionType;
    private String type;
    private String parentName;
    public int x;
    public int y;
    public int width;
    public int height;
    public RptBorder border;
    public Object customData;

    public RptStyle(RptStyle s) {
        this.name = s.name;
        this.baseName = s.baseName;
        this.sectionId = s.sectionId;
        this.sectionType = s.sectionType;
        this.type = s.type;
        this.parentName = s.parentName;
        this.x = s.x;
        this.y = s.y;
        this.width = s.width;
        this.height = s.height;
        if (s.border != null) {
            this.border = new RptBorder(s.border);
        }
    }

    public RptStyle(String name) {
        this.name = name;
        Matcher m = RPT_STYLE_PTN.matcher(name);
        if (m.find()) {
            this.sectionType = m.group(2);
            this.sectionId = m.group(1);
            this.type = m.group(3);
            this.baseName = m.group(4);
            if (this.type.startsWith("tc") || this.type.equals("imc")) {
                StringBuilder parname = new StringBuilder();
                parname.append(this.sectionId);
                parname.append("-");
                if (this.type.equals("tc")) {
                    parname.append("tb");
                } else if (this.type.startsWith("tc")) {
                    parname.append(this.type.substring(0, this.type.length() - 1));
                } else {
                    parname.append("im");
                }
                parname.append("-");
                parname.append(this.baseName.substring(0, this.baseName.lastIndexOf(45)));
                this.parentName = parname.toString();
            }
        }
    }

    public boolean isTableComponent() {
        return this.type != null && this.type.equals("tb");
    }

    public boolean isTableCellComponent() {
        return this.type != null && this.type.startsWith("tc");
    }

    public boolean isBoxComponent() {
        return this.type != null && this.type.equals("bx");
    }

    public boolean isLineComponent() {
        return this.type != null && this.type.equals("ln");
    }

    public boolean isImageComponent() {
        return this.type != null && this.type.equals("im");
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String name) {
        this.parentName = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public String getSectionType() {
        return this.sectionType;
    }

    public String toString() {
        return this.name;
    }

    public String getBaseName() {
        return this.baseName;
    }
}

