/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.server;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.Constants;
import com.iscobol.gui.Events;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.MessageBoxCustom;
import com.iscobol.gui.RemoteContainer;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.server.CobolGUIEnvironment;
import com.iscobol.gui.server.CobolRecordAccept;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.EventsImpl;
import com.iscobol.gui.server.FontCmp;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IObjectVar;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.ObjectVar;
import java.io.IOException;
import java.util.Vector;

public class DisplayMessageBox
implements Constants {
    CobolGUIEnvironment env;
    String text = "";
    String title;
    int type = 1;
    int btnDefault = 1;
    int icon = 1;
    boolean end;
    byte[] RESULT$0 = Factory.getMem(4);
    ObjectVar RESULT = Factory.getVarObject(this.RESULT$0, 0, 4, false, null, null, null, "RESULT", false, 0, 0, false, false, false);
    Events events;
    RemoteContainer rmb;
    int rmbId = -1;
    private Vector eventStack = new Vector();
    private FontCmp font;
    private ColorCmp color;
    long acceptTimeout = -1L;
    private Vector attributes = new Vector();
    private boolean iscp;
    private boolean fontset;

    public DisplayMessageBox(CobolGUIEnvironment envCbl) {
        this.env = envCbl;
        try {
            this.events = new EventsImpl(this);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
    }

    public DisplayMessageBox setText(String t) {
        this.text = t;
        return this;
    }

    public DisplayMessageBox setTitle(String t) {
        String tmp = t;
        this.title = t;
        if (t == null || tmp != null && tmp.trim().length() == 0) {
            DisplayWindow wnd;
            for (wnd = this.env.searchOutputWindow(); wnd != null && !wnd.isVisible() && wnd.getParentWnd() != null; wnd = wnd.getParentWnd()) {
            }
            if (wnd != null) {
                this.title = wnd.getTitle();
            }
        }
        return this;
    }

    public DisplayMessageBox setTitle(CobolVar tCV) {
        return this.setTitle((ICobolVar)tCV);
    }

    public DisplayMessageBox setTitle(ICobolVar tCV) {
        this.title = tCV.toString();
        return this;
    }

    public DisplayMessageBox setType(float t) {
        this.type = (int)t;
        return this;
    }

    public DisplayMessageBox setType(CobolVar tCV) {
        return this.setType((ICobolVar)tCV);
    }

    public DisplayMessageBox setType(ICobolVar tCV) {
        if (tCV instanceof INumericVar) {
            this.type = ((INumericVar)tCV).integer();
        }
        return this;
    }

    public DisplayMessageBox setIcon(float t) {
        this.icon = (int)t;
        return this;
    }

    public DisplayMessageBox setIcon(CobolVar tCV) {
        return this.setIcon((ICobolVar)tCV);
    }

    public DisplayMessageBox setIcon(ICobolVar tCV) {
        if (tCV instanceof INumericVar) {
            this.icon = ((INumericVar)tCV).integer();
        }
        return this;
    }

    public DisplayMessageBox setDefault(float t) {
        this.btnDefault = (int)t;
        return this;
    }

    public DisplayMessageBox setDefault(CobolVar tCV) {
        return this.setDefault((ICobolVar)tCV);
    }

    public DisplayMessageBox setDefault(ICobolVar tCV) {
        if (tCV instanceof INumericVar) {
            this.btnDefault = ((INumericVar)tCV).integer();
        }
        return this;
    }

    protected DisplayMessageBox setFont(FontCmp f) {
        this.font = f;
        if (this.font != null) {
            this.fontset = true;
        }
        return this;
    }

    public DisplayMessageBox setFont(CobolVar cv) {
        return this.setFont((ICobolVar)cv);
    }

    public DisplayMessageBox setFont(ICobolVar cv) {
        FontCmp fc;
        if (cv != null && cv instanceof IObjectVar && ((IObjectVar)cv).getOId() != null && ((IObjectVar)cv).getOId() instanceof FontCmp && (fc = (FontCmp)((IObjectVar)cv).getOId()) != null) {
            this.setFont(fc);
        }
        return this;
    }

    public DisplayMessageBox setColor(float c) {
        if (this.color == null) {
            this.color = new ColorCmp(false);
        }
        this.color.setColor((int)c);
        return this;
    }

    void setBackground(int bg) {
        if (this.color == null) {
            this.color = new ColorCmp(false);
        }
        this.color.setBackground(bg);
    }

    public DisplayMessageBox setColorBackground(int bg) {
        this.setBackground(bg);
        return this;
    }

    public DisplayMessageBox setColorBackRGB(int bg) {
        if (this.color == null) {
            this.color = new ColorCmp(false);
        }
        if (ColorCmp.isRGB(bg)) {
            this.setColorBackRGB(bg);
        } else {
            this.color.setBackRGB(bg);
        }
        return this;
    }

    public DisplayMessageBox setColorBackRGB(CobolVar cv) {
        return this.setColorBackRGB((ICobolVar)cv);
    }

    public DisplayMessageBox setColorBackRGB(ICobolVar cv) {
        this.setColorBackRGB(cv.toint());
        return this;
    }

    void setForeground(int fg) {
        if (this.color == null) {
            this.color = new ColorCmp(false);
        }
        this.color.setForeground(fg);
    }

    public DisplayMessageBox setColorForeground(int fg) {
        if (ColorCmp.isRGB(fg)) {
            this.setColorForeRGB(fg);
        } else {
            this.setForeground(fg);
        }
        return this;
    }

    public DisplayMessageBox setColorForeRGB(int bg) {
        if (this.color == null) {
            this.color = new ColorCmp(false);
        }
        this.color.setForeRGB(bg);
        return this;
    }

    public DisplayMessageBox setColorForeRGB(CobolVar cv) {
        return this.setColorForeRGB((ICobolVar)cv);
    }

    public DisplayMessageBox setColorForeRGB(ICobolVar cv) {
        this.setColorForeRGB(cv.toint());
        return this;
    }

    public DisplayMessageBox show(ICobolVar dest) {
        if (dest != null) {
            dest.set(this.show().toint());
        } else {
            this.show();
        }
        return this;
    }

    private long getstartTimer() {
        long Return2 = -1L;
        if (this.acceptTimeout >= 0L) {
            Return2 = this.acceptTimeout;
        }
        return Return2;
    }

    public DisplayMessageBox setAcceptTimeout(ICobolVar h_seconds) {
        long val = -1L;
        if (h_seconds != null) {
            val = h_seconds.tolong();
        } else {
            val = Config.getProperty("iscobol.accept_timeout", -1);
            if (val >= 0L) {
                val *= 100L;
            }
        }
        if (val >= 0L) {
            this.acceptTimeout = val;
        }
        return this;
    }

    public DisplayMessageBox setAttributes(String attr) {
        if (attr != null & attr.length() > 0) {
            this.attributes.add(attr);
        }
        return this;
    }

    public DisplayMessageBox isCp(boolean iscp) {
        this.iscp = iscp;
        return this;
    }

    public ObjectVar show() {
        CobolGUIEnvironment.setAcceptActive(true);
        int backgroundidx = -1;
        int foregroundidx = -1;
        switch (Config.getProperty("iscobol.exception_message", "iscobol.display_message", 0)) {
            case 1: {
                Factory.displayUponSysOut(true, "[" + this.title + "] " + this.text);
                return this.RESULT;
            }
            default: {
                Factory.displayUponSysErr(true, "[" + this.title + "] " + this.text);
                return this.RESULT;
            }
            case 0: 
        }
        boolean Return2 = false;
        int wId = -1;
        if (this.env == null) {
            this.env = ScrFactory.getGUIEnviroment();
        }
        DisplayWindow wnd = this.env.searchOutputWindow();
        ScrFactory.flushProperties();
        int fontid = -1;
        if (wnd != null) {
            if (this.font == null) {
                this.font = wnd.getControlFont();
                if (this.font != null) {
                    fontid = this.font.getFontId(false);
                    fontid *= -1;
                }
            }
            wId = wnd.getTheObjectId();
            this.setTitle(this.title);
            this.env.dequeueWindow(wnd);
        }
        if (this.font == null) {
            this.font = FontCmp.getDefaultFont();
            fontid = this.font.getFontId(false);
            fontid *= -1;
        } else if (this.fontset) {
            fontid = this.font.getFontId(false);
        }
        if (this.color != null) {
            int cback = -1;
            int cfore = -1;
            boolean cbackH = false;
            boolean cforeH = false;
            if (this.color.isBackgroundSet()) {
                cback = this.color.getBackground();
            }
            if (this.color.isBackIntensitySet()) {
                cbackH = this.color.getBackHighIntensity();
            }
            if (this.color.isForegroundSet()) {
                cfore = this.color.getForeground();
            }
            if (this.color.isForeIntensitySet()) {
                cforeH = this.color.getForeHighIntensity();
            }
            backgroundidx = ColorCmp.getRealColorBack(cback, cbackH);
            foregroundidx = ColorCmp.getRealColor(cfore, cforeH);
        }
        String[] strattributes = new String[this.attributes.size()];
        this.attributes.toArray(strattributes);
        String name = Config.getProperty("iscobol.gui.messagebox.custom_prog", null);
        boolean serverside = true;
        if (name != null) {
            int idx = -1;
            String side = "";
            idx = (name = name.trim()).indexOf(44);
            if (idx > 0) {
                side = name.substring(idx + 1);
                name = name.substring(0, idx);
                boolean bl = serverside = side == null || side.length() == 0 || !side.equalsIgnoreCase("C");
            }
        }
        if (serverside && name != null) {
            Object[] Returnmsg = null;
            boolean centered = false;
            int commandId = -1;
            int[] argsret = new int[1];
            MessageBoxCustom mbc = new MessageBoxCustom();
            if (strattributes != null && strattributes.length > 0) {
                for (int i = 0; i < strattributes.length; ++i) {
                    centered = strattributes[i].equalsIgnoreCase("CENTERED");
                }
            }
            if (!centered) {
                try {
                    centered = Config.getProperty("iscobol.gui.messagebox.centered", false);
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            try {
                Returnmsg = mbc.callmsg(name, wId, fontid, ScreenUtility.removeLowValues(this.text.trim()), this.title, this.type, this.icon, this.btnDefault, backgroundidx, foregroundidx, this.getstartTimer(), strattributes, this.iscp, centered, argsret);
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
            if (Returnmsg != null) {
                boolean error = false;
                int v = -1;
                try {
                    v = Integer.parseInt(Returnmsg[argsret[0]].toString());
                }
                catch (NumberFormatException e) {
                    error = true;
                }
                if (!error) {
                    commandId = v;
                }
            }
            this.fireevent(new RemoteRecordAccept(22, commandId, 0));
        } else {
            GuiFactory gf = ScreenUtility.getGuiFactory();
            try {
                this.rmb = gf.getMessageBox(this.events, wId, fontid, ScreenUtility.removeLowValues(this.text.trim()), this.title, this.type, this.icon, this.btnDefault, backgroundidx, foregroundidx, this.getstartTimer(), strattributes, this.iscp, name);
                this.rmbId = this.rmb.getTheObjectId();
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
        }
        this.env.manageMsgBox(this);
        if (this.rmb != null) {
            try {
                this.rmb.destroy();
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
        }
        CobolGUIEnvironment.setAcceptActive(false);
        return this.RESULT;
    }

    public int fireevent(RemoteRecordAccept rra) {
        return this.env.fireCobolRecordAccept(new CobolRecordAccept(this, rra.getRecordType(), rra.getEventType(), false));
    }

    public void msgboxEvent(CobolRecordAccept rra) {
        this.RESULT.set(CobolNum.noo(rra.getEventType(), 0), false, false);
    }

    void setEvent(CobolRecordAccept cra) {
        this.eventStack.addElement(cra);
    }

    CobolRecordAccept getEvent() {
        if (this.eventStack.size() > 0) {
            CobolRecordAccept Return2 = (CobolRecordAccept)this.eventStack.remove(0);
            return Return2;
        }
        return null;
    }
}

